/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.io;

import flex.messaging.MessageException;
import flex.messaging.io.PropertyProxy;
import flex.messaging.io.SerializationContext;
import flex.messaging.io.SerializationDescriptor;
import flex.messaging.io.TypeMarshallingContext;
import flex.messaging.io.amf.ASObject;
import flex.messaging.log.Log;
import flex.messaging.log.Logger;
import flex.messaging.util.ClassUtil;
import java.io.Externalizable;
import java.io.Serializable;
import java.util.List;

public abstract class AbstractProxy
implements PropertyProxy,
Serializable {
    protected Object defaultInstance;
    protected String alias;
    protected boolean dynamic;
    protected boolean externalizable;
    protected boolean includeReadOnly;
    protected SerializationDescriptor descriptor;
    protected SerializationContext context;
    protected static final String LOG_CATEGORY = "Endpoint.Type";
    private static final int CONVERSION_ERROR = 10006;

    protected AbstractProxy(Object defaultInstance) {
        this.defaultInstance = defaultInstance;
        if (defaultInstance != null) {
            this.alias = defaultInstance.getClass().getName();
        }
    }

    @Override
    public Object getDefaultInstance() {
        return this.defaultInstance;
    }

    @Override
    public void setDefaultInstance(Object instance) {
        this.defaultInstance = instance;
    }

    public static Class getClassFromClassName(String className) {
        TypeMarshallingContext typeContext = TypeMarshallingContext.getTypeMarshallingContext();
        return ClassUtil.createClass(className, typeContext.getClassLoader());
    }

    public static Object createInstanceFromClassName(String className) {
        Class desiredClass = AbstractProxy.getClassFromClassName(className);
        return ClassUtil.createDefaultInstance(desiredClass, null, true);
    }

    @Override
    public Object createInstance(String className) {
        Object instance;
        if (className == null || className.length() == 0) {
            instance = ClassUtil.createDefaultInstance(ASObject.class, null, true);
        } else if (className.startsWith(">")) {
            instance = ClassUtil.createDefaultInstance(ASObject.class, null, true);
            ((ASObject)instance).setType(className);
        } else {
            if (this.getSerializationContext().instantiateTypes || className.startsWith("flex.")) {
                return AbstractProxy.createInstanceFromClassName(className);
            }
            instance = ClassUtil.createDefaultInstance(ASObject.class, null, true);
            ((ASObject)instance).setType(className);
        }
        return instance;
    }

    @Override
    public List getPropertyNames() {
        return this.getPropertyNames(this.getDefaultInstance());
    }

    @Override
    public Class getType(String propertyName) {
        return this.getType(this.getDefaultInstance(), propertyName);
    }

    @Override
    public Object getValue(String propertyName) {
        return this.getValue(this.getDefaultInstance(), propertyName);
    }

    @Override
    public void setValue(String propertyName, Object value) {
        this.setValue(this.getDefaultInstance(), propertyName, value);
    }

    @Override
    public void setAlias(String value) {
        this.alias = value;
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    @Override
    public void setDynamic(boolean value) {
        this.dynamic = value;
    }

    @Override
    public boolean isDynamic() {
        return this.dynamic;
    }

    @Override
    public boolean isExternalizable() {
        return this.externalizable;
    }

    @Override
    public void setExternalizable(boolean value) {
        this.externalizable = value;
    }

    @Override
    public boolean isExternalizable(Object instance) {
        return instance instanceof Externalizable;
    }

    @Override
    public SerializationContext getSerializationContext() {
        return this.context == null ? SerializationContext.getSerializationContext() : this.context;
    }

    @Override
    public void setSerializationContext(SerializationContext value) {
        this.context = value;
    }

    @Override
    public void setIncludeReadOnly(boolean value) {
        this.includeReadOnly = value;
    }

    @Override
    public boolean getIncludeReadOnly() {
        if (this.includeReadOnly) {
            return true;
        }
        return this.getSerializationContext().includeReadOnly;
    }

    @Override
    public SerializationDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public void setDescriptor(SerializationDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    @Override
    public Object instanceComplete(Object instance) {
        return instance;
    }

    @Override
    public Object getInstanceToSerialize(Object instance) {
        return instance;
    }

    @Override
    public Object clone() {
        try {
            AbstractProxy clonedProxy = (AbstractProxy)super.clone();
            clonedProxy.setCloneFieldsFrom(this);
            return clonedProxy;
        }
        catch (CloneNotSupportedException e) {
            if (Log.isError()) {
                Logger log = Log.getLogger((String)LOG_CATEGORY);
                log.error("Failed to clone a property proxy: " + this.toString());
            }
            MessageException ex = new MessageException();
            ex.setMessage(10006);
            throw ex;
        }
    }

    public String toString() {
        if (this.defaultInstance != null) {
            return "[Proxy(inst=" + this.defaultInstance + ") proxyClass=" + this.getClass() + " descriptor=" + this.descriptor + "]";
        }
        return "[Proxy(proxyClass=" + this.getClass() + " descriptor=" + this.descriptor + "]";
    }

    protected void setCloneFieldsFrom(AbstractProxy source) {
        this.setDescriptor(source.getDescriptor());
        this.setDefaultInstance(source.getDefaultInstance());
        this.context = source.context;
        this.includeReadOnly = source.includeReadOnly;
    }
}

