/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.shell.remote;

import java.io.OutputStream;
import java.io.PrintStream;
import org.apache.felix.shell.remote.ServiceMediator;

class TerminalPrintStream
extends PrintStream {
    private final ServiceMediator m_services;
    private volatile boolean m_isClosed = false;

    public TerminalPrintStream(ServiceMediator services, OutputStream tout) {
        super(tout);
        this.m_services = services;
    }

    public void print(String str) {
        block3: {
            if (this.out != null) {
                try {
                    byte[] bytes = str.getBytes();
                    this.out.write(bytes, 0, bytes.length);
                    this.flush();
                }
                catch (Exception ex) {
                    if (this.m_isClosed) break block3;
                    this.m_services.error("TerminalPrintStream::print()", ex);
                }
            }
        }
    }

    public void println(String str) {
        this.print(str + "\r\n");
    }

    public void flush() {
        block3: {
            if (this.out != null) {
                try {
                    this.out.flush();
                }
                catch (Exception ex) {
                    if (this.m_isClosed) break block3;
                    this.m_services.error("TerminalPrintStream::println()", ex);
                }
            }
        }
    }

    public void close() {
        this.m_isClosed = true;
        super.close();
    }
}

