/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.util;

import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.ErrorHandler;
import org.apache.felix.ipojo.extender.internal.Extender;
import org.apache.felix.ipojo.util.Log;
import org.apache.felix.ipojo.util.SecurityHelper;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogService;

public class Logger
implements Log {
    public static final String IPOJO_LOG_LEVEL_PROP = "ipojo.log.level";
    public static final String IPOJO_LOG_LEVEL_HEADER = "IPOJO-log-level";
    private static final LogService m_defaultLogger = new ConsoleLogService();
    private static final String DEBUG_HEADER = "[DEBUG]";
    private static final String INFO_HEADER = "[INFO]";
    private static final String WARNING_HEADER = "[WARNING]";
    private static final String ERROR_HEADER = "[ERROR]";
    private static final String UNKNOWN_HEADER = "[UNKNOWN]";
    private final BundleContext m_context;
    private final String m_name;
    private final int m_level;
    private ComponentInstance m_instance;

    public Logger(BundleContext context, String name, int level) {
        this.m_name = name;
        this.m_level = level;
        this.m_context = context;
    }

    public Logger(BundleContext context, ComponentInstance instance, int level) {
        this(context, instance.getInstanceName(), level);
        this.m_instance = instance;
    }

    public Logger(BundleContext context, String name) {
        this(context, name, Logger.getDefaultLevel(context));
    }

    public Logger(BundleContext context, ComponentInstance instance) {
        this(context, instance, Logger.getDefaultLevel(context));
    }

    private static int getDefaultLevel(BundleContext context) {
        String level = context.getProperty(IPOJO_LOG_LEVEL_PROP);
        if (level == null) {
            String key = IPOJO_LOG_LEVEL_PROP.replace('.', '-');
            level = (String)context.getBundle().getHeaders().get(key);
        }
        if (level == null) {
            level = (String)context.getBundle().getHeaders().get(IPOJO_LOG_LEVEL_HEADER);
        }
        if (level != null) {
            if (level.equalsIgnoreCase("info")) {
                return 3;
            }
            if (level.equalsIgnoreCase("debug")) {
                return 4;
            }
            if (level.equalsIgnoreCase("warning")) {
                return 2;
            }
            if (level.equalsIgnoreCase("error")) {
                return 1;
            }
        }
        return 2;
    }

    private static String getLogHeaderForLevel(int level) {
        switch (level) {
            case 4: {
                return DEBUG_HEADER;
            }
            case 3: {
                return INFO_HEADER;
            }
            case 2: {
                return WARNING_HEADER;
            }
            case 1: {
                return ERROR_HEADER;
            }
        }
        return UNKNOWN_HEADER;
    }

    public void log(int level, String msg) {
        if (this.m_level >= level) {
            this.dispatch(level, msg, null);
        }
        this.invokeErrorHandler(level, msg, null);
    }

    public void log(int level, String msg, Throwable exception) {
        if (this.m_level >= level) {
            this.dispatch(level, msg, exception);
        }
        this.invokeErrorHandler(level, msg, exception);
    }

    private void dispatch(int level, String msg, Throwable exception) {
        String name;
        LogService log = null;
        ServiceReference ref = null;
        try {
            if (SecurityHelper.hasPermissionToGetService(LogService.class.getName(), this.m_context)) {
                ref = this.m_context.getServiceReference(LogService.class.getName());
            } else {
                Extender.getIPOJOBundleContext().getServiceReference(LogService.class.getName());
            }
            if (ref != null) {
                log = (LogService)this.m_context.getService(ref);
            }
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        if (log == null) {
            log = m_defaultLogger;
        }
        if ((name = this.m_name) == null) {
            name = "";
        }
        String message = String.format("%s %s : %s", Logger.getLogHeaderForLevel(level), name, msg);
        switch (level) {
            case 4: {
                log.log(4, message, exception);
                break;
            }
            case 3: {
                log.log(3, message, exception);
                break;
            }
            case 2: {
                log.log(2, message, exception);
                break;
            }
            case 1: {
                log.log(1, message, exception);
                break;
            }
            default: {
                log.log(3, message, exception);
            }
        }
        if (ref != null) {
            this.m_context.ungetService(ref);
        }
    }

    private void invokeErrorHandler(int level, String msg, Throwable error) {
        if (level > 2) {
            return;
        }
        try {
            ServiceReference ref = this.m_context.getServiceReference(ErrorHandler.class.getName());
            if (ref != null) {
                ErrorHandler handler = (ErrorHandler)this.m_context.getService(ref);
                if (level == 1) {
                    handler.onError(this.m_instance, msg, error);
                } else if (level == 2) {
                    handler.onWarning(this.m_instance, msg, error);
                }
                this.m_context.ungetService(ref);
            }
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
    }

    private static class ConsoleLogService
    implements LogService {
        private ConsoleLogService() {
        }

        public void log(int i, String s) {
            this.log(i, s, null);
        }

        public void log(int level, String message, Throwable exception) {
            System.err.println(message);
            if (exception != null) {
                exception.printStackTrace();
            }
        }

        public void log(ServiceReference serviceReference, int i, String s) {
        }

        public void log(ServiceReference serviceReference, int i, String s, Throwable throwable) {
        }
    }
}

