/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.felix.ipojo.ConfigurationException;
import org.apache.felix.ipojo.metadata.Element;
import org.apache.felix.ipojo.parser.FieldMetadata;
import org.apache.felix.ipojo.parser.MethodMetadata;

public class PojoMetadata {
    private String[] m_interfaces = new String[0];
    private FieldMetadata[] m_fields = new FieldMetadata[0];
    private List<MethodMetadata> m_methods = new ArrayList<MethodMetadata>();
    private String m_super;
    private String m_className;
    private Map<String, List<MethodMetadata>> m_innerClasses = new HashMap<String, List<MethodMetadata>>();

    public PojoMetadata(Element metadata) throws ConfigurationException {
        Element[] inners;
        Element[] itfs;
        Element[] methods;
        Element[] elems = metadata.getElements("manipulation", "");
        if (elems == null) {
            throw new ConfigurationException("The component " + metadata.getAttribute("classname") + " has no manipulation metadata");
        }
        Element manip = elems[0];
        this.m_className = manip.getAttribute("classname");
        this.m_super = manip.getAttribute("super");
        Element[] fields = manip.getElements("field");
        if (fields != null) {
            for (Element field : fields) {
                this.addField(new FieldMetadata(field));
            }
        }
        if ((methods = manip.getElements("method")) != null) {
            for (Element method : methods) {
                this.m_methods.add(new MethodMetadata(method));
            }
        }
        if ((itfs = manip.getElements("interface")) != null) {
            for (Element itf : itfs) {
                this.addInterface(itf.getAttribute("name"));
            }
        }
        if ((inners = manip.getElements("inner")) != null) {
            for (Element inner : inners) {
                String name = inner.getAttribute("name");
                List<MethodMetadata> list = this.m_innerClasses.get(name);
                if (list == null) {
                    list = new ArrayList<MethodMetadata>();
                    this.m_innerClasses.put(name, list);
                }
                if ((methods = inner.getElements("method")) == null) continue;
                for (Element m : methods) {
                    list.add(new MethodMetadata(m));
                }
            }
        }
    }

    public MethodMetadata[] getMethods() {
        return this.m_methods.toArray(new MethodMetadata[this.m_methods.size()]);
    }

    public FieldMetadata[] getFields() {
        return this.m_fields;
    }

    public String[] getInterfaces() {
        return this.m_interfaces;
    }

    public String getClassName() {
        return this.m_className;
    }

    public String[] getInnerClasses() {
        Set<String> classes = this.m_innerClasses.keySet();
        return classes.toArray(new String[classes.size()]);
    }

    public MethodMetadata[] getMethodsFromInnerClass(String inner) {
        List<MethodMetadata> methods = this.m_innerClasses.get(inner);
        if (inner != null) {
            return methods.toArray(new MethodMetadata[methods.size()]);
        }
        return new MethodMetadata[0];
    }

    public FieldMetadata getField(String name) {
        for (int i = 0; i < this.m_fields.length; ++i) {
            if (!this.m_fields[i].getFieldName().equalsIgnoreCase(name)) continue;
            return this.m_fields[i];
        }
        return null;
    }

    public FieldMetadata getField(String name, String type) {
        for (int i = 0; i < this.m_fields.length; ++i) {
            if (!this.m_fields[i].getFieldName().equalsIgnoreCase(name) || !this.m_fields[i].getFieldType().equalsIgnoreCase(type)) continue;
            return this.m_fields[i];
        }
        return null;
    }

    public boolean isInterfaceImplemented(String itf) {
        for (int i = 0; i < this.m_interfaces.length; ++i) {
            if (!this.m_interfaces[i].equals(itf)) continue;
            return true;
        }
        return false;
    }

    public MethodMetadata getMethod(String name) {
        for (MethodMetadata metadata : this.m_methods) {
            if (!metadata.getMethodName().equalsIgnoreCase(name)) continue;
            return metadata;
        }
        return null;
    }

    public MethodMetadata[] getMethods(String name) {
        ArrayList<MethodMetadata> list = new ArrayList<MethodMetadata>();
        for (MethodMetadata metadata : this.m_methods) {
            if (!metadata.getMethodName().equalsIgnoreCase(name)) continue;
            list.add(metadata);
        }
        return list.toArray(new MethodMetadata[list.size()]);
    }

    public MethodMetadata[] getConstructors() {
        return this.getMethods("$init");
    }

    public MethodMetadata getMethod(String name, String[] types) {
        for (MethodMetadata metadata : this.m_methods) {
            int argIndex;
            if (!metadata.getMethodName().equalsIgnoreCase(name) || metadata.getMethodArguments().length != types.length) continue;
            for (argIndex = 0; argIndex < types.length && types[argIndex].equals(metadata.getMethodArguments()[argIndex]); ++argIndex) {
            }
            if (argIndex != types.length) continue;
            return metadata;
        }
        return null;
    }

    public MethodMetadata getConstructor(String[] types) {
        return this.getMethod("$init", types);
    }

    private void addField(FieldMetadata field) {
        if (this.m_fields.length > 0) {
            FieldMetadata[] newInstances = new FieldMetadata[this.m_fields.length + 1];
            System.arraycopy(this.m_fields, 0, newInstances, 0, this.m_fields.length);
            newInstances[this.m_fields.length] = field;
            this.m_fields = newInstances;
        } else {
            this.m_fields = new FieldMetadata[]{field};
        }
    }

    private void addInterface(String itf) {
        if (this.m_interfaces.length > 0) {
            String[] newInstances = new String[this.m_interfaces.length + 1];
            System.arraycopy(this.m_interfaces, 0, newInstances, 0, this.m_interfaces.length);
            newInstances[this.m_interfaces.length] = itf;
            this.m_interfaces = newInstances;
        } else {
            this.m_interfaces = new String[]{itf};
        }
    }

    public String getSuperClass() {
        return this.m_super;
    }
}

