/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.handlers.configuration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.ConfigurationException;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.PrimitiveHandler;
import org.apache.felix.ipojo.architecture.ComponentTypeDescription;
import org.apache.felix.ipojo.architecture.HandlerDescription;
import org.apache.felix.ipojo.architecture.PropertyDescription;
import org.apache.felix.ipojo.handlers.configuration.ConfigurationHandlerDescription;
import org.apache.felix.ipojo.handlers.configuration.ConfigurationListener;
import org.apache.felix.ipojo.handlers.providedservice.ProvidedServiceHandler;
import org.apache.felix.ipojo.metadata.Attribute;
import org.apache.felix.ipojo.metadata.Element;
import org.apache.felix.ipojo.parser.FieldMetadata;
import org.apache.felix.ipojo.parser.MethodMetadata;
import org.apache.felix.ipojo.parser.PojoMetadata;
import org.apache.felix.ipojo.util.Callback;
import org.apache.felix.ipojo.util.Property;
import org.apache.felix.ipojo.util.SecurityHelper;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ManagedService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationHandler
extends PrimitiveHandler
implements ManagedService,
Pojo {
    InstanceManager __IM;
    public static final String MANAGED_SERVICE_PID = "managed.service.pid";
    private boolean __Fm_configurableProperties;
    private List<Property> m_configurableProperties;
    private boolean __Fm_providedServiceHandler;
    private ProvidedServiceHandler m_providedServiceHandler;
    private boolean __Fm_propagatedFromInstance;
    private Dictionary m_propagatedFromInstance;
    private boolean __Fm_toPropagate;
    private Dictionary<String, Object> m_toPropagate;
    private boolean __Fm_propagatedFromCA;
    private Dictionary m_propagatedFromCA;
    private boolean __Fm_configurationAlreadyPushed;
    private boolean m_configurationAlreadyPushed;
    private boolean __Fm_mustPropagate;
    private boolean m_mustPropagate;
    private boolean __Fm_sr;
    private ServiceRegistration m_sr;
    private boolean __Fm_managedServicePID;
    private String m_managedServicePID;
    private boolean __Fm_description;
    private ConfigurationHandlerDescription m_description;
    private boolean __Fm_updated;
    private Callback m_updated;
    private boolean __Fm_listeners;
    private final Set<ConfigurationListener> m_listeners;
    private boolean __Fm_lastConfiguration;
    private Map<String, Object> m_lastConfiguration;
    boolean __MinitializeComponentFactory$org_apache_felix_ipojo_architecture_ComponentTypeDescription$org_apache_felix_ipojo_metadata_Element;
    boolean __Mconfigure$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary;
    boolean __Mstop;
    boolean __Mstart;
    boolean __MaddProperty$org_apache_felix_ipojo_util_Property;
    boolean __Mreconfigure$java_util_Dictionary;
    boolean __MdetectConfigurationChanges$java_util_Dictionary;
    boolean __MgetPropertyByName$java_lang_String;
    boolean __MreconfigureProperties$java_util_Dictionary;
    boolean __Mexcluded$java_lang_String;
    boolean __MreconfigureProperty$org_apache_felix_ipojo_util_Property$java_lang_Object;
    boolean __Mpropagate$java_util_Dictionary$java_util_Dictionary;
    boolean __MonCreation$java_lang_Object;
    boolean __MnotifyUpdated$java_lang_Object;
    boolean __Mupdated$java_util_Dictionary;
    boolean __MgetDescription;
    boolean __MaddListener$org_apache_felix_ipojo_handlers_configuration_ConfigurationListener;
    boolean __MremoveListener$org_apache_felix_ipojo_handlers_configuration_ConfigurationListener;
    boolean __MnotifyListeners$java_util_Map;
    boolean __MstateChanged$int;

    List __getm_configurableProperties() {
        if (!this.__Fm_configurableProperties) {
            return this.m_configurableProperties;
        }
        return (List)this.__IM.onGet(this, "m_configurableProperties");
    }

    void __setm_configurableProperties(List list) {
        if (!this.__Fm_configurableProperties) {
            this.m_configurableProperties = list;
            return;
        }
        this.__IM.onSet(this, "m_configurableProperties", list);
    }

    ProvidedServiceHandler __getm_providedServiceHandler() {
        if (!this.__Fm_providedServiceHandler) {
            return this.m_providedServiceHandler;
        }
        return (ProvidedServiceHandler)this.__IM.onGet(this, "m_providedServiceHandler");
    }

    void __setm_providedServiceHandler(ProvidedServiceHandler providedServiceHandler) {
        if (!this.__Fm_providedServiceHandler) {
            this.m_providedServiceHandler = providedServiceHandler;
            return;
        }
        this.__IM.onSet(this, "m_providedServiceHandler", providedServiceHandler);
    }

    Dictionary __getm_propagatedFromInstance() {
        if (!this.__Fm_propagatedFromInstance) {
            return this.m_propagatedFromInstance;
        }
        return (Dictionary)this.__IM.onGet(this, "m_propagatedFromInstance");
    }

    void __setm_propagatedFromInstance(Dictionary dictionary) {
        if (!this.__Fm_propagatedFromInstance) {
            this.m_propagatedFromInstance = dictionary;
            return;
        }
        this.__IM.onSet(this, "m_propagatedFromInstance", dictionary);
    }

    Dictionary __getm_toPropagate() {
        if (!this.__Fm_toPropagate) {
            return this.m_toPropagate;
        }
        return (Dictionary)this.__IM.onGet(this, "m_toPropagate");
    }

    void __setm_toPropagate(Dictionary dictionary) {
        if (!this.__Fm_toPropagate) {
            this.m_toPropagate = dictionary;
            return;
        }
        this.__IM.onSet(this, "m_toPropagate", dictionary);
    }

    Dictionary __getm_propagatedFromCA() {
        if (!this.__Fm_propagatedFromCA) {
            return this.m_propagatedFromCA;
        }
        return (Dictionary)this.__IM.onGet(this, "m_propagatedFromCA");
    }

    void __setm_propagatedFromCA(Dictionary dictionary) {
        if (!this.__Fm_propagatedFromCA) {
            this.m_propagatedFromCA = dictionary;
            return;
        }
        this.__IM.onSet(this, "m_propagatedFromCA", dictionary);
    }

    boolean __getm_configurationAlreadyPushed() {
        if (!this.__Fm_configurationAlreadyPushed) {
            return this.m_configurationAlreadyPushed;
        }
        Object object = this.__IM.onGet(this, "m_configurationAlreadyPushed");
        Boolean bl = (Boolean)object;
        return bl;
    }

    void __setm_configurationAlreadyPushed(boolean bl) {
        if (!this.__Fm_configurationAlreadyPushed) {
            this.m_configurationAlreadyPushed = bl;
            return;
        }
        Boolean bl2 = new Boolean(bl);
        this.__IM.onSet(this, "m_configurationAlreadyPushed", bl2);
    }

    boolean __getm_mustPropagate() {
        if (!this.__Fm_mustPropagate) {
            return this.m_mustPropagate;
        }
        Object object = this.__IM.onGet(this, "m_mustPropagate");
        Boolean bl = (Boolean)object;
        return bl;
    }

    void __setm_mustPropagate(boolean bl) {
        if (!this.__Fm_mustPropagate) {
            this.m_mustPropagate = bl;
            return;
        }
        Boolean bl2 = new Boolean(bl);
        this.__IM.onSet(this, "m_mustPropagate", bl2);
    }

    ServiceRegistration __getm_sr() {
        if (!this.__Fm_sr) {
            return this.m_sr;
        }
        return (ServiceRegistration)this.__IM.onGet(this, "m_sr");
    }

    void __setm_sr(ServiceRegistration serviceRegistration) {
        if (!this.__Fm_sr) {
            this.m_sr = serviceRegistration;
            return;
        }
        this.__IM.onSet(this, "m_sr", serviceRegistration);
    }

    String __getm_managedServicePID() {
        if (!this.__Fm_managedServicePID) {
            return this.m_managedServicePID;
        }
        return (String)this.__IM.onGet(this, "m_managedServicePID");
    }

    void __setm_managedServicePID(String string) {
        if (!this.__Fm_managedServicePID) {
            this.m_managedServicePID = string;
            return;
        }
        this.__IM.onSet(this, "m_managedServicePID", string);
    }

    ConfigurationHandlerDescription __getm_description() {
        if (!this.__Fm_description) {
            return this.m_description;
        }
        return (ConfigurationHandlerDescription)this.__IM.onGet(this, "m_description");
    }

    void __setm_description(ConfigurationHandlerDescription configurationHandlerDescription) {
        if (!this.__Fm_description) {
            this.m_description = configurationHandlerDescription;
            return;
        }
        this.__IM.onSet(this, "m_description", configurationHandlerDescription);
    }

    Callback __getm_updated() {
        if (!this.__Fm_updated) {
            return this.m_updated;
        }
        return (Callback)this.__IM.onGet(this, "m_updated");
    }

    void __setm_updated(Callback callback) {
        if (!this.__Fm_updated) {
            this.m_updated = callback;
            return;
        }
        this.__IM.onSet(this, "m_updated", callback);
    }

    Set __getm_listeners() {
        if (!this.__Fm_listeners) {
            return this.m_listeners;
        }
        return (Set)this.__IM.onGet(this, "m_listeners");
    }

    void __setm_listeners(Set set) {
        if (!this.__Fm_listeners) {
            this.m_listeners = set;
            return;
        }
        this.__IM.onSet(this, "m_listeners", set);
    }

    Map __getm_lastConfiguration() {
        if (!this.__Fm_lastConfiguration) {
            return this.m_lastConfiguration;
        }
        return (Map)this.__IM.onGet(this, "m_lastConfiguration");
    }

    void __setm_lastConfiguration(Map map) {
        if (!this.__Fm_lastConfiguration) {
            this.m_lastConfiguration = map;
            return;
        }
        this.__IM.onSet(this, "m_lastConfiguration", map);
    }

    public ConfigurationHandler() {
        this(null);
    }

    private ConfigurationHandler(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__setm_configurableProperties(new ArrayList(1));
        this.__setm_propagatedFromInstance(new Properties());
        this.__setm_toPropagate(new Hashtable());
        this.__setm_listeners(new LinkedHashSet());
    }

    @Override
    public void initializeComponentFactory(ComponentTypeDescription desc, Element metadata) throws ConfigurationException {
        if (!this.__MinitializeComponentFactory$org_apache_felix_ipojo_architecture_ComponentTypeDescription$org_apache_felix_ipojo_metadata_Element) {
            this.__M_initializeComponentFactory(desc, metadata);
            return;
        }
        try {
            this.__IM.onEntry(this, "initializeComponentFactory$org_apache_felix_ipojo_architecture_ComponentTypeDescription$org_apache_felix_ipojo_metadata_Element", new Object[]{desc, metadata});
            this.__M_initializeComponentFactory(desc, metadata);
            this.__IM.onExit(this, "initializeComponentFactory$org_apache_felix_ipojo_architecture_ComponentTypeDescription$org_apache_felix_ipojo_metadata_Element", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError(this, "initializeComponentFactory$org_apache_felix_ipojo_architecture_ComponentTypeDescription$org_apache_felix_ipojo_metadata_Element", throwable);
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void __M_initializeComponentFactory(ComponentTypeDescription desc, Element metadata) throws ConfigurationException {
        Element[] confs = metadata.getElements("Properties", "");
        if (confs == null) {
            return;
        }
        Element[] configurables = confs[0].getElements("Property");
        for (int i = 0; configurables != null && i < configurables.length; ++i) {
            String fieldName = configurables[i].getAttribute("field");
            String methodName = configurables[i].getAttribute("method");
            String paramIndex = configurables[i].getAttribute("constructor-parameter");
            if (fieldName == null && methodName == null && paramIndex == null) {
                throw new ConfigurationException("Malformed property : The property needs to contain at least a field, a method or a constructor-parameter");
            }
            String name = configurables[i].getAttribute("name");
            if (name == null) {
                if (fieldName == null && methodName != null) {
                    name = methodName;
                } else if (fieldName == null && paramIndex != null) {
                    MethodMetadata[] constructors = this.getFactory().getPojoMetadata().getConstructors();
                    if (constructors.length != 1) {
                        throw new ConfigurationException("Cannot infer the property name injected in the constructor parameter #" + paramIndex + " - add the `name` attribute");
                    }
                    int idx = Integer.valueOf(paramIndex);
                    if (constructors[0].getMethodArgumentNames().length <= idx) throw new ConfigurationException("Cannot infer the property name injected in the constructor parameter #" + paramIndex + " - not enough argument in the constructor :" + constructors[0].getArguments());
                    name = constructors[0].getMethodArgumentNames()[idx];
                } else {
                    name = fieldName;
                }
                configurables[i].addAttribute(new Attribute("name", name));
            }
            String value = configurables[i].getAttribute("value");
            PojoMetadata manipulation = this.getFactory().getPojoMetadata();
            String type = null;
            if (methodName != null) {
                MethodMetadata[] method = manipulation.getMethods(methodName);
                if (method.length == 0) {
                    type = configurables[i].getAttribute("type");
                    if (type == null) {
                        throw new ConfigurationException("Malformed property : The type of the property cannot be discovered, add a 'type' attribute");
                    }
                } else {
                    if (method[0].getMethodArguments().length != 1) {
                        throw new ConfigurationException("Malformed property :  The method " + methodName + " does not have one argument");
                    }
                    type = method[0].getMethodArguments()[0];
                    configurables[i].addAttribute(new Attribute("type", type));
                }
            } else if (fieldName != null) {
                FieldMetadata field = manipulation.getField(fieldName);
                if (field == null) {
                    throw new ConfigurationException("Malformed property : The field " + fieldName + " does not exist in the implementation class");
                }
                type = field.getFieldType();
                configurables[i].addAttribute(new Attribute("type", type));
            } else if (paramIndex != null) {
                int index = Integer.parseInt(paramIndex);
                type = configurables[i].getAttribute("type");
                MethodMetadata[] cts = manipulation.getConstructors();
                if (type == null && cts.length > 0 && cts[0].getMethodArguments().length > index) {
                    type = cts[0].getMethodArguments()[index];
                } else if (type == null) {
                    throw new ConfigurationException("Cannot determine the type of the property " + index + ", please use the type attribute");
                }
                configurables[i].addAttribute(new Attribute("type", type));
            }
            boolean immutable = false;
            String imm = configurables[i].getAttribute("immutable");
            immutable = imm != null && imm.equalsIgnoreCase("true");
            boolean mandatory = false;
            String man = configurables[i].getAttribute("mandatory");
            mandatory = man != null && man.equalsIgnoreCase("true");
            PropertyDescription pd = value == null ? new PropertyDescription(name, type, null, false) : new PropertyDescription(name, type, value, immutable);
            if (mandatory) {
                pd.setMandatory();
            }
            desc.addProperty(pd);
        }
    }

    @Override
    public void configure(Element metadata, Dictionary configuration) throws ConfigurationException {
        if (!this.__Mconfigure$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary) {
            this.__M_configure(metadata, configuration);
            return;
        }
        try {
            this.__IM.onEntry(this, "configure$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary", new Object[]{metadata, configuration});
            this.__M_configure(metadata, configuration);
            this.__IM.onExit(this, "configure$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError(this, "configure$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary", throwable);
            throw throwable;
        }
    }

    private void __M_configure(Element metadata, Dictionary configuration) throws ConfigurationException {
        String upd;
        String propa;
        Element[] confs = metadata.getElements("Properties", "");
        Element[] configurables = confs[0].getElements("Property");
        this.__setm_mustPropagate(true);
        this.__setm_toPropagate(new Hashtable());
        if (configuration != null) {
            Enumeration keys = configuration.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                if (this.excluded(key)) continue;
                this.__getm_toPropagate().put(key, configuration.get(key));
            }
        }
        if ((propa = confs[0].getAttribute("propagation")) != null && propa.equalsIgnoreCase("false")) {
            this.__setm_mustPropagate(false);
            this.__setm_toPropagate(null);
        }
        this.__setm_managedServicePID(confs[0].getAttribute("pid"));
        String instanceMSPID = (String)configuration.get(MANAGED_SERVICE_PID);
        if (instanceMSPID != null) {
            this.__setm_managedServicePID(instanceMSPID);
        }
        if ((upd = confs[0].getAttribute("updated")) != null) {
            MethodMetadata method = this.getPojoMetadata().getMethod(upd);
            if (method == null) {
                throw new ConfigurationException("The updated method is not found in the class " + this.getInstanceManager().getClassName());
            }
            if (method.getMethodArguments().length == 0) {
                this.__setm_updated(new Callback(upd, new Class[0], false, this.getInstanceManager()));
            } else if (method.getMethodArguments().length == 1 && method.getMethodArguments()[0].equals(Dictionary.class.getName())) {
                this.__setm_updated(new Callback(upd, new Class[]{Dictionary.class}, false, this.getInstanceManager()));
            } else {
                throw new ConfigurationException("The updated method is found in the class " + this.getInstanceManager().getClassName() + " must have either no argument or a Dictionary");
            }
        }
        for (int i = 0; configurables != null && i < configurables.length; ++i) {
            Property prop;
            String fieldName = configurables[i].getAttribute("field");
            String methodName = configurables[i].getAttribute("method");
            String paramIndex = configurables[i].getAttribute("constructor-parameter");
            int index = -1;
            String name = configurables[i].getAttribute("name");
            String value = configurables[i].getAttribute("value");
            String type = configurables[i].getAttribute("type");
            if (paramIndex == null) {
                prop = new Property(name, fieldName, methodName, value, type, this.getInstanceManager(), this);
            } else {
                index = Integer.parseInt(paramIndex);
                prop = new Property(name, fieldName, methodName, index, value, type, this.getInstanceManager(), this);
            }
            this.addProperty(prop);
            if (configuration.get(name) == null) {
                if (fieldName != null && configuration.get(fieldName) != null) {
                    prop.setValue(configuration.get(fieldName));
                }
            } else {
                prop.setValue(configuration.get(name));
            }
            if (fieldName != null) {
                FieldMetadata field = new FieldMetadata(fieldName, type);
                this.getInstanceManager().register(field, prop);
            }
            if (index == -1) continue;
            this.getInstanceManager().register(index, prop);
        }
        this.__setm_description(new ConfigurationHandlerDescription(this, this.__getm_configurableProperties(), this.__getm_managedServicePID()));
    }

    @Override
    public synchronized void stop() {
        if (!this.__Mstop) {
            this.__M_stop();
            return;
        }
        try {
            this.__IM.onEntry(this, "stop", new Object[0]);
            this.__M_stop();
            this.__IM.onExit(this, "stop", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError(this, "stop", throwable);
            throw throwable;
        }
    }

    private void __M_stop() {
        if (this.__getm_sr() != null) {
            this.__getm_sr().unregister();
            this.__setm_sr(null);
        }
        this.__setm_lastConfiguration(Collections.emptyMap());
    }

    @Override
    public synchronized void start() {
        if (!this.__Mstart) {
            this.__M_start();
            return;
        }
        try {
            this.__IM.onEntry(this, "start", new Object[0]);
            this.__M_start();
            this.__IM.onExit(this, "start", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError(this, "start", throwable);
            throw throwable;
        }
    }

    private void __M_start() {
        this.__setm_providedServiceHandler((ProvidedServiceHandler)this.getHandler("org.apache.felix.ipojo:provides"));
        if (this.__getm_mustPropagate()) {
            for (Property prop : this.__getm_configurableProperties()) {
                if (prop.getValue() == Property.NO_VALUE || prop.getValue() == null) continue;
                this.__getm_toPropagate().put(prop.getName(), prop.getValue());
            }
            Properties extra = this.reconfigureProperties(this.__getm_toPropagate());
            this.propagate(extra, this.__getm_propagatedFromInstance());
            this.__setm_propagatedFromInstance(extra);
            if (this.getInstanceManager().getPojoObjects() != null) {
                try {
                    this.notifyUpdated(null);
                }
                catch (Throwable e) {
                    this.error("Cannot call the updated method : " + e.getMessage(), e);
                }
            }
        }
        for (Property prop : this.__getm_configurableProperties()) {
            prop.reset();
            if (!prop.hasField() || prop.getValue() == Property.NO_VALUE || prop.getValue() == null) continue;
            this.getInstanceManager().onSet(null, prop.getField(), prop.getValue());
        }
        if (this.__getm_managedServicePID() != null && this.__getm_sr() == null) {
            Hashtable<String, String> props = new Hashtable<String, String>();
            props.put("service.pid", this.__getm_managedServicePID());
            props.put("instance.name", this.getInstanceManager().getInstanceName());
            props.put("factory.name", this.getInstanceManager().getFactory().getFactoryName());
            if (SecurityHelper.hasPermissionToRegisterService(ManagedService.class.getName(), this.getInstanceManager().getContext()) && SecurityHelper.canRegisterService(this.getInstanceManager().getContext())) {
                this.__setm_sr(this.getInstanceManager().getContext().registerService(ManagedService.class.getName(), (Object)this, props));
            } else {
                this.error("Cannot register the ManagedService - The bundle " + this.getInstanceManager().getContext().getBundle().getBundleId() + " does not have the permission to register the service");
            }
        }
    }

    protected void addProperty(Property prop) {
        if (!this.__MaddProperty$org_apache_felix_ipojo_util_Property) {
            this.__M_addProperty(prop);
            return;
        }
        try {
            this.__IM.onEntry(this, "addProperty$org_apache_felix_ipojo_util_Property", new Object[]{prop});
            this.__M_addProperty(prop);
            this.__IM.onExit(this, "addProperty$org_apache_felix_ipojo_util_Property", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError(this, "addProperty$org_apache_felix_ipojo_util_Property", throwable);
            throw throwable;
        }
    }

    private void __M_addProperty(Property prop) {
        this.__getm_configurableProperties().add(prop);
    }

    @Override
    public void reconfigure(Dictionary configuration) {
        if (!this.__Mreconfigure$java_util_Dictionary) {
            this.__M_reconfigure(configuration);
            return;
        }
        try {
            this.__IM.onEntry(this, "reconfigure$java_util_Dictionary", new Object[]{configuration});
            this.__M_reconfigure(configuration);
            this.__IM.onExit(this, "reconfigure$java_util_Dictionary", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError(this, "reconfigure$java_util_Dictionary", throwable);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void __M_reconfigure(Dictionary configuration) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        boolean changed = false;
        ConfigurationHandler configurationHandler = this;
        synchronized (configurationHandler) {
            this.info(this.getInstanceManager().getInstanceName() + " is reconfiguring the properties : " + configuration);
            changed = this.detectConfigurationChanges(configuration);
            if (changed) {
                Properties extra = this.reconfigureProperties(configuration);
                this.propagate(extra, this.__getm_propagatedFromInstance());
                this.__setm_propagatedFromInstance(extra);
                if (this.getInstanceManager().getPojoObjects() != null) {
                    try {
                        this.notifyUpdated(null);
                    }
                    catch (Throwable e) {
                        this.error("Cannot call the updated method : " + e.getMessage(), e);
                    }
                }
                for (Property p : this.__getm_configurableProperties()) {
                    map.put(p.getName(), p.getValue());
                }
            }
        }
        if (changed) {
            this.notifyListeners(map);
        }
    }

    private boolean detectConfigurationChanges(Dictionary configuration) {
        boolean bl;
        if (!this.__MdetectConfigurationChanges$java_util_Dictionary) {
            return this.__M_detectConfigurationChanges(configuration);
        }
        try {
            this.__IM.onEntry(this, "detectConfigurationChanges$java_util_Dictionary", new Object[]{configuration});
            bl = this.__M_detectConfigurationChanges(configuration);
            this.__IM.onExit(this, "detectConfigurationChanges$java_util_Dictionary", new Boolean(bl));
        }
        catch (Throwable throwable) {
            this.__IM.onError(this, "detectConfigurationChanges$java_util_Dictionary", throwable);
            throw throwable;
        }
        return bl;
    }

    private boolean __M_detectConfigurationChanges(Dictionary configuration) {
        String k;
        Enumeration enumeration;
        Enumeration keysEnumeration = configuration.keys();
        while (keysEnumeration.hasMoreElements()) {
            Object v;
            String name = (String)keysEnumeration.nextElement();
            Object value = configuration.get(name);
            if (name.equals("instance.name") || name.equals("service.pid") || name.equals(MANAGED_SERVICE_PID)) continue;
            Property p = this.getPropertyByName(name);
            if (p != null) {
                if (p.getValue() == null) {
                    return true;
                }
                if (p.getValue().equals(value)) continue;
                return true;
            }
            if (!(this.__getm_propagatedFromCA() == null || (v = this.__getm_propagatedFromCA().get(name)) != null && v.equals(value))) {
                return true;
            }
            if (this.__getm_propagatedFromInstance() == null || (v = this.__getm_propagatedFromInstance().get(name)) != null && v.equals(value)) continue;
            return true;
        }
        if (this.__getm_propagatedFromCA() != null) {
            enumeration = this.__getm_propagatedFromCA().keys();
            while (enumeration.hasMoreElements()) {
                k = (String)enumeration.nextElement();
                if (configuration.get(k) != null) continue;
                return true;
            }
        }
        if (this.__getm_propagatedFromInstance() != null) {
            enumeration = this.__getm_propagatedFromInstance().keys();
            while (enumeration.hasMoreElements()) {
                k = (String)enumeration.nextElement();
                if (configuration.get(k) != null) continue;
                return true;
            }
        }
        return false;
    }

    private Property getPropertyByName(String name) {
        Property property;
        if (!this.__MgetPropertyByName$java_lang_String) {
            return this.__M_getPropertyByName(name);
        }
        try {
            this.__IM.onEntry(this, "getPropertyByName$java_lang_String", new Object[]{name});
            property = this.__M_getPropertyByName(name);
            this.__IM.onExit(this, "getPropertyByName$java_lang_String", property);
        }
        catch (Throwable throwable) {
            this.__IM.onError(this, "getPropertyByName$java_lang_String", throwable);
            throw throwable;
        }
        return property;
    }

    private Property __M_getPropertyByName(String name) {
        for (Property p : this.__getm_configurableProperties()) {
            if (!p.getName().equals(name)) continue;
            return p;
        }
        return null;
    }

    private Properties reconfigureProperties(Dictionary configuration) {
        Properties properties;
        if (!this.__MreconfigureProperties$java_util_Dictionary) {
            return this.__M_reconfigureProperties(configuration);
        }
        try {
            this.__IM.onEntry(this, "reconfigureProperties$java_util_Dictionary", new Object[]{configuration});
            properties = this.__M_reconfigureProperties(configuration);
            this.__IM.onExit(this, "reconfigureProperties$java_util_Dictionary", properties);
        }
        catch (Throwable throwable) {
            this.__IM.onError(this, "reconfigureProperties$java_util_Dictionary", throwable);
            throw throwable;
        }
        return properties;
    }

    private Properties __M_reconfigureProperties(Dictionary configuration) {
        Properties toPropagate = new Properties();
        Enumeration keysEnumeration = configuration.keys();
        while (keysEnumeration.hasMoreElements()) {
            String name = (String)keysEnumeration.nextElement();
            Object value = configuration.get(name);
            boolean found = false;
            for (Property prop : this.__getm_configurableProperties()) {
                if (!prop.getName().equals(name)) continue;
                Object v = this.reconfigureProperty(prop, value);
                found = true;
                if (!this.__getm_mustPropagate() || this.excluded(name)) break;
                toPropagate.put(name, v);
                break;
            }
            if (found || !this.__getm_mustPropagate() || this.excluded(name)) continue;
            toPropagate.put(name, value);
        }
        for (Property prop : this.__getm_configurableProperties()) {
            if (configuration.get(prop.getName()) != null) continue;
            this.reconfigureProperty(prop, prop.getDefaultValue());
        }
        return toPropagate;
    }

    private boolean excluded(String name) {
        boolean bl;
        if (!this.__Mexcluded$java_lang_String) {
            return this.__M_excluded(name);
        }
        try {
            this.__IM.onEntry(this, "excluded$java_lang_String", new Object[]{name});
            bl = this.__M_excluded(name);
            this.__IM.onExit(this, "excluded$java_lang_String", new Boolean(bl));
        }
        catch (Throwable throwable) {
            this.__IM.onError(this, "excluded$java_lang_String", throwable);
            throw throwable;
        }
        return bl;
    }

    private boolean __M_excluded(String name) {
        return name.startsWith(".") || "instance.name".equals(name) || "factory.version".equals(name) || "factory.name".equals(name);
    }

    public Object reconfigureProperty(Property prop, Object value) {
        Object object;
        if (!this.__MreconfigureProperty$org_apache_felix_ipojo_util_Property$java_lang_Object) {
            return this.__M_reconfigureProperty(prop, value);
        }
        try {
            this.__IM.onEntry(this, "reconfigureProperty$org_apache_felix_ipojo_util_Property$java_lang_Object", new Object[]{prop, value});
            object = this.__M_reconfigureProperty(prop, value);
            this.__IM.onExit(this, "reconfigureProperty$org_apache_felix_ipojo_util_Property$java_lang_Object", object);
        }
        catch (Throwable throwable) {
            this.__IM.onError(this, "reconfigureProperty$org_apache_felix_ipojo_util_Property$java_lang_Object", throwable);
            throw throwable;
        }
        return object;
    }

    private Object __M_reconfigureProperty(Property prop, Object value) {
        if (prop.getValue() == null || !prop.getValue().equals(value)) {
            prop.setValue(value);
            if (prop.hasField()) {
                this.getInstanceManager().onSet(null, prop.getField(), prop.getValue());
            }
            if (prop.hasMethod() && this.getInstanceManager().getPojoObjects() != null) {
                prop.invoke(null);
            }
        }
        return prop.getValue();
    }

    private void propagate(Dictionary newProps, Dictionary oldProps) {
        if (!this.__Mpropagate$java_util_Dictionary$java_util_Dictionary) {
            this.__M_propagate(newProps, oldProps);
            return;
        }
        try {
            this.__IM.onEntry(this, "propagate$java_util_Dictionary$java_util_Dictionary", new Object[]{newProps, oldProps});
            this.__M_propagate(newProps, oldProps);
            this.__IM.onExit(this, "propagate$java_util_Dictionary$java_util_Dictionary", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError(this, "propagate$java_util_Dictionary$java_util_Dictionary", throwable);
            throw throwable;
        }
    }

    private void __M_propagate(Dictionary newProps, Dictionary oldProps) {
        if (this.__getm_mustPropagate() && this.__getm_providedServiceHandler() != null) {
            if (oldProps != null) {
                this.__getm_providedServiceHandler().removeProperties(oldProps);
            }
            if (newProps != null) {
                newProps.remove("instance.name");
                newProps.remove(MANAGED_SERVICE_PID);
                newProps.remove("service.pid");
                Enumeration keys = newProps.keys();
                ArrayList<String> propertiesStartingWithDot = new ArrayList<String>();
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    if (!key.startsWith(".")) continue;
                    propertiesStartingWithDot.add(key);
                }
                for (String k : propertiesStartingWithDot) {
                    newProps.remove(k);
                }
                this.__getm_providedServiceHandler().addProperties(newProps);
            }
        }
    }

    @Override
    public void onCreation(Object instance) {
        if (!this.__MonCreation$java_lang_Object) {
            this.__M_onCreation(instance);
            return;
        }
        try {
            this.__IM.onEntry(this, "onCreation$java_lang_Object", new Object[]{instance});
            this.__M_onCreation(instance);
            this.__IM.onExit(this, "onCreation$java_lang_Object", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError(this, "onCreation$java_lang_Object", throwable);
            throw throwable;
        }
    }

    private void __M_onCreation(Object instance) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (Property prop : this.__getm_configurableProperties()) {
            if (prop.hasMethod()) {
                prop.invoke(instance);
            }
            map.put(prop.getName(), prop.getValue());
        }
        try {
            this.notifyUpdated(instance);
        }
        catch (Throwable e) {
            this.error("Cannot call the updated method : " + e.getMessage(), e);
        }
        this.notifyListeners(map);
    }

    private void notifyUpdated(Object instance) {
        if (!this.__MnotifyUpdated$java_lang_Object) {
            this.__M_notifyUpdated(instance);
            return;
        }
        try {
            this.__IM.onEntry(this, "notifyUpdated$java_lang_Object", new Object[]{instance});
            this.__M_notifyUpdated(instance);
            this.__IM.onExit(this, "notifyUpdated$java_lang_Object", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError(this, "notifyUpdated$java_lang_Object", throwable);
            throw throwable;
        }
    }

    private void __M_notifyUpdated(Object instance) {
        if (this.__getm_updated() == null) {
            return;
        }
        if (this.__getm_updated().getArguments().length == 0) {
            try {
                if (instance == null) {
                    this.__getm_updated().call(new Object[0]);
                } else {
                    this.__getm_updated().call(instance, new Object[0]);
                }
            }
            catch (Exception e) {
                this.error("Cannot call the updated method " + this.__getm_updated().getMethod() + " : " + e.getMessage());
            }
            return;
        }
        Properties props = new Properties();
        for (Property property : this.__getm_configurableProperties()) {
            String n = property.getName();
            Object v = property.getValue();
            if (v == Property.NO_VALUE) continue;
            props.put(n, v);
        }
        if (this.__getm_mustPropagate()) {
            String k;
            Enumeration e;
            if (this.__getm_propagatedFromCA() != null) {
                e = this.__getm_propagatedFromCA().keys();
                while (e.hasMoreElements()) {
                    k = (String)e.nextElement();
                    if (k.equals("instance.name")) continue;
                    props.put(k, this.__getm_propagatedFromCA().get(k));
                }
            }
            if (this.__getm_propagatedFromInstance() != null) {
                e = this.__getm_propagatedFromInstance().keys();
                while (e.hasMoreElements()) {
                    k = (String)e.nextElement();
                    if (k.equals("instance.name")) continue;
                    props.put(k, this.__getm_propagatedFromInstance().get(k));
                }
            }
        }
        try {
            if (instance == null) {
                this.__getm_updated().call(new Object[]{props});
            } else {
                this.__getm_updated().call(instance, new Object[]{props});
            }
        }
        catch (Exception e) {
            this.error("Cannot call the updated method " + this.__getm_updated().getMethod() + " : " + e.getMessage());
        }
    }

    public void updated(Dictionary conf) throws org.osgi.service.cm.ConfigurationException {
        if (!this.__Mupdated$java_util_Dictionary) {
            this.__M_updated(conf);
            return;
        }
        try {
            this.__IM.onEntry(this, "updated$java_util_Dictionary", new Object[]{conf});
            this.__M_updated(conf);
            this.__IM.onExit(this, "updated$java_util_Dictionary", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError(this, "updated$java_util_Dictionary", throwable);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void __M_updated(Dictionary conf) throws org.osgi.service.cm.ConfigurationException {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        ConfigurationHandler configurationHandler = this;
        synchronized (configurationHandler) {
            if (conf == null && !this.__getm_configurationAlreadyPushed()) {
                return;
            }
            if (conf != null) {
                Properties props = this.reconfigureProperties(conf);
                this.propagate(props, this.__getm_propagatedFromCA());
                this.__setm_propagatedFromCA(props);
                this.__setm_configurationAlreadyPushed(true);
            } else if (this.__getm_configurationAlreadyPushed()) {
                this.propagate(null, this.__getm_propagatedFromCA());
                this.__setm_propagatedFromCA(null);
                this.__setm_configurationAlreadyPushed(false);
            }
            if (this.getInstanceManager().getPojoObjects() != null) {
                try {
                    this.notifyUpdated(null);
                }
                catch (Throwable e) {
                    this.error("Cannot call the updated method : " + e.getMessage(), e);
                }
            }
            for (Property p : this.__getm_configurableProperties()) {
                map.put(p.getName(), p.getValue());
            }
        }
        this.notifyListeners(map);
    }

    @Override
    public HandlerDescription getDescription() {
        HandlerDescription handlerDescription;
        if (!this.__MgetDescription) {
            return this.__M_getDescription();
        }
        try {
            this.__IM.onEntry(this, "getDescription", new Object[0]);
            handlerDescription = this.__M_getDescription();
            this.__IM.onExit(this, "getDescription", handlerDescription);
        }
        catch (Throwable throwable) {
            this.__IM.onError(this, "getDescription", throwable);
            throw throwable;
        }
        return handlerDescription;
    }

    private HandlerDescription __M_getDescription() {
        return this.__getm_description();
    }

    public void addListener(ConfigurationListener listener) {
        if (!this.__MaddListener$org_apache_felix_ipojo_handlers_configuration_ConfigurationListener) {
            this.__M_addListener(listener);
            return;
        }
        try {
            this.__IM.onEntry(this, "addListener$org_apache_felix_ipojo_handlers_configuration_ConfigurationListener", new Object[]{listener});
            this.__M_addListener(listener);
            this.__IM.onExit(this, "addListener$org_apache_felix_ipojo_handlers_configuration_ConfigurationListener", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError(this, "addListener$org_apache_felix_ipojo_handlers_configuration_ConfigurationListener", throwable);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void __M_addListener(ConfigurationListener listener) {
        if (listener == null) {
            throw new NullPointerException("null listener");
        }
        Set set = this.__getm_listeners();
        synchronized (set) {
            this.__getm_listeners().add(listener);
        }
    }

    public void removeListener(ConfigurationListener listener) {
        if (!this.__MremoveListener$org_apache_felix_ipojo_handlers_configuration_ConfigurationListener) {
            this.__M_removeListener(listener);
            return;
        }
        try {
            this.__IM.onEntry(this, "removeListener$org_apache_felix_ipojo_handlers_configuration_ConfigurationListener", new Object[]{listener});
            this.__M_removeListener(listener);
            this.__IM.onExit(this, "removeListener$org_apache_felix_ipojo_handlers_configuration_ConfigurationListener", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError(this, "removeListener$org_apache_felix_ipojo_handlers_configuration_ConfigurationListener", throwable);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void __M_removeListener(ConfigurationListener listener) {
        if (listener == null) {
            throw new NullPointerException("The list of listener is null");
        }
        Set set = this.__getm_listeners();
        synchronized (set) {
            ConfigurationListener found = null;
            for (ConfigurationListener l : this.__getm_listeners()) {
                if (l != listener) continue;
                found = l;
                break;
            }
            if (found != null) {
                this.__getm_listeners().remove(found);
            }
        }
    }

    private void notifyListeners(Map<String, Object> map) {
        if (!this.__MnotifyListeners$java_util_Map) {
            this.__M_notifyListeners(map);
            return;
        }
        try {
            this.__IM.onEntry(this, "notifyListeners$java_util_Map", new Object[]{map});
            this.__M_notifyListeners(map);
            this.__IM.onExit(this, "notifyListeners$java_util_Map", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError(this, "notifyListeners$java_util_Map", throwable);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void __M_notifyListeners(Map<String, Object> map) {
        ArrayList tmp;
        Set set = this.__getm_listeners();
        synchronized (set) {
            tmp = new ArrayList(this.__getm_listeners());
            if (map == null) {
                if (this.__getm_lastConfiguration() == null) {
                    return;
                }
            } else if (this.__getm_lastConfiguration() != null && this.__getm_lastConfiguration().size() == map.size()) {
                boolean diff = false;
                for (String k : map.keySet()) {
                    if (map.get(k).equals(this.__getm_lastConfiguration().get(k))) continue;
                    diff = true;
                    break;
                }
                if (!diff) {
                    return;
                }
            }
            if (map == null) {
                this.__setm_lastConfiguration(Collections.emptyMap());
            } else {
                this.__setm_lastConfiguration(Collections.unmodifiableMap(map));
            }
        }
        if (!tmp.isEmpty()) {
            this.getLogger().log(4, String.format("[%s] Notifying configuration listener: %s", this.getInstanceManager().getInstanceName(), tmp));
        }
        for (ConfigurationListener l : tmp) {
            try {
                l.configurationChanged(this.getInstanceManager(), this.__getm_lastConfiguration());
            }
            catch (Throwable e) {
                this.warn(String.format("[%s] A ConfigurationListener has failed: %s", this.getInstanceManager().getInstanceName(), e.getMessage()), e);
            }
        }
    }

    @Override
    public void stateChanged(int state) {
        if (!this.__MstateChanged$int) {
            this.__M_stateChanged(state);
            return;
        }
        try {
            this.__IM.onEntry(this, "stateChanged$int", new Object[]{new Integer(state)});
            this.__M_stateChanged(state);
            this.__IM.onExit(this, "stateChanged$int", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError(this, "stateChanged$int", throwable);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void __M_stateChanged(int state) {
        if (state == -1) {
            Set set = this.__getm_listeners();
            synchronized (set) {
                this.__getm_listeners().clear();
            }
        }
        super.stateChanged(state);
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("m_configurableProperties")) {
                this.__Fm_configurableProperties = true;
            }
            if (set.contains("m_configurationAlreadyPushed")) {
                this.__Fm_configurationAlreadyPushed = true;
            }
            if (set.contains("m_description")) {
                this.__Fm_description = true;
            }
            if (set.contains("m_lastConfiguration")) {
                this.__Fm_lastConfiguration = true;
            }
            if (set.contains("m_listeners")) {
                this.__Fm_listeners = true;
            }
            if (set.contains("m_managedServicePID")) {
                this.__Fm_managedServicePID = true;
            }
            if (set.contains("m_mustPropagate")) {
                this.__Fm_mustPropagate = true;
            }
            if (set.contains("m_propagatedFromCA")) {
                this.__Fm_propagatedFromCA = true;
            }
            if (set.contains("m_propagatedFromInstance")) {
                this.__Fm_propagatedFromInstance = true;
            }
            if (set.contains("m_providedServiceHandler")) {
                this.__Fm_providedServiceHandler = true;
            }
            if (set.contains("m_sr")) {
                this.__Fm_sr = true;
            }
            if (set.contains("m_toPropagate")) {
                this.__Fm_toPropagate = true;
            }
            if (set.contains("m_updated")) {
                this.__Fm_updated = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("initializeComponentFactory$org_apache_felix_ipojo_architecture_ComponentTypeDescription$org_apache_felix_ipojo_metadata_Element")) {
                this.__MinitializeComponentFactory$org_apache_felix_ipojo_architecture_ComponentTypeDescription$org_apache_felix_ipojo_metadata_Element = true;
            }
            if (set.contains("configure$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary")) {
                this.__Mconfigure$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary = true;
            }
            if (set.contains("stop")) {
                this.__Mstop = true;
            }
            if (set.contains("start")) {
                this.__Mstart = true;
            }
            if (set.contains("addProperty$org_apache_felix_ipojo_util_Property")) {
                this.__MaddProperty$org_apache_felix_ipojo_util_Property = true;
            }
            if (set.contains("reconfigure$java_util_Dictionary")) {
                this.__Mreconfigure$java_util_Dictionary = true;
            }
            if (set.contains("detectConfigurationChanges$java_util_Dictionary")) {
                this.__MdetectConfigurationChanges$java_util_Dictionary = true;
            }
            if (set.contains("getPropertyByName$java_lang_String")) {
                this.__MgetPropertyByName$java_lang_String = true;
            }
            if (set.contains("reconfigureProperties$java_util_Dictionary")) {
                this.__MreconfigureProperties$java_util_Dictionary = true;
            }
            if (set.contains("excluded$java_lang_String")) {
                this.__Mexcluded$java_lang_String = true;
            }
            if (set.contains("reconfigureProperty$org_apache_felix_ipojo_util_Property$java_lang_Object")) {
                this.__MreconfigureProperty$org_apache_felix_ipojo_util_Property$java_lang_Object = true;
            }
            if (set.contains("propagate$java_util_Dictionary$java_util_Dictionary")) {
                this.__Mpropagate$java_util_Dictionary$java_util_Dictionary = true;
            }
            if (set.contains("onCreation$java_lang_Object")) {
                this.__MonCreation$java_lang_Object = true;
            }
            if (set.contains("notifyUpdated$java_lang_Object")) {
                this.__MnotifyUpdated$java_lang_Object = true;
            }
            if (set.contains("updated$java_util_Dictionary")) {
                this.__Mupdated$java_util_Dictionary = true;
            }
            if (set.contains("getDescription")) {
                this.__MgetDescription = true;
            }
            if (set.contains("addListener$org_apache_felix_ipojo_handlers_configuration_ConfigurationListener")) {
                this.__MaddListener$org_apache_felix_ipojo_handlers_configuration_ConfigurationListener = true;
            }
            if (set.contains("removeListener$org_apache_felix_ipojo_handlers_configuration_ConfigurationListener")) {
                this.__MremoveListener$org_apache_felix_ipojo_handlers_configuration_ConfigurationListener = true;
            }
            if (set.contains("notifyListeners$java_util_Map")) {
                this.__MnotifyListeners$java_util_Map = true;
            }
            if (set.contains("stateChanged$int")) {
                this.__MstateChanged$int = true;
            }
        }
    }

    @Override
    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

