/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.jmx;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.UnicastRemoteObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.IntConsumer;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import javax.rmi.ssl.SslRMIClientSocketFactory;
import org.eclipse.jetty.util.HostPort;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.ShutdownThread;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectorServer
extends AbstractLifeCycle {
    public static final String RMI_REGISTRY_CLIENT_SOCKET_FACTORY_ATTRIBUTE = "com.sun.jndi.rmi.factory.socket";
    private static final Logger LOG = LoggerFactory.getLogger(ConnectorServer.class);
    private JMXServiceURL _jmxURL;
    private final Map<String, Object> _environment;
    private String _objectName;
    private SslContextFactory.Server _sslContextFactory;
    private int _registryPort;
    private int _rmiPort;
    private JMXConnectorServer _connectorServer;
    private Registry _registry;

    public ConnectorServer(JMXServiceURL serviceURL, String objectName) {
        this(serviceURL, null, objectName);
    }

    public ConnectorServer(JMXServiceURL serviceURL, Map<String, ?> environment, String objectName) {
        this(serviceURL, environment, objectName, null);
    }

    public ConnectorServer(JMXServiceURL serviceURL, Map<String, ?> environment, String objectName, SslContextFactory.Server sslContextFactory) {
        this._jmxURL = serviceURL;
        this._environment = environment == null ? new HashMap<String, Object>() : new HashMap(environment);
        this._objectName = objectName;
        this._sslContextFactory = sslContextFactory;
    }

    public JMXServiceURL getAddress() {
        return this._jmxURL;
    }

    public void putAttribute(String name, Object value) {
        this._environment.put(name, value);
    }

    public String getObjectName() {
        return this._objectName;
    }

    public void setObjectName(String objectName) {
        this._objectName = objectName;
    }

    public SslContextFactory.Server getSslContextFactory() {
        return this._sslContextFactory;
    }

    public void setSslContextFactory(SslContextFactory.Server sslContextFactory) {
        this._sslContextFactory = sslContextFactory;
    }

    @Override
    public void doStart() throws Exception {
        String jndiRMI;
        Object urlPath;
        boolean rmi = "rmi".equals(this._jmxURL.getProtocol());
        if (rmi) {
            if (!this._environment.containsKey("jmx.remote.rmi.server.socket.factory")) {
                this._environment.put("jmx.remote.rmi.server.socket.factory", new JMXRMIServerSocketFactory(this._jmxURL.getHost(), port -> {
                    this._rmiPort = port;
                }));
            }
            if (this.getSslContextFactory() != null) {
                SslRMIClientSocketFactory csf = new SslRMIClientSocketFactory();
                if (!this._environment.containsKey("jmx.remote.rmi.client.socket.factory")) {
                    this._environment.put("jmx.remote.rmi.client.socket.factory", csf);
                }
                if (!this._environment.containsKey(RMI_REGISTRY_CLIENT_SOCKET_FACTORY_ATTRIBUTE)) {
                    this._environment.put(RMI_REGISTRY_CLIENT_SOCKET_FACTORY_ATTRIBUTE, csf);
                }
            }
        }
        if (((String)(urlPath = this._jmxURL.getURLPath())).startsWith(jndiRMI = "/jndi/rmi://")) {
            int startIndex = jndiRMI.length();
            int endIndex = ((String)urlPath).indexOf(47, startIndex);
            HostPort hostPort = new HostPort(((String)urlPath).substring(startIndex, endIndex));
            String registryHost = this.startRegistry(hostPort);
            if (this._registryPort == 0) {
                this._registryPort = hostPort.getPort();
            }
            urlPath = jndiRMI + registryHost + ":" + this._registryPort + ((String)urlPath).substring(endIndex);
            this._jmxURL = new JMXServiceURL(this._jmxURL.getProtocol(), this._jmxURL.getHost(), this._jmxURL.getPort(), (String)urlPath);
        }
        MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
        this._connectorServer = JMXConnectorServerFactory.newJMXConnectorServer(this._jmxURL, this._environment, mbeanServer);
        mbeanServer.registerMBean(this._connectorServer, new ObjectName(this.getObjectName()));
        this._connectorServer.start();
        String rmiHost = this.normalizeHost(this._jmxURL.getHost());
        if (this._rmiPort == 0) {
            this._rmiPort = this._registryPort;
        }
        this._jmxURL = new JMXServiceURL(this._jmxURL.getProtocol(), rmiHost, this._rmiPort, (String)urlPath);
        ShutdownThread.register(0, this);
        LOG.info("JMX URL: {}", (Object)this._jmxURL);
    }

    @Override
    public void doStop() throws Exception {
        ShutdownThread.deregister(this);
        this._connectorServer.stop();
        MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
        mbeanServer.unregisterMBean(new ObjectName(this.getObjectName()));
        this.stopRegistry();
    }

    private String startRegistry(HostPort hostPort) throws Exception {
        String host = hostPort.getHost();
        int port = hostPort.getPort(1099);
        try {
            LocateRegistry.getRegistry(host, port).list();
            return this.normalizeHost(host);
        }
        catch (Throwable ex) {
            LOG.trace("IGNORED", ex);
            SslRMIClientSocketFactory csf = this._sslContextFactory == null ? null : new SslRMIClientSocketFactory();
            JMXRMIServerSocketFactory ssf = new JMXRMIServerSocketFactory(host, p -> {
                this._registryPort = p;
            });
            this._registry = LocateRegistry.createRegistry(port, csf, ssf);
            return this.normalizeHost(host);
        }
    }

    private String normalizeHost(String host) throws UnknownHostException {
        return host == null || host.isEmpty() ? InetAddress.getLocalHost().getHostName() : host;
    }

    private void stopRegistry() {
        if (this._registry != null) {
            try {
                UnicastRemoteObject.unexportObject(this._registry, true);
            }
            catch (Exception ex) {
                LOG.trace("IGNORED", (Throwable)ex);
            }
            finally {
                this._registry = null;
            }
        }
    }

    private class JMXRMIServerSocketFactory
    implements RMIServerSocketFactory {
        private final String _host;
        private final IntConsumer _portConsumer;

        private JMXRMIServerSocketFactory(String host, IntConsumer portConsumer) {
            this._host = host;
            this._portConsumer = portConsumer;
        }

        @Override
        public ServerSocket createServerSocket(int port) throws IOException {
            InetAddress address = this._host == null || this._host.isEmpty() ? InetAddress.getLocalHost() : InetAddress.getByName(this._host);
            ServerSocket server = this.createServerSocket(address, port);
            this._portConsumer.accept(server.getLocalPort());
            return server;
        }

        private ServerSocket createServerSocket(InetAddress address, int port) throws IOException {
            if (ConnectorServer.this._sslContextFactory == null) {
                ServerSocket server = new ServerSocket();
                server.setReuseAddress(true);
                try {
                    server.bind(new InetSocketAddress(address, port));
                }
                catch (Throwable e) {
                    IO.close(server);
                    throw e;
                }
                return server;
            }
            return ConnectorServer.this._sslContextFactory.newSslServerSocket(address == null ? null : address.getHostName(), port, 0);
        }

        public int hashCode() {
            return this._host != null ? this._host.hashCode() : 0;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            JMXRMIServerSocketFactory that = (JMXRMIServerSocketFactory)obj;
            return Objects.equals(this._host, that._host);
        }
    }
}

