/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.connect;

import java.util.HashSet;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.service.packageadmin.ExportedPackage;

class ExportedPackageImpl
implements ExportedPackage {
    private final BundleCapability m_export;

    public ExportedPackageImpl(BundleCapability export) {
        this.m_export = export;
    }

    @Override
    public Bundle getExportingBundle() {
        return this.m_export.getRevision().getBundle();
    }

    @Override
    public Bundle[] getImportingBundles() {
        HashSet<Bundle> result = new HashSet<Bundle>();
        for (BundleWire wire : this.m_export.getRevision().getWiring().getProvidedWires(null)) {
            if (wire.getCapability() != this.m_export && !"osgi.wiring.bundle".equals(wire.getCapability().getNamespace())) continue;
            result.add(wire.getRequirer().getBundle());
        }
        return result.toArray(new Bundle[result.size()]);
    }

    @Override
    public String getName() {
        return (String)this.m_export.getAttributes().get("osgi.wiring.package");
    }

    @Override
    public String getSpecificationVersion() {
        return this.getVersion().toString();
    }

    @Override
    public Version getVersion() {
        return this.m_export.getAttributes().containsKey("version") ? (Version)this.m_export.getAttributes().get("version") : Version.emptyVersion;
    }

    @Override
    public boolean isRemovalPending() {
        return false;
    }

    public String toString() {
        return this.getName() + "; version=" + this.getVersion();
    }
}

