/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.connect;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.zip.ZipEntry;

class EntriesEnumeration
implements Enumeration<String> {
    private final Enumeration<? extends ZipEntry> m_enumeration;
    private final String m_prefix;
    private volatile String current;

    public EntriesEnumeration(Enumeration<? extends ZipEntry> enumeration) {
        this(enumeration, null);
    }

    public EntriesEnumeration(Enumeration<? extends ZipEntry> enumeration, String prefix) {
        this.m_enumeration = enumeration;
        this.m_prefix = prefix;
    }

    @Override
    public boolean hasMoreElements() {
        while (this.current == null && this.m_enumeration.hasMoreElements()) {
            String result = this.m_enumeration.nextElement().getName();
            if (this.m_prefix != null) {
                if (!result.startsWith(this.m_prefix)) continue;
                this.current = result.substring(this.m_prefix.length());
                continue;
            }
            this.current = result;
        }
        return this.current != null;
    }

    @Override
    public String nextElement() {
        try {
            if (this.hasMoreElements()) {
                String string = this.current;
                return string;
            }
            throw new NoSuchElementException();
        }
        finally {
            this.current = null;
        }
    }
}

