/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.atomos.maven;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.felix.atomos.maven.configs.MavenClassPathFileConfig;
import org.apache.felix.atomos.maven.configs.MavenClasspathMavenConfig;
import org.apache.felix.atomos.maven.configs.MavenIndexConfig;
import org.apache.felix.atomos.maven.configs.MavenNativeImageConfig;
import org.apache.felix.atomos.maven.configs.MavenShadeConfig;
import org.apache.felix.atomos.maven.index.AtomosIndexMojo;
import org.apache.felix.atomos.utils.api.FileType;
import org.apache.felix.atomos.utils.core.plugins.collector.PathCollectorPluginConfig;
import org.apache.felix.atomos.utils.core.plugins.finaliser.ni.NativeImageBuilderConfig;
import org.apache.felix.atomos.utils.core.plugins.finaliser.shade.ShadeConfig;
import org.apache.felix.atomos.utils.core.plugins.index.IndexOutputType;
import org.apache.felix.atomos.utils.core.plugins.index.IndexPluginConfig;
import org.apache.maven.project.MavenProject;

public class LauncherBuilderUtil {
    public static PathCollectorPluginConfig processClasspathFile(final MavenClassPathFileConfig filesIndexMojoConfig) {
        PathCollectorPluginConfig dc = new PathCollectorPluginConfig(){

            public FileType fileType() {
                return filesIndexMojoConfig.fileType;
            }

            public List<String> filters() {
                return filesIndexMojoConfig.filters;
            }

            public List<Path> paths() {
                return Optional.ofNullable(filesIndexMojoConfig.files).orElse(List.of()).stream().filter(Objects::nonNull).map(File::toPath).collect(Collectors.toList());
            }
        };
        return dc;
    }

    public static PathCollectorPluginConfig processClasspathMaven(MavenProject project, MavenClasspathMavenConfig mavenIndexMojoConfig) {
        ArrayList<MavenProject> projects = new ArrayList<MavenProject>();
        projects.add(project);
        if (mavenIndexMojoConfig.includingParent) {
            while (project.hasParent()) {
                projects.add(project.getParent());
            }
        }
        final List paths = projects.stream().flatMap(p -> p.getArtifacts().stream()).filter(AtomosIndexMojo::isJarFile).filter(a -> {
            String scope = a.getScope().isEmpty() ? "*" : a.getScope();
            return Optional.ofNullable(mavenIndexMojoConfig.scopePatterns).orElse(List.of(".*")).stream().anyMatch(s -> scope.matches((String)s));
        }).filter(a -> Optional.ofNullable(mavenIndexMojoConfig.groupIdPattern).orElse(List.of(".*")).stream().anyMatch(s -> a.getGroupId().matches((String)s))).filter(a -> Optional.ofNullable(mavenIndexMojoConfig.artefictIdPattern).orElse(List.of(".*")).stream().anyMatch(s -> a.getArtifactId().matches((String)s))).map(a -> a.getFile().toPath()).sorted().collect(Collectors.toList());
        PathCollectorPluginConfig dc = new PathCollectorPluginConfig(){

            public FileType fileType() {
                return FileType.ARTIFACT;
            }

            public List<String> filters() {
                return null;
            }

            public List<Path> paths() {
                return paths;
            }
        };
        return dc;
    }

    public static IndexPluginConfig processIndex(final MavenIndexConfig indexConfig, MavenProject project) throws IOException {
        final Path indexOutputDirectoryPath = Optional.ofNullable(indexConfig.indexOutputDirectory).orElse(new File(project.getBuild().getOutputDirectory())).toPath();
        Files.createDirectories(indexOutputDirectoryPath, new FileAttribute[0]);
        IndexPluginConfig ic = new IndexPluginConfig(){

            public Path indexOutputDirectory() {
                return indexOutputDirectoryPath;
            }

            public IndexOutputType indexOutputType() {
                return indexConfig.indexOutputType;
            }
        };
        return ic;
    }

    public static NativeImageBuilderConfig processNativeImageConfig(final MavenNativeImageConfig nativeImageConfig, MavenProject project) {
        NativeImageBuilderConfig nic = new NativeImageBuilderConfig(){

            public List<Path> dynamicProxyConfigurationFiles() {
                return Optional.ofNullable(nativeImageConfig.dynamicProxyConfigurationFiles).map(Collection::stream).orElse(Stream.of(new File[0])).map(File::toPath).collect(Collectors.toList());
            }

            public List<Path> reflectionConfigurationFiles() {
                return Optional.ofNullable(nativeImageConfig.reflectionConfigurationFiles).map(Collection::stream).orElse(Stream.of(new File[0])).map(File::toPath).collect(Collectors.toList());
            }

            public List<Path> resourceConfigurationFiles() {
                return Optional.ofNullable(nativeImageConfig.resourceConfigurationFiles).map(Collection::stream).orElse(Stream.of(new File[0])).map(File::toPath).collect(Collectors.toList());
            }

            public List<String> nativeImageAdditionalInitializeAtBuildTime() {
                return nativeImageConfig.additionalInitializeAtBuildTime;
            }

            public String nativeImageApplicationName() {
                return nativeImageConfig.applicationName;
            }

            public Path nativeImageExecutable() {
                return Optional.ofNullable(nativeImageConfig.nativeImageExecutable).map(File::toPath).orElse(null);
            }

            public String nativeImageMainClass() {
                if (nativeImageConfig.mainClass == null || nativeImageConfig.mainClass.isEmpty()) {
                    return "org.apache.felix.atomos.Atomos";
                }
                return nativeImageConfig.mainClass;
            }

            public Path nativeImageOutputDirectory() {
                return Optional.ofNullable(nativeImageConfig.outputDirectory).map(File::toPath).orElse(null);
            }

            public List<String> nativeImageVmFlags() {
                return nativeImageConfig.vmFlags;
            }

            public Map<String, String> nativeImageVmSystemProperties() {
                return nativeImageConfig.vmSystemProperties;
            }

            public Boolean noFallback() {
                return nativeImageConfig.noFallBack;
            }
        };
        return nic;
    }

    public static ShadeConfig processShade(final MavenShadeConfig shade, final MavenProject project) {
        ShadeConfig sc = new ShadeConfig(){

            public Path shadeOutputDirectory() {
                return shade.shadeOutputDirectory != null ? shade.shadeOutputDirectory.toPath() : Paths.get(project.getBuild().getDirectory(), new String[0]);
            }
        };
        return sc;
    }
}

