/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.enhancer;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.enhancer.DoubleEnhanceException;
import org.apache.cayenne.enhancer.EnhancementHelper;
import org.objectweb.asm.ClassAdapter;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;

public class EmbeddableVisitor
extends ClassAdapter {
    private static String OWNER_FEILD = "owner";
    private static String EMBEDDED_PROPERTY_FEILD = "embeddedProperty";
    protected EnhancementHelper helper = new EnhancementHelper((ClassVisitor)this);
    protected Collection<String> reservedFieldNames = new ArrayList<String>(2);
    protected boolean checkReserved = true;

    public EmbeddableVisitor(ClassVisitor visitor) {
        super(visitor);
        this.reservedFieldNames.add(this.helper.getPropertyField(OWNER_FEILD));
        this.reservedFieldNames.add(this.helper.getPropertyField(EMBEDDED_PROPERTY_FEILD));
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        if (this.checkReserved && this.reservedFieldNames.contains(name)) {
            throw new DoubleEnhanceException("Embeddable class already contains field " + name);
        }
        return super.visitField(access, name, desc, signature, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitEnd() {
        this.checkReserved = false;
        try {
            this.helper.createField(Persistent.class, OWNER_FEILD);
            this.helper.createField(String.class, EMBEDDED_PROPERTY_FEILD);
        }
        finally {
            this.checkReserved = true;
        }
    }
}

