/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.select;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.access.select.EntitySelectColumn;
import org.apache.cayenne.access.types.ExtendedTypeMap;
import org.apache.cayenne.dba.TypesMapping;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.map.PathComponent;
import org.apache.cayenne.util.CayenneMapEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class MappedColumnBuilder {
    protected List<EntitySelectColumn> columns = new ArrayList<EntitySelectColumn>();
    protected Map<String, Integer> columnMap = new HashMap<String, Integer>();
    protected ExtendedTypeMap extendedTypes;

    MappedColumnBuilder(ExtendedTypeMap extendedTypes) {
        this.extendedTypes = extendedTypes;
    }

    protected void append(ObjAttribute attribute) {
        if (!this.columnMap.containsKey(attribute.getDbAttributePath())) {
            CayenneMapEntry pathComponent;
            ArrayList<DbRelationship> path = new ArrayList<DbRelationship>(2);
            Iterator<CayenneMapEntry> it = attribute.getDbPathIterator();
            while (it.hasNext() && (pathComponent = it.next()) instanceof DbRelationship) {
                path.add((DbRelationship)pathComponent);
            }
            this.makeColumn(attribute.getDbAttributePath(), attribute, path);
        }
    }

    protected void append(DbAttribute attribute) {
        if (!this.columnMap.containsKey(attribute.getName())) {
            this.makeColumn(attribute.getName(), attribute, null);
        }
    }

    protected void append(DbEntity root, Expression dbPath) {
        String pathString = dbPath.getOperand(0).toString();
        if (!this.columnMap.containsKey(pathString)) {
            ArrayList<DbRelationship> relationships = null;
            for (PathComponent<DbAttribute, DbRelationship> c : root.resolvePath(dbPath, Collections.emptyMap())) {
                if (c.isLast()) {
                    this.makeColumn(pathString, c.getAttribute(), (List<DbRelationship>)relationships);
                    continue;
                }
                if (relationships == null) {
                    relationships = new ArrayList<DbRelationship>(2);
                }
                relationships.add(c.getRelationship());
            }
        }
    }

    protected void append(ObjEntity root, Expression objPath) {
        Expression dbPath = root.translateToDbPath(objPath);
        String pathString = dbPath.getOperand(0).toString();
        if (!this.columnMap.containsKey(pathString)) {
            ArrayList<DbRelationship> relationships = null;
            for (PathComponent<ObjAttribute, ObjRelationship> c : root.resolvePath(objPath, Collections.emptyMap())) {
                if (c.isLast()) {
                    this.makeColumn(pathString, c.getAttribute(), relationships);
                    continue;
                }
                if (relationships == null) {
                    relationships = new ArrayList<DbRelationship>(2);
                }
                relationships.addAll(c.getRelationship().getDbRelationships());
            }
        }
    }

    private EntitySelectColumn makeColumn(String dataRowKey, ObjAttribute attribute, List<DbRelationship> relationships) {
        EntitySelectColumn column = new EntitySelectColumn();
        DbAttribute dbAttribute = attribute.getDbAttribute();
        if (dbAttribute == null) {
            int jdbcType = TypesMapping.getSqlTypeByJava(attribute.getType());
            column.setColumnName(TypesMapping.isNumeric(jdbcType) ? "1" : "'1'");
            column.setJdbcType(jdbcType);
        } else {
            column.setColumnName(dbAttribute.getName());
            column.setJdbcType(dbAttribute.getType());
        }
        column.setDataRowKey(dataRowKey);
        column.setConverter(this.extendedTypes.getRegisteredType(attribute.getType()));
        column.setPath(relationships);
        this.columnMap.put(dataRowKey, this.columns.size());
        this.columns.add(column);
        return column;
    }

    private EntitySelectColumn makeColumn(String dataRowKey, DbAttribute attribute, List<DbRelationship> relationships) {
        EntitySelectColumn column = new EntitySelectColumn();
        column.setColumnName(attribute.getName());
        column.setJdbcType(attribute.getType());
        column.setDataRowKey(dataRowKey);
        String javaType = TypesMapping.getJavaBySqlType(attribute.getType());
        column.setConverter(this.extendedTypes.getRegisteredType(javaType));
        column.setPath(relationships);
        this.columnMap.put(dataRowKey, this.columns.size());
        this.columns.add(column);
        return column;
    }
}

