/*
 * Decompiled with CFR 0.152.
 */
package org.scopemvc.view.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.scopemvc.core.ModelChangeEvent;
import org.scopemvc.core.ModelChangeEventSource;
import org.scopemvc.core.ModelChangeListener;
import org.scopemvc.core.PropertyManager;
import org.scopemvc.core.Selector;
import org.scopemvc.view.util.BoundModel;
import org.scopemvc.view.util.ModelBindable;

public class ActiveBoundModel
extends BoundModel
implements ModelChangeListener {
    private static final Log LOG = LogFactory.getLog(class$org$scopemvc$view$util$ActiveBoundModel == null ? (class$org$scopemvc$view$util$ActiveBoundModel = ActiveBoundModel.class$("org.scopemvc.view.util.ActiveBoundModel")) : class$org$scopemvc$view$util$ActiveBoundModel);
    private ModelBindable view;
    private PropertyManager manager;
    private boolean selectorMandatory = true;
    static /* synthetic */ Class class$org$scopemvc$view$util$ActiveBoundModel;

    public ActiveBoundModel(ModelBindable modelBindable) {
        if (modelBindable == null) {
            throw new IllegalArgumentException("Can't create for null View.");
        }
        this.view = modelBindable;
    }

    public PropertyManager getPropertyManager() {
        return this.manager;
    }

    public boolean getPropertyReadOnly() {
        boolean bl;
        block2: {
            bl = true;
            if (this.getBoundModel() == null) break block2;
            try {
                bl = this.manager.isReadOnly(this.getBoundModel(), this.getSelector());
            }
            catch (Exception exception) {
                LOG.warn("Could not get property read-only state for selector " + Selector.asString(this.getSelector()) + " in model " + this.getBoundModel() + " because: " + exception.getMessage());
            }
        }
        return bl;
    }

    public Object getPropertyValue() {
        Object object;
        block2: {
            object = null;
            if (this.getBoundModel() == null) break block2;
            try {
                object = this.manager.get(this.getBoundModel(), this.getSelector());
            }
            catch (Exception exception) {
                LOG.warn("Could not get property value for selector " + Selector.asString(this.getSelector()) + " in model " + this.getBoundModel() + " because: " + exception.getMessage());
            }
        }
        return object;
    }

    public Class getPropertyClass() {
        Class clazz;
        block2: {
            clazz = null;
            if (this.getBoundModel() == null) break block2;
            try {
                clazz = this.manager.getPropertyClass(this.getBoundModel(), this.getSelector());
            }
            catch (Exception exception) {
                LOG.warn("Could not get property class for selector " + Selector.asString(this.getSelector()) + " in model " + this.getBoundModel() + " because: " + exception.getMessage());
            }
        }
        return clazz;
    }

    public boolean isSelectorMandatory() {
        return this.selectorMandatory;
    }

    public void setBoundModel(Object object) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("setBoundModel: " + object);
        }
        if (this.getBoundModel() instanceof ModelChangeEventSource) {
            ((ModelChangeEventSource)this.getBoundModel()).removeModelChangeListener(this);
        }
        this.manager = null;
        if (object instanceof ModelChangeEventSource) {
            ((ModelChangeEventSource)object).addModelChangeListener(this);
        }
        if (object != null) {
            this.manager = PropertyManager.getInstance(object);
        }
        super.setBoundModel(object);
        this.updateFromModel(0);
    }

    public void setSelector(Selector selector) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("setSelector: " + selector);
        }
        super.setSelector(selector);
        this.updateFromModel(0);
    }

    public void setSelectorMandatory(boolean bl) {
        this.selectorMandatory = bl;
    }

    public void modelChanged(ModelChangeEvent modelChangeEvent) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("modelChanged: view: " + this.view + ", event: " + modelChangeEvent);
            LOG.debug("modelChanged: property selector: " + Selector.asString(this.getSelector()) + ", event selector: " + Selector.asString(modelChangeEvent.getSelector()));
        }
        if (modelChangeEvent.getModel() == this.getBoundModel() && (this.getSelector() == null || this.getSelector().startsWith(modelChangeEvent.getSelector()))) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("modelChanged: for me!");
            }
            this.updateFromModel(modelChangeEvent.getType());
            this.view.validationSuccess();
        }
    }

    public void updateModel() {
        try {
            if (this.getSelector() == null) {
                if (this.isSelectorMandatory()) {
                    LOG.warn("View " + this.view + " doesn't have a selector");
                }
                return;
            }
            Object object = this.view.getViewValue();
            if (LOG.isDebugEnabled()) {
                LOG.debug("updateModel: view: " + this.view + ", currentViewValue: " + object);
            }
            if (this.getBoundModel() == null) {
                if (object != null) {
                    LOG.warn("View " + this.view + " is not bound to a model");
                }
                return;
            }
            Object object2 = this.getPropertyValue();
            if (!this.equals(object2, object)) {
                this.manager.set(this.getBoundModel(), this.getSelector(), object);
            }
            this.view.validationSuccess();
        }
        catch (Exception exception) {
            LOG.warn("Exception when updating model on view " + this.view, exception);
            this.view.validationFailed(exception);
        }
    }

    public void updateFromModel(int n) {
        Object object = this.getPropertyValue();
        boolean bl = this.getPropertyReadOnly();
        if (LOG.isDebugEnabled()) {
            LOG.debug("updateFromModel: view: " + this.view + ", eventType: " + n + ", property: " + object + ", readOnly: " + bl);
        }
        this.view.updateFromProperty(object, bl);
    }

    private boolean equals(Object object, Object object2) {
        return object == object2 || object != null && object.equals(object2);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

