/*
 * Decompiled with CFR 0.152.
 */
package org.scopemvc.util.convertor;

import java.text.NumberFormat;
import java.text.ParseException;
import org.scopemvc.util.convertor.NullStringConvertor;

public abstract class NumberStringConvertor
extends NullStringConvertor {
    private NumberFormat format = NumberFormat.getInstance();

    public NumberFormat getNumberFormat() {
        return this.format;
    }

    public void setNumberFormat(NumberFormat numberFormat) throws IllegalArgumentException {
        if (numberFormat == null) {
            throw new IllegalArgumentException("Passed number format cannot be null");
        }
        this.format = numberFormat;
    }

    public Object stringAsValue(String string) throws IllegalArgumentException {
        if (this.isNull(string)) {
            return null;
        }
        try {
            return this.format.parse(string);
        }
        catch (ParseException parseException) {
            throw new IllegalArgumentException(parseException.getMessage());
        }
    }

    public String valueAsString(Object object) throws IllegalArgumentException {
        if (object == null) {
            return this.getNullAsString();
        }
        if (!(object instanceof Number)) {
            throw new IllegalArgumentException("Passed object is not subclass of java.lang.Number. Its class is " + object.getClass());
        }
        return this.format.format(object);
    }
}

