/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.ashwood.graph.graphml;

import org.objectstyle.ashwood.graph.graphml.GraphmlConstants;
import org.objectstyle.ashwood.graph.graphml.GraphmlContext;
import org.objectstyle.ashwood.graph.graphml.GraphmlFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class GraphmlHandler
extends DefaultHandler {
    private GraphmlContext context;
    private GraphmlFactory factory;

    public GraphmlHandler(GraphmlContext context, GraphmlFactory factory) {
        if (context == null) {
            throw new NullPointerException("Context is null");
        }
        if (factory == null) {
            throw new NullPointerException("Factory is null");
        }
        this.context = context;
        this.factory = factory;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        String element = qName;
        if (GraphmlConstants.isGraphml(element)) {
            this.factory.createGraphml(this.context);
        } else if (GraphmlConstants.isGraph(element)) {
            String id = attributes.getValue("id");
            String edgedefault = attributes.getValue("edgedefault");
            this.factory.createGraph(this.context, id, edgedefault);
        } else if (GraphmlConstants.isNode(element)) {
            String id = attributes.getValue("id");
            this.factory.createNode(this.context, id);
        } else if (GraphmlConstants.isEdge(element)) {
            String id = attributes.getValue("id");
            String source = attributes.getValue("source");
            String target = attributes.getValue("target");
            String sourcePort = attributes.getValue("sourceport");
            String targetPort = attributes.getValue("targetport");
            String directed = attributes.getValue("directed");
            this.factory.createEdge(this.context, id, source, target, sourcePort, targetPort, directed);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        InputSource local = new InputSource(GraphmlHandler.class.getResourceAsStream("graphml.dtd"));
        return local;
    }
}

