/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.util;

import java.io.Serializable;
import java.math.BigInteger;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.swing.ImageIcon;
import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.types.ExtendedTypeMap;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.action.MultipleObjectsAction;
import org.apache.cayenne.modeler.util.CayenneAction;
import org.apache.cayenne.reflect.PropertyUtils;
import org.apache.cayenne.util.CayenneMapEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ModelerUtil {
    public static String getObjectName(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof CayenneMapEntry) {
            return ((CayenneMapEntry)object).getName();
        }
        if (object instanceof String) {
            return (String)object;
        }
        try {
            return (String)PropertyUtils.getProperty((Object)object, (String)"name");
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static ImageIcon buildIcon(String path) {
        ClassLoader cl = ModelerUtil.class.getClassLoader();
        URL url = cl.getResource("org/apache/cayenne/modeler/images/" + path);
        return new ImageIcon(url);
    }

    public static Collection<String> getDbAttributeNames(ProjectController mediator, DbEntity entity) {
        Set keys = entity.getAttributeMap().keySet();
        ArrayList<String> list = new ArrayList<String>(keys.size() + 1);
        list.add("");
        list.addAll(keys);
        return list;
    }

    public static String[] getRegisteredTypeNames() {
        String[] explicitList = new ExtendedTypeMap().getRegisteredTypeNames();
        HashSet<String> nonPrimitives = new HashSet<String>(Arrays.asList(explicitList));
        nonPrimitives.add(Calendar.class.getName());
        nonPrimitives.add(BigInteger.class.getName());
        nonPrimitives.add(Serializable.class.getName());
        nonPrimitives.add(Character.class.getName());
        nonPrimitives.add("char[]");
        nonPrimitives.add("java.lang.Character[]");
        nonPrimitives.add("java.lang.Byte[]");
        nonPrimitives.add("java.util.Date");
        nonPrimitives.remove(Void.TYPE.getName());
        Object[] nonPrimitivesNames = new String[nonPrimitives.size()];
        nonPrimitives.toArray(nonPrimitivesNames);
        Arrays.sort(nonPrimitivesNames);
        String[] primitivesNames = new String[]{"boolean", "byte", "char", "double", "float", "int", "long", "short"};
        String[] finalList = new String[primitivesNames.length + nonPrimitivesNames.length + 1];
        finalList[0] = "";
        System.arraycopy(primitivesNames, 0, finalList, 1, primitivesNames.length);
        System.arraycopy(nonPrimitivesNames, 0, finalList, primitivesNames.length + 1, nonPrimitivesNames.length);
        return finalList;
    }

    public static DataNode getNodeLinkedToMap(DataDomain domain, DataMap map) {
        Collection nodes = domain.getDataNodes();
        for (DataNode node : nodes) {
            if (!node.getDataMaps().contains(map)) continue;
            return node;
        }
        return null;
    }

    public static void updateActions(int numSelected, String ... actionNames) {
        for (String actionName : actionNames) {
            CayenneAction action = Application.getInstance().getAction(actionName);
            if (!(action instanceof MultipleObjectsAction)) continue;
            action.setEnabled(numSelected > 0);
            action.setName(((MultipleObjectsAction)((Object)action)).getActionName(numSelected > 1));
        }
    }
}

