/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.typedevent.bus.impl;

import java.util.Arrays;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.aries.component.dsl.CachingServiceReference;
import org.apache.aries.component.dsl.OSGi;
import org.apache.aries.component.dsl.OSGiResult;
import org.apache.aries.typedevent.bus.impl.TypedEventBusImpl;
import org.apache.aries.typedevent.bus.impl.TypedEventMonitorImpl;
import org.osgi.annotation.bundle.Header;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.typedevent.TypedEventBus;
import org.osgi.service.typedevent.TypedEventHandler;
import org.osgi.service.typedevent.UnhandledEventHandler;
import org.osgi.service.typedevent.UntypedEventHandler;
import org.osgi.service.typedevent.monitor.TypedEventMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Header(name="Bundle-Activator", value="${@class}")
public class TypedEventBusActivator
implements BundleActivator {
    private static final Logger _log = LoggerFactory.getLogger(TypedEventBusActivator.class);
    OSGiResult eventBus;

    public void start(BundleContext bundleContext) throws Exception {
        if (_log.isDebugEnabled()) {
            _log.debug("Aries Typed Event Bus Starting");
        }
        this.eventBus = OSGi.coalesce((OSGi[])new OSGi[]{OSGi.configuration((String)"org.apache.aries.typedevent.bus"), OSGi.just(Hashtable::new)}).map(this::toConfigProps).flatMap(configuration -> this.createProgram((Map<String, ?>)configuration)).run(bundleContext);
        if (_log.isDebugEnabled()) {
            _log.debug("Aries Typed Event Bus Started");
        }
    }

    private OSGi<?> createProgram(Map<String, ?> configuration) {
        Map<String, Object> serviceProps = this.toServiceProps(configuration);
        return OSGi.just(configuration).map(TypedEventMonitorImpl::new).effects(x -> {}, TypedEventMonitorImpl::destroy).flatMap(temi -> OSGi.register(TypedEventMonitor.class, (Object)temi, (Map)serviceProps).then(OSGi.just((Object)new TypedEventBusImpl((TypedEventMonitorImpl)temi, configuration)).effects(TypedEventBusImpl::start, TypedEventBusImpl::stop))).flatMap(tebi -> OSGi.all((OSGi[])new OSGi[]{OSGi.serviceReferences(TypedEventHandler.class, csr -> {
            tebi.updatedTypedEventHandler(csr.getServiceReference().getBundle(), this.getServiceProps(csr.getServiceReference()));
            return false;
        }).flatMap(csr -> OSGi.service((CachingServiceReference)csr).effects(handler -> tebi.addTypedEventHandler(csr.getServiceReference().getBundle(), (TypedEventHandler<?>)handler, this.getServiceProps(csr.getServiceReference())), handler -> tebi.removeTypedEventHandler((TypedEventHandler<?>)handler, this.getServiceProps(csr.getServiceReference())))), OSGi.serviceReferences(UntypedEventHandler.class, csr -> {
            tebi.updatedUntypedEventHandler(this.getServiceProps(csr.getServiceReference()));
            return false;
        }).flatMap(csr -> OSGi.service((CachingServiceReference)csr).effects(handler -> tebi.addUntypedEventHandler((UntypedEventHandler)handler, this.getServiceProps(csr.getServiceReference())), handler -> tebi.removeUntypedEventHandler((UntypedEventHandler)handler, this.getServiceProps(csr.getServiceReference())))), OSGi.serviceReferences(UnhandledEventHandler.class).flatMap(csr -> OSGi.service((CachingServiceReference)csr).effects(handler -> tebi.addUnhandledEventHandler((UnhandledEventHandler)handler, this.getServiceProps(csr.getServiceReference())), handler -> tebi.removeUnhandledEventHandler((UnhandledEventHandler)handler, this.getServiceProps(csr.getServiceReference())))), OSGi.register(TypedEventBus.class, (Object)tebi, (Map)serviceProps).flatMap(x -> OSGi.nothing())}));
    }

    private Map<String, Object> toConfigProps(Dictionary<String, ?> config) {
        Enumeration<String> keys = config.keys();
        HashMap<String, Object> map = new HashMap<String, Object>();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            map.put(key, config.get(key));
        }
        return map;
    }

    private Map<String, Object> toServiceProps(Map<String, ?> config) {
        return config.entrySet().stream().filter(e -> e.getKey() != null && ((String)e.getKey()).startsWith(".")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a, b) -> {
            throw new IllegalArgumentException("Duplicate key ");
        }, Hashtable::new));
    }

    private Map<String, Object> getServiceProps(ServiceReference<?> ref) {
        return Arrays.stream(ref.getPropertyKeys()).collect(Collectors.toMap(Function.identity(), arg_0 -> ref.getProperty(arg_0)));
    }

    public void stop(BundleContext context) throws Exception {
        if (_log.isDebugEnabled()) {
            _log.debug("Aries Typed Event Bus Stopping");
        }
        this.eventBus.close();
        if (_log.isDebugEnabled()) {
            _log.debug("Aries Typed Event Bus Stopped");
        }
    }
}

