/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.obr.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.aries.subsystem.obr.internal.OsgiCapabilityAdapter;
import org.apache.aries.subsystem.obr.internal.OsgiRequirementAdapter;
import org.apache.aries.subsystem.obr.internal.ResourceHelper;
import org.apache.felix.bundlerepository.Capability;
import org.apache.felix.bundlerepository.Resource;
import org.osgi.framework.Version;
import org.osgi.resource.Requirement;

public class OsgiResourceAdapter
implements Resource {
    private final org.osgi.resource.Resource resource;

    public OsgiResourceAdapter(org.osgi.resource.Resource resource) {
        if (resource == null) {
            throw new NullPointerException("Missing required parameter: resource");
        }
        this.resource = resource;
    }

    public Capability[] getCapabilities() {
        List capabilities = this.resource.getCapabilities(null);
        ArrayList<OsgiCapabilityAdapter> result = new ArrayList<OsgiCapabilityAdapter>(capabilities.size());
        for (org.osgi.resource.Capability capability : capabilities) {
            result.add(new OsgiCapabilityAdapter(capability));
        }
        return result.toArray(new Capability[result.size()]);
    }

    public String[] getCategories() {
        return new String[0];
    }

    public String getId() {
        String symbolicName = ResourceHelper.getSymbolicNameAttribute(this.resource);
        Version version = ResourceHelper.getVersionAttribute(this.resource);
        return symbolicName + ";version=" + version;
    }

    public String getPresentationName() {
        return ResourceHelper.getSymbolicNameAttribute(this.resource);
    }

    public Map getProperties() {
        return Collections.emptyMap();
    }

    public org.apache.felix.bundlerepository.Requirement[] getRequirements() {
        List requirements = this.resource.getRequirements(null);
        ArrayList<OsgiRequirementAdapter> result = new ArrayList<OsgiRequirementAdapter>(requirements.size());
        for (Requirement requirement : requirements) {
            result.add(new OsgiRequirementAdapter(requirement));
        }
        return result.toArray(new org.apache.felix.bundlerepository.Requirement[result.size()]);
    }

    public Long getSize() {
        return -1L;
    }

    public String getSymbolicName() {
        return ResourceHelper.getSymbolicNameAttribute(this.resource);
    }

    public String getURI() {
        return ResourceHelper.getContentAttribute(this.resource);
    }

    public Version getVersion() {
        return ResourceHelper.getVersionAttribute(this.resource);
    }

    public boolean isLocal() {
        return false;
    }
}

