/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.obr.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.aries.subsystem.obr.internal.FelixResourceAdapter;
import org.apache.aries.subsystem.obr.internal.OsgiIdentityCapability;
import org.apache.aries.subsystem.obr.internal.ResourceHelper;
import org.apache.felix.bundlerepository.Repository;
import org.apache.felix.bundlerepository.Resource;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FelixRepositoryAdapter
implements org.osgi.service.repository.Repository {
    private static final Logger logger = LoggerFactory.getLogger(FelixRepositoryAdapter.class);
    private final Map<String, Collection<Capability>> identityIndex = Collections.synchronizedMap(new HashMap());
    private final Repository repository;
    private long lastUpdated;

    public FelixRepositoryAdapter(Repository repository) {
        if (repository == null) {
            throw new NullPointerException("Missing required parameter: repository");
        }
        this.repository = repository;
    }

    public Collection<Capability> findProviders(Requirement requirement) {
        this.update();
        List<Capability> result = Collections.emptyList();
        if ("osgi.identity".equals(requirement.getNamespace())) {
            String symbolicName = new IdentityRequirementFilter((String)requirement.getDirectives().get("filter")).getSymbolicName();
            logger.debug("Looking for symbolic name {}", (Object)symbolicName);
            Collection<Capability> capabilities = this.identityIndex.get(symbolicName);
            if (capabilities != null) {
                result = new ArrayList<Capability>(capabilities.size());
                for (Capability capability : capabilities) {
                    if (!ResourceHelper.matches(requirement, capability)) continue;
                    result.add(capability);
                }
                ((ArrayList)result).trimToSize();
            }
        } else {
            Resource[] resources = this.repository.getResources();
            if (resources != null && resources.length != 0) {
                result = new ArrayList<Capability>(resources.length);
                for (Resource resource : resources) {
                    FelixResourceAdapter r = new FelixResourceAdapter(resource);
                    for (Capability capability : r.getCapabilities(requirement.getNamespace())) {
                        if (!ResourceHelper.matches(requirement, capability)) continue;
                        result.add(capability);
                    }
                }
                ((ArrayList)result).trimToSize();
            }
        }
        return result;
    }

    public Map<Requirement, Collection<Capability>> findProviders(Collection<? extends Requirement> requirements) {
        HashMap<Requirement, Collection<Capability>> result = new HashMap<Requirement, Collection<Capability>>(requirements.size());
        for (Requirement requirement : requirements) {
            result.put(requirement, this.findProviders(requirement));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void update() {
        long lastModified = this.repository.getLastModified();
        logger.debug("The repository adaptor was last updated at {}. The repository was last modified at {}", (Object)this.lastUpdated, (Object)lastModified);
        if (lastModified > this.lastUpdated) {
            logger.debug("Updating the adapter with the modified repository contents...");
            this.lastUpdated = lastModified;
            Map<String, Collection<Capability>> map = this.identityIndex;
            synchronized (map) {
                this.identityIndex.clear();
                Resource[] resources = this.repository.getResources();
                logger.debug("There are {} resources to evaluate", (Object)(resources == null ? 0 : resources.length));
                if (resources != null && resources.length != 0) {
                    for (Resource resource : resources) {
                        logger.debug("Evaluating resource {}", (Object)resource);
                        String symbolicName = resource.getSymbolicName();
                        Collection<Capability> capabilities = this.identityIndex.get(symbolicName);
                        if (capabilities == null) {
                            capabilities = new HashSet<Capability>();
                            this.identityIndex.put(symbolicName, capabilities);
                        }
                        OsgiIdentityCapability capability = new OsgiIdentityCapability(new FelixResourceAdapter(resource), symbolicName, resource.getVersion(), "osgi.bundle");
                        logger.debug("Indexing capability {}", (Object)capability);
                        capabilities.add(capability);
                    }
                }
            }
        }
    }

    private static class IdentityRequirementFilter {
        private static final String REGEX = "\\(osgi.identity=([^\\)]*)\\)";
        private static final Pattern PATTERN = Pattern.compile("\\(osgi.identity=([^\\)]*)\\)");
        private final String symbolicName;

        public IdentityRequirementFilter(String filter) {
            Matcher matcher = PATTERN.matcher(filter);
            if (!matcher.find()) {
                throw new IllegalArgumentException("Could not find pattern '\\(osgi.identity=([^\\)]*)\\)' in filter string '" + filter + "'");
            }
            this.symbolicName = matcher.group(1);
        }

        public String getSymbolicName() {
            return this.symbolicName;
        }
    }
}

