/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.aries.blueprint.services;

import org.apache.aries.blueprint.ComponentDefinitionRegistry;
import org.apache.aries.blueprint.Processor;
import org.osgi.service.blueprint.container.BlueprintContainer;
import org.osgi.service.blueprint.container.Converter;

import java.net.URL;
import java.security.AccessControlContext;
import java.util.List;

public interface ExtendedBlueprintContainer extends BlueprintContainer {

    Converter getConverter();

    Class loadClass(String name) throws ClassNotFoundException;

    URL getResource(String name);

    AccessControlContext getAccessControlContext();

    ComponentDefinitionRegistry getComponentDefinitionRegistry();

    <T extends Processor> List<T> getProcessors(Class<T> type);

    String getProperty(String key);

}
