/*
 * Decompiled with CFR 0.152.
 */
package gnu.q2.lang;

import gnu.expr.Compilation;
import gnu.expr.Special;
import gnu.kawa.io.InPort;
import gnu.kawa.lispexpr.LispReader;
import gnu.kawa.lispexpr.ReadTable;
import gnu.kawa.lispexpr.ReaderDispatchMisc;
import gnu.lists.EmptyList;
import gnu.lists.LList;
import gnu.lists.Pair;
import gnu.lists.Sequence;
import gnu.mapping.Symbol;
import gnu.mapping.Values;
import gnu.q2.lang.Operator;
import gnu.q2.lang.Q2;
import gnu.q2.lang.Q2Translator;
import gnu.text.Lexer;
import gnu.text.SourceMessages;
import gnu.text.SyntaxException;
import java.io.IOException;
import kawa.standard.begin;

public class Q2Read
extends LispReader {
    int curIndentation;
    boolean resetNeeded;
    String expressionStartFile;
    int expressionStartLine;
    int expressionStartColumn;

    void init() {
        this.port.readState = (char)32;
    }

    public Q2Read(InPort port) {
        super(port);
        this.init();
    }

    public Q2Read(InPort port, SourceMessages messages) {
        super(port, messages);
        this.init();
    }

    int skipIndentation() throws IOException, SyntaxException {
        int numTabs = 0;
        int numSpaces = 0;
        int ch = this.port.read();
        while (ch == 9) {
            ++numTabs;
            ch = this.port.read();
        }
        while (ch == 32) {
            ++numSpaces;
            ch = this.port.read();
        }
        if (ch < 0) {
            return -1;
        }
        this.port.unread();
        return (numTabs << 16) + numSpaces;
    }

    Object readIndentCommand(boolean singleLine) throws IOException, SyntaxException {
        int ch;
        Pair head;
        int startIndentation = this.curIndentation;
        Pair last = head = new Pair(null, LList.Empty);
        EmptyList obj = LList.Empty;
        Object pair = null;
        Object prev = null;
        ReadTable rtable = ReadTable.getCurrent();
        while ((ch = this.read()) >= 0) {
            if (ch == 32 || ch == 9) continue;
            this.unread();
            if (ch == 41) break;
            if (ch == 13 || ch == 10) {
                Operator rhsNeeded = null;
                if (singleLine) {
                    prev = last.getCar();
                    Q2Translator tr = (Q2Translator)Compilation.getCurrent();
                    Operator op = tr.checkIfOperator(prev);
                    if (op == null || (op.flags & 2) == 0) break;
                    rhsNeeded = op;
                }
                ch = this.read();
                this.port.mark(Integer.MAX_VALUE);
                this.resetNeeded = true;
                int subIndentation = this.skipIndentation();
                if (subIndentation == -1 && rhsNeeded != null) {
                    this.eofError("missing right operand after " + rhsNeeded.getName());
                }
                LList qresult = LList.Empty;
                this.curIndentation = subIndentation;
                while (this.curIndentation != -1 && subIndentation == this.curIndentation) {
                    int comparedIndent = Q2.compareIndentation(subIndentation, startIndentation);
                    if (comparedIndent == Integer.MIN_VALUE) {
                        this.error('e', "cannot compare indentation - mix of tabs and spaces");
                        break;
                    }
                    if (comparedIndent == -1 || comparedIndent == 1) {
                        this.error('e', "indentation must differ by 2 or more");
                    } else if (comparedIndent <= 0) break;
                    int line = this.port.getLineNumber();
                    int column = this.port.getColumnNumber();
                    Object val = this.readIndentCommand(false);
                    if (val == LList.Empty) break;
                    qresult = this.makePair(val, qresult, line, column);
                }
                if (qresult != LList.Empty) {
                    qresult = new Pair(begin.begin, LList.reverseInPlace(qresult));
                    Pair t = new Pair(qresult, LList.Empty);
                    last.setCdrBackdoor(t);
                    last = t;
                }
                prev = qresult;
                break;
            }
            int line = this.port.getLineNumber();
            int column = this.port.getColumnNumber();
            ch = this.port.read();
            if (ch < 0) break;
            last = this.readValuesAndAppend(ch, rtable, last);
        }
        return this.makeCommand(head.getCdr());
    }

    Object makeCommand(Object command) {
        return command;
    }

    boolean singleLine() {
        return this.isInteractive() && this.nesting <= 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object readCommand() throws IOException, SyntaxException {
        int indent = this.skipIndentation();
        if (indent < 0) {
            return Sequence.eofValue;
        }
        this.curIndentation = indent;
        char saveReadState = this.pushNesting('-');
        try {
            Pair presult;
            Object result = this.readIndentCommand(this.singleLine());
            if (this.resetNeeded) {
                this.resetNeeded = false;
                int line = this.port.getLineNumber();
                int column = this.port.getColumnNumber();
                this.port.reset();
            }
            if (result instanceof Pair && (presult = (Pair)result).getCdr() == LList.Empty && presult.getCar() == Special.eof) {
                Object object2 = Special.eof;
                return object2;
            }
            Object object3 = result;
            return object3;
        }
        finally {
            this.popNesting(saveReadState);
        }
    }

    @Override
    protected boolean isTerminatingChar(int ch, ReadTable rtable) throws IOException, SyntaxException {
        return ch == 94 || super.isTerminatingChar(ch, rtable);
    }

    @Override
    protected Object handlePostfix(Object value, ReadTable rtable, int line, int column) throws IOException, SyntaxException {
        if (this.port.peek() == 94) {
            LList r;
            this.port.read();
            int rline = this.port.getLineNumber();
            int rcolumn = this.port.getColumnNumber();
            int ch = this.port.read();
            if (ch < 0 || ch == 93 || ch == 41 || ch == 125 || Character.isWhitespace(ch)) {
                this.unread(ch);
                r = LList.Empty;
            } else {
                Object rightOperand = this.readValues(ch, rtable.lookup(ch), rtable, -1);
                r = this.makePair(rightOperand, rline, rcolumn, this.port.getLineNumber(), this.port.getColumnNumber());
            }
            r = Pair.make(value, r);
            return Pair.make(Q2.defineSym, r);
        }
        return super.handlePostfix(value, rtable, line, column);
    }

    public static Object readObject(InPort port) throws IOException, SyntaxException {
        return new Q2Read(port).readObject();
    }

    void saveExpressionStartPosition() {
        this.expressionStartFile = this.port.getName();
        this.expressionStartLine = this.port.getLineNumber();
        this.expressionStartColumn = this.port.getColumnNumber();
    }

    static class ReadTableEntry
    extends ReaderDispatchMisc {
        ReadTableEntry() {
        }

        @Override
        public Object read(Lexer in, int ch, int count) throws IOException, SyntaxException {
            switch (ch) {
                case 40: {
                    return this.readParens(in);
                }
                case 59: {
                    return Symbol.valueOf(";");
                }
                case 124: {
                    in.error("unexpected '|'");
                    return Values.empty;
                }
            }
            throw new Error();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object readParens(Lexer in) throws IOException, SyntaxException {
            Q2Read reader = (Q2Read)in;
            char saveReadState = reader.pushNesting('(');
            int startLine = reader.getLineNumber();
            int startColumn = reader.getColumnNumber();
            InPort port = reader.getPort();
            boolean lambdaParamList = false;
            if (port.peek() == 124) {
                Pair head;
                lambdaParamList = true;
                port.skip();
                ReadTable rtable = ReadTable.getCurrent();
                Pair last = head = new Pair(null, LList.Empty);
                while (true) {
                    int ch;
                    if ((ch = reader.read()) < 0) {
                        reader.eofError("unexpected EOF in vector starting here", startLine + 1, startColumn);
                    }
                    if (ch == 124 && reader.peek() == 41) break;
                    last = reader.readValuesAndAppend(ch, rtable, last);
                }
                port.skip();
                return Operator.makeLambda(head.getCdr());
            }
            try {
                Object result = reader.readIndentCommand(false);
                int ch = port.peek();
                if (ch == 41) {
                    port.skip();
                } else {
                    String msg = "missing ')' after '(' starting here";
                    if (ch < 0) {
                        reader.eofError(msg, startLine + 1, startColumn);
                    } else {
                        reader.error('e', port.getName(), startLine + 1, startColumn, msg);
                    }
                }
                if (reader.resetNeeded) {
                    reader.resetNeeded = false;
                    port.mark(0);
                }
                Object object2 = reader.makeCommand(result);
                return object2;
            }
            finally {
                reader.popNesting(saveReadState);
            }
        }
    }
}

