/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.vectorgraphics2d.intermediate.filters;

import de.erichseifert.vectorgraphics2d.intermediate.CommandSequence;
import de.erichseifert.vectorgraphics2d.intermediate.commands.Command;
import de.erichseifert.vectorgraphics2d.intermediate.filters.Filter;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;

public abstract class StreamingFilter
implements Iterator<Command<?>>,
Filter {
    private final Queue<Command<?>> buffer = new LinkedList();
    private final Iterator<Command<?>> iterator;

    public StreamingFilter(CommandSequence stream) {
        this.iterator = stream.iterator();
    }

    @Override
    public Iterator<Command<?>> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        this.findNextCommand();
        return !this.buffer.isEmpty();
    }

    private void findNextCommand() {
        while (this.buffer.isEmpty() && this.iterator.hasNext()) {
            Command<?> command = this.iterator.next();
            List<Command<?>> commands = this.filter(command);
            if (commands == null) continue;
            this.buffer.addAll(commands);
        }
    }

    @Override
    public Command<?> next() {
        this.findNextCommand();
        return this.buffer.poll();
    }

    @Override
    public void remove() {
    }

    protected abstract List<Command<?>> filter(Command<?> var1);
}

