/*
 * Decompiled with CFR 0.152.
 */
package gnu.lists;

import gnu.lists.AbstractSequence;
import gnu.lists.SeqPosition;

public class TreePosition
extends SeqPosition
implements Cloneable {
    private Object xpos;
    AbstractSequence[] sstack;
    int[] istack;
    int depth;
    int start;

    public TreePosition() {
        this.depth = -1;
    }

    public TreePosition(Object object2) {
        this.xpos = object2;
        this.depth = -1;
    }

    public TreePosition(AbstractSequence abstractSequence, int n) {
        super(abstractSequence, n, false);
    }

    public TreePosition(TreePosition treePosition) {
        this.set(treePosition);
    }

    public Object clone() {
        return new TreePosition(this);
    }

    public void set(TreePosition treePosition) {
        AbstractSequence abstractSequence;
        int n;
        this.clear();
        this.depth = n = treePosition.depth;
        if (n < 0) {
            this.xpos = treePosition.xpos;
            return;
        }
        if (this.sstack == null || this.sstack.length <= n) {
            this.sstack = new AbstractSequence[n + 10];
        }
        if (this.istack == null || this.istack.length <= n) {
            this.istack = new int[n + 10];
        }
        for (int i = 0; i < this.depth; ++i) {
            int n2 = i + treePosition.start;
            this.sstack[this.depth - 1] = abstractSequence = treePosition.sstack[n2];
            this.istack[this.depth - i] = abstractSequence.copyPos(treePosition.istack[n2]);
        }
        this.sequence = abstractSequence = treePosition.sequence;
        this.ipos = abstractSequence.copyPos(treePosition.ipos);
    }

    public int getDepth() {
        return this.depth + 1;
    }

    public AbstractSequence getRoot() {
        return this.depth == 0 ? this.sequence : this.sstack[this.start];
    }

    public Object getPosNext() {
        return this.sequence == null ? this.xpos : this.sequence.getPosNext(this.ipos);
    }

    public void push(AbstractSequence abstractSequence, int n) {
        int n2 = this.depth + this.start;
        if (n2 >= 0) {
            if (n2 == 0) {
                this.istack = new int[8];
                this.sstack = new AbstractSequence[8];
            } else if (n2 >= this.istack.length) {
                int n3 = 2 * n2;
                int[] nArray = new int[n3];
                Object[] objectArray = new Object[n3];
                AbstractSequence[] abstractSequenceArray = new AbstractSequence[n3];
                System.arraycopy(this.istack, 0, nArray, 0, this.depth);
                System.arraycopy(this.sstack, 0, abstractSequenceArray, 0, this.depth);
                this.istack = nArray;
                this.sstack = abstractSequenceArray;
            }
            this.sstack[n2] = this.sequence;
            this.istack[n2] = this.ipos;
        }
        ++this.depth;
        this.sequence = abstractSequence;
        this.ipos = n;
    }

    public void pop() {
        this.sequence.releasePos(this.ipos);
        this.popNoRelease();
    }

    public void popNoRelease() {
        if (--this.depth < 0) {
            this.xpos = this.sequence;
            this.sequence = null;
        } else {
            this.sequence = this.sstack[this.start + this.depth];
            this.ipos = this.istack[this.start + this.depth];
        }
    }

    public final boolean gotoParent() {
        return this.sequence == null ? false : this.sequence.gotoParent(this);
    }

    public boolean gotoChildrenStart() {
        if (this.sequence == null) {
            if (!(this.xpos instanceof AbstractSequence)) {
                return false;
            }
            this.depth = 0;
            this.sequence = (AbstractSequence)this.xpos;
            this.setPos(this.sequence.startPos());
        } else if (!this.sequence.gotoChildrenStart(this)) {
            return false;
        }
        return true;
    }

    public boolean gotoAttributesStart() {
        if (this.sequence == null) {
            if (this.xpos instanceof AbstractSequence) {
                // empty if block
            }
            return false;
        }
        return this.sequence.gotoAttributesStart(this);
    }

    public Object getAncestor(int n) {
        if (n == 0) {
            return this.sequence.getPosNext(this.ipos);
        }
        int n2 = this.depth - n;
        if (n2 <= 0) {
            return this.getRoot();
        }
        return this.sstack[n2 += this.start].getPosNext(this.istack[n2]);
    }

    public void finalize() {
        this.clear();
    }

    public void clear() {
        while (this.sequence != null) {
            this.sequence.releasePos(this.ipos);
            this.pop();
        }
        this.xpos = null;
    }

    public void dump() {
        System.err.println("TreePosition dump depth:" + this.depth + " start:" + this.start);
        for (int i = 0; i <= this.depth; ++i) {
            AbstractSequence abstractSequence = i == 0 ? this.sequence : this.sstack[this.depth - i];
            System.err.print("#" + i + " seq:" + abstractSequence);
            System.err.println(" ipos:" + (i == 0 ? this.ipos : this.istack[this.depth - i]));
        }
    }
}

