/*
 * Decompiled with CFR 0.152.
 */
package gnu.lists;

import gnu.lists.AbstractSequence;
import gnu.lists.Array;
import gnu.lists.FVector;
import gnu.lists.GeneralArray1;
import gnu.lists.SimpleVector;

public class GeneralArray
extends AbstractSequence
implements Array {
    SimpleVector base;
    int[] dimensions;
    int[] strides;
    int[] lowBounds;
    static final int[] zeros = new int[8];
    int offset;
    boolean simple = true;

    public static Array makeSimple(int[] nArray, int[] nArray2, SimpleVector simpleVector) {
        int n = nArray2.length;
        if (nArray == null && n > (nArray = zeros).length) {
            nArray = new int[n];
        }
        if (n == 1 && nArray[0] == 0) {
            return simpleVector;
        }
        GeneralArray generalArray = new GeneralArray();
        int[] nArray3 = new int[n];
        int n2 = 1;
        int n3 = n;
        while (--n3 >= 0) {
            nArray3[n3] = n2;
            n2 *= nArray2[n3];
        }
        generalArray.strides = nArray3;
        generalArray.dimensions = nArray2;
        generalArray.lowBounds = nArray;
        generalArray.base = simpleVector;
        return generalArray;
    }

    public GeneralArray() {
    }

    public GeneralArray(int[] nArray) {
        int n = 1;
        int n2 = nArray.length;
        this.lowBounds = n2 <= zeros.length ? zeros : new int[n2];
        int[] nArray2 = new int[n2];
        int n3 = n2;
        while (--n3 >= 0) {
            nArray2[n3] = n;
            n *= nArray[n3];
        }
        this.base = new FVector(n);
        this.dimensions = nArray;
        this.offset = 0;
    }

    public int rank() {
        return this.dimensions.length;
    }

    public int getEffectiveIndex(int[] nArray) {
        int n = this.offset;
        int n2 = this.dimensions.length;
        while (--n2 >= 0) {
            int n3 = nArray[n2];
            int n4 = this.lowBounds[n2];
            if (n3 < n4 || (n3 -= n4) >= this.dimensions[n2]) {
                throw new IndexOutOfBoundsException();
            }
            n += this.strides[n2] * n3;
        }
        return n;
    }

    public Object get(int n) {
        return this.getRowMajor(n);
    }

    public int createPos(int n, boolean bl) {
        int n2 = this.offset;
        int n3 = this.dimensions.length;
        while (--n3 >= 0) {
            int n4 = this.dimensions[n3];
            int n5 = n % n4;
            n /= n4;
            n2 += this.strides[n3] * n5;
        }
        return n2 << 1 | (bl ? 1 : 0);
    }

    public Object getRowMajor(int n) {
        if (this.simple) {
            return this.base.get(n);
        }
        int n2 = this.offset;
        int n3 = this.dimensions.length;
        while (--n3 >= 0) {
            int n4 = this.dimensions[n3];
            int n5 = n % n4;
            n /= n4;
            n2 += this.strides[n3] * n5;
        }
        return this.base.get(n2);
    }

    public Object get(int[] nArray) {
        return this.base.get(this.getEffectiveIndex(nArray));
    }

    public Object set(int[] nArray, Object object2) {
        return this.base.set(this.getEffectiveIndex(nArray), object2);
    }

    public int size() {
        int n = 1;
        int n2 = this.dimensions.length;
        while (--n2 >= 0) {
            n *= this.dimensions[n2];
        }
        return n;
    }

    public int getLowBound(int n) {
        return this.lowBounds[n];
    }

    public int getSize(int n) {
        return this.dimensions[n];
    }

    public Array transpose(int[] nArray, int[] nArray2, int n, int[] nArray3) {
        GeneralArray generalArray = nArray2.length == 1 && nArray[0] == 0 ? new GeneralArray1() : new GeneralArray();
        generalArray.offset = n;
        generalArray.strides = nArray3;
        generalArray.dimensions = nArray2;
        generalArray.lowBounds = nArray;
        generalArray.base = this.base;
        generalArray.simple = false;
        return generalArray;
    }

    public static void toString(Array array, StringBuffer stringBuffer) {
        stringBuffer.append("#<array");
        int n = array.rank();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(' ');
            int n2 = array.getLowBound(i);
            int n3 = array.getSize(i);
            if (n2 != 0) {
                stringBuffer.append(n2);
                stringBuffer.append(':');
            }
            stringBuffer.append(n2 + n3);
        }
        stringBuffer.append('>');
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        GeneralArray.toString(this, stringBuffer);
        return stringBuffer.toString();
    }
}

