/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.lispexpr;

import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Method;
import gnu.bytecode.PrimType;
import gnu.bytecode.Type;
import gnu.expr.Interpreter;
import gnu.mapping.Values;
import gnu.math.DFloNum;
import gnu.math.IntNum;
import gnu.text.Char;

public class LangPrimType
extends PrimType {
    Interpreter interpreter;
    PrimType implementationType;
    public static final LangPrimType byteType = new LangPrimType(Type.byte_type);
    public static final LangPrimType shortType = new LangPrimType(Type.short_type);
    public static final LangPrimType intType = new LangPrimType(Type.int_type);
    public static final LangPrimType longType = new LangPrimType(Type.long_type);
    public static final LangPrimType floatType = new LangPrimType(Type.float_type);
    public static final LangPrimType doubleType = new LangPrimType(Type.double_type);
    public static final LangPrimType charType = new LangPrimType(Type.char_type);
    public static final LangPrimType voidType = new LangPrimType(Type.void_type);

    public LangPrimType(PrimType primType) {
        super(primType);
        this.implementationType = primType;
    }

    public LangPrimType(PrimType primType, Interpreter interpreter) {
        super(primType);
        this.interpreter = interpreter;
        this.implementationType = primType;
    }

    public LangPrimType(String string, String string2, int n, Class clazz) {
        super(string, string2, n, clazz);
    }

    public LangPrimType(String string, String string2, int n, Class clazz, Interpreter interpreter) {
        this(string, string2, n, clazz);
        this.implementationType = Type.signatureToPrimitive(string2.charAt(0));
        this.interpreter = interpreter;
    }

    public Type getImplementationType() {
        return this.implementationType;
    }

    public Object coerceFromObject(Object object2) {
        if (object2.getClass() == this.reflectClass) {
            return object2;
        }
        char c = this.getSignature().charAt(0);
        switch (c) {
            case 'Z': {
                return this.interpreter.isTrue(object2) ? Boolean.TRUE : Boolean.FALSE;
            }
            case 'C': {
                return new Character(((Char)object2).charValue());
            }
        }
        return super.coerceFromObject(object2);
    }

    public char charValue(Object object2) {
        if (object2 instanceof Character) {
            return ((Character)object2).charValue();
        }
        return ((Char)object2).charValue();
    }

    public void emitCoerceFromObject(CodeAttr codeAttr) {
        char c = this.getSignature().charAt(0);
        switch (c) {
            case 'Z': {
                this.interpreter.emitCoerceToBoolean(codeAttr);
                break;
            }
            case 'C': {
                ClassType classType = ClassType.make("gnu.text.Char");
                Method method = classType.getDeclaredMethod("charValue", 0);
                codeAttr.emitCheckcast(classType);
                codeAttr.emitInvokeVirtual(method);
                break;
            }
            default: {
                super.emitCoerceFromObject(codeAttr);
            }
        }
    }

    public Object coerceToObject(Object object2) {
        char c = this.getSignature().charAt(0);
        switch (c) {
            case 'Z': {
                return this.interpreter.booleanObject((Boolean)object2);
            }
            case 'C': {
                if (object2 instanceof Char) {
                    return object2;
                }
                return Char.make(((Character)object2).charValue());
            }
            case 'B': 
            case 'I': 
            case 'S': {
                return IntNum.make(((Number)object2).intValue());
            }
            case 'J': {
                return IntNum.make(((Number)object2).longValue());
            }
            case 'D': 
            case 'F': {
                return DFloNum.make(((Number)object2).doubleValue());
            }
            case 'V': {
                return Values.empty;
            }
        }
        return super.coerceToObject(object2);
    }

    public void emitCoerceToObject(CodeAttr codeAttr) {
        Type[] typeArray;
        ClassType classType;
        char c = this.getSignature().charAt(0);
        PrimType primType = null;
        String string = null;
        switch (c) {
            case 'Z': {
                codeAttr.emitIfIntNotZero();
                this.interpreter.emitPushBoolean(true, codeAttr);
                codeAttr.emitElse();
                this.interpreter.emitPushBoolean(false, codeAttr);
                codeAttr.emitFi();
                break;
            }
            case 'C': {
                classType = ClassType.make("gnu.text.Char");
                typeArray = classType.getDeclaredMethod("make", 1);
                codeAttr.emitInvokeStatic((Method)typeArray);
                break;
            }
            case 'B': 
            case 'I': 
            case 'S': {
                string = "gnu.math.IntNum";
                primType = Type.int_type;
                break;
            }
            case 'J': {
                string = "gnu.math.IntNum";
                primType = Type.long_type;
                break;
            }
            case 'F': {
                codeAttr.emitConvert(Type.float_type, Type.double_type);
            }
            case 'D': {
                string = "gnu.math.DFloNum";
                primType = Type.double_type;
                break;
            }
            default: {
                super.emitCoerceToObject(codeAttr);
            }
        }
        if (string != null) {
            classType = ClassType.make(string);
            typeArray = new Type[]{primType};
            codeAttr.emitInvokeStatic(classType.getDeclaredMethod("make", typeArray));
        }
    }

    public int compare(Type type) {
        char c = this.getSignature().charAt(0);
        if (type instanceof PrimType) {
            char c2 = type.getSignature().charAt(0);
            if (c == c2) {
                return 0;
            }
            if (c == 'V') {
                return 1;
            }
            if (c2 == 'V' || c2 == 'Z') {
                return -1;
            }
        }
        if (c == 'V' || c == 'Z') {
            return 1;
        }
        return super.compare(type);
    }
}

