/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.functions;

import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Label;
import gnu.bytecode.Type;
import gnu.bytecode.Variable;
import gnu.expr.ApplyExp;
import gnu.expr.CanInline;
import gnu.expr.Compilation;
import gnu.expr.ConsumerTarget;
import gnu.expr.Declaration;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.IgnoreTarget;
import gnu.expr.Inlineable;
import gnu.expr.LambdaExp;
import gnu.expr.ReferenceExp;
import gnu.expr.SeriesTarget;
import gnu.expr.Target;
import gnu.lists.Consumer;
import gnu.mapping.CallContext;
import gnu.mapping.CpsProcedure;
import gnu.mapping.Procedure;
import gnu.mapping.Values;
import gnu.math.IntNum;

public class ValuesMap
extends CpsProcedure
implements CanInline,
Inlineable {
    public static final ValuesMap valuesMap = new ValuesMap();
    public static final ValuesMap valuesMapWithPos = new ValuesMap();
    public int startCounter = -1;

    public int numArgs() {
        return 8194;
    }

    public void apply(CallContext callContext) throws Throwable {
        Procedure procedure = (Procedure)callContext.getNextArg();
        Consumer consumer = callContext.consumer;
        Object object2 = callContext.getNextArg();
        Procedure.checkArgCount(procedure, 1);
        if (object2 instanceof Values) {
            int n = 0;
            int n2 = this.startCounter;
            Values values = (Values)object2;
            while ((n = values.nextPos(n)) != 0) {
                Object object3 = values.getPosPrevious(n);
                if (this.startCounter >= 0) {
                    callContext.setArgs(object3, IntNum.make(n2++));
                } else {
                    callContext.setArgs(object3);
                }
                callContext.proc = procedure;
                callContext.runUntilDone();
            }
        } else {
            if (this.startCounter >= 0) {
                callContext.setArgs(object2, IntNum.make(this.startCounter));
            } else {
                callContext.setArgs(object2);
            }
            callContext.proc = procedure;
            callContext.runUntilDone();
        }
    }

    private LambdaExp canInline(ApplyExp applyExp) {
        Expression expression;
        Expression[] expressionArray = applyExp.getArgs();
        if (expressionArray.length == 2 && (expression = expressionArray[0]) instanceof LambdaExp) {
            LambdaExp lambdaExp = (LambdaExp)expression;
            if (lambdaExp.min_args == lambdaExp.max_args && lambdaExp.min_args == (this.startCounter >= 0 ? 2 : 1)) {
                return lambdaExp;
            }
        }
        return null;
    }

    public Expression inline(ApplyExp applyExp, ExpWalker expWalker) {
        LambdaExp lambdaExp = this.canInline(applyExp);
        if (lambdaExp != null) {
            lambdaExp.setInlineOnly(true);
            lambdaExp.returnContinuation = applyExp;
        }
        return applyExp;
    }

    public void compile(ApplyExp applyExp, Compilation compilation, Target target) {
        Variable variable;
        LambdaExp lambdaExp = this.canInline(applyExp);
        if (lambdaExp == null) {
            ApplyExp.compile(applyExp, compilation, target);
            return;
        }
        Expression[] expressionArray = applyExp.getArgs();
        if (!(target instanceof IgnoreTarget || target instanceof ConsumerTarget || target instanceof SeriesTarget)) {
            ConsumerTarget.compileUsingConsumer(applyExp, compilation, target);
            return;
        }
        Expression expression = expressionArray[1];
        Declaration declaration = lambdaExp.firstDecl();
        CodeAttr codeAttr = compilation.getCode();
        SeriesTarget seriesTarget = new SeriesTarget();
        seriesTarget.scope = codeAttr.pushScope();
        if (this.startCounter >= 0) {
            variable = seriesTarget.scope.addVariable(codeAttr, Type.int_type, "position");
            codeAttr.emitPushInt(this.startCounter);
            codeAttr.emitStore(variable);
        } else {
            variable = null;
        }
        seriesTarget.function = new Label(codeAttr);
        seriesTarget.done = new Label(codeAttr);
        if (declaration.isSimple()) {
            declaration.allocateVariable(codeAttr);
        } else {
            declaration = new Declaration(codeAttr.addLocal(declaration.getType(), declaration.getName()));
        }
        seriesTarget.param = declaration;
        ClassType classType = Type.pointer_type;
        Variable variable2 = codeAttr.addLocal(classType);
        expression.compileWithPosition(compilation, seriesTarget);
        if (codeAttr.reachableHere()) {
            codeAttr.emitGoto(seriesTarget.done);
        }
        seriesTarget.function.define(codeAttr);
        codeAttr.pushType(classType);
        codeAttr.emitStore(variable2);
        expressionArray = this.startCounter >= 0 ? new Expression[]{new ReferenceExp(declaration), new ReferenceExp(new Declaration(variable))} : new Expression[]{new ReferenceExp(declaration)};
        new ApplyExp(lambdaExp, expressionArray).compile(compilation, target);
        if (this.startCounter >= 0) {
            codeAttr.emitInc(variable, (short)1);
        }
        codeAttr.emitRet(variable2);
        codeAttr.popScope();
        seriesTarget.done.define(codeAttr);
    }

    public Type getReturnType(Expression[] expressionArray) {
        return Type.pointer_type;
    }

    static {
        ValuesMap.valuesMapWithPos.startCounter = 1;
    }
}

