/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Label;
import gnu.bytecode.Method;
import gnu.bytecode.Type;
import gnu.expr.Compilation;
import gnu.expr.LambdaExp;
import gnu.expr.StackTarget;
import gnu.expr.Target;

public class CheckedTarget
extends StackTarget {
    LambdaExp proc;
    String procname;
    int argno;
    static ClassType typeClassCastException;
    static ClassType typeWrongType;
    static Method makeWrongTypeStringMethod;
    static Method makeWrongTypeProcMethod;

    public CheckedTarget(Type type, LambdaExp lambdaExp, int n) {
        super(type);
        this.proc = lambdaExp;
        this.procname = lambdaExp.getName();
        this.argno = n;
    }

    public CheckedTarget(Type type, String string, int n) {
        super(type);
        this.procname = string;
        this.argno = n;
    }

    public static Target getInstance(Type type, String string, int n) {
        return type == Type.pointer_type ? Target.pushObject : new CheckedTarget(type, string, n);
    }

    public static Target getInstance(Type type, LambdaExp lambdaExp, int n) {
        return type == Type.pointer_type ? Target.pushObject : new CheckedTarget(type, lambdaExp, n);
    }

    private static void initWrongType() {
        if (typeClassCastException == null) {
            typeClassCastException = ClassType.make("java.lang.ClassCastException");
        }
        if (typeWrongType == null) {
            typeWrongType = ClassType.make("gnu.mapping.WrongType");
            Type[] typeArray = new Type[]{typeClassCastException, Compilation.javaStringType, Type.int_type};
            makeWrongTypeStringMethod = typeWrongType.addMethod("make", typeArray, typeWrongType, 9);
            typeArray = new Type[]{typeClassCastException, Compilation.typeProcedure, Type.int_type};
            makeWrongTypeProcMethod = typeWrongType.addMethod("make", typeArray, typeWrongType, 9);
        }
    }

    public void compileFromStack(Compilation compilation, Type type) {
        if (!this.compileFromStack0(compilation, type)) {
            CheckedTarget.emitCheckedCoerce(compilation, this.proc, this.procname, this.argno, this.type);
        }
    }

    public static void emitCheckedCoerce(Compilation compilation, String string, int n, Type type) {
        CheckedTarget.emitCheckedCoerce(compilation, null, string, n, type);
    }

    public static void emitCheckedCoerce(Compilation compilation, LambdaExp lambdaExp, int n, Type type) {
        CheckedTarget.emitCheckedCoerce(compilation, lambdaExp, lambdaExp.getName(), n, type);
    }

    static void emitCheckedCoerce(Compilation compilation, LambdaExp lambdaExp, String string, int n, Type type) {
        int n2;
        CodeAttr codeAttr = compilation.getCode();
        boolean bl = codeAttr.isInTry();
        CheckedTarget.initWrongType();
        int n3 = codeAttr.getPC();
        CheckedTarget.emitCoerceFromObject(type, compilation);
        int n4 = codeAttr.getPC();
        if (n4 == n3) {
            return;
        }
        if (type == Type.tostring_type) {
            return;
        }
        Label label = null;
        if (bl) {
            label = new Label(codeAttr);
            codeAttr.emitGoto(label);
            n4 = codeAttr.getPC();
        }
        codeAttr.addHandler(n3, n4, bl ? n4 : -1, typeClassCastException, codeAttr.getConstants());
        if (!bl) {
            codeAttr.beginFragment(true);
        }
        codeAttr.pushType(typeClassCastException);
        boolean bl2 = false;
        if (lambdaExp != null && lambdaExp.isClassGenerated() && !compilation.method.getStaticFlag() && compilation.method.getDeclaringClass() == lambdaExp.getCompiledClassType(compilation)) {
            bl2 = true;
        }
        if ((n2 = compilation.getLine()) > 0) {
            codeAttr.putLineNumber(n2);
        }
        if (bl2) {
            codeAttr.emitPushThis();
        } else {
            codeAttr.emitPushString(string == null ? "lambda" : string);
        }
        codeAttr.emitPushInt(n);
        codeAttr.emitInvokeStatic(bl2 ? makeWrongTypeProcMethod : makeWrongTypeStringMethod);
        codeAttr.emitThrow();
        if (bl) {
            label.define(codeAttr);
        } else {
            codeAttr.endFragment();
        }
    }
}

