/*
 * Decompiled with CFR 0.152.
 */
package gnu.bytecode;

import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Label;
import gnu.bytecode.Method;
import gnu.bytecode.Type;

public class SwitchState {
    int minValue;
    int maxValue;
    int numCases;
    int[] values;
    Label[] labels;
    Label defaultLabel;
    Label switch_label;
    Type[] typeState;

    public int getMaxValue() {
        return this.maxValue;
    }

    public SwitchState(CodeAttr codeAttr) {
        this.switch_label = new Label(codeAttr);
        codeAttr.popType();
        this.typeState = codeAttr.saveStackTypeState(false);
        codeAttr.emitGoto(this.switch_label);
        this.numCases = 0;
    }

    public boolean addCase(int n, CodeAttr codeAttr) {
        Label label = new Label(codeAttr);
        boolean bl = this.addCase(n, label, codeAttr);
        label.define(codeAttr);
        codeAttr.restoreStackTypeState(this.typeState);
        return bl;
    }

    public void addDefault(CodeAttr codeAttr) {
        Label label = new Label(codeAttr);
        label.define(codeAttr);
        this.addDefault(label, codeAttr);
    }

    public void addDefault(Label label, CodeAttr codeAttr) {
        this.defaultLabel = label;
        codeAttr.restoreStackTypeState(this.typeState);
    }

    public boolean addCase(int n, Label label, CodeAttr codeAttr) {
        int n2;
        int n3;
        if (this.values == null) {
            this.values = new int[10];
            this.labels = new Label[10];
            this.numCases = 1;
            this.minValue = this.maxValue = n;
            this.values[0] = n;
            this.labels[0] = label;
            return true;
        }
        int[] nArray = this.values;
        Label[] labelArray = this.labels;
        if (this.numCases >= this.values.length) {
            this.values = new int[2 * this.numCases];
            this.labels = new Label[2 * this.numCases];
        }
        if (n < this.minValue) {
            n3 = 0;
            this.minValue = n;
        } else if (n > this.maxValue) {
            n3 = this.numCases;
            this.maxValue = n;
        } else {
            n2 = 0;
            int n4 = this.numCases - 1;
            n3 = 0;
            while (n2 <= n4) {
                n3 = n2 + n4 >> 1;
                if (nArray[n3] >= n) {
                    n4 = n3 - 1;
                    continue;
                }
                n2 = ++n3;
            }
            if (n == nArray[n3]) {
                return false;
            }
        }
        n2 = this.numCases - n3;
        System.arraycopy(nArray, n3, this.values, n3 + 1, n2);
        System.arraycopy(nArray, 0, this.values, 0, n3);
        this.values[n3] = n;
        System.arraycopy(labelArray, n3, this.labels, n3 + 1, n2);
        System.arraycopy(labelArray, 0, this.labels, 0, n3);
        this.labels[n3] = label;
        ++this.numCases;
        return true;
    }

    public void finish(CodeAttr codeAttr) {
        if (this.defaultLabel == null) {
            this.defaultLabel = new Label(codeAttr);
            this.defaultLabel.define(codeAttr);
            ClassType classType = ClassType.make("java.lang.RuntimeException");
            codeAttr.emitNew(classType);
            codeAttr.emitDup(classType);
            codeAttr.emitPushString("bad case value!");
            Type[] typeArray = new Type[]{Type.string_type};
            Method method = classType.addMethod("<init>", 1, typeArray, Type.void_type);
            codeAttr.emitInvokeSpecial(method);
            codeAttr.emitThrow();
        }
        this.switch_label.define(codeAttr);
        if (this.numCases <= 1) {
            codeAttr.pushType(Type.int_type);
            if (this.numCases == 1) {
                codeAttr.emitPushInt(this.minValue);
                codeAttr.emitGotoIfEq(this.labels[0]);
            } else {
                codeAttr.emitPop(1);
            }
            codeAttr.emitGoto(this.defaultLabel);
            return;
        }
        int n = codeAttr.PC;
        int n2 = 3 - n & 3;
        if (2 * this.numCases >= this.maxValue - this.minValue) {
            codeAttr.reserve(13 + n2 + 4 * (this.maxValue - this.minValue + 1));
            codeAttr.put1(170);
            while (--n2 >= 0) {
                codeAttr.put1(0);
            }
            this.defaultLabel.emit_wide(codeAttr, n);
            codeAttr.put4(this.minValue);
            codeAttr.put4(this.maxValue);
            int n3 = 0;
            for (int i = this.minValue; i <= this.maxValue; ++i) {
                Label label = this.values[n3] == i ? this.labels[n3++] : this.defaultLabel;
                label.emit_wide(codeAttr, n);
            }
        } else {
            codeAttr.reserve(9 + n2 + 8 * this.numCases);
            codeAttr.put1(171);
            while (--n2 >= 0) {
                codeAttr.put1(0);
            }
            this.defaultLabel.emit_wide(codeAttr, n);
            codeAttr.put4(this.numCases);
            for (int i = 0; i < this.numCases; ++i) {
                codeAttr.put4(this.values[i]);
                this.labels[i].emit_wide(codeAttr, n);
            }
        }
    }
}

