/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.input;

import com.sun.electric.database.Environment;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.UserInterfaceExec;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.io.input.EpicOut;
import com.sun.electric.tool.io.input.HSpiceOut;
import com.sun.electric.tool.io.input.Input;
import com.sun.electric.tool.io.input.PSpiceOut;
import com.sun.electric.tool.io.input.RawSpiceOut;
import com.sun.electric.tool.io.input.SpiceOut;
import com.sun.electric.tool.io.input.verilog.VerilogOut;
import com.sun.electric.tool.simulation.SimulationTool;
import com.sun.electric.tool.simulation.Stimuli;
import com.sun.electric.tool.user.waveform.WaveformWindow;
import com.sun.electric.util.TextUtils;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.swing.SwingUtilities;

public final class SimulationData {
    private static final String[] known_extensions = new String[]{"tr0", "ac0", "vcd", "raw", "dump", "spo", "out", "txt", "out.gz"};

    private SimulationData() {
    }

    public static boolean isKnownSimulationFormatExtension(String extension2) {
        return SimulationData.getInputForExtension(extension2) != null;
    }

    public static void plotGuessed(Cell cell, WaveformWindow ww) {
        String[] paths;
        if (cell == null) {
            return;
        }
        for (String path : paths = new String[]{FileType.SPICE.getGroupPath(), TextUtils.getFilePath(cell.getLibrary().getLibFile())}) {
            for (String ext : known_extensions) {
                if (!new File(path, cell.getName() + '.' + ext).exists()) continue;
                SimulationData.plot(cell, TextUtils.makeURLToFile(new File(path, cell.getName() + '.' + ext).getPath()), ww);
                return;
            }
        }
        System.out.println("unable to guess any simulation file with a known extension; the following directories were checked: ");
        for (String path : paths) {
            System.out.println("  " + path);
        }
    }

    public static void plot(Cell cell, URL url, WaveformWindow ww) {
        new ReadSimulationOutput(cell, url, ww).start();
    }

    private static Input<Stimuli> getInputForExtension(String extension2) {
        if (extension2.endsWith(".out.gz")) {
            return new EpicOut();
        }
        if (extension2.indexOf(46) != -1) {
            extension2 = extension2.substring(extension2.lastIndexOf(46) + 1);
        }
        if (extension2.equals("dump") || extension2.equals("vcd")) {
            return new VerilogOut();
        }
        if (extension2.equals("txt")) {
            return new PSpiceOut();
        }
        if (extension2.equals("raw")) {
            return new RawSpiceOut();
        }
        if (extension2.equals("spo")) {
            return new SpiceOut();
        }
        if (extension2.equals("out")) {
            return new EpicOut();
        }
        if (extension2.startsWith("tr") || extension2.startsWith("sw") || extension2.startsWith("ic") || extension2.startsWith("ac") || extension2.startsWith("mt") || extension2.startsWith("pa")) {
            return new HSpiceOut();
        }
        return null;
    }

    public static Stimuli processInput(Cell cell, URL url) {
        ReadSimulationOutput job = new ReadSimulationOutput(cell, url, null);
        job.run();
        return job.sd;
    }

    public static Stimuli processInput(Cell cell, URL url, String netDelimeter) {
        Input<Stimuli> is = SimulationData.getInputForExtension(url.getPath());
        if (is == null) {
            throw new RuntimeException("unable to detect type");
        }
        Stimuli sd = new Stimuli();
        sd.setNetDelimiter(netDelimeter);
        sd.setCell(cell);
        try {
            is.processInput(url, cell, sd);
        }
        catch (IOException e) {
            System.out.println("End of file reached while reading " + url);
            return null;
        }
        sd.setFileURL(url);
        return sd;
    }

    private static class ReadSimulationOutput
    extends Thread {
        private Input<Stimuli> is;
        private URL fileURL;
        private Cell cell;
        private WaveformWindow ww;
        private Stimuli sd;
        private final Environment launcherEnvironment;
        private final UserInterfaceExec userInterface;
        private String netDelimeter;

        private ReadSimulationOutput(Cell cell, URL fileURL, WaveformWindow ww) {
            this.fileURL = fileURL;
            this.cell = cell;
            this.ww = ww;
            this.is = SimulationData.getInputForExtension(fileURL.getPath());
            this.netDelimeter = SimulationTool.getSpiceExtractedNetDelimiter();
            if (this.is == null) {
                throw new RuntimeException("unable to detect type");
            }
            this.launcherEnvironment = Environment.getThreadEnvironment();
            this.userInterface = new UserInterfaceExec();
        }

        @Override
        public void run() {
            if (this.is == null) {
                return;
            }
            if (Thread.currentThread() == this) {
                Environment.setThreadEnvironment(this.launcherEnvironment);
                Job.setUserInterface(this.userInterface);
            }
            try {
                this.sd = new Stimuli();
                this.sd.setNetDelimiter(this.netDelimeter);
                this.sd.setCell(this.cell);
                try {
                    this.is.processInput(this.fileURL, this.cell, this.sd);
                }
                catch (EOFException ee) {
                    System.out.println("Warning: EOF encountered in data; displaying partial results: " + ee);
                    Input.stopProgressDialog();
                }
                if (this.sd == null) {
                    return;
                }
                this.sd.setFileURL(this.fileURL);
                final Stimuli sdx = this.sd;
                assert (this.cell.getDatabase() == EDatabase.clientDatabase());
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (ReadSimulationOutput.this.ww == null) {
                            WaveformWindow.showSimulationDataInNewWindow(sdx);
                        } else {
                            WaveformWindow.refreshSimulationData(sdx, ReadSimulationOutput.this.ww);
                        }
                    }
                });
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

