/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs.options;

import com.sun.electric.database.geometry.EGraphics;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.user.Resources;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.ColorPatternPanel;
import com.sun.electric.tool.user.dialogs.options.PreferencePanel;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class LayersTab
extends PreferencePanel {
    private HashMap<Layer, ColorPatternPanel.Info> layerMap;
    private HashMap<String, ColorPatternPanel.Info> transAndSpecialMap;
    private HashMap<Technology, Color[]> colorMapMap;
    private MyColorPatternPanel colorAndPatternPanel;
    private JComboBox layerName;
    private JLabel layerTechName;
    private JLabel layerTechName1;
    private JPanel layers;
    private JComboBox technology;

    private void factoryResetAll() {
        for (Layer layer : this.layerMap.keySet()) {
            ColorPatternPanel.Info cpi = this.layerMap.get(layer);
            cpi.useStippleDisplay = cpi.graphics.isFactoryPatternedOnDisplay();
            cpi.useStipplePrinter = cpi.graphics.isFactoryPatternedOnPrinter();
            cpi.outlinePatternDisplay = cpi.graphics.getFactoryOutlined();
            cpi.transparentLayer = cpi.graphics.getFactoryTransparentLayer();
            cpi.pattern = cpi.graphics.getFactoryPattern();
            cpi.opacity = cpi.graphics.getFactoryOpacity();
            int factoryColor = cpi.graphics.getFactoryColor();
            cpi.red = factoryColor >> 16 & 0xFF;
            cpi.green = factoryColor >> 8 & 0xFF;
            cpi.blue = factoryColor & 0xFF;
        }
        Iterator<Technology> it = Technology.getTechnologies();
        while (it.hasNext()) {
            Technology tech = it.next();
            Color[] map = new Color[tech.getNumTransparentLayers()];
            Color[] fullMap = tech.getFactoryColorMap();
            for (int i = 0; i < map.length; ++i) {
                map[i] = fullMap[1 << i];
            }
            this.colorMapMap.put(tech, map);
        }
        this.setTechnology();
    }

    public LayersTab(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.colorAndPatternPanel = new MyColorPatternPanel(this, true, true);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridwidth = 4;
        gbc.gridheight = 1;
        gbc.insets = new Insets(4, 4, 4, 4);
        this.layers.add((Component)this.colorAndPatternPanel, gbc);
        this.layerMap = new HashMap();
        this.transAndSpecialMap = new HashMap();
        this.colorMapMap = new HashMap();
        this.layerName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayersTab.this.layerSelected();
            }
        });
        Iterator<Technology> it = Technology.getTechnologies();
        while (it.hasNext()) {
            Technology tech = it.next();
            this.technology.addItem(tech.getTechName());
        }
        this.technology.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayersTab.this.setTechnology();
            }
        });
    }

    @Override
    public JPanel getPanel() {
        return this.layers;
    }

    @Override
    public String getName() {
        return "Layers";
    }

    @Override
    public void init() {
        Iterator<Technology> it = Technology.getTechnologies();
        while (it.hasNext()) {
            Technology tech = it.next();
            Iterator<Layer> lIt = tech.getLayers();
            while (lIt.hasNext()) {
                Layer layer = lIt.next();
                if (layer.isPseudoLayer() && layer.getNonPseudoLayer() != layer) continue;
                this.layerName.addItem(layer.getName());
                ColorPatternPanel.Info li = new ColorPatternPanel.Info(layer.getGraphics());
                this.layerMap.put(layer, li);
            }
            Color[] map = new Color[tech.getNumTransparentLayers()];
            Color[] fullMap = tech.getColorMap();
            for (int i = 0; i < map.length; ++i) {
                map[i] = fullMap[1 << i];
            }
            this.colorMapMap.put(tech, map);
        }
        this.transAndSpecialMap.put("Special: BACKGROUND", new ColorPatternPanel.Info(User.getColorBackground()));
        this.transAndSpecialMap.put("Special: GRID", new ColorPatternPanel.Info(User.getColorGrid()));
        this.transAndSpecialMap.put("Special: HIGHLIGHT", new ColorPatternPanel.Info(User.getColorHighlight()));
        this.transAndSpecialMap.put("Special: MOUSE-OVER HIGHLIGHT", new ColorPatternPanel.Info(User.getColorMouseOverHighlight()));
        this.transAndSpecialMap.put("Special: PORT HIGHLIGHT", new ColorPatternPanel.Info(User.getColorPortHighlight()));
        this.transAndSpecialMap.put("Special: TEXT", new ColorPatternPanel.Info(User.getColorText()));
        this.transAndSpecialMap.put("Special: INSTANCE OUTLINES", new ColorPatternPanel.Info(User.getColorInstanceOutline()));
        this.transAndSpecialMap.put("Special: WAVEFORM BACKGROUND", new ColorPatternPanel.Info(User.getColorWaveformBackground()));
        this.transAndSpecialMap.put("Special: WAVEFORM FOREGROUND", new ColorPatternPanel.Info(User.getColorWaveformForeground()));
        this.transAndSpecialMap.put("Special: WAVEFORM STIMULI", new ColorPatternPanel.Info(User.getColorWaveformStimuli()));
        this.transAndSpecialMap.put("Special: WAVEFORM OFF STRENGTH", new ColorPatternPanel.Info(User.getColorWaveformStrengthOff()));
        this.transAndSpecialMap.put("Special: WAVEFORM NODE (WEAK) STRENGTH", new ColorPatternPanel.Info(User.getColorWaveformStrengthNode()));
        this.transAndSpecialMap.put("Special: WAVEFORM GATE STRENGTH", new ColorPatternPanel.Info(User.getColorWaveformStrengthGate()));
        this.transAndSpecialMap.put("Special: WAVEFORM POWER STRENGTH", new ColorPatternPanel.Info(User.getColorWaveformStrengthPower()));
        this.transAndSpecialMap.put("Special: WAVEFORM CROSSPROBE LOW", new ColorPatternPanel.Info(User.getColorWaveformCrossProbeLow()));
        this.transAndSpecialMap.put("Special: WAVEFORM CROSSPROBE HIGH", new ColorPatternPanel.Info(User.getColorWaveformCrossProbeHigh()));
        this.transAndSpecialMap.put("Special: WAVEFORM CROSSPROBE UNDEFINED", new ColorPatternPanel.Info(User.getColorWaveformCrossProbeX()));
        this.transAndSpecialMap.put("Special: WAVEFORM CROSSPROBE FLOATING", new ColorPatternPanel.Info(User.getColorWaveformCrossProbeZ()));
        try {
            Class j3DUtilsClass = Resources.get3DClass("utils.J3DUtils");
            if (j3DUtilsClass != null) {
                Method setMethod = j3DUtilsClass.getDeclaredMethod("get3DColorsInTab", HashMap.class);
                setMethod.invoke((Object)j3DUtilsClass, this.transAndSpecialMap);
            } else {
                System.out.println("Cannot call 3D plugin method get3DColorsInTab");
            }
        }
        catch (Exception e) {
            System.out.println("Cannot call 3D plugin method get3DColorsInTab");
            e.printStackTrace();
        }
        this.technology.setSelectedItem(Technology.getCurrent().getTechName());
    }

    private void setTechnology() {
        String techName = (String)this.technology.getSelectedItem();
        Technology tech = Technology.findTechnology(techName);
        if (tech == null) {
            return;
        }
        Color[] map = this.colorMapMap.get(tech);
        this.colorAndPatternPanel.setColorMap(map);
        this.layerName.removeAllItems();
        Iterator<Layer> lIt = tech.getLayers();
        while (lIt.hasNext()) {
            Layer layer = lIt.next();
            if (layer.isPseudoLayer() && layer.getNonPseudoLayer() != layer) continue;
            this.layerName.addItem(layer.getName());
        }
        ArrayList<String> specialList = new ArrayList<String>();
        for (String name : this.transAndSpecialMap.keySet()) {
            specialList.add(name);
        }
        Collections.sort(specialList, TextUtils.STRING_NUMBER_ORDER);
        for (String name : specialList) {
            this.layerName.addItem(name);
        }
        this.layerSelected();
    }

    private void layerSelected() {
        String techName = (String)this.technology.getSelectedItem();
        Technology tech = Technology.findTechnology(techName);
        if (tech == null) {
            return;
        }
        String name = (String)this.layerName.getSelectedItem();
        ColorPatternPanel.Info li = this.transAndSpecialMap.get(name);
        Layer layer = null;
        if (li == null) {
            layer = tech.findLayer(name);
            li = this.layerMap.get(layer);
        }
        if (li == null) {
            return;
        }
        this.colorAndPatternPanel.setColorPattern(li);
        String otherLayers = null;
        if (li.transparentLayer > 0 && layer != null) {
            Iterator<Layer> it = tech.getLayers();
            while (it.hasNext()) {
                ColorPatternPanel.Info oLi;
                Layer oLayer = it.next();
                if (oLayer == layer || (oLi = this.layerMap.get(oLayer)) == null || oLi.transparentLayer != li.transparentLayer) continue;
                if (otherLayers == null) {
                    otherLayers = oLayer.getName();
                    continue;
                }
                otherLayers = otherLayers + ", " + oLayer.getName();
            }
        }
        this.colorAndPatternPanel.setOtherTransparentLayerNames(otherLayers);
    }

    @Override
    public void term() {
        boolean changed = false;
        Iterator<Technology> it = Technology.getTechnologies();
        while (it.hasNext()) {
            Technology tech = it.next();
            Iterator<Layer> lIt = tech.getLayers();
            while (lIt.hasNext()) {
                ColorPatternPanel.Info altLI;
                Layer layer = lIt.next();
                ColorPatternPanel.Info li = this.layerMap.get(layer);
                EGraphics graphics = layer.getGraphics();
                if (layer.isPseudoLayer() && (altLI = this.layerMap.get(layer.getNonPseudoLayer())) != null) {
                    li = altLI;
                }
                if (!li.updateGraphics(graphics)) continue;
                changed = true;
            }
            Color[] fullOrigMap = tech.getColorMap();
            Color[] origMap = new Color[tech.getNumTransparentLayers()];
            for (int i = 0; i < origMap.length; ++i) {
                origMap[i] = fullOrigMap[1 << i];
            }
            boolean mapChanged = false;
            Color[] map = this.colorMapMap.get(tech);
            for (int i = 0; i < map.length; ++i) {
                if (map[i].getRGB() == origMap[i].getRGB()) continue;
                mapChanged = true;
            }
            if (!mapChanged) continue;
            tech.setColorMapFromLayers(map);
        }
        int c = 0;
        c = this.specialMapColor("Special: BACKGROUND", User.getColorBackground());
        if (c >= 0) {
            User.setColorBackground(c);
            changed = true;
        }
        if ((c = this.specialMapColor("Special: GRID", User.getColorGrid())) >= 0) {
            User.setColorGrid(c);
            changed = true;
        }
        if ((c = this.specialMapColor("Special: HIGHLIGHT", User.getColorHighlight())) >= 0) {
            User.setColorHighlight(c);
            changed = true;
        }
        if ((c = this.specialMapColor("Special: MOUSE-OVER HIGHLIGHT", User.getColorMouseOverHighlight())) >= 0) {
            User.setColorMouseOverHighlight(c);
            changed = true;
        }
        if ((c = this.specialMapColor("Special: PORT HIGHLIGHT", User.getColorPortHighlight())) >= 0) {
            User.setColorPortHighlight(c);
            changed = true;
        }
        if ((c = this.specialMapColor("Special: TEXT", User.getColorText())) >= 0) {
            User.setColorText(c);
            changed = true;
        }
        if ((c = this.specialMapColor("Special: INSTANCE OUTLINES", User.getColorInstanceOutline())) >= 0) {
            User.setColorInstanceOutline(c);
            changed = true;
        }
        if ((c = this.specialMapColor("Special: WAVEFORM BACKGROUND", User.getColorWaveformBackground())) >= 0) {
            User.setColorWaveformBackground(c);
            changed = true;
        }
        if ((c = this.specialMapColor("Special: WAVEFORM FOREGROUND", User.getColorWaveformForeground())) >= 0) {
            User.setColorWaveformForeground(c);
            changed = true;
        }
        if ((c = this.specialMapColor("Special: WAVEFORM STIMULI", User.getColorWaveformStimuli())) >= 0) {
            User.setColorWaveformStimuli(c);
            changed = true;
        }
        if ((c = this.specialMapColor("Special: WAVEFORM OFF STRENGTH", User.getColorWaveformStrengthOff())) >= 0) {
            User.setColorWaveformStrengthOff(c);
            changed = true;
        }
        if ((c = this.specialMapColor("Special: WAVEFORM NODE (WEAK) STRENGTH", User.getColorWaveformStrengthNode())) >= 0) {
            User.setColorWaveformStrengthNode(c);
            changed = true;
        }
        if ((c = this.specialMapColor("Special: WAVEFORM GATE STRENGTH", User.getColorWaveformStrengthGate())) >= 0) {
            User.setColorWaveformStrengthGate(c);
            changed = true;
        }
        if ((c = this.specialMapColor("Special: WAVEFORM POWER STRENGTH", User.getColorWaveformStrengthPower())) >= 0) {
            User.setColorWaveformStrengthPower(c);
            changed = true;
        }
        if ((c = this.specialMapColor("Special: WAVEFORM CROSSPROBE LOW", User.getColorWaveformCrossProbeLow())) >= 0) {
            User.setColorWaveformCrossProbeLow(c);
            changed = true;
        }
        if ((c = this.specialMapColor("Special: WAVEFORM CROSSPROBE HIGH", User.getColorWaveformCrossProbeHigh())) >= 0) {
            User.setColorWaveformCrossProbeHigh(c);
            changed = true;
        }
        if ((c = this.specialMapColor("Special: WAVEFORM CROSSPROBE UNDEFINED", User.getColorWaveformCrossProbeX())) >= 0) {
            User.setColorWaveformCrossProbeX(c);
            changed = true;
        }
        if ((c = this.specialMapColor("Special: WAVEFORM CROSSPROBE FLOATING", User.getColorWaveformCrossProbeZ())) >= 0) {
            User.setColorWaveformCrossProbeZ(c);
            changed = true;
        }
        try {
            Class j3DUtilsClass = Resources.get3DClass("utils.J3DUtils");
            Method setMethod = j3DUtilsClass.getDeclaredMethod("set3DColorsInTab", LayersTab.class);
            Object color3DChanged = setMethod.invoke((Object)j3DUtilsClass, this);
            if (!changed && color3DChanged != null) {
                changed = (Boolean)color3DChanged;
            }
        }
        catch (Exception e) {
            System.out.println("Cannot call 3D plugin method set3DColorsInTab: " + e.getMessage());
            e.printStackTrace();
        }
        if (changed) {
            WindowFrame wf = WindowFrame.getCurrentWindowFrame(false);
            if (wf != null) {
                wf.loadComponentMenuForTechnology();
            }
            EditWindow.repaintAllContents();
        }
    }

    public int specialMapColor(String title, int curColor) {
        ColorPatternPanel.Info li = this.transAndSpecialMap.get(title);
        if (li == null) {
            return -1;
        }
        int newColor = li.red << 16 | li.green << 8 | li.blue;
        if (newColor != curColor) {
            return newColor;
        }
        return -1;
    }

    private void initComponents() {
        this.layers = new JPanel();
        this.layerName = new JComboBox();
        this.layerTechName = new JLabel();
        this.technology = new JComboBox();
        this.layerTechName1 = new JLabel();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Edit Options");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                LayersTab.this.closeDialog(evt);
            }
        });
        this.layers.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.layers.add((Component)this.layerName, gridBagConstraints);
        this.layerTechName.setText("Layer:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.layers.add((Component)this.layerTechName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.layers.add((Component)this.technology, gridBagConstraints);
        this.layerTechName1.setText("Technology:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.layers.add((Component)this.layerTechName1, gridBagConstraints);
        this.getContentPane().add((Component)this.layers, new GridBagConstraints());
        this.pack();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private static class MyColorPatternPanel
    extends ColorPatternPanel {
        private LayersTab lt;

        public MyColorPatternPanel(LayersTab lt, boolean showPrinter, boolean showFactoryReset) {
            super(showPrinter, showFactoryReset);
            this.lt = lt;
        }

        @Override
        public void factoryResetActionPerformed() {
            this.lt.factoryResetAll();
        }
    }
}

