/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs.options;

import com.sun.electric.database.text.TextUtils;
import com.sun.electric.technology.Layer;
import com.sun.electric.tool.io.GDSLayers;
import com.sun.electric.tool.io.IOTool;
import com.sun.electric.tool.user.dialogs.options.PreferencePanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class GDSTab
extends PreferencePanel {
    private JList gdsLayersList;
    private DefaultListModel gdsLayersModel;
    private boolean changingGDS = false;
    private JPanel gds;
    private JTextField gdsCellNameLenMax;
    private JCheckBox gdsConvertNCCExportsConnectedByParentPins;
    private JTextField gdsDefaultTextLayer;
    private JCheckBox gdsInputExpandsCells;
    private JCheckBox gdsInputIgnoresUnknownLayers;
    private JCheckBox gdsInputIncludesText;
    private JCheckBox gdsInputInstantiatesArrays;
    private JScrollPane gdsLayerList;
    private JTextField gdsLayerNumber;
    private JTextField gdsLayerType;
    private JCheckBox gdsOutputConvertsBracketsInExports;
    private JCheckBox gdsOutputMergesBoxes;
    private JCheckBox gdsOutputUpperCase;
    private JCheckBox gdsOutputWritesExportPins;
    private JTextField gdsPinLayer;
    private JTextField gdsPinType;
    private JLabel gdsTechName;
    private JTextField gdsTextLayer;
    private JTextField gdsTextType;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel29;
    private JLabel jLabel3;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;

    public GDSTab(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    public JPanel getPanel() {
        return this.gds;
    }

    public String getName() {
        return "GDS";
    }

    public void init() {
        this.gdsTechName.setText("Technology '" + this.curTech.getTechName() + "' using '" + this.curTech.getSelectedFoundry() + "' :");
        this.gdsOutputMergesBoxes.setSelected(IOTool.isGDSOutMergesBoxes());
        this.gdsOutputWritesExportPins.setSelected(IOTool.isGDSOutWritesExportPins());
        this.gdsOutputUpperCase.setSelected(IOTool.isGDSOutUpperCase());
        this.gdsDefaultTextLayer.setText(Integer.toString(IOTool.getGDSOutDefaultTextLayer()));
        this.gdsOutputConvertsBracketsInExports.setSelected(IOTool.getGDSOutputConvertsBracketsInExports());
        this.gdsCellNameLenMax.setText(Integer.toString(IOTool.getGDSCellNameLenMax()));
        this.gdsConvertNCCExportsConnectedByParentPins.setSelected(IOTool.getGDSConvertNCCExportsConnectedByParentPins());
        this.gdsInputIncludesText.setSelected(IOTool.isGDSInIncludesText());
        this.gdsInputExpandsCells.setSelected(IOTool.isGDSInExpandsCells());
        this.gdsInputInstantiatesArrays.setSelected(IOTool.isGDSInInstantiatesArrays());
        this.gdsInputIgnoresUnknownLayers.setSelected(IOTool.isGDSInIgnoresUnknownLayers());
        this.gdsLayersModel = new DefaultListModel();
        this.gdsLayersList = new JList(this.gdsLayersModel);
        this.gdsLayersList.setSelectionMode(0);
        this.gdsLayerList.setViewportView(this.gdsLayersList);
        this.gdsLayersList.clearSelection();
        this.gdsLayersList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                GDSTab.this.gdsClickLayer();
            }
        });
        this.gdsLayersModel.clear();
        Iterator it = this.curTech.getLayers();
        while (it.hasNext()) {
            Layer layer = (Layer)it.next();
            String str = layer.getName();
            String gdsLayer = layer.getGDSLayer();
            if (gdsLayer != null) {
                str = str + " (" + gdsLayer + ")";
            }
            this.gdsLayersModel.addElement(str);
        }
        this.gdsLayersList.setSelectedIndex(0);
        this.gdsClickLayer();
        GDSDocumentListener myDocumentListener = new GDSDocumentListener(this);
        this.gdsLayerNumber.getDocument().addDocumentListener(myDocumentListener);
        this.gdsLayerType.getDocument().addDocumentListener(myDocumentListener);
        this.gdsPinLayer.getDocument().addDocumentListener(myDocumentListener);
        this.gdsPinType.getDocument().addDocumentListener(myDocumentListener);
        this.gdsTextLayer.getDocument().addDocumentListener(myDocumentListener);
        this.gdsTextType.getDocument().addDocumentListener(myDocumentListener);
    }

    private void gdsClickLayer() {
        this.changingGDS = true;
        String str = (String)this.gdsLayersList.getSelectedValue();
        GDSLayers numbers = this.gdsGetNumbers(str);
        if (numbers == null) {
            return;
        }
        if (numbers.getNumLayers() == 0) {
            this.gdsLayerNumber.setText("");
            this.gdsLayerType.setText("");
        } else {
            Integer gdsValue = numbers.getFirstLayer();
            int layerNum = gdsValue & 0xFFFF;
            int layerType = gdsValue >> 16 & 0xFFFF;
            this.gdsLayerNumber.setText(Integer.toString(layerNum));
            this.gdsLayerType.setText(Integer.toString(layerType));
        }
        if (numbers.getPinLayer() == -1) {
            this.gdsPinLayer.setText("");
            this.gdsPinType.setText("");
        } else {
            this.gdsPinLayer.setText(Integer.toString(numbers.getPinLayer() & 0xFFFF));
            this.gdsPinType.setText(Integer.toString(numbers.getPinLayer() >> 16 & 0xFFFF));
        }
        if (numbers.getTextLayer() == -1) {
            this.gdsTextLayer.setText("");
            this.gdsTextType.setText("");
        } else {
            this.gdsTextLayer.setText(Integer.toString(numbers.getTextLayer() & 0xFFFF));
            this.gdsTextType.setText(Integer.toString(numbers.getTextLayer() >> 16 & 0xFFFF));
        }
        this.changingGDS = false;
    }

    private GDSLayers gdsGetNumbers(String str) {
        int openParen = str.indexOf(40);
        if (openParen < 0) {
            return null;
        }
        int closeParen = str.lastIndexOf(41);
        if (closeParen < 0) {
            return null;
        }
        String gdsNumbers = str.substring(openParen + 1, closeParen);
        GDSLayers numbers = GDSLayers.parseLayerString(gdsNumbers);
        return numbers;
    }

    private Layer gdsGetLayer(String str) {
        int openParen = str.indexOf(40);
        if (openParen < 0) {
            return null;
        }
        String layerName = str.substring(0, openParen - 1);
        Layer layer = this.curTech.findLayer(layerName);
        return layer;
    }

    private void gdsNumbersChanged() {
        if (this.changingGDS) {
            return;
        }
        String str = (String)this.gdsLayersList.getSelectedValue();
        Layer layer = this.gdsGetLayer(str);
        if (layer == null) {
            return;
        }
        String newLine = layer.getName() + " (" + this.gdsLayerNumber.getText().trim();
        int layerType = TextUtils.atoi(this.gdsLayerType.getText().trim());
        if (layerType != 0) {
            newLine = newLine + "/" + layerType;
        }
        String pinLayer = this.gdsPinLayer.getText().trim();
        int pinType = TextUtils.atoi(this.gdsPinType.getText().trim());
        if (pinLayer.length() > 0 || pinType != 0) {
            newLine = newLine + "," + pinLayer;
            if (pinType != 0) {
                newLine = newLine + "/" + pinType;
            }
            newLine = newLine + "p";
        }
        String textLayer = this.gdsTextLayer.getText().trim();
        int textType = TextUtils.atoi(this.gdsTextType.getText().trim());
        if (textLayer.length() > 0 || textType != 0) {
            newLine = newLine + "," + textLayer;
            if (textType != 0) {
                newLine = newLine + "/" + textType;
            }
            newLine = newLine + "t";
        }
        newLine = newLine + ")";
        int index = this.gdsLayersList.getSelectedIndex();
        this.gdsLayersModel.set(index, newLine);
    }

    public void term() {
        int currentCellNameLen;
        int currentTextLayer;
        for (int i = 0; i < this.gdsLayersModel.getSize(); ++i) {
            GDSLayers oldNumbers;
            GDSLayers numbers;
            String str = (String)this.gdsLayersModel.getElementAt(i);
            Layer layer = this.gdsGetLayer(str);
            if (layer == null || (numbers = this.gdsGetNumbers(str)) == null || (oldNumbers = GDSLayers.parseLayerString(layer.getGDSLayer())).equals(numbers)) continue;
            String currentGDSNumbers = "";
            Iterator it = numbers.getLayers();
            while (it.hasNext()) {
                Integer layVal = (Integer)it.next();
                int layNum = layVal & 0xFFFF;
                int layType = layVal >> 16 & 0xFFFF;
                currentGDSNumbers = currentGDSNumbers + Integer.toString(layNum);
                if (layType == 0) continue;
                currentGDSNumbers = currentGDSNumbers + "/" + layType;
            }
            if (numbers.getPinLayer() != -1) {
                currentGDSNumbers = currentGDSNumbers + "," + (numbers.getPinLayer() & 0xFFFF);
                int pinType = numbers.getPinLayer() >> 16 & 0xFFFF;
                if (pinType != 0) {
                    currentGDSNumbers = currentGDSNumbers + "/" + pinType;
                }
                currentGDSNumbers = currentGDSNumbers + "p";
            }
            if (numbers.getTextLayer() != -1) {
                currentGDSNumbers = currentGDSNumbers + "," + (numbers.getTextLayer() & 0xFFFF);
                int textType = numbers.getTextLayer() >> 16 & 0xFFFF;
                if (textType != 0) {
                    currentGDSNumbers = currentGDSNumbers + "/" + textType;
                }
                currentGDSNumbers = currentGDSNumbers + "t";
            }
            layer.setGDSLayer(currentGDSNumbers);
        }
        boolean currentValue = this.gdsOutputMergesBoxes.isSelected();
        if (currentValue != IOTool.isGDSOutMergesBoxes()) {
            IOTool.setGDSOutMergesBoxes(currentValue);
        }
        if ((currentValue = this.gdsOutputWritesExportPins.isSelected()) != IOTool.isGDSOutWritesExportPins()) {
            IOTool.setGDSOutWritesExportPins(currentValue);
        }
        if ((currentValue = this.gdsOutputUpperCase.isSelected()) != IOTool.isGDSOutUpperCase()) {
            IOTool.setGDSOutUpperCase(currentValue);
        }
        if ((currentValue = this.gdsOutputConvertsBracketsInExports.isSelected()) != IOTool.getGDSOutputConvertsBracketsInExports()) {
            IOTool.setGDSOutputConvertsBracketsInExports(currentValue);
        }
        if ((currentValue = this.gdsConvertNCCExportsConnectedByParentPins.isSelected()) != IOTool.getGDSConvertNCCExportsConnectedByParentPins()) {
            IOTool.setGDSConvertNCCExportsConnectedByParentPins(currentValue);
        }
        if ((currentTextLayer = TextUtils.atoi(this.gdsDefaultTextLayer.getText())) != IOTool.getGDSOutDefaultTextLayer()) {
            IOTool.setGDSOutDefaultTextLayer(currentTextLayer);
        }
        if ((currentCellNameLen = TextUtils.atoi(this.gdsCellNameLenMax.getText())) != IOTool.getGDSCellNameLenMax()) {
            IOTool.setGDSCellNameLenMax(currentCellNameLen);
        }
        if ((currentValue = this.gdsInputIncludesText.isSelected()) != IOTool.isGDSInIncludesText()) {
            IOTool.setGDSInIncludesText(currentValue);
        }
        if ((currentValue = this.gdsInputExpandsCells.isSelected()) != IOTool.isGDSInExpandsCells()) {
            IOTool.setGDSInExpandsCells(currentValue);
        }
        if ((currentValue = this.gdsInputInstantiatesArrays.isSelected()) != IOTool.isGDSInInstantiatesArrays()) {
            IOTool.setGDSInInstantiatesArrays(currentValue);
        }
        if ((currentValue = this.gdsInputIgnoresUnknownLayers.isSelected()) != IOTool.isGDSInIgnoresUnknownLayers()) {
            IOTool.setGDSInIgnoresUnknownLayers(currentValue);
        }
    }

    private void initComponents() {
        this.gds = new JPanel();
        this.gdsLayerList = new JScrollPane();
        this.jLabel6 = new JLabel();
        this.gdsLayerNumber = new JTextField();
        this.jLabel7 = new JLabel();
        this.gdsPinLayer = new JTextField();
        this.jLabel8 = new JLabel();
        this.gdsTextLayer = new JTextField();
        this.gdsInputIncludesText = new JCheckBox();
        this.gdsInputExpandsCells = new JCheckBox();
        this.gdsInputInstantiatesArrays = new JCheckBox();
        this.gdsInputIgnoresUnknownLayers = new JCheckBox();
        this.gdsOutputMergesBoxes = new JCheckBox();
        this.gdsOutputWritesExportPins = new JCheckBox();
        this.gdsOutputUpperCase = new JCheckBox();
        this.jLabel9 = new JLabel();
        this.gdsDefaultTextLayer = new JTextField();
        this.gdsTechName = new JLabel();
        this.jLabel29 = new JLabel();
        this.gdsOutputConvertsBracketsInExports = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.gdsLayerType = new JTextField();
        this.gdsPinType = new JTextField();
        this.gdsTextType = new JTextField();
        this.jLabel3 = new JLabel();
        this.gdsCellNameLenMax = new JTextField();
        this.gdsConvertNCCExportsConnectedByParentPins = new JCheckBox();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("IO Options");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                GDSTab.this.closeDialog(evt);
            }
        });
        this.gds.setLayout(new GridBagLayout());
        this.gdsLayerList.setMinimumSize(new Dimension(100, 200));
        this.gdsLayerList.setPreferredSize(new Dimension(150, 200));
        this.gdsLayerList.setOpaque(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 15;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.gds.add((Component)this.gdsLayerList, gridBagConstraints);
        this.jLabel6.setText("Normal:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.gds.add((Component)this.jLabel6, gridBagConstraints);
        this.gdsLayerNumber.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.gds.add((Component)this.gdsLayerNumber, gridBagConstraints);
        this.jLabel7.setText("Pin:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.gds.add((Component)this.jLabel7, gridBagConstraints);
        this.gdsPinLayer.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.gds.add((Component)this.gdsPinLayer, gridBagConstraints);
        this.jLabel8.setText("Text:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.gds.add((Component)this.jLabel8, gridBagConstraints);
        this.gdsTextLayer.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.gds.add((Component)this.gdsTextLayer, gridBagConstraints);
        this.gdsInputIncludesText.setText("Input includes Text");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 2, 4);
        this.gds.add((Component)this.gdsInputIncludesText, gridBagConstraints);
        this.gdsInputExpandsCells.setText("Input expands cells");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.gds.add((Component)this.gdsInputExpandsCells, gridBagConstraints);
        this.gdsInputInstantiatesArrays.setText("Input instantiates Arrays");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.gds.add((Component)this.gdsInputInstantiatesArrays, gridBagConstraints);
        this.gdsInputIgnoresUnknownLayers.setText("Input ignores unknown layers");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 6, 4);
        this.gds.add((Component)this.gdsInputIgnoresUnknownLayers, gridBagConstraints);
        this.gdsOutputMergesBoxes.setText("Output merges Boxes");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 4, 2, 4);
        this.gds.add((Component)this.gdsOutputMergesBoxes, gridBagConstraints);
        this.gdsOutputWritesExportPins.setText("Output writes export Pins");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.gds.add((Component)this.gdsOutputWritesExportPins, gridBagConstraints);
        this.gdsOutputUpperCase.setText("Output all upper-case");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.gds.add((Component)this.gdsOutputUpperCase, gridBagConstraints);
        this.jLabel9.setText("Output default text layer:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.gds.add((Component)this.jLabel9, gridBagConstraints);
        this.gdsDefaultTextLayer.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints.anchor = 17;
        this.gds.add((Component)this.gdsDefaultTextLayer, gridBagConstraints);
        this.gdsTechName.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.gds.add((Component)this.gdsTechName, gridBagConstraints);
        this.jLabel29.setText("Negative layer values generate no GDS");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.gridwidth = 3;
        this.gds.add((Component)this.jLabel29, gridBagConstraints);
        this.gdsOutputConvertsBracketsInExports.setText("Output converts brackets in exports");
        this.gdsOutputConvertsBracketsInExports.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GDSTab.this.gdsOutputConvertsBracketsInExportsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        gridBagConstraints.anchor = 17;
        this.gds.add((Component)this.gdsOutputConvertsBracketsInExports, gridBagConstraints);
        this.jLabel1.setText("Layer:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        this.gds.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel2.setText("Type:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        this.gds.add((Component)this.jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.gds.add((Component)this.gdsLayerType, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.gds.add((Component)this.gdsPinType, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.gds.add((Component)this.gdsTextType, gridBagConstraints);
        this.jLabel3.setText("Max chars in output cell name:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        gridBagConstraints.anchor = 17;
        this.gds.add((Component)this.jLabel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        gridBagConstraints.anchor = 17;
        this.gds.add((Component)this.gdsCellNameLenMax, gridBagConstraints);
        this.gdsConvertNCCExportsConnectedByParentPins.setText("Convert NCC exportsConnectedByParent Exports");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 17;
        this.gds.add((Component)this.gdsConvertNCCExportsConnectedByParentPins, gridBagConstraints);
        this.getContentPane().add((Component)this.gds, new GridBagConstraints());
        this.pack();
    }

    private void gdsOutputConvertsBracketsInExportsActionPerformed(ActionEvent evt) {
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private static class GDSDocumentListener
    implements DocumentListener {
        GDSTab dialog;

        GDSDocumentListener(GDSTab dialog) {
            this.dialog = dialog;
        }

        public void changedUpdate(DocumentEvent e) {
            this.dialog.gdsNumbersChanged();
        }

        public void insertUpdate(DocumentEvent e) {
            this.dialog.gdsNumbersChanged();
        }

        public void removeUpdate(DocumentEvent e) {
            this.dialog.gdsNumbersChanged();
        }
    }
}

