/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.ui;

import com.sun.electric.database.change.Undo;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.prototype.ArcProto;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.lib.LibFile;
import com.sun.electric.technology.PrimitiveArc;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.SizeOffset;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.io.input.Input;
import com.sun.electric.tool.simulation.Simulation;
import com.sun.electric.tool.user.ExportChanges;
import com.sun.electric.tool.user.Highlight;
import com.sun.electric.tool.user.Resources;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.AnnularRing;
import com.sun.electric.tool.user.dialogs.CellBrowser;
import com.sun.electric.tool.user.dialogs.LayoutText;
import com.sun.electric.tool.user.dialogs.OpenFile;
import com.sun.electric.tool.user.menus.CellMenu;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.StatusBar;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.net.URL;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class PaletteFrame {
    private Container container;
    private PalettePanel panel;
    private int menuX = -1;
    private int menuY = -1;
    private int entrySize;
    private List inPalette;
    private Object highlightedNode;
    private JComboBox selector;

    private PaletteFrame() {
    }

    public static PaletteFrame newInstance() {
        PaletteFrame palette = new PaletteFrame();
        Dimension screenSize = TopLevel.getScreenSize();
        int screenHeight = (int)screenSize.getHeight();
        Dimension frameSize = new Dimension(100, (int)((double)screenHeight * 0.9));
        if (TopLevel.isMDIMode()) {
            JInternalFrame jInternalFrame = new JInternalFrame("Components", true, false, false, false);
            palette.container = jInternalFrame;
            jInternalFrame.setSize(frameSize);
            jInternalFrame.setLocation(0, 0);
            jInternalFrame.setAutoscrolls(true);
            jInternalFrame.setFrameIcon(Resources.getResource(palette.getClass(), "IconElectric.gif"));
        } else {
            JFrame jFrame = new JFrame("Components");
            palette.container = jFrame;
            jFrame.setSize(frameSize);
            jFrame.setLocation(0, 0);
            jFrame.setDefaultCloseOperation(0);
        }
        palette.panel = new PalettePanel(palette);
        palette.panel.setFocusable(true);
        palette.selector = new JComboBox();
        palette.selector.setLightWeightPopupEnabled(false);
        List techList = Technology.getTechnologiesSortedByName();
        Iterator it = techList.iterator();
        while (it.hasNext()) {
            Technology tech = (Technology)it.next();
            if (tech == Generic.tech) continue;
            palette.selector.addItem(tech.getTechName());
        }
        palette.selector.setSelectedItem(Technology.getCurrent().getTechName());
        palette.selector.addActionListener(new TechnologyPopupActionListener(palette));
        if (TopLevel.isMDIMode()) {
            ((JInternalFrame)palette.container).getContentPane().setLayout(new BorderLayout());
            ((JInternalFrame)palette.container).getContentPane().add((Component)palette.selector, "North");
            ((JInternalFrame)palette.container).getContentPane().add((Component)palette.panel, "Center");
            ((JInternalFrame)palette.container).show();
            TopLevel.addToDesktop((JInternalFrame)palette.container);
            ((JInternalFrame)palette.container).moveToFront();
        } else {
            ((JFrame)palette.container).getContentPane().setLayout(new BorderLayout());
            ((JFrame)palette.container).getContentPane().add((Component)palette.selector, "North");
            ((JFrame)palette.container).getContentPane().add((Component)palette.panel, "Center");
            ((JFrame)palette.container).show();
        }
        return palette;
    }

    public void setCursor(Cursor cursor) {
        this.panel.setCursor(cursor);
    }

    public Rectangle getPaletteLocation() {
        return this.container.getBounds();
    }

    public void arcProtoChanged() {
        this.panel.repaint();
    }

    public static void autoTechnologySwitch(Cell cell) {
        if (cell.getView().isTextView()) {
            return;
        }
        Technology tech = cell.getTechnology();
        if (tech != null && tech != Technology.getCurrent() && User.isAutoTechnologySwitch()) {
            tech.setCurrent();
            TopLevel.getPaletteFrame().selector.setSelectedItem(tech.getTechName());
        }
    }

    public void loadForTechnology() {
        Technology tech = Technology.getCurrent();
        this.inPalette = new ArrayList();
        if (tech == Schematics.tech) {
            this.menuX = 2;
            this.menuY = 14;
            this.inPalette.add(Schematics.tech.wire_arc);
            this.inPalette.add(Schematics.tech.wirePinNode);
            this.inPalette.add("Spice");
            this.inPalette.add(Schematics.tech.offpageNode);
            this.inPalette.add(Schematics.tech.globalNode);
            this.inPalette.add(Schematics.tech.powerNode);
            this.inPalette.add(Schematics.tech.resistorNode);
            this.inPalette.add(Schematics.tech.capacitorNode);
            this.inPalette.add(PaletteFrame.makeNodeInst(Schematics.tech.transistor4Node, NodeProto.Function.TRA4PNP, 900));
            this.inPalette.add(PaletteFrame.makeNodeInst(Schematics.tech.transistorNode, NodeProto.Function.TRAPNP, 900));
            this.inPalette.add(Schematics.tech.switchNode);
            this.inPalette.add(Schematics.tech.muxNode);
            this.inPalette.add(Schematics.tech.xorNode);
            this.inPalette.add(Schematics.tech.bboxNode);
            this.inPalette.add(Schematics.tech.bus_arc);
            this.inPalette.add(Schematics.tech.busPinNode);
            this.inPalette.add("Cell");
            this.inPalette.add(Schematics.tech.wireConNode);
            this.inPalette.add("Misc.");
            this.inPalette.add(Schematics.tech.groundNode);
            this.inPalette.add(Schematics.tech.inductorNode);
            this.inPalette.add(Schematics.tech.diodeNode);
            this.inPalette.add(PaletteFrame.makeNodeInst(Schematics.tech.transistorNode, NodeProto.Function.TRAPMOS, 900));
            this.inPalette.add(PaletteFrame.makeNodeInst(Schematics.tech.transistorNode, NodeProto.Function.TRANMOS, 900));
            this.inPalette.add(Schematics.tech.flipflopNode);
            this.inPalette.add(Schematics.tech.bufferNode);
            this.inPalette.add(Schematics.tech.orNode);
            this.inPalette.add(Schematics.tech.andNode);
        } else if (tech == Artwork.tech) {
            this.menuX = 2;
            this.menuY = 12;
            this.inPalette.add(Artwork.tech.solidArc);
            this.inPalette.add(Artwork.tech.thickerArc);
            this.inPalette.add("Cell");
            this.inPalette.add(Artwork.tech.openedPolygonNode);
            this.inPalette.add(Artwork.tech.openedThickerPolygonNode);
            this.inPalette.add(Artwork.tech.filledTriangleNode);
            this.inPalette.add(Artwork.tech.filledBoxNode);
            this.inPalette.add(PaletteFrame.makeNodeInst(Artwork.tech.filledPolygonNode, NodeProto.Function.ART, 0));
            this.inPalette.add(Artwork.tech.filledCircleNode);
            this.inPalette.add(Artwork.tech.pinNode);
            this.inPalette.add(Artwork.tech.crossedBoxNode);
            this.inPalette.add(Artwork.tech.thickCircleNode);
            this.inPalette.add(Artwork.tech.dottedArc);
            this.inPalette.add(Artwork.tech.dashedArc);
            this.inPalette.add("Text");
            this.inPalette.add(Artwork.tech.openedDottedPolygonNode);
            this.inPalette.add(Artwork.tech.openedDashedPolygonNode);
            this.inPalette.add(Artwork.tech.triangleNode);
            this.inPalette.add(Artwork.tech.boxNode);
            this.inPalette.add(PaletteFrame.makeNodeInst(Artwork.tech.closedPolygonNode, NodeProto.Function.ART, 0));
            this.inPalette.add(Artwork.tech.circleNode);
            this.inPalette.add("Export");
            this.inPalette.add(Artwork.tech.arrowNode);
            this.inPalette.add(PaletteFrame.makeNodeInst(Artwork.tech.splineNode, NodeProto.Function.ART, 0));
        } else {
            int pinTotal = 0;
            int pureTotal = 0;
            int compTotal = 0;
            int arcTotal = 0;
            PrimitiveArc firstHighlightedArc = null;
            this.highlightedNode = null;
            Iterator it = tech.getArcs();
            while (it.hasNext()) {
                PrimitiveNode np;
                PrimitiveArc ap = (PrimitiveArc)it.next();
                if (ap.isNotUsed() || (np = ap.findPinProto()) != null && np.isNotUsed()) continue;
                if (firstHighlightedArc == null) {
                    firstHighlightedArc = ap;
                }
                ++arcTotal;
                this.inPalette.add(ap);
            }
            User.tool.setCurrentArcProto(firstHighlightedArc);
            this.inPalette.add("Cell");
            this.inPalette.add("Misc.");
            this.inPalette.add("Pure");
            it = tech.getNodes();
            while (it.hasNext()) {
                PrimitiveNode np = (PrimitiveNode)it.next();
                if (np.isNotUsed()) continue;
                NodeProto.Function fun = np.getFunction();
                if (fun == NodeProto.Function.PIN) {
                    ++pinTotal;
                    this.inPalette.add(np);
                    continue;
                }
                if (fun == NodeProto.Function.NODE) {
                    ++pureTotal;
                    continue;
                }
                ++compTotal;
                this.inPalette.add(np);
            }
            if (pinTotal + compTotal == 0) {
                pinTotal = pureTotal;
            }
            this.menuY = arcTotal + pinTotal + compTotal + 3;
            this.menuX = 1;
            if (this.menuY > 40) {
                this.menuY = (this.menuY + 2) / 3;
                this.menuX = 3;
            } else if (this.menuY > 20) {
                this.menuY = (this.menuY + 1) / 2;
                this.menuX = 2;
            }
        }
        Dimension size = TopLevel.getScreenSize();
        this.entrySize = (int)size.getWidth() / this.menuX;
        int ysize = (int)(size.getHeight() * 0.9) / this.menuY;
        if (ysize < this.entrySize) {
            this.entrySize = ysize;
        }
        size.setSize(this.entrySize * this.menuX + 1, this.entrySize * this.menuY + 1);
        this.container.setSize(size);
        User.tool.setCurrentArcProto((ArcProto)tech.getArcs().next());
        this.panel.repaint();
    }

    private static NodeInst makeNodeInst(NodeProto np, NodeProto.Function func, int angle) {
        NodeInst ni = NodeInst.lowLevelAllocate();
        SizeOffset so = np.getProtoSizeOffset();
        Point2D.Double pt = new Point2D.Double((so.getHighXOffset() - so.getLowXOffset()) / 2.0, (so.getHighYOffset() - so.getLowYOffset()) / 2.0);
        AffineTransform trans = NodeInst.pureRotate(angle, false, false);
        trans.transform(pt, pt);
        ni.lowLevelPopulate(np, pt, np.getDefWidth(), np.getDefHeight(), angle, null);
        np.getTechnology().setPrimitiveFunction(ni, func);
        np.getTechnology().setDefaultOutline(ni);
        return ni;
    }

    public static void placeInstance(Object obj, PalettePanel panel, boolean export) {
        NodeProto np = null;
        NodeInst ni = null;
        String placeText = null;
        String whatToCreate = null;
        if (obj instanceof String) {
            placeText = (String)obj;
            whatToCreate = Variable.betterVariableName(placeText);
            obj = Generic.tech.invisiblePinNode;
        }
        if (obj instanceof NodeProto) {
            Cell cell;
            Cell iconCell;
            np = (NodeProto)obj;
            if (np instanceof Cell && (iconCell = (cell = (Cell)np).iconView()) != null && iconCell != cell) {
                int response = JOptionPane.showConfirmDialog(TopLevel.getCurrentJFrame(), "Don't you really want to place the icon " + iconCell.describe() + "?");
                if (response == 2) {
                    return;
                }
                if (response == 0) {
                    np = iconCell;
                    obj = np;
                }
            }
        } else if (obj instanceof NodeInst) {
            ni = (NodeInst)obj;
            np = ni.getProto();
            whatToCreate = ni.getFunction() + " node";
        }
        if (np != null) {
            EventListener oldListener = WindowFrame.getListener();
            Cursor oldCursor = TopLevel.getCurrentCursor();
            if (whatToCreate != null) {
                System.out.println("Click to create " + whatToCreate);
            } else if (np instanceof Cell) {
                System.out.println("Click to create an instance of cell " + np.describe());
            } else {
                System.out.println("Click to create node " + np.describe());
            }
            EventListener newListener = oldListener;
            if (newListener != null && newListener instanceof PlaceNodeListener) {
                ((PlaceNodeListener)newListener).setParameter(np);
                ((PlaceNodeListener)newListener).makePortWhenCreated(export);
            } else {
                newListener = new PlaceNodeListener(panel, obj, oldListener, oldCursor);
                ((PlaceNodeListener)newListener).makePortWhenCreated(export);
                WindowFrame.setListener(newListener);
            }
            if (placeText != null) {
                ((PlaceNodeListener)newListener).setTextNode(placeText);
            }
            if (panel != null) {
                panel.getFrame().highlightedNode = obj;
            }
            TopLevel.setCurrentCursor(Cursor.getPredefinedCursor(12));
        }
    }

    private static class PlaceNewNode
    extends Job {
        Object toDraw;
        Point2D where;
        Cell cell;
        String varName;
        boolean export;

        protected PlaceNewNode(String description, Object toDraw, Point2D where, Cell cell, String varName, boolean export) {
            super(description, User.tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.toDraw = toDraw;
            this.where = where;
            this.cell = cell;
            this.varName = varName;
            this.export = export;
            this.startJob();
        }

        public boolean doIt() {
            NodeProto np = null;
            NodeInst ni = null;
            if (this.toDraw instanceof NodeProto) {
                np = (NodeProto)this.toDraw;
            } else if (this.toDraw instanceof NodeInst) {
                ni = (NodeInst)this.toDraw;
                np = ni.getProto();
            }
            double width = np.getDefWidth();
            double height = np.getDefHeight();
            if (this.varName != null) {
                height = 0.0;
                width = 0.0;
            }
            int defAngle = 0;
            if (ni != null) {
                defAngle = ni.getAngle();
            } else {
                defAngle = np.getDefPlacementAngle();
                if (defAngle >= 3600) {
                    defAngle %= 3600;
                    width = -width;
                }
            }
            NodeInst newNi = NodeInst.makeInstance(np, this.where, width, height, defAngle, this.cell, null);
            if (newNi == null) {
                return false;
            }
            if (this.varName != null) {
                Variable var = newNi.newVar(this.varName, (Object)"text");
                if (var != null) {
                    var.setDisplay(true);
                    TextDescriptor td = TextDescriptor.getAnnotationTextDescriptor(null);
                    if (!this.varName.equals("ART_message")) {
                        td.setDispPart(TextDescriptor.DispPos.NAMEVALUE);
                    }
                    var.setTextDescriptor(td);
                    Highlight h = Highlight.addText(newNi, this.cell, var, null);
                }
            } else {
                Variable var;
                if (ni != null) {
                    newNi.setTechSpecific(ni.getTechSpecific());
                }
                if (np == Schematics.tech.resistorNode) {
                    var = newNi.newVar(Schematics.SCHEM_RESISTANCE, (Object)"100");
                    var.setDisplay(true);
                    TextDescriptor td = TextDescriptor.getNodeTextDescriptor(null);
                    var.setTextDescriptor(td);
                } else if (np == Schematics.tech.capacitorNode) {
                    var = newNi.newVar(Schematics.SCHEM_CAPACITANCE, (Object)"100M");
                    var.setDisplay(true);
                    TextDescriptor td = TextDescriptor.getNodeTextDescriptor(null);
                    var.setTextDescriptor(td);
                } else if (np == Schematics.tech.inductorNode) {
                    var = newNi.newVar(Schematics.SCHEM_INDUCTANCE, (Object)"100");
                    var.setDisplay(true);
                    TextDescriptor td = TextDescriptor.getNodeTextDescriptor(null);
                    var.setTextDescriptor(td);
                } else if (np == Schematics.tech.diodeNode) {
                    var = newNi.newVar(Schematics.SCHEM_DIODE, (Object)"10");
                    var.setDisplay(true);
                    TextDescriptor td = TextDescriptor.getNodeTextDescriptor(null);
                    var.setTextDescriptor(td);
                } else if (np == Schematics.tech.transistorNode || np == Schematics.tech.transistor4Node) {
                    if (newNi.isFET()) {
                        var = newNi.newVar(Schematics.ATTR_WIDTH, (Object)"2");
                        var.setDisplay(true);
                        TextDescriptor td = TextDescriptor.getNodeTextDescriptor(null);
                        td.setOff(0.5, -1.0);
                        var.setTextDescriptor(td);
                        var = newNi.newVar(Schematics.ATTR_LENGTH, (Object)"2");
                        var.setDisplay(true);
                        td = TextDescriptor.getNodeTextDescriptor(null);
                        td.setOff(-0.5, -1.0);
                        if (td.getSize().isAbsolute()) {
                            td.setAbsSize((int)(td.getSize().getSize() - 2.0));
                        } else {
                            td.setRelSize(td.getSize().getSize() - 0.5);
                        }
                        var.setTextDescriptor(td);
                    } else {
                        var = newNi.newVar(Schematics.ATTR_AREA, (Object)"10");
                        var.setDisplay(true);
                        TextDescriptor td = TextDescriptor.getNodeTextDescriptor(null);
                        var.setTextDescriptor(td);
                    }
                }
                ElectricObject eObj = newNi;
                if (newNi.getNumPortInsts() > 0) {
                    eObj = (ElectricObject)newNi.getPortInsts().next();
                }
                Highlight.addElectricObject(eObj, this.cell);
            }
            Highlight.finished();
            if (this.export) {
                ExportChanges.newExportCommand();
                System.out.println("SHOULD EXPORT IT NOW");
            }
            return true;
        }
    }

    public static class PlaceNodeListener
    implements MouseMotionListener,
    MouseListener,
    MouseWheelListener,
    KeyListener {
        private int oldx;
        private int oldy;
        private Point2D drawnLoc;
        private boolean doingMotionDrag;
        private Object toDraw;
        private EventListener oldListener;
        private Cursor oldCursor;
        private boolean isDrawn;
        private String textNode;
        private PalettePanel window;
        private int defAngle;
        private boolean makePort;

        public PlaceNodeListener(PalettePanel window, Object toDraw, EventListener oldListener, Cursor oldCursor) {
            this.window = window;
            this.toDraw = toDraw;
            this.oldListener = oldListener;
            this.oldCursor = oldCursor;
            this.isDrawn = false;
            this.textNode = null;
            this.makePort = false;
            NodeProto np = null;
            this.defAngle = 0;
            if (toDraw instanceof NodeInst) {
                NodeInst ni = (NodeInst)toDraw;
                np = ni.getProto();
                this.defAngle = ni.getAngle();
            }
            if (toDraw instanceof NodeProto) {
                np = (NodeProto)toDraw;
                this.defAngle = np.getDefPlacementAngle();
            }
            if (window != null) {
                window.addKeyListener(this);
            }
        }

        public void makePortWhenCreated(boolean m) {
            this.makePort = m;
        }

        public void setParameter(Object toDraw) {
            this.toDraw = toDraw;
        }

        public void setTextNode(String varName) {
            this.textNode = varName;
        }

        private void updateBox(Object source, int oldx, int oldy) {
            if (!(source instanceof EditWindow)) {
                return;
            }
            EditWindow wnd = (EditWindow)source;
            if (this.isDrawn) {
                Highlight.clear();
            }
            this.drawnLoc = wnd.screenToDatabase(oldx, oldy);
            EditWindow.gridAlign(this.drawnLoc);
            NodeProto np = null;
            if (this.toDraw instanceof NodeInst) {
                NodeInst ni = (NodeInst)this.toDraw;
                np = ni.getProto();
            }
            if (this.toDraw instanceof NodeProto) {
                np = (NodeProto)this.toDraw;
            }
            if (np != null) {
                Poly poly = null;
                if (np instanceof Cell) {
                    Cell placeCell = (Cell)np;
                    Rectangle2D cellBounds = placeCell.getBounds();
                    SizeOffset so = np.getProtoSizeOffset();
                    poly = new Poly(cellBounds);
                    AffineTransform rotate = NodeInst.pureRotate(this.defAngle % 3600, this.defAngle >= 3600, false);
                    AffineTransform translate = new AffineTransform();
                    translate.setToTranslation(this.drawnLoc.getX(), this.drawnLoc.getY());
                    rotate.concatenate(translate);
                    poly.transform(rotate);
                } else {
                    SizeOffset so = np.getProtoSizeOffset();
                    double trueSizeX = np.getDefWidth() - so.getLowXOffset() - so.getHighXOffset();
                    double trueSizeY = np.getDefHeight() - so.getLowYOffset() - so.getHighYOffset();
                    poly = new Poly(this.drawnLoc.getX(), this.drawnLoc.getY(), trueSizeX, trueSizeY);
                    AffineTransform trans = NodeInst.rotateAbout(this.defAngle % 3600, this.drawnLoc.getX(), this.drawnLoc.getY(), this.defAngle >= 3600 ? -trueSizeX : trueSizeX, trueSizeY);
                    poly.transform(trans);
                }
                Point2D[] points = poly.getPoints();
                for (int i = 0; i < points.length; ++i) {
                    int last = i - 1;
                    if (i == 0) {
                        last = points.length - 1;
                    }
                    Highlight.addLine(points[last], points[i], wnd.getCell());
                }
                this.isDrawn = true;
                wnd.repaint();
            }
            Highlight.finished();
        }

        public void mouseReleased(MouseEvent evt) {
            if (!(evt.getSource() instanceof EditWindow)) {
                return;
            }
            EditWindow wnd = (EditWindow)evt.getSource();
            this.oldx = evt.getX();
            this.oldy = evt.getY();
            if (wnd.getCell() == null) {
                JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "Cannot create node: this window has no cell in it");
                return;
            }
            Point2D where = wnd.screenToDatabase(this.oldx, this.oldy);
            EditWindow.gridAlign(where);
            NodeInst ni = null;
            NodeProto np = null;
            if (this.toDraw instanceof NodeProto) {
                np = (NodeProto)this.toDraw;
            } else if (this.toDraw instanceof NodeInst) {
                ni = (NodeInst)this.toDraw;
                np = ni.getProto();
            }
            String descript = "Create ";
            descript = np instanceof Cell ? descript + ((Cell)np).noLibDescribe() : descript + np.getName() + " Primitive";
            PlaceNewNode job = new PlaceNewNode(descript, this.toDraw, where, wnd.getCell(), this.textNode, this.makePort);
            this.finished();
        }

        public void finished() {
            Highlight.clear();
            Highlight.finished();
            WindowFrame.setListener(this.oldListener);
            TopLevel.setCurrentCursor(this.oldCursor);
            if (this.window != null) {
                this.window.removeKeyListener(this);
                this.window.frame.highlightedNode = null;
                this.window.repaint();
            }
        }

        public void mousePressed(MouseEvent evt) {
        }

        public void mouseClicked(MouseEvent evt) {
        }

        public void mouseEntered(MouseEvent evt) {
        }

        public void mouseExited(MouseEvent evt) {
        }

        public void mouseMoved(MouseEvent evt) {
            this.updateBox(evt.getSource(), evt.getX(), evt.getY());
        }

        public void mouseDragged(MouseEvent evt) {
            this.updateBox(evt.getSource(), evt.getX(), evt.getY());
        }

        public void mouseWheelMoved(MouseWheelEvent evt) {
        }

        public void keyPressed(KeyEvent evt) {
            int chr = evt.getKeyCode();
            if (chr == 65 || chr == 27) {
                this.finished();
            }
        }

        public void keyReleased(KeyEvent evt) {
        }

        public void keyTyped(KeyEvent evt) {
        }
    }

    public static class PalettePanel
    extends JPanel
    implements MouseMotionListener,
    MouseListener,
    MouseWheelListener,
    KeyListener {
        PaletteFrame frame;
        private static final double menuArcLength = 8.0;

        PalettePanel(PaletteFrame frame) {
            this.frame = frame;
            this.addKeyListener(this);
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            this.addMouseWheelListener(this);
        }

        PaletteFrame getFrame() {
            return this.frame;
        }

        public void mousePressed(MouseEvent e) {
            PalettePanel panel = (PalettePanel)e.getSource();
            panel.requestFocus();
            Object obj = this.getObjectUnderCursor(e);
            if (obj instanceof NodeProto || obj instanceof NodeInst) {
                NodeInst ni;
                if (obj == Schematics.tech.diodeNode) {
                    JPopupMenu menu = new JPopupMenu("Diode");
                    JMenuItem menuItem = new JMenuItem("Normal Diode");
                    menu.add(menuItem);
                    menuItem.addActionListener(new PlacePopupListener(panel, Schematics.tech.diodeNode));
                    menuItem = new JMenuItem("Zener Diode");
                    menu.add(menuItem);
                    menuItem.addActionListener(new PlacePopupListener(panel, PaletteFrame.makeNodeInst(Schematics.tech.diodeNode, NodeProto.Function.DIODEZ, 0)));
                    menu.show(panel, e.getX(), e.getY());
                    return;
                }
                if (obj == Schematics.tech.capacitorNode) {
                    JPopupMenu menu = new JPopupMenu("Capacitor");
                    JMenuItem menuItem = new JMenuItem("Normal Capacitor");
                    menu.add(menuItem);
                    menuItem.addActionListener(new PlacePopupListener(panel, Schematics.tech.capacitorNode));
                    menuItem = new JMenuItem("Electrolytic Capacitor");
                    menu.add(menuItem);
                    menuItem.addActionListener(new PlacePopupListener(panel, PaletteFrame.makeNodeInst(Schematics.tech.capacitorNode, NodeProto.Function.ECAPAC, 0)));
                    menu.show(panel, e.getX(), e.getY());
                    return;
                }
                if (obj == Schematics.tech.flipflopNode) {
                    JPopupMenu menu = new JPopupMenu("Flip-flop");
                    JMenuItem menuItem = new JMenuItem("R-S master/slave");
                    menu.add(menuItem);
                    menuItem.addActionListener(new PlacePopupListener(panel, PaletteFrame.makeNodeInst(Schematics.tech.flipflopNode, NodeProto.Function.FLIPFLOPRSMS, 0)));
                    menuItem = new JMenuItem("R-S positive");
                    menu.add(menuItem);
                    menuItem.addActionListener(new PlacePopupListener(panel, PaletteFrame.makeNodeInst(Schematics.tech.flipflopNode, NodeProto.Function.FLIPFLOPRSP, 0)));
                    menuItem = new JMenuItem("R-S negative");
                    menu.add(menuItem);
                    menuItem.addActionListener(new PlacePopupListener(panel, PaletteFrame.makeNodeInst(Schematics.tech.flipflopNode, NodeProto.Function.FLIPFLOPRSN, 0)));
                    menu.addSeparator();
                    menuItem = new JMenuItem("J-K master/slave");
                    menu.add(menuItem);
                    menuItem.addActionListener(new PlacePopupListener(panel, PaletteFrame.makeNodeInst(Schematics.tech.flipflopNode, NodeProto.Function.FLIPFLOPJKMS, 0)));
                    menuItem = new JMenuItem("J-K positive");
                    menu.add(menuItem);
                    menuItem.addActionListener(new PlacePopupListener(panel, PaletteFrame.makeNodeInst(Schematics.tech.flipflopNode, NodeProto.Function.FLIPFLOPJKP, 0)));
                    menuItem = new JMenuItem("J-K negative");
                    menu.add(menuItem);
                    menuItem.addActionListener(new PlacePopupListener(panel, PaletteFrame.makeNodeInst(Schematics.tech.flipflopNode, NodeProto.Function.FLIPFLOPJKN, 0)));
                    menu.addSeparator();
                    menuItem = new JMenuItem("D master/slave");
                    menu.add(menuItem);
                    menuItem.addActionListener(new PlacePopupListener(panel, PaletteFrame.makeNodeInst(Schematics.tech.flipflopNode, NodeProto.Function.FLIPFLOPDMS, 0)));
                    menuItem = new JMenuItem("D positive");
                    menu.add(menuItem);
                    menuItem.addActionListener(new PlacePopupListener(panel, PaletteFrame.makeNodeInst(Schematics.tech.flipflopNode, NodeProto.Function.FLIPFLOPDP, 0)));
                    menuItem = new JMenuItem("D negative");
                    menu.add(menuItem);
                    menuItem.addActionListener(new PlacePopupListener(panel, PaletteFrame.makeNodeInst(Schematics.tech.flipflopNode, NodeProto.Function.FLIPFLOPDN, 0)));
                    menu.addSeparator();
                    menuItem = new JMenuItem("T master/slave");
                    menu.add(menuItem);
                    menuItem.addActionListener(new PlacePopupListener(panel, PaletteFrame.makeNodeInst(Schematics.tech.flipflopNode, NodeProto.Function.FLIPFLOPTMS, 0)));
                    menuItem = new JMenuItem("T positive");
                    menu.add(menuItem);
                    menuItem.addActionListener(new PlacePopupListener(panel, PaletteFrame.makeNodeInst(Schematics.tech.flipflopNode, NodeProto.Function.FLIPFLOPTP, 0)));
                    menuItem = new JMenuItem("T negative");
                    menu.add(menuItem);
                    menuItem.addActionListener(new PlacePopupListener(panel, PaletteFrame.makeNodeInst(Schematics.tech.flipflopNode, NodeProto.Function.FLIPFLOPTN, 0)));
                    menu.show(panel, e.getX(), e.getY());
                    return;
                }
                if (obj instanceof NodeInst && ((NodeInst)obj).getProto() == Schematics.tech.transistor4Node) {
                    JPopupMenu menu = new JPopupMenu("4-Port Transistors");
                    JMenuItem menuItem = new JMenuItem("nMOS 4-port");
                    menu.add(menuItem);
                    menuItem.addActionListener(new PlacePopupListener(panel, PaletteFrame.makeNodeInst(Schematics.tech.transistor4Node, NodeProto.Function.TRA4NMOS, 900)));
                    menuItem = new JMenuItem("PMOS 4-port");
                    menu.add(menuItem);
                    menuItem.addActionListener(new PlacePopupListener(panel, PaletteFrame.makeNodeInst(Schematics.tech.transistor4Node, NodeProto.Function.TRA4PMOS, 900)));
                    menuItem = new JMenuItem("DMOS 4-port");
                    menu.add(menuItem);
                    menuItem.addActionListener(new PlacePopupListener(panel, PaletteFrame.makeNodeInst(Schematics.tech.transistor4Node, NodeProto.Function.TRA4DMOS, 900)));
                    menuItem = new JMenuItem("NPN 4-port");
                    menu.add(menuItem);
                    menuItem.addActionListener(new PlacePopupListener(panel, PaletteFrame.makeNodeInst(Schematics.tech.transistor4Node, NodeProto.Function.TRA4NPN, 900)));
                    menuItem = new JMenuItem("PNP 4-port");
                    menu.add(menuItem);
                    menuItem.addActionListener(new PlacePopupListener(panel, PaletteFrame.makeNodeInst(Schematics.tech.transistor4Node, NodeProto.Function.TRA4PNP, 900)));
                    menuItem = new JMenuItem("DMES 4-port");
                    menu.add(menuItem);
                    menuItem.addActionListener(new PlacePopupListener(panel, PaletteFrame.makeNodeInst(Schematics.tech.transistor4Node, NodeProto.Function.TRA4DMES, 900)));
                    menuItem = new JMenuItem("EMES 4-port");
                    menu.add(menuItem);
                    menuItem.addActionListener(new PlacePopupListener(panel, PaletteFrame.makeNodeInst(Schematics.tech.transistor4Node, NodeProto.Function.TRA4EMES, 900)));
                    menuItem = new JMenuItem("PJFET 4-port");
                    menu.add(menuItem);
                    menuItem.addActionListener(new PlacePopupListener(panel, PaletteFrame.makeNodeInst(Schematics.tech.transistor4Node, NodeProto.Function.TRA4PJFET, 900)));
                    menuItem = new JMenuItem("NJFET 4-port");
                    menu.add(menuItem);
                    menuItem.addActionListener(new PlacePopupListener(panel, PaletteFrame.makeNodeInst(Schematics.tech.transistor4Node, NodeProto.Function.TRA4NJFET, 900)));
                    menu.show(panel, e.getX(), e.getY());
                    return;
                }
                if (obj instanceof NodeInst && ((NodeInst)obj).getProto() == Schematics.tech.transistorNode && (ni = (NodeInst)obj).getFunction() == NodeProto.Function.TRAPNP) {
                    JPopupMenu menu = new JPopupMenu("3-Port Transistors");
                    JMenuItem menuItem = new JMenuItem("nMOS");
                    menu.add(menuItem);
                    menuItem.addActionListener(new PlacePopupListener(panel, PaletteFrame.makeNodeInst(Schematics.tech.transistorNode, NodeProto.Function.TRANMOS, 900)));
                    menuItem = new JMenuItem("PMOS");
                    menu.add(menuItem);
                    menuItem.addActionListener(new PlacePopupListener(panel, PaletteFrame.makeNodeInst(Schematics.tech.transistorNode, NodeProto.Function.TRAPMOS, 900)));
                    menuItem = new JMenuItem("DMOS");
                    menu.add(menuItem);
                    menuItem.addActionListener(new PlacePopupListener(panel, PaletteFrame.makeNodeInst(Schematics.tech.transistorNode, NodeProto.Function.TRADMOS, 900)));
                    menuItem = new JMenuItem("NPN");
                    menu.add(menuItem);
                    menuItem.addActionListener(new PlacePopupListener(panel, PaletteFrame.makeNodeInst(Schematics.tech.transistorNode, NodeProto.Function.TRANPN, 900)));
                    menuItem = new JMenuItem("PNP");
                    menu.add(menuItem);
                    menuItem.addActionListener(new PlacePopupListener(panel, PaletteFrame.makeNodeInst(Schematics.tech.transistorNode, NodeProto.Function.TRAPNP, 900)));
                    menuItem = new JMenuItem("DMES");
                    menu.add(menuItem);
                    menuItem.addActionListener(new PlacePopupListener(panel, PaletteFrame.makeNodeInst(Schematics.tech.transistorNode, NodeProto.Function.TRADMES, 900)));
                    menuItem = new JMenuItem("EMES");
                    menu.add(menuItem);
                    menuItem.addActionListener(new PlacePopupListener(panel, PaletteFrame.makeNodeInst(Schematics.tech.transistorNode, NodeProto.Function.TRAEMES, 900)));
                    menuItem = new JMenuItem("PJFET");
                    menu.add(menuItem);
                    menuItem.addActionListener(new PlacePopupListener(panel, PaletteFrame.makeNodeInst(Schematics.tech.transistorNode, NodeProto.Function.TRAPJFET, 900)));
                    menuItem = new JMenuItem("NJFET");
                    menu.add(menuItem);
                    menuItem.addActionListener(new PlacePopupListener(panel, PaletteFrame.makeNodeInst(Schematics.tech.transistorNode, NodeProto.Function.TRANJFET, 900)));
                    menu.show(panel, e.getX(), e.getY());
                    return;
                }
                PaletteFrame.placeInstance(obj, panel, false);
            } else if (obj instanceof PrimitiveArc) {
                PrimitiveArc ap = (PrimitiveArc)obj;
                User.tool.setCurrentArcProto(ap);
            } else if (obj instanceof String) {
                JMenuItem menuItem;
                JPopupMenu specialMenu;
                JPopupMenu cellMenu;
                String msg = (String)obj;
                if (msg.equals("Cell")) {
                    cellMenu = new JPopupMenu("Cells");
                    List sortedCells = Library.getCurrent().getCellsSortedByName();
                    Iterator it = sortedCells.iterator();
                    while (it.hasNext()) {
                        Cell cell = (Cell)it.next();
                        JMenuItem menuItem2 = new JMenuItem(cell.describe());
                        menuItem2.addActionListener(new PlacePopupListener(panel, cell));
                        cellMenu.add(menuItem2);
                    }
                    cellMenu.show(panel, e.getX(), e.getY());
                } else if (msg.equals("Misc.")) {
                    specialMenu = new JPopupMenu("Miscellaneous");
                    menuItem = new JMenuItem("Cell Instance...");
                    menuItem.addActionListener(new ActionListener(this){
                        private final /* synthetic */ PalettePanel this$0;
                        {
                            this.this$0 = this$0;
                        }

                        public void actionPerformed(ActionEvent e) {
                            CellMenu.cellBrowserCommand(CellBrowser.DoAction.newInstance);
                        }
                    });
                    specialMenu.add(menuItem);
                    specialMenu.addSeparator();
                    menuItem = new JMenuItem("Annotation Text");
                    menuItem.addActionListener(new PlacePopupListener(panel, "ART_message"));
                    specialMenu.add(menuItem);
                    menuItem = new JMenuItem("Layout Text...");
                    menuItem.addActionListener(new ActionListener(this){
                        private final /* synthetic */ PalettePanel this$0;
                        {
                            this.this$0 = this$0;
                        }

                        public void actionPerformed(ActionEvent e) {
                            this.this$0.makeLayoutTextCommand();
                        }
                    });
                    specialMenu.add(menuItem);
                    menuItem = new JMenuItem("Annular Ring...");
                    menuItem.addActionListener(new ActionListener(this){
                        private final /* synthetic */ PalettePanel this$0;
                        {
                            this.this$0 = this$0;
                        }

                        public void actionPerformed(ActionEvent e) {
                            AnnularRing.showAnnularRingDialog();
                        }
                    });
                    specialMenu.add(menuItem);
                    specialMenu.addSeparator();
                    menuItem = new JMenuItem("Cell Center");
                    menuItem.addActionListener(new PlacePopupListener(panel, Generic.tech.cellCenterNode));
                    specialMenu.add(menuItem);
                    menuItem = new JMenuItem("Essential Bounds");
                    menuItem.addActionListener(new PlacePopupListener(panel, Generic.tech.essentialBoundsNode));
                    specialMenu.add(menuItem);
                    specialMenu.addSeparator();
                    menuItem = new JMenuItem("Spice Code");
                    menuItem.addActionListener(new PlacePopupListener(panel, "SIM_spice_card"));
                    specialMenu.add(menuItem);
                    menuItem = new JMenuItem("Verilog Code");
                    menuItem.addActionListener(new PlacePopupListener(panel, "VERILOG_code"));
                    specialMenu.add(menuItem);
                    menuItem = new JMenuItem("Verilog Declaration");
                    menuItem.addActionListener(new PlacePopupListener(panel, "VERILOG_declaration"));
                    specialMenu.add(menuItem);
                    menuItem = new JMenuItem("Simulation Probe");
                    menuItem.addActionListener(new PlacePopupListener(panel, Generic.tech.simProbeNode));
                    specialMenu.add(menuItem);
                    menuItem = new JMenuItem("DRC Exclusion");
                    menuItem.addActionListener(new PlacePopupListener(panel, Generic.tech.drcNode));
                    specialMenu.add(menuItem);
                    specialMenu.addSeparator();
                    menuItem = new JMenuItem("Invisible Pin");
                    menuItem.addActionListener(new PlacePopupListener(panel, Generic.tech.invisiblePinNode));
                    specialMenu.add(menuItem);
                    menuItem = new JMenuItem("Universal Pin");
                    menuItem.addActionListener(new PlacePopupListener(panel, Generic.tech.universalPinNode));
                    specialMenu.add(menuItem);
                    menuItem = new JMenuItem("Unrouted Pin");
                    menuItem.addActionListener(new PlacePopupListener(panel, Generic.tech.unroutedPinNode));
                    specialMenu.add(menuItem);
                    specialMenu.show(panel, e.getX(), e.getY());
                } else if (msg.equals("Pure")) {
                    JPopupMenu pureMenu = new JPopupMenu("Pure");
                    Iterator it = Technology.getCurrent().getNodes();
                    while (it.hasNext()) {
                        PrimitiveNode np = (PrimitiveNode)it.next();
                        if (np.isNotUsed() || np.getFunction() != NodeProto.Function.NODE) continue;
                        JMenuItem menuItem3 = new JMenuItem(np.describe());
                        menuItem3.addActionListener(new PlacePopupListener(panel, np));
                        pureMenu.add(menuItem3);
                    }
                    pureMenu.show(panel, e.getX(), e.getY());
                }
                if (msg.equals("Spice")) {
                    cellMenu = new JPopupMenu("Spice");
                    String currentSpiceLib = Simulation.getSpicePartsLibrary();
                    Library spiceLib = Library.findLibrary(currentSpiceLib);
                    if (spiceLib == null) {
                        URL fileURL = LibFile.getLibFile(currentSpiceLib + ".txt");
                        ReadSpiceLibrary job = new ReadSpiceLibrary(fileURL, cellMenu, panel, e.getX(), e.getY());
                    } else {
                        Iterator it = spiceLib.getCells();
                        while (it.hasNext()) {
                            Cell cell = (Cell)it.next();
                            JMenuItem menuItem4 = new JMenuItem(cell.getName());
                            menuItem4.addActionListener(new PlacePopupListener(panel, cell));
                            cellMenu.add(menuItem4);
                        }
                        cellMenu.show(panel, e.getX(), e.getY());
                    }
                }
                if (msg.equals("Export")) {
                    specialMenu = new JPopupMenu("Export");
                    menuItem = new JMenuItem("Wire");
                    menuItem.addActionListener(new ActionListener(this){
                        private final /* synthetic */ PalettePanel this$0;
                        {
                            this.this$0 = this$0;
                        }

                        public void actionPerformed(ActionEvent e) {
                            PalettePanel.access$200(this.this$0, "wire");
                        }
                    });
                    specialMenu.add(menuItem);
                    menuItem = new JMenuItem("Bus");
                    menuItem.addActionListener(new ActionListener(this){
                        private final /* synthetic */ PalettePanel this$0;
                        {
                            this.this$0 = this$0;
                        }

                        public void actionPerformed(ActionEvent e) {
                            PalettePanel.access$200(this.this$0, "bus");
                        }
                    });
                    specialMenu.add(menuItem);
                    menuItem = new JMenuItem("Universal");
                    menuItem.addActionListener(new ActionListener(this){
                        private final /* synthetic */ PalettePanel this$0;
                        {
                            this.this$0 = this$0;
                        }

                        public void actionPerformed(ActionEvent e) {
                            PalettePanel.access$200(this.this$0, "universal");
                        }
                    });
                    specialMenu.add(menuItem);
                    specialMenu.show(panel, e.getX(), e.getY());
                }
                if (msg.equals("Text")) {
                    PaletteFrame.placeInstance("ART_message", panel, false);
                }
            }
            this.repaint();
        }

        private void makeExport(String type) {
            if (type.equals("wire")) {
                PaletteFrame.placeInstance(Schematics.tech.wirePinNode, this, true);
            } else if (type.equals("bus")) {
                PaletteFrame.placeInstance(Schematics.tech.busPinNode, this, true);
            } else if (type.equals("universal")) {
                PaletteFrame.placeInstance(Generic.tech.invisiblePinNode, this, true);
            }
        }

        public void makeLayoutTextCommand() {
            LayoutText dialog = new LayoutText((Frame)TopLevel.getCurrentJFrame(), true);
            dialog.show();
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void keyPressed(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
        }

        public void keyTyped(KeyEvent e) {
        }

        public void mouseDragged(MouseEvent e) {
        }

        private Object getObjectUnderCursor(MouseEvent e) {
            int index;
            PalettePanel panel = (PalettePanel)e.getSource();
            int x = e.getX() / (panel.frame.entrySize + 1);
            int y = panel.frame.menuY - e.getY() / (panel.frame.entrySize + 1) - 1;
            if (y < 0) {
                y = 0;
            }
            if ((index = x * this.frame.menuY + y) < 0 || index >= panel.frame.inPalette.size()) {
                return null;
            }
            Object obj = panel.frame.inPalette.get(index);
            return obj;
        }

        public void mouseMoved(MouseEvent e) {
            Object obj = this.getObjectUnderCursor(e);
            if (obj instanceof NodeProto || obj instanceof NodeInst) {
                NodeProto np = null;
                np = obj instanceof NodeProto ? (NodeProto)obj : ((NodeInst)obj).getProto();
                StatusBar.setSelectionOverride("CREATE NODE: " + np.describe());
            } else if (obj instanceof PrimitiveArc) {
                PrimitiveArc ap = (PrimitiveArc)obj;
                StatusBar.setSelectionOverride("USE ARC: " + ap.describe());
            } else if (obj instanceof String) {
                StatusBar.setSelectionOverride(null);
            }
        }

        public void mouseExited(MouseEvent e) {
            StatusBar.setSelectionOverride(null);
        }

        public void mouseWheelMoved(MouseWheelEvent e) {
        }

        public void paint(Graphics g) {
            int i;
            if (this.frame.menuX < 0 || this.frame.menuY < 0) {
                return;
            }
            Dimension size = this.getSize();
            int wid = (int)size.getWidth();
            int hei = (int)size.getHeight();
            g.clearRect(0, 0, wid, hei);
            this.frame.entrySize = Math.min(wid / this.frame.menuX - 1, hei / this.frame.menuY - 1);
            EditWindow w = EditWindow.CreateElectricDoc(null, null);
            w.setScreenSize(new Dimension(this.frame.entrySize, this.frame.entrySize));
            for (int x = 0; x < this.frame.menuX; ++x) {
                for (int y = 0; y < this.frame.menuY; ++y) {
                    int index = x * this.frame.menuY + y;
                    if (index >= this.frame.inPalette.size()) continue;
                    Object toDraw = this.frame.inPalette.get(index);
                    Image img = this.drawMenuEntry(w, toDraw);
                    int imgX = x * (this.frame.entrySize + 1) + 1;
                    int imgY = (this.frame.menuY - y - 1) * (this.frame.entrySize + 1) + 1;
                    if (img != null) {
                        g.drawImage(img, imgX, imgY, this);
                    }
                    if (toDraw instanceof PrimitiveArc) {
                        g.setColor(Color.RED);
                        g.drawRect(imgX, imgY, this.frame.entrySize - 1, this.frame.entrySize - 1);
                        if (toDraw == User.tool.getCurrentArcProto()) {
                            g.drawRect(imgX + 1, imgY + 1, this.frame.entrySize - 3, this.frame.entrySize - 3);
                            g.drawRect(imgX + 2, imgY + 2, this.frame.entrySize - 5, this.frame.entrySize - 5);
                        }
                    }
                    if (toDraw instanceof NodeProto || toDraw instanceof NodeInst) {
                        NodeInst ni;
                        g.setColor(Color.BLUE);
                        g.drawRect(imgX, imgY, this.frame.entrySize - 1, this.frame.entrySize - 1);
                        NodeProto np = null;
                        np = toDraw instanceof NodeProto ? (NodeProto)toDraw : ((NodeInst)toDraw).getProto();
                        if (toDraw == this.frame.highlightedNode) {
                            g.drawRect(imgX + 1, imgY + 1, this.frame.entrySize - 3, this.frame.entrySize - 3);
                            g.drawRect(imgX + 2, imgY + 2, this.frame.entrySize - 5, this.frame.entrySize - 5);
                        }
                        boolean drawArrow = false;
                        if (toDraw == Schematics.tech.diodeNode || toDraw == Schematics.tech.capacitorNode || toDraw == Schematics.tech.flipflopNode) {
                            drawArrow = true;
                        }
                        if (toDraw instanceof NodeInst && ((ni = (NodeInst)toDraw).getFunction() == NodeProto.Function.TRAPNP || ni.getFunction() == NodeProto.Function.TRA4PNP)) {
                            drawArrow = true;
                        }
                        if (drawArrow) {
                            this.drawArrow(g, x, y);
                        }
                    }
                    if (!(toDraw instanceof String)) continue;
                    String str = (String)toDraw;
                    g.setColor(new Color(User.getColorBackground()));
                    g.fillRect(imgX, imgY, this.frame.entrySize, this.frame.entrySize);
                    g.setColor(new Color(User.getColorText()));
                    g.setFont(new Font("Helvetica", 0, 20));
                    FontMetrics fm = g.getFontMetrics();
                    int strWid = fm.stringWidth(str);
                    int strHeight = fm.getMaxAscent() + fm.getMaxDescent();
                    int xpos = imgX + this.frame.entrySize / 2 - strWid / 2;
                    int ypos = imgY + this.frame.entrySize / 2 + strHeight / 2 - fm.getMaxDescent();
                    g.drawString(str, xpos, ypos);
                    if (!str.equals("Cell") && !str.equals("Spice") && !str.equals("Misc.") && !str.equals("Pure")) continue;
                    this.drawArrow(g, x, y);
                }
            }
            g.setColor(Color.BLACK);
            for (i = 0; i <= this.frame.menuX; ++i) {
                int xPos = (this.frame.entrySize + 1) * i;
                g.drawLine(xPos, 0, xPos, this.frame.menuY * (this.frame.entrySize + 1));
            }
            for (i = 0; i <= this.frame.menuY; ++i) {
                int yPos = (this.frame.entrySize + 1) * i;
                g.drawLine(0, yPos, this.frame.menuX * (this.frame.entrySize + 1), yPos);
            }
        }

        private void drawArrow(Graphics g, int x, int y) {
            int imgX = x * (this.frame.entrySize + 1) + 1;
            int imgY = (this.frame.menuY - y - 1) * (this.frame.entrySize + 1) + 1;
            int[] arrowX = new int[3];
            int[] arrowY = new int[3];
            arrowX[0] = imgX - 2 + this.frame.entrySize * 7 / 8;
            arrowY[0] = imgY - 2 + this.frame.entrySize;
            arrowX[1] = imgX - 2 + this.frame.entrySize;
            arrowY[1] = imgY - 2 + this.frame.entrySize * 7 / 8;
            arrowX[2] = imgX - 2 + this.frame.entrySize * 7 / 8;
            arrowY[2] = imgY - 2 + this.frame.entrySize * 3 / 4;
            g.setColor(Color.BLACK);
            g.fillPolygon(arrowX, arrowY, 3);
        }

        Image drawNodeInMenu(EditWindow wnd, NodeInst ni) {
            NodeProto np = ni.getProto();
            double largest = 0.0;
            NodeProto.Function groupFunction = np.getGroupFunction();
            Iterator it = np.getTechnology().getNodes();
            while (it.hasNext()) {
                PrimitiveNode otherNp = (PrimitiveNode)it.next();
                if (otherNp.getGroupFunction() != groupFunction) continue;
                if (otherNp.getDefHeight() > largest) {
                    largest = otherNp.getDefHeight();
                }
                if (!(otherNp.getDefWidth() > largest)) continue;
                largest = otherNp.getDefWidth();
            }
            if (groupFunction == NodeProto.Function.PIN) {
                largest = 0.0;
                it = np.getTechnology().getArcs();
                while (it.hasNext()) {
                    PrimitiveArc otherAp = (PrimitiveArc)it.next();
                    double wid = otherAp.getDefaultWidth();
                    if (!(wid + 8.0 > largest)) continue;
                    largest = wid + 8.0;
                }
            }
            double scalex = (double)this.frame.entrySize / largest * 0.8;
            double scaley = (double)this.frame.entrySize / largest * 0.8;
            double scale = Math.min(scalex, scaley);
            return wnd.renderNode(ni, scale);
        }

        Image drawMenuEntry(EditWindow wnd, Object entry) {
            if (entry instanceof NodeInst) {
                NodeInst ni = (NodeInst)entry;
                return this.drawNodeInMenu(wnd, ni);
            }
            if (entry instanceof NodeProto) {
                NodeProto np = (NodeProto)entry;
                NodeInst ni = NodeInst.makeDummyInstance(np);
                return this.drawNodeInMenu(wnd, ni);
            }
            if (entry instanceof PrimitiveArc) {
                PrimitiveArc ap = (PrimitiveArc)entry;
                ArcInst ai = ArcInst.makeDummyInstance(ap, 8.0);
                double largest = 0.0;
                Iterator it = ap.getTechnology().getArcs();
                while (it.hasNext()) {
                    PrimitiveArc otherAp = (PrimitiveArc)it.next();
                    double wid = otherAp.getDefaultWidth();
                    if (!(wid + 8.0 > largest)) continue;
                    largest = wid + 8.0;
                }
                double scalex = (double)this.frame.entrySize / largest * 0.8;
                double scaley = (double)this.frame.entrySize / largest * 0.8;
                double scale = Math.min(scalex, scaley);
                return wnd.renderArc(ai, scale);
            }
            return null;
        }

        static /* synthetic */ void access$200(PalettePanel x0, String x1) {
            x0.makeExport(x1);
        }

        static class PlacePopupListener
        implements ActionListener {
            PalettePanel panel;
            Object obj;

            PlacePopupListener(PalettePanel panel, Object obj) {
                this.panel = panel;
                this.obj = obj;
            }

            public void actionPerformed(ActionEvent evt) {
                JMenuItem mi = (JMenuItem)evt.getSource();
                String msg = mi.getText();
                PaletteFrame.placeInstance(this.obj, this.panel, false);
            }
        }

        private static class ReadSpiceLibrary
        extends Job {
            URL fileURL;
            JPopupMenu cellMenu;
            PalettePanel panel;
            int x;
            int y;

            protected ReadSpiceLibrary(URL fileURL, JPopupMenu cellMenu, PalettePanel panel, int x, int y) {
                super("Read Spice Library", User.tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
                this.fileURL = fileURL;
                this.cellMenu = cellMenu;
                this.panel = panel;
                this.x = x;
                this.y = y;
                this.startJob();
            }

            public boolean doIt() {
                Library lib = Input.readLibrary(this.fileURL, OpenFile.Type.READABLEDUMP);
                Undo.noUndoAllowed();
                if (lib == null) {
                    return false;
                }
                Iterator it = lib.getCells();
                while (it.hasNext()) {
                    Cell cell = (Cell)it.next();
                    JMenuItem menuItem = new JMenuItem(cell.getName());
                    menuItem.addActionListener(new PlacePopupListener(this.panel, cell));
                    this.cellMenu.add(menuItem);
                }
                this.cellMenu.show(this.panel, this.x, this.y);
                return true;
            }
        }
    }

    private static class TechnologyPopupActionListener
    implements ActionListener {
        PaletteFrame palette;

        TechnologyPopupActionListener(PaletteFrame palette) {
            this.palette = palette;
        }

        public void actionPerformed(ActionEvent evt) {
            String techName = (String)this.palette.selector.getSelectedItem();
            Technology tech = Technology.findTechnology(techName);
            if (tech != null) {
                tech.setCurrent();
                this.palette.loadForTechnology();
            }
        }
    }
}

