/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs.options;

import com.sun.electric.database.geometry.GenMath;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.technology.Layer;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.options.PreferencePanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ThreeDTab
extends PreferencePanel {
    private boolean initial3DPerspective;
    private boolean initial3DTextChanging = false;
    private JList threeDLayerList;
    private DefaultListModel threeDLayerModel;
    private HashMap threeDThicknessMap;
    private HashMap threeDHeightMap;
    private JPanel threeDSideView;
    private JLabel jLabel45;
    private JLabel jLabel47;
    private JPanel threeD;
    private JTextField threeDHeight;
    private JScrollPane threeDLayerPane;
    private JCheckBox threeDPerspective;
    private JLabel threeDTechnology;
    private JTextField threeDThickness;

    public ThreeDTab(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    public JPanel getPanel() {
        return this.threeD;
    }

    public String getName() {
        return "3D";
    }

    public void init() {
        this.threeDTechnology.setText("Layer heights for technology " + this.curTech.getTechName());
        this.threeDLayerModel = new DefaultListModel();
        this.threeDLayerList = new JList(this.threeDLayerModel);
        this.threeDLayerList.setSelectionMode(0);
        this.threeDLayerPane.setViewportView(this.threeDLayerList);
        this.threeDLayerList.clearSelection();
        this.threeDLayerList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                ThreeDTab.this.threeDClickedLayer();
            }
        });
        this.threeDThicknessMap = new HashMap();
        this.threeDHeightMap = new HashMap();
        Iterator it = this.curTech.getLayers();
        while (it.hasNext()) {
            Layer layer = (Layer)it.next();
            if ((layer.getFunctionExtras() & 0x1000) != 0) continue;
            this.threeDLayerModel.addElement(layer.getName());
            this.threeDThicknessMap.put(layer, new GenMath.MutableDouble(layer.getThickness()));
            this.threeDHeightMap.put(layer, new GenMath.MutableDouble(layer.getHeight()));
        }
        this.threeDLayerList.setSelectedIndex(0);
        this.threeDHeight.getDocument().addDocumentListener(new ThreeDInfoDocumentListener(this));
        this.threeDThickness.getDocument().addDocumentListener(new ThreeDInfoDocumentListener(this));
        this.threeDSideView = new ThreeDSideView(this);
        this.threeDSideView.setMinimumSize(new Dimension(200, 450));
        this.threeDSideView.setPreferredSize(new Dimension(200, 450));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.gridwidth = 2;
        gbc.gridheight = 4;
        gbc.weightx = 0.5;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(4, 4, 4, 4);
        this.threeD.add((Component)this.threeDSideView, gbc);
        this.threeDClickedLayer();
        this.initial3DPerspective = User.is3DPerspective();
        this.threeDPerspective.setSelected(this.initial3DPerspective);
        this.threeDPerspective.setEnabled(false);
    }

    private void threeDValuesChanged() {
        if (this.initial3DTextChanging) {
            return;
        }
        String layerName = (String)this.threeDLayerList.getSelectedValue();
        Layer layer = this.curTech.findLayer(layerName);
        if (layer == null) {
            return;
        }
        GenMath.MutableDouble thickness = (GenMath.MutableDouble)this.threeDThicknessMap.get(layer);
        GenMath.MutableDouble height = (GenMath.MutableDouble)this.threeDHeightMap.get(layer);
        thickness.setValue(TextUtils.atof(this.threeDThickness.getText()));
        height.setValue(TextUtils.atof(this.threeDHeight.getText()));
        this.threeDSideView.repaint();
    }

    private void threeDClickedLayer() {
        this.initial3DTextChanging = true;
        String layerName = (String)this.threeDLayerList.getSelectedValue();
        Layer layer = this.curTech.findLayer(layerName);
        if (layer == null) {
            return;
        }
        GenMath.MutableDouble thickness = (GenMath.MutableDouble)this.threeDThicknessMap.get(layer);
        GenMath.MutableDouble height = (GenMath.MutableDouble)this.threeDHeightMap.get(layer);
        this.threeDHeight.setText(TextUtils.formatDouble(height.doubleValue()));
        this.threeDThickness.setText(TextUtils.formatDouble(thickness.doubleValue()));
        this.initial3DTextChanging = false;
        this.threeDSideView.repaint();
    }

    public void term() {
        Iterator it = this.curTech.getLayers();
        while (it.hasNext()) {
            Layer layer = (Layer)it.next();
            if ((layer.getFunctionExtras() & 0x1000) != 0) continue;
            GenMath.MutableDouble thickness = (GenMath.MutableDouble)this.threeDThicknessMap.get(layer);
            GenMath.MutableDouble height = (GenMath.MutableDouble)this.threeDHeightMap.get(layer);
            if (thickness.doubleValue() != layer.getThickness()) {
                layer.setThickness(thickness.doubleValue());
            }
            if (height.doubleValue() == layer.getHeight()) continue;
            layer.setHeight(height.doubleValue());
        }
        boolean currentPerspective = this.threeDPerspective.isSelected();
        if (currentPerspective != this.initial3DPerspective) {
            User.set3DPerspective(currentPerspective);
        }
    }

    private void initComponents() {
        this.threeD = new JPanel();
        this.threeDTechnology = new JLabel();
        this.threeDLayerPane = new JScrollPane();
        this.jLabel45 = new JLabel();
        this.jLabel47 = new JLabel();
        this.threeDThickness = new JTextField();
        this.threeDHeight = new JTextField();
        this.threeDPerspective = new JCheckBox();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Edit Options");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                ThreeDTab.this.closeDialog(evt);
            }
        });
        this.threeD.setLayout(new GridBagLayout());
        this.threeDTechnology.setText("Layer heights for technology:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.threeD.add((Component)this.threeDTechnology, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.threeD.add((Component)this.threeDLayerPane, gridBagConstraints);
        this.jLabel45.setText("Thickness:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.threeD.add((Component)this.jLabel45, gridBagConstraints);
        this.jLabel47.setText("Height:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.threeD.add((Component)this.jLabel47, gridBagConstraints);
        this.threeDThickness.setColumns(6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.threeD.add((Component)this.threeDThickness, gridBagConstraints);
        this.threeDHeight.setColumns(6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.threeD.add((Component)this.threeDHeight, gridBagConstraints);
        this.threeDPerspective.setText("Use Perspective");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.threeD.add((Component)this.threeDPerspective, gridBagConstraints);
        this.getContentPane().add((Component)this.threeD, new GridBagConstraints());
        this.pack();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private static class ThreeDInfoDocumentListener
    implements DocumentListener {
        ThreeDTab dialog;

        ThreeDInfoDocumentListener(ThreeDTab dialog) {
            this.dialog = dialog;
        }

        public void changedUpdate(DocumentEvent e) {
            this.dialog.threeDValuesChanged();
        }

        public void insertUpdate(DocumentEvent e) {
            this.dialog.threeDValuesChanged();
        }

        public void removeUpdate(DocumentEvent e) {
            this.dialog.threeDValuesChanged();
        }
    }

    private class ThreeDSideView
    extends JPanel
    implements MouseMotionListener,
    MouseListener {
        ThreeDTab dialog;
        double lowHeight;
        double highHeight;

        ThreeDSideView(ThreeDTab dialog) {
            this.dialog = dialog;
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            boolean first = true;
            Iterator it = dialog.curTech.getLayers();
            while (it.hasNext()) {
                Layer layer = (Layer)it.next();
                if ((layer.getFunctionExtras() & 0x1000) != 0) continue;
                GenMath.MutableDouble thickness = (GenMath.MutableDouble)dialog.threeDThicknessMap.get(layer);
                GenMath.MutableDouble height = (GenMath.MutableDouble)dialog.threeDHeightMap.get(layer);
                if (first) {
                    this.lowHeight = height.doubleValue() - thickness.doubleValue() / 2.0;
                    this.highHeight = height.doubleValue() + thickness.doubleValue() / 2.0;
                    first = false;
                    continue;
                }
                if (height.doubleValue() - thickness.doubleValue() / 2.0 < this.lowHeight) {
                    this.lowHeight = height.doubleValue() - thickness.doubleValue() / 2.0;
                }
                if (!(height.doubleValue() + thickness.doubleValue() / 2.0 > this.highHeight)) continue;
                this.highHeight = height.doubleValue() + thickness.doubleValue() / 2.0;
            }
            this.lowHeight -= 4.0;
            this.highHeight += 4.0;
        }

        public void paint(Graphics g) {
            Dimension dim = this.getSize();
            g.setColor(Color.WHITE);
            g.fillRect(0, 0, dim.width, dim.height);
            g.setColor(Color.BLACK);
            g.drawLine(0, 0, 0, dim.height - 1);
            g.drawLine(0, dim.height - 1, dim.width - 1, dim.height - 1);
            g.drawLine(dim.width - 1, dim.height - 1, dim.width - 1, 0);
            g.drawLine(dim.width - 1, 0, 0, 0);
            String layerName = (String)this.dialog.threeDLayerList.getSelectedValue();
            Layer selectedLayer = this.dialog.curTech.findLayer(layerName);
            Iterator it = this.dialog.curTech.getLayers();
            while (it.hasNext()) {
                Layer layer = (Layer)it.next();
                if ((layer.getFunctionExtras() & 0x1000) != 0) continue;
                if (layer == selectedLayer) {
                    g.setColor(Color.RED);
                } else {
                    g.setColor(Color.BLACK);
                }
                GenMath.MutableDouble thickness = (GenMath.MutableDouble)this.dialog.threeDThicknessMap.get(layer);
                GenMath.MutableDouble height = (GenMath.MutableDouble)this.dialog.threeDHeightMap.get(layer);
                int yValue = dim.height - (int)((height.doubleValue() - this.lowHeight) / (this.highHeight - this.lowHeight) * (double)dim.height + 0.5);
                int yHeight = (int)(thickness.doubleValue() / (this.highHeight - this.lowHeight) * (double)dim.height + 0.5);
                if (yHeight == 0) {
                    g.drawLine(0, yValue, dim.width / 3, yValue);
                } else {
                    int firstPart = dim.width / 6;
                    int pointPos = dim.width / 4;
                    g.drawLine(0, yValue - (yHeight -= 4) / 2, firstPart, yValue - yHeight / 2);
                    g.drawLine(0, yValue + yHeight / 2, firstPart, yValue + yHeight / 2);
                    g.drawLine(firstPart, yValue - yHeight / 2, pointPos, yValue);
                    g.drawLine(firstPart, yValue + yHeight / 2, pointPos, yValue);
                    g.drawLine(pointPos, yValue, dim.width / 3, yValue);
                }
                String string = layer.getName();
                Font font = new Font(User.getDefaultFont(), 0, 9);
                g.setFont(font);
                FontRenderContext frc = new FontRenderContext(null, true, true);
                GlyphVector gv = font.createGlyphVector(frc, string);
                LineMetrics lm = font.getLineMetrics(string, frc);
                Rectangle rect = gv.getOutline(0.0f, lm.getAscent() - lm.getLeading()).getBounds();
                double txtWidth = rect.width;
                double txtHeight = lm.getHeight();
                Graphics2D g2 = (Graphics2D)g;
                g2.drawGlyphVector(gv, dim.width / 3 + 1, (float)((double)yValue + txtHeight / 2.0) - lm.getDescent());
            }
        }

        public void mousePressed(MouseEvent evt) {
            Dimension dim = this.getSize();
            String layerName = (String)this.dialog.threeDLayerList.getSelectedValue();
            Layer selectedLayer = this.dialog.curTech.findLayer(layerName);
            GenMath.MutableDouble height = (GenMath.MutableDouble)this.dialog.threeDHeightMap.get(selectedLayer);
            int yValue = dim.height - (int)((height.doubleValue() - this.lowHeight) / (this.highHeight - this.lowHeight) * (double)dim.height + 0.5);
            if (Math.abs(yValue - evt.getY()) > 5) {
                int bestDist = dim.height;
                Iterator it = this.dialog.curTech.getLayers();
                while (it.hasNext()) {
                    int dist;
                    Layer layer = (Layer)it.next();
                    if ((layer.getFunctionExtras() & 0x1000) != 0 || (dist = Math.abs((yValue = dim.height - (int)(((height = (GenMath.MutableDouble)this.dialog.threeDHeightMap.get(layer)).doubleValue() - this.lowHeight) / (this.highHeight - this.lowHeight) * (double)dim.height + 0.5)) - evt.getY())) >= bestDist) continue;
                    bestDist = dist;
                    selectedLayer = layer;
                }
                this.dialog.threeDLayerList.setSelectedValue(selectedLayer.getName(), true);
                this.dialog.threeDClickedLayer();
            }
        }

        public void mouseReleased(MouseEvent evt) {
        }

        public void mouseClicked(MouseEvent evt) {
        }

        public void mouseEntered(MouseEvent evt) {
        }

        public void mouseExited(MouseEvent evt) {
        }

        public void mouseMoved(MouseEvent evt) {
        }

        public void mouseDragged(MouseEvent evt) {
            Dimension dim = this.getSize();
            String layerName = (String)this.dialog.threeDLayerList.getSelectedValue();
            Layer layer = this.dialog.curTech.findLayer(layerName);
            GenMath.MutableDouble height = (GenMath.MutableDouble)ThreeDTab.this.threeDHeightMap.get(layer);
            double newHeight = (double)(dim.height - evt.getY()) / (double)dim.height * (this.highHeight - this.lowHeight) + this.lowHeight;
            if (height.doubleValue() != newHeight) {
                height.setValue(newHeight);
                this.dialog.threeDHeight.setText(TextUtils.formatDouble(newHeight));
                this.repaint();
            }
        }
    }
}

