#!BPY
""" Released under the Blender Artistic Licence (BAL)
Name: 'Displace Verts'
Blender: 248
Group: 'Misc'
Tooltip: 'Displaces selected verts only.'
"""
__author__ = "pat"
__version__ = "1.0a - 01/10/05 -"
__email__ = ('Author, pat:psycho3d*de')
__url__ = ('http;//www.psycho3d.de', 'http://wiki.blender.org/index.php/Scripts/Manual/Mesh/Displace_Verts')
__bpydoc__ ="""\
This script displaces the selected verts only. It should be called from EditMode.
"""
# -------------------------------------------------------------------------- 
# Displace Verts_248 By pat:psycho3d
# -------------------------------------------------------------------------- 
# Originally Released under the Blender Artistic Licence (BAL)
# ***** BEGIN GPL LICENSE BLOCK ***** 
# 
# This program is free software; you can redistribute it and/or 
# modify it under the terms of the GNU General Public License 
# as published by the Free Software Foundation; either version 2 
# of the License, or (at your option) any later version. 
# 
# This program is distributed in the hope that it will be useful, 
# but WITHOUT ANY WARRANTY; without even the implied warranty of 
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
# GNU General Public License for more details. 
# 
# You should have received a copy of the GNU General Public License 
# along with this program; if not, write to the Free Software Foundation, 
# Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. 
# 
# ***** END GPL LICENCE BLOCK ***** 
# -------------------------------------------------------------------------- 
import Blender
from Blender.Draw import *
from Blender.BGL import *
from random import randint

### config ###
master = Create(0.)
displaceX = Create(0.)
displaceY = Create(0.)
displaceZ = Create(0.)

def displace():
	ob=Blender.Object.GetSelected()[0]
	Blender.Window.EditMode(0)
	me = ob.getData()
	for vert in me.verts:
	   if (vert.sel == 1):
	      vert.co[0] += randint(-1000,1000)/1000. * displaceX.val
	      vert.co[1] += randint(-1000,1000)/1000. * displaceY.val
	      vert.co[2] += randint(-1000,1000)/1000. * displaceZ.val
	me.update()
	Blender.Window.EditMode(1)

def gui():
	global displaceX, displaceY, displaceZ, master
	col = Blender.Window.Theme.Get()[0].get("buts").back
	glClearColor(col[0]/255., col[1]/255., col[2]/255., col[3]/255.)
	glClear(GL_COLOR_BUFFER_BIT)
	master = Number("Master: ", 4, 10, 180, 100, 20, master.val, 0., 5.)
	displaceX = Number("X: ", 2, 10, 150, 100, 20, displaceX.val, 0., 5.)
	displaceY = Number("Y: ", 2, 10, 120, 100, 20, displaceY.val, 0., 5.)
	displaceZ = Number("Z: ", 2, 10, 90, 100, 20, displaceZ.val, 0., 5.)
	Button("Displace", 3, 10, 60, 100, 20, "Die eingestellten Werte auf die ausgewahlten Verts anwenden.")
	Button("Beenden", 1, 10, 30, 100, 20, "Selbsterklarend :)")
  
def event(evt, val):
	if (evt == QKEY and not val): Exit()
def bevent(evt):
	if (evt == 1): Exit()
	elif evt == 3:
		displace()
	elif (evt == 4):
		displaceX.val=master.val
		displaceY.val=master.val
		displaceZ.val=master.val
		Redraw()

Register(gui, event, bevent)