#!BPY

"""
Name: 'BMAE'
Blender: 248
Group: 'Mesh'
Tooltip: 'Edit Mesh Atrributes'
"""

__author__ = "Ron Walker"
__url__ = ("http://wiki.blender.org/index.php/Scripts/Manual/Mesh/BMAE")
__version__ = "Blender Mesh Attribute Editor v1.2a 2006/06/01, 2008/05/15"
__bpydoc__ = """\
This program allows you to create a mesh and edit its size and 
location attributes according to US Standard or Metric Units.
"""

#############################################################################################################		
# -----------------------------------------------------------------------------------------------------------
# BMAE v1.2a
# -----------------------------------------------------------------------------------------------------------
# ***** BEGIN GPL LICENSE BLOCK *****
#
# Copyright (C) 2006 - 2008: Ron Walker
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software Foundation
# Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
# ***** END GPL LICENCE BLOCK *****
# -----------------------------------------------------------------------------------------------------------
#############################################################################################################



#############################################################################################################
#Import and Load Section                                                                                    #
#############################################################################################################

import Blender
from Blender import *
from Blender import Window #BGL
from Blender.Window import Theme
from Blender.Draw import *
from Blender.BGL import *

import os
import sys
import math
from decimal import *

#import BMAE modules
#====================	
dir = os.path.join(Blender.Get(r'scriptsdir'),'Mesh','BMAE')	
if os.path.isdir(dir):
	sys.path.append(dir)
	
import BMAE_LID as bd
reload(bd)
import BMAE_MMC as bc
reload(bc)

ld = bd.ld
id = bd.id

#Load .bsf (settings)
#=====================
try:
	#read file
	BMAE_File = open(os.path.join(dir,'BMAE.bsf'),'r')
	settings_list = list(BMAE_File.readlines())
	BMAE_File.close()
	#assign and format
	settings = []
	index = 0
	for item in settings_list:
		if index == 2:
			settings.append(float(item))
		else:
			settings.append(int(item))
		index += 1			
except(IOError, EOFError):
	settings = [0,1,1.0,1,1]
	print
	print "********************************************************"	
	print
	print "----------------English--------------------" 
	print "Could not load settings! Reverting to default."
	print
	#Spanish
	print
	print "----------------Espanol--------------------" 
	print "No poda cargar ajustes! Inversin a omitir." 
	print
	#French
	print
	print "----------------Francais-------------------"
	print "Ne peut pas demarrer les reglages! Retour aux reglages par defaut."
	print
	#Italian
	print
	print "----------------Italiano--------------------" 
	print "Non ha potuto caricare le regolazioni! Ritorno da stabilizzare." 
	print
	print "********************************************************"		
	print



#############################################################################################################
#Events Section                                                                                             #
#############################################################################################################

mcreate       =  1
moptions      =  2
mexit         =  3
mreset        =  4
msl_reset     =  5

m2d           =  6
m3d           =  7

mmeshtype_2d  =  8
mmeshtype_3d  =  9

mmeshname     = 10
munits        = 11

mn_segments   = 12
mn_rings      = 13

mbl           =	14
mbr           =	15
mtl           = 16
mtr           = 17

mcalgng       = 18
mxaxis        = 19
myaxis        = 20
mzaxis        = 21

moutside      = 22
mcenter       = 23
minside       = 24

mmks_x        = 25
mmks_y        = 26
mmks_z        =	27
mfms_x        = 28
mfms_y        = 29
mfms_z        = 30
mics_x        = 31
mics_y        = 32
mics_z        = 33

mmkl_x        = 34
mmkl_y        = 35
mmkl_z        = 36
mfml_x        = 37
mfml_y        = 38
mfml_z        = 39	
micl_x        = 40
micl_y        = 41
micl_z        = 42

mmkis_x       = 43
mmkis_y       = 44
mmkis_z       = 45
mfmis_x       = 46
mfmis_y       = 47
mfmis_z       = 48
micis_x       = 49
micis_y       = 50
micis_z       = 51

m_core        = 52
m_fill        = 53

m_floor       = 54
mf_pos        = 55
mf_neg        = 56

mois_outer    = 57
mois_inner    = 58



#############################################################################################################
#GUI Section                                                                                                #
#############################################################################################################

#============================================================================================================
#Settings
#============================================================================================================

#Language 
#=========
o_mn_language = Create(settings[0])
l = o_mn_language.val

#Scale
#======
o_n_scale = Create(settings[2])

#Editmode
#========
o_t_editmode = Create(settings[3])

#Y face direction
#=================
o_t_flip_y = Create(settings[4])

#Theme drawtype
#===============
theme = Theme.Get()[0]
ui = theme.get('ui')


#============================================================================================================
#Image display
#============================================================================================================
def image_display(image,h,v):
	"""Diplay images from dictionary."""
	
	BGL.glEnable(BGL.GL_BLEND)
	BGL.glBlendFunc(BGL.GL_SRC_ALPHA, BGL.GL_ONE_MINUS_SRC_ALPHA)
	Blender.Draw.Image(image,h,v)
	BGL.glDisable(BGL.GL_BLEND)


#============================================================================================================
#Segments & Rings Labels & Buttons
#============================================================================================================

#Segments & Rings     
#=================    
def segments_rings_display():
	"""Displays the segments buttons and the text."""
	global n_segments, n_rings
	
	if mn_meshtype_2d.val > 2:
		if mn_meshtype_2d.val == 3 or mn_meshtype_2d.val == 4: 
			glColor3f(1.000, 1.000, 1.000)
			glRasterPos2d(8, 340)
			Text(ld[l]['B_Segments'])
			n_segments = Number("", mn_segments, 78, 335, 60, 16, n_segments.val, 3, 500, ld[l]['B_N_Segs'])
		else:
			pass
			
	if mn_meshtype_3d.val > 2:
		if mn_meshtype_3d.val == 3 or mn_meshtype_3d.val == 4 or mn_meshtype_3d.val == 10: 
			glColor3f(1.000, 1.000, 1.000)
			glRasterPos2d(8, 340)
			Text(ld[l]['B_Segments'])
			n_segments = Number("", mn_segments, 78, 335, 60, 16, n_segments.val, 3, 500,ld[l]['B_N_Segs'])
		elif mn_meshtype_3d.val == 11 or mn_meshtype_3d.val == 12: 
			glColor3f(1.000, 1.000, 1.000)
			glRasterPos2d(8, 340)
			Text(ld[l]['B_Segments'])
			n_segments = Number("", mn_segments, 78, 335, 60, 16, n_segments.val, 3, 500,ld[l]['B_N_Segs'])
			glRasterPos2d(8, 318)
			Text(ld[l]['B_Rings'])
			n_rings = Number("", mn_rings, 78, 313, 60, 16, n_rings.val, 3, 500, ld[l]['B_N_Rings'])
		else:
			pass

#============================================================================================================
#Right Angle Triangle Buttons 
#============================================================================================================

#Right Angle Triangle Buttons states
#====================================
def r_triangle_states(a,b,c,d):
	"""Sets the display state of the Right Triangle direction buttons to on or Off."""
	global t_blratriangle,t_brratriangle,t_tlratriangle,t_trratriangle
	#When one is on the others are off		
	t_blratriangle.val = a
	t_brratriangle.val = b
	t_tlratriangle.val = c
	t_trratriangle.val = d

#Right Angle Triangle Buttons Display
#=====================================
def r_triangle_display():
	"""Displays the Right Triangle direction buttons."""
	global t_blratriangle,t_brratriangle,t_tlratriangle,t_trratriangle,mn_meshtype_2d
	
	if mn_meshtype_2d.val >= 1:
		if mn_meshtype_2d.val == 6:
			t_blratriangle = Toggle(ld[l]['B_RT_BL'], mbl, 8, 313, 80, 16, t_blratriangle.val, ld[l]['B_RT_BL_T'])
			t_brratriangle = Toggle(ld[l]['B_RT_BR'], mbr, 92, 313, 80, 16, t_brratriangle.val, ld[l]['B_RT_BR_T'])
			t_tlratriangle = Toggle(ld[l]['B_RT_TL'], mtl, 8, 335, 80, 16, t_tlratriangle.val, ld[l]['B_RT_TL_T'])
			t_trratriangle = Toggle(ld[l]['B_RT_TR'], mtr, 92, 335, 80, 16, t_trratriangle.val, ld[l]['B_RT_TR_T'])
		else:
			pass
	if mn_meshtype_3d.val >= 1:
		if mn_meshtype_3d.val == 6:
			t_blratriangle = Toggle(ld[l]['B_RT_BL'], mbl, 8, 313, 80, 16, t_blratriangle.val, ld[l]['B_RT_BL_T'])
			t_brratriangle = Toggle(ld[l]['B_RT_BR'], mbr, 92, 313, 80, 16, t_brratriangle.val, ld[l]['B_RT_BR_T'])
			t_tlratriangle = Toggle(ld[l]['B_RT_TL'], mtl, 8, 335, 80, 16, t_tlratriangle.val, ld[l]['B_RT_TL_T'])
			t_trratriangle = Toggle(ld[l]['B_RT_TR'], mtr, 92, 335, 80, 16, t_trratriangle.val, ld[l]['B_RT_TR_T'])
		else:
			pass
		
#Right Triangle Definition
#==========================
def rtriangle_def():
	"""Define which directional position to use for the Right Triangle."""
	global rt_d
	
	if t_trratriangle.val:
		rt_d = 3
	elif t_tlratriangle.val:
		rt_d = 2
	elif t_brratriangle.val:
		rt_d = 1
	else:
		rt_d = 0
		
		
#============================================================================================================
#Torus Radius Definition Buttons 
#============================================================================================================

#Torus Buttons states
#=====================
def torus_radius_states(a,b,c):
	"""Sets the display state of the Torus Radius buttons to on or Off."""
	global t_outside, t_center, t_inside
	
	#When one is on the others are off		
	t_outside.val = a
	t_center.val = b
	t_inside.val = c

#Torus Radius Buttons Display
#=============================
def torus_radius_display():
	"""Displays the Torus direction buttons."""
	global t_outside, t_center, t_inside
	
	if mn_meshtype_3d.val == 12:
		t_outside = Toggle(ld[l]['B_Outside'], moutside, 200, 313, 20, 16, t_outside.val, ld[l]['B_Outside_T'])
		t_center = Toggle(ld[l]['B_Center'], mcenter, 227, 313, 20, 16, t_center.val, ld[l]['B_Center_T'])
		t_inside = Toggle(ld[l]['B_Inside'], minside, 254, 313, 20, 16, t_inside.val, ld[l]['B_Inside_T'])
	
#Torus Radius Definition
#========================
def torus_def():
	"""Defines which radius position to use for the Torus."""
	global t_r
	
	if t_inside.val:
		t_r = 2
	elif t_center.val:
		t_r = 1
	else:
		t_r = 0
		

#============================================================================================================
#Axis Display
#============================================================================================================

#Axis Buttons States
#====================		
def axis_states(a,b,c):
	"""Determines what axis text label to display. If X is off Z is on."""
	global t_xaxis, t_yaxis, t_zaxis
	
	#When one is on the others are off
	t_xaxis.val = a
	t_yaxis.val = b
	t_zaxis.val = c
	
#Set the axis
#=============
def set_axis():
	"""Pass the axis value as ax."""
	global ax
	
	if t_xaxis.val == 1: ax = 0
	if t_yaxis.val == 1: ax = 1
	if t_zaxis.val == 1: ax = 2

#XAxis Labels Display
#=====================	
def xaxis_labels():
	"""Diplays the X axis text labels."""
	if o_mn_language.val == 1 or o_mn_language.val == 2:
		glColor3f(0.863, 0.847, 0.953)
		glRasterPos2d(8, 246)
		Text(ld[l]['I_H_X'],'small')
		glRasterPos2d(8, 224)
		Text(ld[l]['I_W_Y'],'small')
		glRasterPos2d(8, 202)
		Text(ld[l]['I_D_Z'],'small')
	else:
		glColor3f(0.863, 0.847, 0.953)
		glRasterPos2d(8, 246)
		Text(ld[l]['I_H_X'])
		glRasterPos2d(8, 224)
		Text(ld[l]['I_W_Y'])
		glRasterPos2d(8, 202)
		Text(ld[l]['I_D_Z'])

#YAxis Labels Display
#=====================
def yaxis_labels():
	"""Diplays the Y axis text labels."""
	if o_mn_language.val == 1 or o_mn_language.val == 2: 
		glColor3f(0.863, 0.847, 0.953)
		glRasterPos2d(8, 246)
		Text(ld[l]['I_W_X'],'small')
		glRasterPos2d(8, 224)
		Text(ld[l]['I_H_Y'],'small')
		glRasterPos2d(8, 202)
		Text(ld[l]['I_D_Z'],'small')
	else:
		glColor3f(0.863, 0.847, 0.953)
		glRasterPos2d(8, 246)
		Text(ld[l]['I_W_X'])
		glRasterPos2d(8, 224)
		Text(ld[l]['I_H_Y'])
		glRasterPos2d(8, 202)
		Text(ld[l]['I_D_Z'])

#ZAxis Labels Display
#=====================		
def zaxis_labels():
	"""Diplays the Z axis text labels."""
	if o_mn_language.val == 1 or o_mn_language.val == 2:
		glColor3f(0.863, 0.847, 0.953)
		glRasterPos2d(6, 246)
		Text(ld[l]['I_D_X'],'small')
		glRasterPos2d(6, 224)
		Text(ld[l]['I_W_Y'],'small')
		glRasterPos2d(6, 202)
		Text(ld[l]['I_H_Z'],'small')
	else:
		glColor3f(0.863, 0.847, 0.953)
		glRasterPos2d(8, 246)
		Text(ld[l]['I_D_X'])
		glRasterPos2d(8, 224)
		Text(ld[l]['I_W_Y'])
		glRasterPos2d(8, 202)
		Text(ld[l]['I_H_Z'])
	

#============================================================================================================
#Size and Location Buttons
#============================================================================================================

#+++++++++++++++++++++++++	
#Outer Size Button States
#=========================
def o_size_button_states(sm_1,sm_2,sm_3,sm_4,sm_5,slbb,slbm,slbs):
	"""Outer size button states. Changes for no-mesh, 2d and 3d."""
	global n_mks_x, n_mks_y, n_mks_z, n_fms_x, n_fms_y, n_fms_z, n_ics_x, n_ics_y, n_ics_z
		
	#Outer Size Number Buttons (compile/eval made tracking easier)	
	mks_x = compile("Number('', mmks_x, 78, 241, 60, 16, n_mks_x.val, sm_1, sm_2, slbb)","<button>","eval")
	mks_y = compile("Number('', mmks_y, 78, 219, 60, 16, n_mks_y.val, sm_1, sm_2, slbb)","<button>","eval")
	mks_z = compile("Number('', mmks_z, 78, 197, 60, 16, n_mks_z.val, sm_1, sm_2, slbb)","<button>","eval")	
	fms_x = compile("Number('', mfms_x, 148, 241, 60, 16, n_fms_x.val, sm_1, sm_3, slbm)","<button>","eval")
	fms_y = compile("Number('', mfms_y, 148, 219, 60, 16, n_fms_y.val, sm_1, sm_3, slbm)","<button>","eval")
	fms_z = compile("Number('', mfms_z, 148, 197, 60, 16, n_fms_z.val, sm_1, sm_3, slbm)","<button>","eval")	
	ics_x = compile("Number('', mics_x, 218, 241, 60, 16, n_ics_x.val, sm_4, sm_5, slbs)","<button>","eval")
	ics_y = compile("Number('', mics_y, 218, 219, 60, 16, n_ics_y.val, sm_4, sm_5, slbs)","<button>","eval")
	ics_z = compile("Number('', mics_z, 218, 197, 60, 16, n_ics_z.val, sm_4, sm_5, slbs)","<button>","eval")
	
	btos = [[mks_x,fms_x,ics_x],[mks_y,fms_y,ics_y],[mks_z,fms_z,ics_z]]	
	
	if t_2d.val == 0 and t_3d.val == 0:
		if ui.drawType == 2:
			try:
				image_display(id[0]['I_SLBtn_R'],78,197)
				image_display(id[0]['I_SLBtn_R'],78,219)
				image_display(id[0]['I_SLBtn_R'],78,241)
			except(NameError):
				pass
		elif ui.drawType != 2:
			try:
				image_display(id[0]['I_SLBtn_D'],78,197)
				image_display(id[0]['I_SLBtn_D'],78,219)
				image_display(id[0]['I_SLBtn_D'],78,241)
			except(NameError):
				pass	
	elif t_2d.val:
		if t_zaxis.val:
			#Size Number Buttons
			n_mks_x=eval(btos[0][0]); n_fms_x=eval(btos[0][1]); n_ics_x=eval(btos[0][2])
			n_mks_y=eval(btos[1][0]); n_fms_y=eval(btos[1][1]); n_ics_y=eval(btos[1][2])
			n_mks_z.val = 0; n_fms_z.val = 0; n_ics_z.val = 0
			if ui.drawType is 2:
				try:
					image_display(id[0]['I_SLBtn_R'],78,197)
				except(NameError):
					pass
			elif ui.drawType is not 2:
				try:
					image_display(id[0]['I_SLBtn_D'],78,197)
				except(NameError):
					pass			
		if t_yaxis.val:
			#Size Number Buttons
			n_mks_x=eval(btos[0][0]); n_fms_x=eval(btos[0][1]); n_ics_x=eval(btos[0][2])
			n_mks_z=eval(btos[2][0]); n_fms_z=eval(btos[2][1]); n_ics_z=eval(btos[2][2])
			n_mks_y.val = 0; n_fms_y.val = 0; n_ics_y.val = 0
			if ui.drawType is 2:
				try:
					image_display(id[0]['I_SLBtn_R'],78,219)
				except(NameError):
					pass
			elif ui.drawType != 2:
				try:
					image_display(id[0]['I_SLBtn_D'],78,219)
				except(NameError):
					pass
		if t_xaxis.val:
			#Size Number Buttons
			n_mks_y=eval(btos[1][0]); n_fms_y=eval(btos[1][1]); n_ics_y=eval(btos[1][2])
			n_mks_z=eval(btos[2][0]); n_fms_z=eval(btos[2][1]); n_ics_z=eval(btos[2][2])
			n_mks_x.val = 0; n_fms_x.val = 0; n_ics_x.val = 0
			if ui.drawType == 2:
				try:
					image_display(id[0]['I_SLBtn_R'],78,241)
				except(NameError):
					pass
			elif ui.drawType is not 2:
				try:
					image_display(id[0]['I_SLBtn_D'],78,241)
				except(NameError):
					pass
	else:
		#Size Number Buttons	
		n_mks_x=eval(btos[0][0]); n_fms_x=eval(btos[0][1]); n_ics_x=eval(btos[0][2])
		n_mks_y=eval(btos[1][0]); n_fms_y=eval(btos[1][1]); n_ics_y=eval(btos[1][2])
		n_mks_z=eval(btos[2][0]); n_fms_z=eval(btos[2][1]); n_ics_z=eval(btos[2][2]) 		
		
#Outer Size NS
#==============
def o_size_buttons():
	"""Nested sequence of outer size buttons value for measure class."""
	global o_s_b	
	
	o_s_b = []
	
	#Size 	
	o_s_b = [[n_mks_x.val, n_fms_x.val, n_ics_x.val], #x
	         [n_mks_y.val, n_fms_y.val, n_ics_y.val], #y
	         [n_mks_z.val, n_fms_z.val, n_ics_z.val]] #z

#+++++++++++++++++++++++++	
#Inner Size Button States
#=========================
def i_size_button_states(min_mkfm,min_ic, max_mk_x,max_fm_x,max_ic_x, max_mk_y,max_fm_y,max_ic_y, max_mk_z,max_fm_z,max_ic_z, slbb,slbm,slbs):
	"""Inner size button states. Changes for no-mesh, 2d and 3d."""
	global n_mkis_x, n_mkis_y, n_mkis_z, n_fmis_x, n_fmis_y, n_fmis_z, n_icis_x, n_icis_y, n_icis_z
		
	#Inner Size Number Buttons (compile/eval made tracking easier)
	mkis_x = compile("Number('', mmkis_x, 78, 241, 60, 16, n_mkis_x.val, min_mkfm, max_mk_x, slbb)","<button>","eval")
	mkis_y = compile("Number('', mmkis_y, 78, 219, 60, 16, n_mkis_y.val, min_mkfm, max_mk_y, slbb)","<button>","eval")
	mkis_z = compile("Number('', mmkis_z, 78, 197, 60, 16, n_mkis_z.val, min_mkfm, max_mk_z, slbb)","<button>","eval")	
	fmis_x = compile("Number('', mfmis_x, 148, 241, 60, 16, n_fmis_x.val, min_mkfm, max_fm_x, slbm)","<button>","eval")
	fmis_y = compile("Number('', mfmis_y, 148, 219, 60, 16, n_fmis_y.val, min_mkfm, max_fm_y, slbm)","<button>","eval")
	fmis_z = compile("Number('', mfmis_z, 148, 197, 60, 16, n_fmis_z.val, min_mkfm, max_fm_z, slbm)","<button>","eval")	
	icis_x = compile("Number('', micis_x, 218, 241, 60, 16, n_icis_x.val, min_ic, max_ic_x, slbs)","<button>","eval")
	icis_y = compile("Number('', micis_y, 218, 219, 60, 16, n_icis_y.val, min_ic, max_ic_y, slbs)","<button>","eval")
	icis_z = compile("Number('', micis_z, 218, 197, 60, 16, n_icis_z.val, min_ic, max_ic_z, slbs)","<button>","eval")

	btis = [[mkis_x,fmis_x,icis_x],[mkis_y,fmis_y,icis_y],[mkis_z,fmis_z,icis_z]]
	
	if t_2d.val == 0 and t_3d.val == 0:
		if ui.drawType == 2:
			try:
				image_display(id[0]['I_SLBtn_R'],78,197)
				image_display(id[0]['I_SLBtn_R'],78,219)
				image_display(id[0]['I_SLBtn_R'],78,241)
			except(NameError):
				pass
		elif ui.drawType != 2:
			try:
				image_display(id[0]['I_SLBtn_D'],78,197)
				image_display(id[0]['I_SLBtn_D'],78,219)
				image_display(id[0]['I_SLBtn_D'],78,241)
			except(NameError):
				pass	
	elif t_2d.val:
		if t_zaxis.val:
			#Size Number Buttons
			n_mkis_x=eval(btis[0][0]); n_fmis_x=eval(btis[0][1]); n_icis_x=eval(btis[0][2])
			n_mkis_y=eval(btis[1][0]); n_fmis_y=eval(btis[1][1]); n_icis_y=eval(btis[1][2])
			n_mkis_z.val = 0; n_fmis_z.val = 0; n_icis_z.val = 0
			if ui.drawType == 2:
				try:
					image_display(id[0]['I_SLBtn_R'],78,197)
				except(NameError):
					pass
			elif ui.drawType != 2:
				try:
					image_display(id[0]['I_SLBtn_D'],78,197)
				except(NameError):
					pass			
		if t_yaxis.val:
			#Size Number Buttons
			n_mkis_x=eval(btis[0][0]); n_fmis_x=eval(btis[0][1]); n_icis_x=eval(btis[0][2])
			n_mkis_z=eval(btis[2][0]); n_fmis_z=eval(btis[2][1]); n_icis_z=eval(btis[2][2])
			n_mkis_y.val = 0; n_fmis_y.val = 0; n_icis_y.val = 0
			if ui.drawType == 2:
				try:
					image_display(id[0]['I_SLBtn_R'],78,219)
				except(NameError):
					pass
			elif ui.drawType != 2:
				try:
					image_display(id[0]['I_SLBtn_D'],78,219)
				except(NameError):
					pass
		if t_xaxis.val:
			#Size Number Buttons
			n_mkis_y=eval(btis[1][0]); n_fmis_y=eval(btis[1][1]); n_icis_y=eval(btis[1][2])
			n_mkis_z=eval(btis[2][0]); n_fmis_z=eval(btis[2][1]); n_icis_z=eval(btis[2][2])
			n_mkis_x.val = 0; n_fmis_x.val = 0; n_icis_x.val = 0
			if ui.drawType == 2:
				try:
					image_display(id[0]['I_SLBtn_R'],78,241)
				except(NameError):
					pass
			elif ui.drawType != 2:
				try:
					image_display(id[0]['I_SLBtn_D'],78,241)
				except(NameError):
					pass
	else:
		#Size Number Buttons	
		n_mkis_x=eval(btis[0][0]); n_fmis_x=eval(btis[0][1]); n_icis_x=eval(btis[0][2])
		n_mkis_y=eval(btis[1][0]); n_fmis_y=eval(btis[1][1]); n_icis_y=eval(btis[1][2])
		n_mkis_z=eval(btis[2][0]); n_fmis_z=eval(btis[2][1]); n_icis_z=eval(btis[2][2]) 		
		
#Inner Size NS
#==============
def i_size_buttons():
	"""Nested sequence of inner size buttons value for measure class."""
	global i_s_b	
	
	i_s_b = []
	
	#Size 	
	i_s_b = [[n_mkis_x.val, n_fmis_x.val, n_icis_x.val],  #x
	         [n_mkis_y.val, n_fmis_y.val, n_icis_y.val],  #y
	         [n_mkis_z.val, n_fmis_z.val, n_icis_z.val]]  #z
	
#Inner Size Limits
#==================
def inner_sb_limits(mt, mk,fm,ic, ic2):
	"""Set the inner size limits."""

	#x
	if t_xaxis.val:
		ai1=mk; ai2=fm; ai3=ic
	else:
		if n_mks_x.val == 0 and n_fms_x.val == 0 and n_ics_x.val == 0:
			ai1 = 0 
			ai2 = 0
			ai3 = 0
		elif n_mks_x.val == 0 and n_fms_x.val == 0 and n_ics_x.val > 0:
			ai1 = 0 
			ai2 = 0
			ai3 = n_ics_x.val - 0.1
		elif n_mks_x.val == 0 and n_fms_x.val > 0 and n_ics_x.val == 0:
			ai1 = 0
			ai2 = n_fms_x.val - 1
			ai3 = ic2
		elif n_mks_x.val > 0 and n_fms_x.val == 0 and n_ics_x.val == 0:
			ai1 = n_mks_x.val - 1 
			ai2 = n_fms_x.val
			ai3 = ic2
		elif n_mks_x.val == 0 and n_fms_x.val > 0 and n_ics_x.val > 0:
			ai1 = 0 
			ai2 = n_fms_x.val 
			ai3 = n_ics_x.val - 0.1
		elif n_mks_x.val > 0 and n_fms_x.val > 0 and n_ics_x.val == 0:
			ai1 = n_mks_x.val - 1 
			ai2 = fm
			ai3 = ic2
		elif n_mks_x.val > 0 and n_fms_x.val > 0 and n_ics_x.val > 0:
			ai1 = n_mks_x.val 
			ai2 = n_fms_x.val 
			ai3 = n_ics_x.val - 0.1		
	#y
	if t_yaxis.val:
		bi1=mk; bi2=fm; bi3=ic
	else:
		if n_mks_y.val == 0 and n_fms_y.val == 0 and n_ics_y.val == 0:
			bi1 = 0 
			bi2 = 0
			bi3 = 0
		elif n_mks_y.val == 0 and n_fms_y.val == 0 and n_ics_y.val > 0:
			bi1 = 0 
			bi2 = 0
			bi3 = n_ics_y.val - 0.1
		elif n_mks_y.val == 0 and n_fms_y.val > 0 and n_ics_y.val == 0:
			bi1 = 0
			bi2 = n_fms_y.val - 1
			bi3 = ic2
		elif n_mks_y.val > 0 and n_fms_y.val == 0 and n_ics_y.val == 0:
			bi1 = n_mks_y.val - 1 
			bi2 = n_fms_y.val
			bi3 = ic2
		elif n_mks_y.val == 0 and n_fms_y.val > 0 and n_ics_y.val > 0:
			bi1 = 0 
			bi2 = n_fms_y.val 
			bi3 = n_ics_y.val - 0.1
		elif n_mks_y.val > 0 and n_fms_y.val > 0 and n_ics_y.val == 0:
			bi1 = n_mks_y.val - 1 
			bi2 = fm
			bi3 = ic2
		elif n_mks_y.val > 0 and n_fms_y.val > 0 and n_ics_y.val > 0:
			bi1 = n_mks_y.val 
			bi2 = n_fms_y.val 
			bi3 = n_ics_y.val - 0.1
	
	#z
	if t_zaxis.val:
		ci1=mk; ci2=fm; ci3=ic
	else:
		if n_mks_z.val == 0 and n_fms_z.val == 0 and n_ics_z.val == 0:
			ci1 = 0 
			ci2 = 0
			ci3 = 0
		elif n_mks_z.val == 0 and n_fms_z.val == 0 and n_ics_z.val > 0:
			ci1 = 0 
			ci2 = 0
			ci3 = n_ics_z.val - 0.1
		elif n_mks_z.val == 0 and n_fms_z.val > 0 and n_ics_z.val == 0:
			ci1 = 0
			ci2 = n_fms_z.val - 1
			ci3 = ic2
		elif n_mks_z.val > 0 and n_fms_z.val == 0 and n_ics_z.val == 0:
			ci1 = n_mks_z.val - 1 
			ci2 = n_fms_z.val
			ci3 = ic2
		elif n_mks_z.val == 0 and n_fms_z.val > 0 and n_ics_z.val > 0:
			ci1 = 0 
			ci2 = n_fms_z.val 
			ci3 = n_ics_z.val - 0.1
		elif n_mks_z.val > 0 and n_fms_z.val > 0 and n_ics_z.val == 0:
			ci1 = n_mks_z.val - 1 
			ci2 = fm
			ci3 = ic2
		elif n_mks_z.val > 0 and n_fms_z.val > 0 and n_ics_z.val > 0:
			ci1 = n_mks_z.val 
			ci2 = n_fms_z.val 
			ci3 = n_ics_z.val - 0.1
	
	#None
	if mt == 1:
		i_size_button_states(0,0.0, ai1,ai2,ai3, bi1,bi2,bi3, ci1,ci2,ci3, ld[l]['B_N'],ld[l]['B_N'],ld[l]['B_N'])
	#Standard	
	elif mt == 2:
		i_size_button_states(0,0.0, ai1,ai2,ai3, bi1,bi2,bi3, ci1,ci2,ci3, ld[l]['B_MiS'],ld[l]['B_FS'],ld[l]['B_IS'])
	#Metric
	elif mt == 3:
		i_size_button_states(0,0.0, ai1,ai2,ai3, bi1,bi2,bi3, ci1,ci2,ci3, ld[l]['B_KS'],ld[l]['B_MeS'],ld[l]['B_CS'])


#+++++++++++++++++++++++	
#Location Button States
#=======================
def location_button_states(lm_1,lm_2,lm_3,lm_4,lm_5,lm_6,llbb,llbm,llbs):
	"""Location button states. Changes for no-mesh, 2d and 3d."""
	global n_mkl_x, n_mkl_y, n_mkl_z, n_fml_x, n_fml_y, n_fml_z, n_icl_x, n_icl_y, n_icl_z

	#Location Number Buttons (compile/eval made tracking easier)
	mkl_x = compile("Number('', mmkl_x, 78, 125, 60, 16, n_mkl_x.val, lm_4, lm_1, llbb)","<button>","eval")
	mkl_y = compile("Number('', mmkl_y, 78, 103, 60, 16, n_mkl_y.val, lm_4, lm_1, llbb)","<button>","eval")
	mkl_z = compile("Number('', mmkl_z, 78, 81, 60, 16, n_mkl_z.val, lm_4, lm_1, llbb)","<button>","eval")	 
	fml_x = compile("Number('', mfml_x, 148, 125, 60, 16, n_fml_x.val, lm_5, lm_2, llbm)","<button>","eval")
	fml_y = compile("Number('', mfml_y, 148, 103, 60, 16, n_fml_y.val, lm_5, lm_2, llbm)","<button>","eval")
	fml_z = compile("Number('', mfml_z, 148, 81, 60, 16, n_fml_z.val, lm_5, lm_2, llbm)","<button>","eval")
	icl_x = compile("Number('', micl_x, 218, 125, 60, 16, n_icl_x.val, lm_6, lm_3, llbs)","<button>","eval")
	icl_y = compile("Number('', micl_y, 218, 103, 60, 16, n_icl_y.val, lm_6, lm_3, llbs)","<button>","eval")
	icl_z = compile("Number('', micl_z, 218, 81, 60, 16, n_icl_z.val, lm_6, lm_3, llbs)","<button>","eval")
	
	btl = [[mkl_x,fml_x,icl_x],[mkl_y,fml_y,icl_y],[mkl_z,fml_z,icl_z]]
	
	if t_2d.val == 0 and t_3d.val == 0:
		if ui.drawType == 2:
			try:
				image_display(id[0]['I_SLBtn_R'],78,81)
				image_display(id[0]['I_SLBtn_R'],78,103)
				image_display(id[0]['I_SLBtn_R'],78,125)
			except(NameError):
				pass
		elif ui.drawType != 2:
			try:
				image_display(id[0]['I_SLBtn_D'],78,81)
				image_display(id[0]['I_SLBtn_D'],78,103)
				image_display(id[0]['I_SLBtn_D'],78,125)
			except(NameError):
				pass
	elif t_floor.val:
		n_mkl_x=eval(btl[0][0]); n_fml_x=eval(btl[0][1]); n_icl_x=eval(btl[0][2]) 
		n_mkl_y=eval(btl[1][0]); n_fml_y=eval(btl[1][1]); n_icl_y=eval(btl[1][2])
		try:
			image_display(id[0]['I_SLBtn_R'],78,81)
		except(NameError):
				pass
	else:
		#Location Number Buttons 
		n_mkl_x=eval(btl[0][0]); n_fml_x=eval(btl[0][1]); n_icl_x=eval(btl[0][2]) 
		n_mkl_y=eval(btl[1][0]); n_fml_y=eval(btl[1][1]); n_icl_y=eval(btl[1][2])
		n_mkl_z=eval(btl[2][0]); n_fml_z=eval(btl[2][1]); n_icl_z=eval(btl[2][2]) 

#Location Size NS
#=================	
def location_buttons():
	"""Nested sequence of location buttons value for measure class."""
	global l_b
	
	#Location
	l_b = [[n_mkl_x.val, n_fml_x.val, n_icl_x.val], #x
	   	   [n_mkl_y.val, n_fml_y.val, n_icl_y.val], #y
	       [n_mkl_z.val, n_fml_z.val, n_icl_z.val]] #z
		
	
#============================================================================================================
#Core Buttons & Outer / Inner Size Toggle Buttons 
#============================================================================================================

#Size Toggle Buttons states
#===========================
def ois_states(a,b):
	"""Sets the display state of the inner and outer size toggle buttons to on or Off."""
	global t_ois_outer, t_ois_inner
	
	#When one is on the other is off		
	t_ois_outer.val = a
	t_ois_inner.val = b

#Size Toggle Buttons Display
#============================
def ois_display():
	"""Displays the Right Triangle direction buttons."""
	global t_core, t_fill, t_ois_outer, t_ois_inner
	
	CORE_LIST = (2,4,5,6)

	if mn_meshtype_2d.val in CORE_LIST or mn_meshtype_3d.val in CORE_LIST:
		t_core = Toggle(ld[l]['B_Core'], m_core, 228, 285, 50, 16, t_core.val, ld[l]['B_Core_T'])	
		if t_core.val:
			t_ois_outer = Toggle(ld[l]['B_Outer'], mois_outer, 135, 285, 20, 16, t_ois_outer.val, ld[l]['B_Outer_T'])
			t_ois_inner = Toggle(ld[l]['B_Inner'], mois_inner, 157, 285, 20, 16, t_ois_inner.val, ld[l]['B_Inner_T'])	
			if mn_meshtype_3d.val in CORE_LIST:
				t_fill = Toggle(ld[l]['B_Fill'], m_fill, 185, 285, 30, 16, t_fill.val, ld[l]['B_Fill_T'])


	
#============================================================================================================
#Floor Axis Buttons 
#============================================================================================================

#Floor axis Toggle Buttons States
#=================================
def floor_axis_states(a,b):
	"""Sets the display state of the inner and outer size toggle buttons to on or Off."""
	global t_f_pos, t_f_neg
	
	#When one is on the other is off		
	t_f_pos.val = a
	t_f_neg.val = b
		
#Floor Toggle Buttons Display
#=============================
def floor_toggle_display():
	"""Sets the display state of the floor toggle button."""
	global t_floor, t_f_pos, t_f_neg
	
	if mn_meshtype_2d.val > 1 or mn_meshtype_3d.val > 1:
		t_floor = Toggle(ld[l]['B_Floor'], m_floor, 228, 169, 50, 16, t_floor.val, ld[l]['B_Floor_T'])
		if t_floor.val:
			t_f_pos = Toggle("+Z", mf_pos, 194, 169, 25, 16, t_f_pos.val, ld[l]['B_+Z_T'])
			t_f_neg = Toggle("-Z", mf_neg, 165, 169, 25, 16, t_f_neg.val, ld[l]['B_-Z_T'])
			
def set_floor():
	"""Set the floor as positive or negative."""
	global floor_pn
	
	if t_floor.val:
		if t_f_pos.val:
			floor_pn = 1
		elif t_f_neg.val:
			floor_pn = 2
	else:
		floor_pn = 0			

	
#============================================================================================================
#MeshType Menu Display
#============================================================================================================

#MeshType Menu States
#=====================		
def meshtype_menu_states(a,b):
	"""Determines what meshtype menu to display as on and off."""
	global t_xaxis, t_yaxis, t_zaxis, mn_meshtype_2d, mn_meshtype_3d
	#When one is on the other is off
	t_2d.val = a
	t_3d.val = b

#MeshType Menu Display
#======================
def mesh_menus():
	"""Display the 2d or 3d meshtype selection menus."""
	global mn_meshtype_2d, mn_meshtype_3d	
	if t_2d.val:
		mn_meshtype_2d = Menu(ld[l]['B_MT_2d'], mmeshtype_2d, 148, 407, 130, 16, mn_meshtype_2d.val, ld[l]['B_Mesh_Type_2d_T'])#Change these three for languages
		mn_meshtype_3d.val = 0
	elif t_3d.val:
	  	mn_meshtype_3d = Menu(ld[l]['B_MT_3d'], mmeshtype_3d, 148, 407, 130, 16, mn_meshtype_3d.val, ld[l]['B_Mesh_Type_3d_T'])
		mn_meshtype_2d.val = 0
	else:
		if ui.drawType == 2:
			try:
				image_display(id[0]['I_MeshType_R'],148,407)
			except(NameError):
				pass
		elif ui.drawType != 2:
			try:
				image_display(id[0]['I_MeshType_D'],148,407)
			except(NameError):
				pass
		
		
#============================================================================================================
#Name Textbox
#============================================================================================================

#Name Mesh Textbox state
#========================
def name_textbox():
	"""Enable or disable the meshname textbox."""
	global tb_namemesh
	if t_2d.val == 0 and t_3d.val == 0:
		if ui.drawType == 2:
			try:
				image_display(id[0]['I_MeshName_R'],148,385)
			except(NameError):
				pass
		elif ui.drawType != 2:
			try:
				image_display(id[0]['I_MeshName_D'],148,385)
			except(NameError):
				pass
	else:
		tb_namemesh = String('', mmeshname, 148, 385, 130, 16, tb_namemesh.val, 80, ld[l]['B_Mesh_Name_T'])	


#============================================================================================================
#Size Labels Display
#============================================================================================================

#Standard Units Display Labels
#==============================		
def standard_unit_labels():
	#global mnTheme
	"""Diplays US Standard Unit text labels for both size and location."""
	glColor3f(0.502, 1.000, 1.000)
	glRasterPos2d(78, 268)
	Text(ld[l]['I_Miles'])
	glRasterPos2i(148, 268)
	Text(ld[l]['I_Feet'])
	glRasterPos2d(218, 268)
	Text(ld[l]['I_Inches'])
	glRasterPos2d(78, 152)
	Text(ld[l]['I_Miles'])
	glRasterPos2d(148, 152)
	Text(ld[l]['I_Feet'])
	glRasterPos2d(218, 152)
	Text(ld[l]['I_Inches'])
	
#Metric Units Display Labels
#============================
def metric_unit_labels():
	"""Diplays Metric Unit text labels for both size and location."""
	glColor3f(0.502, 1.000, 1.000)
	glRasterPos2d(78, 268)
	Text(ld[l]['I_Kilo'])
	glRasterPos2d(148, 268)
	Text(ld[l]['I_Meters'])
	glRasterPos2d(216, 268)
	Text(ld[l]['I_Cent'])
	glRasterPos2d(78, 152)
	Text(ld[l]['I_Kilo'])
	glRasterPos2d(148, 152)
	Text(ld[l]['I_Meters'])
	glRasterPos2d(216, 152)
	Text(ld[l]['I_Cent'])
		
	
#============================================================================================================
#Warnings Displays & Filters
#============================================================================================================	

#filter trigger values
#======================
def filter_trigger_values_o():
	"""Check if Outer values are set."""
	global xo,yo,zo, xi,yi,zi
	
	xo = o_s_b[0][0] + o_s_b[0][1] + o_s_b[0][2]
	yo = o_s_b[1][0] + o_s_b[1][1] + o_s_b[1][2]
	zo = o_s_b[2][0] + o_s_b[2][1] + o_s_b[2][2]
	
#filter trigger values
#======================
def filter_trigger_values_i():
	"""Check if Inner values are set."""
	global xi,yi,zi
	
	xi = i_s_b[0][0] + i_s_b[0][1] + i_s_b[0][2]
	yi = i_s_b[1][0] + i_s_b[1][1] + i_s_b[1][2]
	zi = i_s_b[2][0] + i_s_b[2][1] + i_s_b[2][2]

#exit Button Warning 
#====================
def exit_warning():
	"""Displays an exit warning before commiting."""
	global M
	exitnow = Blender.Draw.PupMenu(ld[l]['Exit_W'])
	if exitnow == 1:
		Exit()
	elif exitnow == 0:
		return

#Reset SLB Button Warning 
#=========================
def reset_sl_warning():
	"""Diplays the Reset proceed or stop popup."""
	reset = Blender.Draw.PupMenu(ld[l]['SL_Reset_W'])
	if reset == 1:
		sl_reset()
	elif reset == 0:
		return

#Reset Button Warning 
#=====================
def reset_warning():
	"""Diplays the Reset proceed or stop popup."""
	reset = Blender.Draw.PupMenu(ld[l]['Reset_W'])
	if reset == 1:
		startup_reset()
	elif reset == 0:
		return

#Proceed Filters
#================
def selection_filter_2d():
	"""Determines if a Mesh Type. 
	   If not an error popup menu will appear to explain."""
	if t_2d.val:
		Blender.Draw.PupMenu(ld[l]['UE_SMT'])
		return
	
def selection_filter_3d():
	"""Determines if a Mesh Type. 
	   If not an error popup menu will appear to explain."""
	if t_3d.val:
		Blender.Draw.PupMenu(ld[l]['UE_SMT'])
		return

def selection_filter_ex():
	"""Determines if a Mesh Type. 
	   If not an error popup menu will appear to explain."""
	if t_ex.val:
		Blender.Draw.PupMenu(ld[l]['UE_SMT'])
		return
	
def ois_filter():
	"""Determine if the outer size has been set 
		before use of the inner size is allowed."""	
	
	o_size_buttons()
	filter_trigger_values_o()
	if t_2d.val and t_xaxis.val:
		if int(yo) == 0 or int(zo) == 0:
			Blender.Draw.PupMenu(ld[l]['OIS_F_W'])
			ois_states(1,0)
			return
	elif t_2d.val and t_yaxis.val:
		if int(xo) == 0 or int(zo) == 0:
			Blender.Draw.PupMenu(ld[l]['OIS_F_W'])
			ois_states(1,0)
			return
	elif t_2d.val and t_zaxis.val:
		if int(xo) == 0 or int(yo) == 0:
			Blender.Draw.PupMenu(ld[l]['OIS_F_W'])
			ois_states(1,0)
			return
	elif t_3d.val:
		if int(xo) == 0 or int(yo) == 0 or int(zo) == 0:
			Blender.Draw.PupMenu(ld[l]['OIS_F_W'])
			ois_states(1,0)
			return
	
	ois_states(0,1)
		
		
#Name Filter
#============
def set_name(m_n):
	"""Get a user name or give default."""
	global name
	if tb_namemesh.val == "":
		name = m_n
	else:
		name = tb_namemesh.val 
		
		
#============================================================================================================
#Button States & Reset Section
#============================================================================================================

#Complete reset
#===============
def startup_reset():
	"""Sets the initial state of the GUI and for the reset button."""
 	global mn_meshtype_2d, mn_meshtype_3d, tb_namemesh, mn_units,\
	t_2d, t_3d, t_ex, t_zaxis, t_xaxis, t_yaxis, n_segments, n_rings,\
    t_blratriangle, t_brratriangle, t_tlratriangle, t_trratriangle,\
	n_mks_x, n_mks_y, n_mks_z, n_fms_x, n_fms_y, n_fms_z, n_ics_x, n_ics_y, n_ics_z,\
	n_mkis_x, n_mkis_y, n_mkis_z, n_fmis_x, n_fmis_y, n_fmis_z, n_icis_x, n_icis_y, n_icis_z,\
	n_mkl_x, n_mkl_y, n_mkl_z, n_fml_x, n_fml_y, n_fml_z, n_icl_x, n_icl_y, n_icl_z,\
	t_core, t_fill, t_ois_outer, t_ois_inner, t_outside, t_center, t_inside,\
	t_floor, t_f_pos, t_f_neg 
	
	#Initial
	bt_create = Create(0)
	bt_options = Create(0)
	bt_exit = Create(0)
	bt_reset = Create(0)
	bt_calculator = Create(0)
	
	#MeshType Toggle
	t_2d = Create(0)
	t_3d = Create(0)
	
	#Mesh Type Menu
	mn_meshtype_2d = Create(0)
	mn_meshtype_3d = Create(0)
	
	#Units of Measurements Menu
	mn_units = Create(int(settings[1]))
	
	#Mesh Name Text Box
	tb_namemesh = Create("")
		
	#Segments & Rings
	n_segments = Create(12)
	n_rings = Create(12)
	
	#Right Angle Toggle
	t_blratriangle = Create(1)
	t_brratriangle = Create(0)
	t_tlratriangle = Create(0)
	t_trratriangle = Create(0)
		
	#Axis Toggle
	t_xaxis = Create(0)
	t_yaxis = Create(0)
	t_zaxis = Create(1)
	
	#Number Size - Miles/Kilometers
	n_mks_x = Create(0)
	n_mks_y = Create(0)
	n_mks_z = Create(0)
	#Number Size - Feet/Meters
	n_fms_x = Create(0)
	n_fms_y = Create(0)
	n_fms_z = Create(0)
	#Number Size - Inches/Centimeters
	n_ics_x = Create(0.0)
	n_ics_y = Create(0.0)
	n_ics_z = Create(0.0)
	
	#Number Location - Miles/Kilometers
	n_mkl_x = Create(0)
	n_mkl_y = Create(0)
	n_mkl_z = Create(0)
	#Number Location - Feet/Meters
	n_fml_x = Create(0)
	n_fml_y = Create(0)
	n_fml_z = Create(0)
	#Number Location - Inches/Centimeters
	n_icl_x = Create(0.0)
	n_icl_y = Create(0.0)
	n_icl_z = Create(0.0)
	
	#Number Inner Size - Miles/Kilometers
	n_mkis_x = Create(0)
	n_mkis_y = Create(0)
	n_mkis_z = Create(0)
	#Number Inner Size - Feet/Meters
	n_fmis_x = Create(0)
	n_fmis_y = Create(0)
	n_fmis_z = Create(0)
	#Number Inner Size - Inches/Centimeters
	n_icis_x = Create(0.0)
	n_icis_y = Create(0.0)
	n_icis_z = Create(0.0)
	
	#Cored
	t_core = Create(0)
	t_fill = Create(0)
	
	t_floor = Create(0)
	t_f_pos = Create(1)
	t_f_neg = Create(0)
	
	#Size Toggle
	t_ois_outer = Create(1)
	t_ois_inner = Create(0)
	
	#Torus Buttons
	t_outside = Create(1)
	t_center = Create(0)
	t_inside = Create(0)

#Size and Location buttons reset
#================================
def sl_reset():
	"""Resets the size and Location number buttons to startup state."""
	global n_mks_x, n_mks_y, n_mks_z, n_fms_x, n_fms_y, n_fms_z, n_ics_x, n_ics_y, n_ics_z,\
	n_mkis_x, n_mkis_y, n_mkis_z, n_fmis_x, n_fmis_y, n_fmis_z, n_icis_x, n_icis_y, n_icis_z,\
	n_mkl_x, n_mkl_y, n_mkl_z, n_fml_x, n_fml_y, n_fml_z, n_icl_x, n_icl_y, n_icl_z
	
	#Number Size - Miles/Kilometers
	n_mks_x = Create(0)
	n_mks_y = Create(0)
	n_mks_z = Create(0)
	#Number Size - Feet/Meters
	n_fms_x = Create(0)
	n_fms_y = Create(0)
	n_fms_z = Create(0)
	#Number Size - Inches/Centimeters
	n_ics_x = Create(0.0)
	n_ics_y = Create(0.0)
	n_ics_z = Create(0.0)
	
	#Number Location - Miles/Kilometers
	n_mkl_x = Create(0)
	n_mkl_y = Create(0)
	n_mkl_z = Create(0)
	#Number Location - Feet/Meters
	n_fml_x = Create(0)
	n_fml_y = Create(0)
	n_fml_z = Create(0)
	#Number Location - Inches/Centimeters
	n_icl_x = Create(0.0)
	n_icl_y = Create(0.0)
	n_icl_z = Create(0.0)
	
	#Number Inner Size - Miles/Kilometers
	n_mkis_x = Create(0)
	n_mkis_y = Create(0)
	n_mkis_z = Create(0)
	#Number Inner Size - Feet/Meters
	n_fmis_x = Create(0)
	n_fmis_y = Create(0)
	n_fmis_z = Create(0)
	#Number Inner Size - Inches/Centimeters
	n_icis_x = Create(0.0)
	n_icis_y = Create(0.0)
	n_icis_z = Create(0.0)


#============================================================================================================
#Main GUI
#============================================================================================================

def main_gui():
	"""The main GUI"""
	global  tb_namemesh, mn_units,\
	t_xaxis, t_yaxis, t_zaxis, o_mn_language, l,\
	t_2d, t_3d, mn_meshtype_2d, mn_meshtype_3d,\
	mn_meshtype_ex, n_segments, n_rings,\
	t_core, t_fill, t_ois_outside, t_ois_inner,\
	t_outside, t_center, t_inside, t_floor,\
	t_f_pos, t_f_neg 
	
	#Backgrounds
	#============
	glClearColor(0.300, 0.300, 0.300, 0.0)#Dark
	glClear(GL_COLOR_BUFFER_BIT)
	glColor3f(0.000, 0.000, 0.000)#Black
	glRecti(0, 1, 286, 462) #BackGround
	glColor3f(0.588, 0.588, 0.588)#Grey
	glRecti(1, 357, 285, 460)#Title
	glRecti(1, 307, 285, 355)#Seg/Rings/Axis/Cal
	glRecti(1, 191, 285, 305)#Size
	glRecti(1, 75, 285, 189) #Location
	glRecti(1, 43, 285, 73)  #Edit
	glRecti(1, 3, 285, 41)   #Create
		
	
	#Images
	#=======
	try:
		image_display(id[0]['I_2d3d_BG'],222,427)
		image_display(id[0]['I_Size_BG'],4,285)
		image_display(id[0]['I_Core_BG'],131,282)
		image_display(id[0]['I_Floor_BG'],160,166)
		if ui.drawType == 2:
			image_display(id[0]['I_C_E_BG'],16,11)
		elif ui.drawType != 2:
			image_display(id[0]['I_C_E_D_BG'],16,11)
	except(NameError):
		pass
		
	#===============
	#Display Labels
	#===============
	
	#Header Labels
	#============== 
	try:
		image_display(id[0]['I_Title_BG'],92,442)
	except(NameError):
		glColor3f(0.000, 0.000, 0.000)
		glRasterPos2d(8, 442)
		Text(ld[l]['T_Title'],'large')#Title
	glColor3f(0.902, 1.000, 0.996)
	glRasterPos2d(8, 412)
	Text(ld[l]['T_M_Type'])#Select Mesh
	glColor3f(0.945, 0.859, 0.847)
	glRasterPos2i(8, 368)
	Text(ld[l]['T_Mea_Unit'])#Units  
	if o_mn_language.val == 1:
		glColor3f(1.000, 1.000, 1.000)
		glRasterPos2d(8, 390)
		Text(ld[l]['T_M_Name'],'small')#Mesh Name
	else:
		glColor3f(1.000, 1.000, 1.000)
		glRasterPos2d(8, 390)
		Text(ld[l]['T_M_Name'])#Mesh Name
	
	#Axis
	#=====
	glColor3f(0.945, 0.859, 0.847)
	glRasterPos2d(180, 339)
	Text(ld[l]['T_Axis'])
	
	#Outer & Inner Labels
	#=====================
	if t_core.val:
		if t_ois_outer.val:
			if o_mn_language.val is 1 or o_mn_language.val is 2:
				glColor3f(0.000, 1.000, 0.000)#0,.8,0
				glRasterPos2d(46, 290)
				Text(ld[l]['T_Outer'],'small')
			else:
				glColor3f(0.000, 1.000, 0.000)#0,.8,0
				glRasterPos2d(40, 290)
				Text(ld[l]['T_Outer'])
		elif t_ois_inner.val:
			if o_mn_language.val is 1 or o_mn_language.val is 2:
				glColor3f(0.800, 0.000, 0.000)
				glRasterPos2d(46, 290)
				Text(ld[l]['T_Inner'],'small')
			else:
				glColor3f(0.800, 0.000, 0.000)
				glRasterPos2d(40, 290)
				Text(ld[l]['T_Inner'])
	
	#Size OI Label
	#==============
	if o_mn_language.val == 1 or o_mn_language.val == 2:
		glColor3f(0.945, 0.859, 0.847)
		glRasterPos2d(8, 290)
		Text(ld[l]['T_Size'],'small')
	else:
		glColor3f(0.945, 0.859, 0.847)
		glRasterPos2d(8, 290)
		Text(ld[l]['T_Size'])
	
	#Location Labels
	#================
	glColor3f(0.945, 0.859, 0.847)
	glRasterPos2d(8, 174)
	Text(ld[l]['T_Loc'])
	if o_mn_language.val == 2: 
		glColor3f(0.863, 0.847, 0.953)
		glRasterPos2d(8, 130)
		Text(ld[l]['T_Loc_X'],'small')
		glRasterPos2d(8, 108)
		Text(ld[l]['T_Loc_Y'],'small')
		glRasterPos2d(8, 86)
		Text(ld[l]['T_Loc_Z'],'small')
	else:
		glColor3f(0.863, 0.847, 0.953)
		glRasterPos2d(8, 130)
		Text(ld[l]['T_Loc_X'])
		glRasterPos2d(8, 108)
		Text(ld[l]['T_Loc_Y'])
		glRasterPos2d(8, 86)
		Text(ld[l]['T_Loc_Z'])
			
	
	#================================
	#Labels, Buttons & Menus Display
	#================================
	
	#Size Labels Change
	#===================
	if t_xaxis.val:
		xaxis_labels()
	elif t_yaxis.val:
		yaxis_labels()
	elif t_zaxis.val:
		zaxis_labels()
		
	#Standard/Metric Text & Number Buttons
	#======================================
	if t_ois_outer.val:
		if mn_units.val == 1:
			o_size_button_states(0,1,1,0.00,11.99,ld[l]['B_N'],ld[l]['B_N'],ld[l]['B_N'])
			location_button_states(1,1,11.99,-1,-1,-11.99,ld[l]['B_N'],ld[l]['B_N'],ld[l]['B_N'])
		elif mn_units.val == 2 or mn_units.val == 5:
			standard_unit_labels()
			o_size_button_states(0,5,5279,0.00,11.99,ld[l]['B_MiS'],ld[l]['B_FS'],ld[l]['B_IS'])
			location_button_states(5,5279,11.99,-5,-5279,-11.99,ld[l]['B_MiL'],ld[l]['B_FL'],ld[l]['B_IL'])	
		elif mn_units.val == 3 or mn_units.val == 4:
			metric_unit_labels()
			o_size_button_states(0,8,999,0.00,99.99,ld[l]['B_KS'],ld[l]['B_MeS'],ld[l]['B_CS'])	
			location_button_states(8,999,99.99,-8,-999,-99.99,ld[l]['B_KL'],ld[l]['B_MeL'],ld[l]['B_CL'])		
	elif t_ois_inner.val:
		if mn_units.val == 1:
			inner_sb_limits(1, 0,0,0.00, 0.00)	
			location_button_states(1,1,11.99,-1,-1,-11.99,ld[l]['B_N'],ld[l]['B_N'],ld[l]['B_N'])
		elif mn_units.val == 2 or mn_units.val == 5:
			standard_unit_labels()
			inner_sb_limits(2, 5,5279,11.99, 11.89)
			location_button_states(5,5279,11.99,-5,-5279,-11.99,ld[l]['B_MiL'],ld[l]['B_FL'],ld[l]['B_IL'])	
		elif mn_units.val == 3 or mn_units.val == 4:
			metric_unit_labels()
			inner_sb_limits(3, 8,999,99.99, 99.89)	
			location_button_states(8,999,99.99,-8,-999,-99.99,ld[l]['B_KL'],ld[l]['B_MeL'],ld[l]['B_CL'])
		
	#Segments & Rings Labels & Buttons Display
	#==========================================
	segments_rings_display()
		
	#Right Triangle Toggle Display
	#==============================	
	r_triangle_display()
	
	
	#=================
	#constant Buttons
	#=================
	
	#Toggle MeshType Buttons
	#========================
	t_2d = Toggle("2D", m2d, 227, 429, 25, 16, t_2d.val, ld[l]['B_2d_T'])
	t_3d = Toggle("3D", m3d, 254, 429, 25, 16, t_3d.val, ld[l]['B_3d_T'])
	
	#Toggle Torus Measurement
	#=========================
	torus_radius_display()
	
	#Mesh Type Menus
	#================
	mesh_menus()
	
	#Name The Mesh Text Box
	#=======================
	name_textbox()
	
	#Units Menu
	#===========
	mn_units = Menu(ld[l]['B_Units_Menu'], munits, 148, 363, 130, 16, mn_units.val, ld[l]['B_Units_Menu_T'])
	
	#Toggle Axis Buttons
	#====================
	t_xaxis = Toggle("X", mxaxis, 214, 334, 20, 16, t_xaxis.val, ld[l]['B_Axis_X_T'])
	t_yaxis = Toggle("Y", myaxis, 236, 334, 20, 16, t_yaxis.val, ld[l]['B_Axis_Y_T'])
	t_zaxis = Toggle("Z", mzaxis, 258, 334, 20, 16, t_zaxis.val, ld[l]['B_Axis_Z_T']) 
	
	#Toggle Size Buttons
	#====================
	ois_display()
	
	#Toggle Floor
	#=============
	floor_toggle_display()
		
	#Calculate Button
	#=================
	bt_calculator = PushButton(ld[l]['B_Cal_D'], mcalgng, 112, 51, 64, 16, ld[l]['B_Cal_T'])
	
	#Reset SLB Button
	#=================
	bt_sl_reset = PushButton(ld[l]['B_SL_R'], msl_reset, 206, 51, 60, 16, ld[l]['B_SL_R_T'])
		
	#Reset All Button
	#=================
	bt_reset = PushButton(ld[l]['B_Reset_D'], mreset, 114, 15, 60, 16, ld[l]['B_Reset_T'])
	
	#Create Button
	#==============
	bt_create = PushButton(ld[l]['B_Create_D'], mcreate, 20, 15, 60, 16, ld[l]['B_Create_T'])
	
	#Options Button
	#===============
	bt_options = PushButton(ld[l]['B_Options'], moptions, 20, 51, 60, 16, ld[l]['B_Options_T'])
	
	#Exit Button
	#============
	bt_exit = PushButton(ld[l]['B_Exit_D'], mexit, 206, 15, 60, 16, ld[l]['B_Exit_T'])
	
	

#############################################################################################################
#Main Events Section                                                                                        #
#############################################################################################################

def main_event(evt, val):
	if (evt == QKEY and not val): pass
		
def main_bevent(evt):
	"""Handles the main button events"""
	
	#Right Triangle Toggle Display
	#==============================
	if evt == mbl:
		r_triangle_states(1,0,0,0)
	if evt == mbr:
		r_triangle_states(0,1,0,0)
	if evt == mtl:
		r_triangle_states(0,0,1,0)
	if evt == mtr:
		r_triangle_states(0,0,0,1)
		
	#Meshtype Toggle
	#===============
	if evt == m2d:
		meshtype_menu_states(1,0)
		Window.Redraw()
	if evt == m3d:
		meshtype_menu_states(0,1)
		Window.Redraw()
		
	#Meshtype menu selection
	#========================
	if evt == mmeshtype_2d:
		t_core.val = 0
		t_ois_outer.val = 1
		t_ois_inner.val = 0
		t_floor.val = 0
	if evt == mmeshtype_3d:
		t_core.val = 0
		t_ois_outer.val = 1
		t_ois_inner.val = 0
		t_floor.val = 0
	
	#Axis Toggle
	#============
	if evt == mxaxis:
		axis_states(1,0,0)
	if evt == myaxis:
		axis_states(0,1,0)
	if evt == mzaxis:
		axis_states(0,0,1)
		
	#Core Toggle
	#============
	if evt == m_core:
		t_ois_outer.val = 1
		t_ois_inner.val = 0
		
	#Outer/Inner Toggle
	#============
	if evt == mois_outer:
		ois_states(1,0)
	if evt == mois_inner:
		ois_filter()
		
	#Floor Toggle
	#=============
	if evt == m_floor:
		t_f_pos.val = 1
		t_f_neg.val = 0
	
	#Floor +/- toggle
	#=================
	if evt == mf_pos:
		floor_axis_states(1,0)
	if evt == mf_neg:
		floor_axis_states(0,1)
	
	#Torus Toggle
	#=============
	if evt == moutside:
		torus_radius_states(1,0,0)
	if evt == mcenter:
		torus_radius_states(0,1,0)
	if evt == minside:
		torus_radius_states(0,0,1)
		
	#Calculator Warning
	#===================
	if evt == mcalgng:
		cal_reg()	
		
	#Reset Warning & Functions
	#=========================	
	#sl
	if evt == msl_reset:
		reset_sl_warning()
		ois_states(1,0)	
		t_f_pos.val = 1
		t_f_neg.val = 0
	#all
	if evt == mreset:
		reset_warning()
		
	#Options selection
	#==================
	if evt == moptions:
		o_reg()
		
	#Exit Warning & Function
	#========================
	if evt == mexit: 
		exit_warning()


	#==============
	#Create Button
	#==============		
	if evt == mcreate:             
		Window.WaitCursor(1)

		#Selection and Unit check
		#=========================
		if mn_meshtype_2d.val == 0:    #No Selection
			selection_filter_2d()
		if mn_meshtype_3d.val == 0:    #No Selection
			selection_filter_3d()
		if mn_units.val <= 1:  		   #No Units
			Blender.Draw.PupMenu(ld[l]['UE - No Unit'])
			return		
		              
		#Size and Location buttons values
		#=================================
		o_size_buttons() 
		i_size_buttons()
		location_buttons()
		
		#Set the axis
		#=============
		set_axis()
		
		#Set the floor
		#==============
		set_floor()
		
		#Set the measurements
		#=====================
		bc.Measure(mn_units.val,o_n_scale.val, o_s_b,l_b,i_s_b, floor_pn,t_core.val)
		
		#filter trigger values
		#======================
		filter_trigger_values_o()
		filter_trigger_values_i()
		
		#2d	Meshes
		#==========
		if t_2d.val == 1 and t_zaxis.val == 1:
			if xo == 0 or yo == 0:
				Blender.Draw.PupMenu(ld[l]['No_OVal_W'])
				return 
			elif t_core.val:
				if xi == 0 or yi == 0:
					Blender.Draw.PupMenu(ld[l]['No_IVal_W'])
					return
		if t_2d.val == 1 and t_yaxis.val == 1:
			if xo == 0 or zo == 0:
				Blender.Draw.PupMenu(ld[l]['No_OVal_W'])
				return
			elif t_core.val:
				if xi == 0 or zi == 0:
					Blender.Draw.PupMenu(ld[l]['No_IVal_W'])
					return	
		if t_2d.val == 1 and t_xaxis.val == 1:
			if yo == 0 or zo == 0:
				Blender.Draw.PupMenu(ld[l]['No_OVal_W'])
				return
			elif t_core.val:
				if yi == 0 or zi == 0:
					Blender.Draw.PupMenu(ld[l]['No_IVal_W'])
					return               
		if t_2d.val >= 1:
			if mn_meshtype_2d.val == 2:      #Plane
				set_name("Plane") 
				bc.PlaneMesh(1,ax,o_t_editmode.val,t_core.val,name,o_t_flip_y.val).create()
				
			elif mn_meshtype_2d.val == 3:    #Circle
				set_name("Circle")
				bc.CircleMesh(n_segments.val,1,ax,o_t_editmode.val,name).create()
				
			elif mn_meshtype_2d.val == 4:    #Disc
				set_name("Disc")
				bc.DiscMesh(n_segments.val,1,ax,o_t_editmode.val,t_core.val,name,o_t_flip_y.val).create()
				
			elif mn_meshtype_2d.val == 5:    #Triangle
				set_name("Triangle")
				bc.TriangleMesh(1,ax,o_t_editmode.val,t_core.val,name,o_t_flip_y.val).create()
				
			elif mn_meshtype_2d.val == 6:    #Right Triangle
				set_name("Right Triangle")
				rtriangle_def()
				bc.RightTriangleMesh(1,ax,o_t_editmode.val,t_core.val,rt_d,name,o_t_flip_y.val,1).create()
		
		#3d Meshes
		#==========
		if t_3d.val == 1:
			if xo == 0 or yo == 0 or zo == 0:
				Blender.Draw.PupMenu(ld[l]['No_OVal_W'])
				return
			elif t_core.val:
				if xi == 0 or yi == 0 or zi == 0:
					Blender.Draw.PupMenu(ld[l]['No_IVal_W'])
					return
		if t_3d.val >= 1:
			if mn_meshtype_3d.val == 2:      #Cube
				set_name("Cube")
				bc.CubeMesh(1,ax,o_t_editmode.val,t_core.val,t_fill.val,name).create()
				
			elif mn_meshtype_3d.val == 3:    #Tube
				set_name("Tube")
				bc.TubeMesh(n_segments.val,0,ax,o_t_editmode.val,name).create()
				
			elif mn_meshtype_3d.val == 4:    #Cylinder
				set_name("Cylinder")
				bc.CylinderMesh(n_segments.val,1,ax,o_t_editmode.val,t_core.val,t_fill.val,name).create()
				
			elif mn_meshtype_3d.val == 5:    #Triangle 3d
				set_name("Triangle")
				bc.Triangle3dMesh(1,ax,o_t_editmode.val,t_core.val,t_fill.val,name).create()
				
			elif mn_meshtype_3d.val == 6:    #Right Triangle 3d
				set_name("Right Triangle")
				rtriangle_def()
				bc.RightTriangle3dMesh(1,ax,o_t_editmode.val,t_core.val,t_fill.val,rt_d,name,o_t_flip_y.val,1).create()
				
			elif mn_meshtype_3d.val == 7:    #Tetrahedron
				set_name("Tetrahedron")
				bc.TetrahedronMesh(1,ax,o_t_editmode.val,name).create()
				
			elif mn_meshtype_3d.val == 8:     #Pyramid
				set_name("Pyramid")
				bc.PyramidMesh(1,ax,o_t_editmode.val,name).create()
				
			elif mn_meshtype_3d.val == 9:	  #Diamond (Rhombus)
				set_name("Diamond")
				bc.DiamondMesh(1,ax,o_t_editmode.val,name).create()
					
			elif mn_meshtype_3d.val == 10:    #Cone
				set_name("Cone")
				bc.ConeMesh(n_segments.val,0,ax,o_t_editmode.val,name).create()
				
			elif mn_meshtype_3d.val == 11:    #Sphere
				set_name("Sphere")
				bc.SphereMesh(n_segments.val,n_rings.val,0,ax,o_t_editmode.val,name).create()
				
			elif mn_meshtype_3d.val == 12:    #Torus 
				set_name("Torus")
				torus_def()
				if t_r == 0:#Outside
					mp = 2.5
				elif t_r == 1:#Center
					mp = 2
				elif t_r == 2:#Inside
					mp = 1.5
				bc.TorusMesh(mp, n_segments.val,n_rings.val,0,ax,o_t_editmode.val,name).create()
			
		Window.WaitCursor(0)
	
	
	#Redraw interface
	#=================	
	Window.RedrawAll()
	
	

#############################################################################################################
#Register the Main Interface                                                                                #
#############################################################################################################
startup_reset()
Register(main_gui,main_event,main_bevent)

#																																	 #
#																																	 #
#End of Main                        																								 #                                                                       
######################################################################################################################################

		
######################################################################################################################################
#Beginning of Options Section                                                                                                        #
#																																	 #
#																																	 #


#############################################################################################################
#Register the Options Interface                                                                             #
#############################################################################################################
def o_reg():
	"""Sets the initial state of the Option GUI and for the reset button."""
	try:
		o_startup()
		Register(o_gui,o_event,o_bevent)
	except(IOError, NameError):
		Blender.Draw.PupMenu(ld[l]['Op_Load1_W'])
		print
		print "------------------------------------------"
		print ld[l]['Op_Load_W_T1']
		print ld[l]['Op_Load_W_T2']
		print ld[l]['Op_Load_W_T3']
		print
	


#############################################################################################################
#Events Section                                                                                             #
#############################################################################################################

o_msave      = 59
o_msave      = 60
o_mback      = 61
o_mlanguage  = 62
o_munits     = 63
o_mscale     = 64
o_meditmode  = 65
o_mflip_y    = 66
	
	
#============================================================================================================		
#Save Settings	
#============================================================================================================

def o_save():
	"""Save user defined load settings."""
	global o_mn_language, o_mn_units, o_in, o_t_scale, o_t_editmode, o_t_flip_y
	try:
		#assign and format
		language  = int(o_mn_language.val)
		unit      = int(o_mn_units.val)
		scale     = float(o_n_scale.val)
		editmode  = int(o_t_editmode.val)
		flip_y    = int(o_t_flip_y.val)
		settings  = [language, unit, scale, editmode, flip_y]
		settings_list = [(str(item) + '\n') for item in settings]
		#Save Settings
		BMAE_File = open(os.path.join(dir,'BMAE.bsf'),'w')
		BMAE_File.writelines(settings_list)	
		BMAE_File.close	
		#Save Popup
		Blender.Draw.PupMenu(ld[l]['Op_Save_W'])
	except(IOError, EOFError):
		Blender.Draw.PupMenu(ld[l]['Op_Load_W'])
	
		
		
		
#############################################################################################################
#GUI Section                                                                                                #
#############################################################################################################
		
#Startup (Load)
#===============
def o_startup():
	"""Startup and reset states of the Options panel."""
	global o_mn_language, o_mn_units, o_t_save,\
		   o_n_scale, o_t_editmode, o_t_flip_y
	o_bt_back       = Create(0)
	o_bt_save       = Create(0)
	o_mn_language 	= Create(int(settings[0]))
	o_mn_units    	= Create(int(settings[1]))
	o_n_scale       = Create(float(settings[2]))
	o_t_editmode    = Create(int(settings[3]))
	o_t_flip_y      = Create(int(settings[4]))

#Edit Mode Toggle State & warning  
#=================================
def editmode_state():
	"""Diplays the Edit Mode on or off popup."""
	global o_t_editmode
	editmodes = Blender.Draw.PupMenu(ld[l]['EMode_Sel'])
	if editmodes == 1:
		o_t_editmode.val = 1
	elif editmodes == 0:
		o_t_editmode.val = 0

#Flip Y
#=========
def o_flip_y_mode():
	"""Diplays the Flip Y Mode on or off popup."""
	global o_t_flip_y
	flip_y = Blender.Draw.PupMenu(ld[l]['B_Op_YFlip_W'])
	if flip_y == 1:
		o_t_flip_y.val = 1#Front
	elif flip_y == 0:
		o_t_flip_y.val = 0#Back


#============================================================================================================		
#GUI	
#============================================================================================================
def o_gui():
	"""Main GUI"""
	global o_mn_language, o_mn_units, o_t_save,\
	 	   o_t_editmode, o_t_flip_y, o_n_scale, l
	
	#Background
	#============
	glClearColor(0.300, 0.300, 0.300, 0.0)#Dark
	glClear(GL_COLOR_BUFFER_BIT)
	glColor3f(0.000, 0.000, 0.000)#Black
	glRecti(0, 1, 286, 462) 	  #BackGround
	glColor3f(0.588, 0.588, 0.588)#Grey
	glRecti(1, 420, 285, 460)	  #Title 357
	glRecti(1, 388, 285, 418)	  #Settings
	glRecti(1, 285, 285, 386)	  #Language
	glRecti(1, 181, 285, 283)	  #Unit
	glRecti(1, 75, 285, 179) 	  #Theme
	glRecti(1, 43, 138, 73)  	  #Confirmation
	glRecti(140, 43, 285, 73) 
	glRecti(1, 3, 285, 41)   	  #Create
	
	try:
		image_display(id[0]['I_Title_BG'],92,442)
	except(NameError):
		glColor3f(0.000, 0.000, 0.000)
		glRasterPos2d(8, 442)
		Text(ld[l]['T_Title'],'large')#Title
	glRasterPos2d(120, 400)
	Text(ld[l]['T_Op_Settings'])
	glColor3f(0.945, 0.859, 0.847)
	#Language
	glRasterPos2d(8, 370)
	Text(ld[l]['T_Op_Language'])
	#Unit
	glRasterPos2d(8, 267)
	Text(ld[l]['T_Op_Unit'])
	#Scale
	glRasterPos2d(8, 163)
	Text(ld[l]['B_Mesh_Size_D'])
	
	#Edit Mode Label
	#================
	if o_mn_language.val == 0:
		glColor3f(0.945, 0.859, 0.847)
		glRasterPos2i(8, 56)
		Text(ld[l]['T_Draw_Type'])
	else:
		glColor3f(0.945, 0.859, 0.847)
		glRasterPos2i(4, 56)
		Text(ld[l]['T_Draw_Type'],'small')
		
	#Flip Y Label
	#=============
	if o_mn_language.val == 1 or o_mn_language.val == 2:
		glColor3f(0.945, 0.859, 0.847)
		glRasterPos2i(150, 56)
		Text(ld[l]['T_Op_YDir'],'small')
	else:
		glColor3f(0.945, 0.859, 0.847)
		glRasterPos2i(150, 56)
		Text(ld[l]['T_Op_YDir'])
		
	#Language Selection
	#===================	
	o_mn_language = Menu("|Language %t|English %x0|Espanol %x1|Francais %x2|Italiano %x3", o_mlanguage,\
	 110, 328, 65, 16, o_mn_language.val, ld[l]['B_Op_Lang_T'])

	l = int(o_mn_language.val)
		
	#Units Menu
	#===========
	o_mn_units = Menu(ld[l]['B_Op_Units_Menu'], o_munits, 77, 225, 130, 16, o_mn_units.val, ld[l]['B_Op_Units_Menu_T'])
	
	#Save Settings
	#==============
	o_bt_save = PushButton(ld[l]['B_Op_Save'], o_msave, 20, 15, 60, 16, ld[l]['B_Op_Save_T'])
	
	#Back to Main Program
	#=====================
	o_bt_back = PushButton(ld[l]['CalOp_Back_D'], o_mback, 206, 15, 60, 16, ld[l]['CalOp_Back_T'])

	#Edit mode toggle    
	#=================
	o_t_editmode = Toggle(ld[l]['B_EMode_D'], o_meditmode, 84, 51, 40, 16, o_t_editmode.val, ld[l]['B_EMode_T'])

	#scale toggle 
	#=============
	o_n_scale = Number('', o_mscale, 110, 115, 65, 16, o_n_scale.val, 0.1, 100.00, ld[l]['B_Mesh_Size_T'])  
	
	#flip_y mode toggle    
	#===================
	o_t_flip_y = Toggle(ld[l]['B_EMode_D'], o_mflip_y, 232, 51, 40, 16, o_t_flip_y.val, ld[l]['B_Op_YDir_T'])
	


#############################################################################################################
#Options Events Section                                                                                     #
#############################################################################################################
	
def o_event(evt, val):
	if (evt == QKEY and not val): pass
	
	
def o_bevent(evt):
	"""Handles the Options button events"""	
	
	#EditMode Display & Function   
	#============================	
	if evt == o_meditmode:
		editmode_state()
				
	if evt == o_mlanguage:
		Window.Redraw()
				
	#Save settings
	#==============
	if evt == o_msave:
		o_save()
		
	if evt == o_mflip_y:
		o_flip_y_mode()
			
	#Back to main
	#=============	
	if evt == o_mback: 
		Register(main_gui,main_event,main_bevent)
	
		
	Window.RedrawAll()
			

#																																	 #
#																																	 #
#End of Options Section                        																					     #                                                                       
######################################################################################################################################


######################################################################################################################################
#Beginning of Calculator Section                                                                                                     #
#																																	 #
#																																	 #


#############################################################################################################
#Events Section                                                                                             #
#############################################################################################################

c_mback			= 67        
c_mcal_fd		= 68
c_mcal_du		= 69
c_mreset		= 70
	
c_mfractions	= 71
c_mmetricdec	= 72
	
c_mnumerator	= 73
c_mdenominator	= 74
	
c_minchesdec	= 75



#############################################################################################################
#Calculator Int & Reset                                                                                     #
#############################################################################################################
def c_startup_reset():
	"""Startup and reset states of the Calculator panel."""
	global c_bt_back,c_bt_cal_fd,c_bt_cal_du,c_bt_reset,\
	c_mn_fractions,c_mn_metricdec,c_n_numerator,c_n_denominator,\
	c_n_inchesdec,decr,inr
	
	c_bt_back		  = Create(0)
	c_bt_cal_fd       = Create(0)
	c_bt_cal_du       = Create(0)
	c_bt_reset        = Create(0)
	
	c_mn_fractions    = Create(1)
	c_mn_metricdec    = Create(1)
	
	c_n_numerator     = Create(1)
	c_n_denominator   = Create(1)
	
	c_n_inchesdec     = Create(0.0)
	
	decr 			   = 0.00
	inr     		   = 0.00


#############################################################################################################
#Calculator Functions                                                                                       #
#############################################################################################################
def c_fraction_to_decimal():
	"""Converts the fraction to a decimal"""
	global dec, decr
	getcontext().prec = 3
	decr = Decimal(str(c_n_numerator.val)) / Decimal(str(c_n_denominator.val))
		
def c_decimal_to_inches():
	"""Converts from a decimal to inches"""
	global inc, inr
	getcontext().prec = 3
	inr = Decimal(str(c_n_inchesdec.val)) * 12
	

				
#############################################################################################################	
#Calculator GUI                                                                                             #
#############################################################################################################


#============================================================================================================
#Register The Interface
#============================================================================================================	
def cal_reg():
	"""Handles the initial Calculator GUI and the Reset button."""
	c_startup_reset()
	Register(c_gui, c_event, c_bevent)


#============================================================================================================
#Ledger Menu Text
#============================================================================================================

#Standard
#=========
def c_staled_4():
	"""Displays the 4ths Ledger text."""
	glColor3f(0.000, 0.000, 0.000)
	glRasterPos2d(38, 330)
	Text("1/4 = 0.25")
	glRasterPos2d(38, 314)
	Text("3/4 = 0.75")											
		
def c_staled_8():
	"""Displays the 8ths Ledger text."""
	glColor3f(0.000, 0.000, 0.000)
	glRasterPos2d(38, 330)
	Text("1/8 = 0.13")
	glRasterPos2d(38, 314)
	Text("3/8 = 0.38")
	glRasterPos2d(38, 298)
	Text("5/8 = 0.63")
	glRasterPos2d(38, 282)
	Text("7/8 = 0.88")
		
def c_staled_16():
	"""Displays the 16ths Ledger text."""
	glColor3f(0.000, 0.000, 0.000)
	glRasterPos2d(38, 330)
	Text("1/16 = 0.06")
	glRasterPos2d(38, 314)
	Text("3/16 = 0.19")
	glRasterPos2d(38, 298)
	Text("5/16 = 0.31")
	glRasterPos2d(38, 282)
	Text("7/16 = 0.44")
	glRasterPos2d(38, 266)
	Text("9/16 = 0.56")
	glRasterPos2d(31, 250)
	Text("11/16 = 0.69")
	glRasterPos2d(31, 234)
	Text("13/16 = 0.81")
	glRasterPos2d(31, 218)
	Text("15/16 = 0.94")
	
#Metric
#=======
def c_metled_deci():
	"""Displays the Decimeters Ledger text."""
	glColor3f(0.000, 0.000, 0.000)
	glRasterPos2d(164, 330)
	Text("1" + ld[l]['Cal_Deci_T'] + "= 10.00")
	glRasterPos2d(158, 314)
	Text("2" + ld[l]['Cal_Decis_T'] + "= 20.00")	
	glRasterPos2d(158, 298)
	Text("3" + ld[l]['Cal_Decis_T'] + "= 30.00")	
	glRasterPos2d(158, 282)
	Text("4" + ld[l]['Cal_Decis_T'] + "= 40.00")
	glRasterPos2d(158, 266)
	Text("5" + ld[l]['Cal_Decis_T'] + "= 50.00")	
	glRasterPos2d(158, 250)
	Text("6" + ld[l]['Cal_Decis_T'] + "= 60.00")
	glRasterPos2d(158, 234)
	Text("7" + ld[l]['Cal_Decis_T'] + "= 70.00")
	glRasterPos2d(158, 218)
	Text("8" + ld[l]['Cal_Decis_T'] + "= 80.00")	
	glRasterPos2d(158, 202)
	Text("9" + ld[l]['Cal_Decis_T'] + "= 90.00")			

def c_metled_cent():
	"""Displays the Centimeters Ledger text."""
	glColor3f(0.000, 0.000, 0.000)
	glRasterPos2d(164, 330)
	Text("1" + ld[l]['Cal_Centi_T'] + "= 1.00")
	glRasterPos2d(158, 314)
	Text("2" + ld[l]['Cal_Centis_T'] + "= 2.00")	
	glRasterPos2d(158, 298)
	Text("3" + ld[l]['Cal_Centis_T'] + "= 3.00")	
	glRasterPos2d(158, 282)
	Text("4" + ld[l]['Cal_Centis_T'] + "= 4.00")
	glRasterPos2d(158, 266)
	Text("5" + ld[l]['Cal_Centis_T'] + "= 5.00")	
	glRasterPos2d(158, 250)
	Text("6" + ld[l]['Cal_Centis_T'] + "= 6.00")
	glRasterPos2d(158, 234)
	Text("7" + ld[l]['Cal_Centis_T'] + "= 7.00")
	glRasterPos2d(158, 218)
	Text("8" + ld[l]['Cal_Centis_T'] + "= 8.00")	
	glRasterPos2d(158, 202)
	Text("9" + ld[l]['Cal_Centis_T'] + "= 9.00")

def c_metled_mil():
	"""Displays the Millimeters Ledger text."""
	glColor3f(0.000, 0.000, 0.000)
	glRasterPos2d(164, 330)
	Text("1" + ld[l]['Cal_Milli_T'] + "= 0.10")	
	glRasterPos2d(158, 314)
	Text("2" + ld[l]['Cal_Millis_T'] + "= 0.20")	
	glRasterPos2d(158, 298)
	Text("3" + ld[l]['Cal_Millis_T'] + "= 0.30")	
	glRasterPos2d(158, 282)
	Text("4" + ld[l]['Cal_Millis_T'] + "= 0.40")
	glRasterPos2d(158, 266)
	Text("5" + ld[l]['Cal_Millis_T'] + "= 0.50")	
	glRasterPos2d(158, 250)
	Text("6" + ld[l]['Cal_Millis_T'] + "= 0.60")
	glRasterPos2d(158, 234)
	Text("7" + ld[l]['Cal_Millis_T'] + "= 0.70")
	glRasterPos2d(158, 218)
	Text("8" + ld[l]['Cal_Millis_T'] + "= 0.80")	
	glRasterPos2d(158, 202)
	Text("9" + ld[l]['Cal_Millis_T'] + "= 0.90")	

	
#============================================================================================================
#Reset Button Warning Display
#============================================================================================================
def c_reset_warning():
	"""Displays the Reset proceed or stop popup."""
	reset = Blender.Draw.PupMenu(ld[l]['Cal_Reset_W'])
	if reset == 1:
		c_startup_reset()
	elif reset == 0:
		return


#============================================================================================================
#Main Calculator Draw
#============================================================================================================
def c_gui():
	"""The Calculator GUI"""
	global c_bt_back,c_bt_cal_fd,c_bt_cal_du,c_bt_reset,\
	c_mn_fractions,c_mn_metricdec,c_n_numerator,c_n_denominator,\
	c_n_inchesdec

	glClearColor(0.300, 0.300, 0.300, 0.0)
	glClear(GL_COLOR_BUFFER_BIT)
	glColor3f(0.000, 0.000, 0.000)
	glRecti(0, 1, 286, 462)
	glColor3f(0.588, 0.588, 0.588)
	glRecti(1, 420, 285, 460)   #Title
	glRecti(1, 388, 285, 418)   #Ledger
	glRecti(1, 192, 142, 386)   #Standard
	glRecti(144, 192, 285, 386) #Metric
	glRecti(1, 115, 285, 190)   #Fraction to Decimal Input
	glRecti(1, 43, 285, 113)    #Decimal to Unit Input
	glRecti(1, 3, 285, 41)      #Calculate
	
	#Black Text
	#===========
	try:
		image_display(id[0]['I_Title_BG'],92,442)
	except(NameError):
		glColor3f(0.000, 0.000, 0.000)
		glRasterPos2d(8, 442)
		Text(ld[l]['T_Title'],'large')#Title
	glRasterPos2d(122, 400)
	Text(ld[l]['Cal_T_Ledger'])	
	glRasterPos2d(41, 140)
	Text("----",'large')
	glRasterPos2d(84, 141)
	Text("=",'large')
	glRasterPos2d(95, 70)#100
	Text("=",'large')
	
	#Pastel Text
	#============
	glColor3f(0.945, 0.859, 0.847)
	glRasterPos2d(5, 175)
	Text(ld[l]['Cal_T_FTD'])
	glRasterPos2d(5, 98)
	Text(ld[l]['Cal_T_DTI'])
	if o_mn_language.val is 1:
		glRasterPos2d(16, 370)
		Text(ld[l]['Cal_T_USS'])
		glRasterPos2d(196, 370)
		Text(ld[l]['Cal_T_Metric'])
	elif o_mn_language.val is 2:
		glRasterPos2d(8, 370)
		Text(ld[l]['Cal_T_USS'],'small')
		glRasterPos2d(196, 370)
		Text(ld[l]['Cal_T_Metric'])		
	else:
		glRasterPos2d(34, 370)
		Text(ld[l]['Cal_T_USS'])
		glRasterPos2d(198, 370)
		Text(ld[l]['Cal_T_Metric'])		
	
	#White Text	
	#===========
	glColor3f(0.902, 1.000, 0.996)
	glRasterPos2d(18, 153)
	Text(ld[l]['Cal_T_N'])
	glRasterPos2d(18, 127)
	Text(ld[l]['Cal_T_D'])
	glRasterPos2d(99, 142)
	Text(ld[l]['Cal_T_Dec'])
	glRasterPos2d(18, 70)
	Text(ld[l]['Cal_T_D'])
	glRasterPos2d(106, 70)#115
	Text(ld[l]['Cal_T_In'])

	#Aqua Text
	#==========		
	glColor3f(0.502, 1.000, 1.000)
	glRasterPos2d(166, 142)#152
	Text("%.2f" % decr)
	glRasterPos2d(165, 70)#160
	Text("%.2f" % inr)
	
	#Ledger Text
	#============
	if c_mn_metricdec.val == 2:#Millimeters
		c_metled_mil()
	elif c_mn_metricdec.val == 3:#Centimeters
		c_metled_cent()	
	elif c_mn_metricdec.val == 4:#Decimeters
		c_metled_deci()

	if c_mn_fractions.val == 2:#16ths
		c_staled_16()
	elif c_mn_fractions.val == 3:#8ths
		c_staled_8()
	elif c_mn_fractions.val == 4:#4ths
		c_staled_4()
	
	
	#=================
	#Constant Buttons
	#=================	
	c_bt_back = PushButton(ld[l]['CalOp_Back_D'], c_mback, 206, 14, 60, 16, ld[l]['CalOp_Back_T'])
	c_bt_cal_fd = PushButton(ld[l]['Cal_Calc_D'], c_mcal_fd, 206, 138, 60, 16, ld[l]['Cal_Calc_TD_T'])
	c_bt_cal_du = PushButton(ld[l]['Cal_Calc_D'], c_mcal_du, 206, 66, 60, 16, ld[l]['Cal_Calc_FD_T'])
	c_bt_reset = PushButton(ld[l]['Cal_Reset_D'], c_mreset, 20, 14, 60, 16, ld[l]['Cal_Reset_T'])
	
	
	c_mn_fractions = Menu(ld[l]['Cal_USM_D'], c_mfractions, 24, 345, 90, 16, c_mn_fractions.val, ld[l]['Cal_USM_T'])	
	c_mn_metricdec = Menu(ld[l]['Cal_MetM_D'], c_mmetricdec, 170, 345, 90, 16, c_mn_metricdec.val, ld[l]['Cal_MetM_T'])
	
	
	c_n_numerator = Number("", c_mnumerator, 36, 149, 40, 16, c_n_numerator.val, 1, 64, ld[l]['Cal_N_T'])
	c_n_denominator = Number("", c_mdenominator, 36, 123, 40, 16, c_n_denominator.val, 1, 64, ld[l]['Cal_D_T'])

	c_n_inchesdec = Number("", c_minchesdec, 36, 66, 55, 16, c_n_inchesdec.val, 0, 1, ld[l]['Cal_Dec_T'])

	

################
#Events Section#
################
def c_event(evt, val):
	if (evt == QKEY and not val): pass
		
def c_bevent(evt):
	"""Handles the Calculator button events"""
	#Fraction to decimal
	#====================
	if evt == c_mcal_fd: 
		c_fraction_to_decimal()
		
	#Decimal to inches
	#==================
	if evt == c_mcal_du: 
		c_decimal_to_inches()
	
	#Reset
	#======
	if evt == c_mreset:
		c_reset_warning()
		
	#Back
	#=====
	if evt == c_mback: #bnBack
		Register(main_gui,main_event,main_bevent)
		

	#Update View
	#============
	Window.Redraw()

#																																	 #
#																																	 #
#End of Calculator Section                        																					 #                                                                       
######################################################################################################################################