/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.test;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.batik.test.Messages;
import org.apache.batik.test.Test;
import org.apache.batik.test.TestReport;
import org.apache.batik.test.TestSuite;
import org.apache.batik.test.TestSuiteReport;

public class DefaultTestSuiteReport
implements TestSuiteReport {
    public static final String ERROR_CHILD_TEST_FAILED = "DefaultTestSuiteReport.error.child.test.failed";
    public static final String ENTRY_KEY_FAILED_CHILD_TEST_REPORT = "DefaultTestSuiteReport.entry.key.failed.child.test.report";
    public static final String ENTRY_KEY_PASSED_CHILD_TEST_REPORT = "DefaultTestSuiteReport.entry.key.passed.child.test.report";
    protected List reports = new ArrayList();
    protected TestSuite testSuite;
    protected TestReport.Entry[] description;
    protected TestSuiteReport parent;

    public DefaultTestSuiteReport(TestSuite testSuite) {
        if (testSuite == null) {
            throw new IllegalArgumentException();
        }
        this.testSuite = testSuite;
    }

    @Override
    public Test getTest() {
        return this.testSuite;
    }

    @Override
    public String getErrorCode() {
        if (this.hasPassed()) {
            return null;
        }
        return ERROR_CHILD_TEST_FAILED;
    }

    @Override
    public TestSuiteReport getParentReport() {
        return this.parent;
    }

    @Override
    public void setParentReport(TestSuiteReport parent) {
        this.parent = parent;
    }

    @Override
    public boolean hasPassed() {
        Iterator iter = this.reports.iterator();
        boolean passed = true;
        while (iter.hasNext()) {
            TestReport childReport = (TestReport)iter.next();
            passed = passed && childReport.hasPassed();
        }
        return passed;
    }

    @Override
    public void addDescriptionEntry(String key, Object value) {
        this.addDescriptionEntry(new TestReport.Entry(key, value));
    }

    protected void addDescriptionEntry(TestReport.Entry entry) {
        if (this.description == null) {
            this.description = new TestReport.Entry[1];
            this.description[0] = entry;
        } else {
            TestReport.Entry[] oldDescription = this.description;
            this.description = new TestReport.Entry[this.description.length + 1];
            System.arraycopy(oldDescription, 0, this.description, 0, oldDescription.length);
            this.description[oldDescription.length] = entry;
        }
    }

    @Override
    public TestReport.Entry[] getDescription() {
        TestReport.Entry entry;
        Iterator iter = this.reports.iterator();
        ArrayList<TestReport.Entry> descs = new ArrayList<TestReport.Entry>();
        while (iter.hasNext()) {
            TestReport childReport = (TestReport)iter.next();
            if (childReport.hasPassed()) continue;
            entry = new TestReport.Entry(Messages.formatMessage(ENTRY_KEY_FAILED_CHILD_TEST_REPORT, null), childReport);
            descs.add(entry);
        }
        for (TestReport childReport : this.reports) {
            if (!childReport.hasPassed()) continue;
            entry = new TestReport.Entry(Messages.formatMessage(ENTRY_KEY_PASSED_CHILD_TEST_REPORT, null), childReport);
            descs.add(entry);
        }
        TestReport.Entry[] entries = null;
        if (descs.size() > 0) {
            entries = new TestReport.Entry[descs.size()];
            descs.toArray(entries);
        }
        if (this.description != null) {
            TestReport.Entry[] e = entries;
            entries = new TestReport.Entry[e.length + this.description.length];
            System.arraycopy(e, 0, entries, 0, e.length);
            System.arraycopy(this.description, 0, entries, e.length, this.description.length);
        }
        return entries;
    }

    public void addReport(TestReport report) {
        if (report == null) {
            throw new IllegalArgumentException();
        }
        report.setParentReport(this);
        this.reports.add(report);
    }

    @Override
    public TestReport[] getChildrenReports() {
        int nReports = this.reports.size();
        TestReport[] r = new TestReport[nReports];
        this.reports.toArray(r);
        return r;
    }
}

