package org.apache.texen;

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.    
 */

import java.io.File;

import org.apache.texen.test.Log;
import org.apache.texen.test.TestUtil;

import junit.framework.TestCase;
import junit.framework.TestSuite;



/**
 * This is a test case for Texen. Simply executes a simple
 * generative task and compares the output.
 *
 * @author <a href="mailto:jvanzyl@apache.org">Jason van Zyl</a>
 * @version $Id: TexenTestCase.java 525422 2007-04-04 05:54:17Z wglass $
 */
public class TexenTestCase extends TestCase
{
    public static final String TEST_DIR_KEY = "test.compare.dir";
    public static final String RESULTS_DIR_KEY = "test.results.dir";
    
    private String resultsDir;
    private String compareDir;

    /**
     * Creates a new instance.
     *
     */
    public TexenTestCase(String name)
    {
        super(name);
    }

    public static junit.framework.Test suite()
    {
        return new TestSuite(TexenTestCase.class);
    }

    /**
     * Find the directories.
     */
    public void setUp()
    {
        resultsDir = System.getProperty(RESULTS_DIR_KEY, "bin/test") + "/texen";
        compareDir = System.getProperty(TEST_DIR_KEY, "test") + "/texen/compare";
    }

    /**
     * Runs the test.
     */
    public void testTexenResults ()
            throws Exception
    {
        TestUtil.assureResultsDirectoryExists(resultsDir);

        // compare with custom context
        if (!TestUtil.compareFiles(
                new File(compareDir, "TurbineWeather.java").toString(),
                new File(resultsDir, "TurbineWeather.java").toString()) ||
            !TestUtil.compareFiles(
                    new File(compareDir, "TurbineWeatherService.java").toString(),
                    new File(resultsDir, "TurbineWeatherService.java").toString()) ||
            !TestUtil.compareFiles(
                    new File(compareDir, "WeatherService.java").toString(),
                    new File(resultsDir, "WeatherService.java").toString()) ||
            !TestUtil.compareFiles(
                    new File(compareDir, "book.txt").toString(),
                    new File(resultsDir, "book.txt").toString()) ||
            !TestUtil.compareFiles(
                    new File(compareDir, "Text.txt").toString(),
                    new File(resultsDir, "Text.txt").toString()) )
        {
            fail("Texen results are incorrect.");
        }
        else
        {
            Log.log ("Passed!");
        }
    }
}
