/*
 * Decompiled with CFR 0.152.
 */
package aQute.lib.aspects;

import aQute.lib.converter.Converter;
import aQute.lib.exceptions.BiFunctionWithException;
import aQute.lib.exceptions.ConsumerWithException;
import aQute.lib.exceptions.Exceptions;
import aQute.lib.exceptions.FunctionWithException;
import aQute.lib.exceptions.RunnableWithException;
import aQute.lib.exceptions.SupplierWithException;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;

public class Aspects {
    static MethodHandles.Lookup publicLookup = MethodHandles.publicLookup();
    static final Object[] EMPTY = new Object[0];
    public static final Object NORETURN = new Object();
    public static final Object DEFAULT = new Object();

    public static <T> InterceptBuilder<T> intercept(final Class<T> type, final T delegate) {
        assert (Objects.nonNull(type));
        assert (Objects.nonNull(delegate));
        return new InterceptBuilder<T>(){
            final Map<Method, FunctionWithException<Invocation, Object>> methods = new HashMap<Method, FunctionWithException<Invocation, Object>>();
            ConsumerWithException<Invocation> before = null;
            BiFunctionWithException<Invocation, Callable<Object>, Object> around = (x, c) -> c.call();
            BiFunctionWithException<Invocation, Object, Object> after = null;
            BiFunctionWithException<Invocation, Throwable, Object> exceptions = null;
            {
                try {
                    for (Method m : type.getMethods()) {
                        this.methods.putIfAbsent(m, inv -> m.invoke(delegate, inv.args));
                    }
                }
                catch (Exception e) {
                    throw Exceptions.duck(e);
                }
            }

            @Override
            public InterceptBuilder<T> intercept(FunctionWithException<Invocation, Object> intercept, String name, Class<?> ... types) {
                try {
                    Method method = type.getMethod(name, types);
                    this.methods.put(method, intercept);
                    return this;
                }
                catch (NoSuchMethodException nsme) {
                    try {
                        Method method = Object.class.getMethod(name, types);
                        this.methods.put(method, intercept);
                    }
                    catch (NoSuchMethodException e) {
                        throw Exceptions.duck(e);
                    }
                    return this;
                }
                catch (Throwable e) {
                    throw Exceptions.duck(e);
                }
            }

            @Override
            public <R> InterceptBuilder<T> intercept(RunnableWithException intercept, String name) {
                return this.intercept((Invocation inv) -> {
                    intercept.run();
                    return null;
                }, name, new Class[0]);
            }

            @Override
            public <R> InterceptBuilder<T> intercept(SupplierWithException<R> intercept, String name) {
                return this.intercept((Invocation inv) -> intercept.get(), name, new Class[0]);
            }

            @Override
            public <A, R> InterceptBuilder<T> intercept(FunctionWithException<A, R> intercept, String name, Class<A> aType) {
                return this.intercept((Invocation inv) -> intercept.apply(inv.args[0]), name, new Class[]{aType});
            }

            @Override
            public <A, B, R> InterceptBuilder<T> intercept(BiFunctionWithException<A, B, R> intercept, String name, Class<A> aType, Class<B> bType) {
                return this.intercept((Invocation inv) -> intercept.apply(inv.args[0], inv.args[1]), name, aType, bType);
            }

            @Override
            public InterceptBuilder<T> around(BiFunctionWithException<Invocation, Callable<Object>, Object> around) {
                if (this.around == null) {
                    this.around = around;
                } else {
                    BiFunctionWithException<Invocation, Callable<Object>, Object> previous = this.around;
                    this.around = (inv, callable) -> around.apply((Invocation)inv, () -> previous.apply((Invocation)inv, (Callable<Object>)callable));
                }
                return this;
            }

            @Override
            public InterceptBuilder<T> before(ConsumerWithException<Invocation> before) {
                if (this.before == null) {
                    this.before = before;
                } else {
                    ConsumerWithException<Invocation> previous = this.before;
                    this.before = args -> {
                        previous.accept((Invocation)args);
                        before.accept((Invocation)args);
                    };
                }
                return this;
            }

            @Override
            public InterceptBuilder<T> after(BiFunctionWithException<Invocation, Object, Object> after) {
                if (this.after == null) {
                    this.after = after;
                } else {
                    BiFunctionWithException<Invocation, Object, Object> previous = this.after;
                    this.after = (args, result) -> {
                        result = previous.apply((Invocation)args, result);
                        return after.apply((Invocation)args, result);
                    };
                }
                return this;
            }

            @Override
            public InterceptBuilder<T> onException(BiFunctionWithException<Invocation, Throwable, Object> exceptions) {
                if (this.exceptions == null) {
                    this.exceptions = exceptions;
                } else {
                    BiFunctionWithException<Invocation, Throwable, Object> previous = this.exceptions;
                    this.exceptions = (invocation, except) -> {
                        Object result = previous.apply((Invocation)invocation, (Throwable)except);
                        if (result != NORETURN) {
                            return result;
                        }
                        return exceptions.apply((Invocation)invocation, (Throwable)except);
                    };
                }
                return this;
            }

            @Override
            public T build() {
                try {
                    if (this.before == null) {
                        this.before = inv -> {};
                    }
                    if (this.after == null) {
                        this.after = (inv, x) -> x;
                    }
                    if (this.exceptions == null) {
                        this.exceptions = (inv, exc) -> {
                            throw Exceptions.duck(Exceptions.unrollCause(exc, InvocationTargetException.class));
                        };
                    }
                    return Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type}, this::invoke);
                }
                catch (Exception e) {
                    throw Exceptions.duck(e);
                }
            }

            Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                Invocation inv = new Invocation(proxy, method, args);
                try {
                    this.before.accept(inv);
                    FunctionWithException<Invocation, Object> target = this.methods.get(method);
                    Object result = this.around.apply(inv, () -> target.apply(inv));
                    return this.after.apply(inv, result);
                }
                catch (Throwable t) {
                    Object result = this.exceptions.apply(inv, t);
                    if (result == DEFAULT) {
                        return Converter.cnv(method.getGenericReturnType(), null);
                    }
                    if (result != NORETURN) {
                        return result;
                    }
                    throw t;
                }
            }
        };
    }

    public static interface InterceptBuilder<T> {
        public InterceptBuilder<T> intercept(FunctionWithException<Invocation, Object> var1, String var2, Class<?> ... var3);

        public <R> InterceptBuilder<T> intercept(SupplierWithException<R> var1, String var2);

        public <R> InterceptBuilder<T> intercept(RunnableWithException var1, String var2);

        public <A, R> InterceptBuilder<T> intercept(FunctionWithException<A, R> var1, String var2, Class<A> var3);

        public <A, B, R> InterceptBuilder<T> intercept(BiFunctionWithException<A, B, R> var1, String var2, Class<A> var3, Class<B> var4);

        public InterceptBuilder<T> around(BiFunctionWithException<Invocation, Callable<Object>, Object> var1);

        public InterceptBuilder<T> before(ConsumerWithException<Invocation> var1);

        public InterceptBuilder<T> after(BiFunctionWithException<Invocation, Object, Object> var1);

        public InterceptBuilder<T> onException(BiFunctionWithException<Invocation, Throwable, Object> var1);

        public T build();
    }

    public static class Invocation {
        final Object proxy;
        final Method method;
        final Object[] args;

        Invocation(Object proxy, Method method, Object[] args) {
            this.proxy = proxy;
            this.method = method;
            this.args = args == null ? EMPTY : args;
        }

        public String toString() {
            return "Invocation [" + (this.method != null ? "method=" + this.method.getName() + ", " : "") + (this.args != null ? "args=" + Arrays.toString(this.args) : "") + "]";
        }
    }
}

