/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.cellar.features;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.Dictionary;
import java.util.Map;
import java.util.Set;
import org.apache.karaf.cellar.core.Group;
import org.apache.karaf.cellar.core.Synchronizer;
import org.apache.karaf.cellar.core.control.SwitchStatus;
import org.apache.karaf.cellar.core.event.Event;
import org.apache.karaf.cellar.core.event.EventProducer;
import org.apache.karaf.cellar.core.event.EventType;
import org.apache.karaf.cellar.core.utils.CellarUtils;
import org.apache.karaf.cellar.features.ClusterFeaturesEvent;
import org.apache.karaf.cellar.features.ClusterRepositoryEvent;
import org.apache.karaf.cellar.features.FeatureState;
import org.apache.karaf.cellar.features.FeaturesSupport;
import org.apache.karaf.features.BootFinished;
import org.apache.karaf.features.Feature;
import org.apache.karaf.features.FeatureEvent;
import org.apache.karaf.features.Repository;
import org.apache.karaf.features.RepositoryEvent;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeaturesSynchronizer
extends FeaturesSupport
implements Synchronizer {
    private static final transient Logger LOGGER = LoggerFactory.getLogger(FeaturesSynchronizer.class);
    private EventProducer eventProducer;

    public void setEventProducer(EventProducer eventProducer) {
        this.eventProducer = eventProducer;
    }

    @Override
    public void init(BundleContext bundleContext) {
        ServiceTracker tracker = new ServiceTracker(bundleContext, BootFinished.class, null);
        try {
            tracker.waitForService(120000L);
        }
        catch (Exception e) {
            LOGGER.warn("Can't start BootFinished service tracker", (Throwable)e);
        }
        if (this.groupManager == null) {
            return;
        }
        Set groups = this.groupManager.listLocalGroups();
        if (groups != null && !groups.isEmpty()) {
            for (Group group : groups) {
                this.sync(group);
            }
        }
    }

    @Override
    public void destroy() {
        super.destroy();
    }

    public void sync(Group group) {
        String policy = this.getSyncPolicy(group);
        if (policy == null) {
            LOGGER.warn("CELLAR FEATURE: sync policy is not defined for cluster group {}", (Object)group.getName());
        } else if (policy.equalsIgnoreCase("cluster")) {
            LOGGER.debug("CELLAR FEATURE: sync policy set as 'cluster' for cluster group {}", (Object)group.getName());
            LOGGER.debug("CELLAR FEATURE: updating node from the cluster (pull first)");
            this.pull(group);
            LOGGER.debug("CELLAR FEATURE: updating cluster from the local node (push after)");
            this.push(group);
        } else if (policy.equalsIgnoreCase("node")) {
            LOGGER.debug("CELLAR FEATURE: sync policy set as 'node' for cluster group {}", (Object)group.getName());
            LOGGER.debug("CELLAR FEATURE: updating cluster from the local node (push first)");
            this.push(group);
            LOGGER.debug("CELLAR FEATURE: updating node from the cluster (pull after)");
            this.pull(group);
        } else if (policy.equalsIgnoreCase("clusterOnly")) {
            LOGGER.debug("CELLAR FEATURE: sync policy set as 'clusterOnly' for cluster group " + group.getName());
            LOGGER.debug("CELLAR FEATURE: updating node from the cluster (pull only)");
            this.pull(group);
        } else if (policy.equalsIgnoreCase("nodeOnly")) {
            LOGGER.debug("CELLAR FEATURE: sync policy set as 'nodeOnly' for cluster group " + group.getName());
            LOGGER.debug("CELLAR FEATURE: updating cluster from the local node (push only)");
            this.push(group);
        } else {
            LOGGER.debug("CELLAR FEATURE: sync policy set as 'disabled' for cluster group " + group.getName());
            LOGGER.debug("CELLAR FEATURE: no sync");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pull(Group group) {
        block23: {
            if (group != null) {
                String groupName = group.getName();
                LOGGER.debug("CELLAR FEATURE: pulling features repositories and features from cluster group {}", (Object)groupName);
                ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
                    Map clusterRepositories = this.clusterManager.getMap("org.apache.karaf.cellar.repositories." + groupName);
                    Map clusterFeatures = this.clusterManager.getMap("org.apache.karaf.cellar.features." + groupName);
                    Map synchronizers = this.getSynchronizerMap();
                    if (clusterRepositories != null && !clusterRepositories.isEmpty()) {
                        for (String url : clusterRepositories.keySet()) {
                            try {
                                if (this.isRepositoryRegisteredLocally(url).booleanValue()) continue;
                                LOGGER.debug("CELLAR FEATURE: adding repository {}", (Object)url);
                                this.featuresService.addRepository(new URI(url));
                            }
                            catch (MalformedURLException e) {
                                LOGGER.error("CELLAR FEATURE: failed to add repository URL {} (malformed)", (Object)url, (Object)e);
                            }
                            catch (Exception e) {
                                LOGGER.error("CELLAR FEATURE: failed to add repository URL {}", (Object)url, (Object)e);
                            }
                        }
                        if (synchronizers.containsKey("org.apache.karaf.cellar.repositories." + groupName)) {
                            try {
                                for (Repository repository : this.featuresService.listRepositories()) {
                                    URI uri = repository.getURI();
                                    boolean found = false;
                                    for (String clusterRepository : clusterRepositories.keySet()) {
                                        if (!clusterRepository.equals(uri.toString())) continue;
                                        found = true;
                                        break;
                                    }
                                    if (found) continue;
                                    LOGGER.debug("CELLAR FEATURE: removing repository {}", (Object)uri);
                                    this.featuresService.removeRepository(uri);
                                }
                            }
                            catch (Exception e) {
                                LOGGER.warn("Can't get local features repositories", (Throwable)e);
                            }
                        }
                    }
                    if (clusterFeatures == null || clusterFeatures.isEmpty()) break block23;
                    boolean doUninstallFeaturesNotPresentInCluster = CellarUtils.doCleanupResourcesNotPresentInCluster((ConfigurationAdmin)this.configurationAdmin) && synchronizers.containsKey("org.apache.karaf.cellar.features." + groupName);
                    for (FeatureState state : clusterFeatures.values()) {
                        String name = state.getName();
                        if (this.isAllowed(group, "feature", name, EventType.INBOUND).booleanValue()) {
                            Boolean clusterInstalled = state.getInstalled();
                            Boolean locallyInstalled = this.isFeatureInstalledLocally(state.getName(), state.getVersion());
                            if (clusterInstalled == null) {
                                clusterInstalled = false;
                            }
                            if (locallyInstalled == null) {
                                locallyInstalled = false;
                            }
                            if (clusterInstalled.booleanValue() && !locallyInstalled.booleanValue()) {
                                try {
                                    LOGGER.debug("CELLAR FEATURE: installing feature {}/{}", (Object)state.getName(), (Object)state.getVersion());
                                    this.featuresService.installFeature(state.getName(), state.getVersion());
                                }
                                catch (Exception e) {
                                    LOGGER.error("CELLAR FEATURE: failed to install feature {}/{} ", (Object)new Object[]{state.getName(), state.getVersion()}, (Object)e);
                                }
                            }
                            if (!doUninstallFeaturesNotPresentInCluster || clusterInstalled.booleanValue() || !locallyInstalled.booleanValue()) continue;
                            try {
                                LOGGER.debug("CELLAR FEATURE: uninstalling feature {}/{}", (Object)state.getName(), (Object)state.getVersion());
                                this.featuresService.uninstallFeature(state.getName(), state.getVersion());
                            }
                            catch (Exception e) {
                                LOGGER.error("CELLAR FEATURE: failed to uninstall feature {}/{}", (Object)new Object[]{state.getName(), state.getVersion()}, (Object)e);
                            }
                            continue;
                        }
                        LOGGER.trace("CELLAR FEATURE: feature {} is marked BLOCKED INBOUND for cluster group {}", (Object)name, (Object)groupName);
                    }
                }
                finally {
                    Thread.currentThread().setContextClassLoader(originalClassLoader);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void push(Group group) {
        if (this.eventProducer.getSwitch().getStatus().equals((Object)SwitchStatus.OFF)) {
            LOGGER.warn("CELLAR FEATURE: cluster event producer is OFF");
            return;
        }
        if (group != null) {
            String groupName = group.getName();
            LOGGER.debug("CELLAR FEATURE: pushing features repositories and features in cluster group {}", (Object)groupName);
            ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
                Map clusterRepositories = this.clusterManager.getMap("org.apache.karaf.cellar.repositories." + groupName);
                Map clusterFeatures = this.clusterManager.getMap("org.apache.karaf.cellar.features." + groupName);
                Map synchronizers = this.getSynchronizerMap();
                Repository[] repositoryList = new Repository[]{};
                Feature[] featuresList = new Feature[]{};
                try {
                    repositoryList = this.featuresService.listRepositories();
                    featuresList = this.featuresService.listFeatures();
                }
                catch (Exception e) {
                    LOGGER.error("CELLAR FEATURE: error listing features", (Throwable)e);
                }
                if (repositoryList != null && repositoryList.length > 0) {
                    for (Repository repository : repositoryList) {
                        try {
                            if (repository != null && repository.getURI() != null && repository.getName() != null && !clusterRepositories.containsKey(repository.getURI().toString())) {
                                LOGGER.debug("CELLAR FEATURE: pushing repository {} in cluster group {}", (Object)repository.getName(), (Object)groupName);
                                clusterRepositories.put(repository.getURI().toString(), repository.getName());
                                ClusterRepositoryEvent event = new ClusterRepositoryEvent(repository.getURI().toString(), RepositoryEvent.EventType.RepositoryAdded);
                                event.setSourceGroup(group);
                                event.setSourceNode(this.clusterManager.getNode());
                                event.setLocal(this.clusterManager.getNode());
                                this.eventProducer.produce((Event)event);
                                continue;
                            }
                            LOGGER.debug("CELLAR FEATURE: repository {} is already in cluster group {}", (Object)repository.getName(), (Object)groupName);
                        }
                        catch (Exception e) {
                            LOGGER.warn("CELLAR FEATURE: can't add repository", (Throwable)e);
                        }
                    }
                }
                synchronizers.put("org.apache.karaf.cellar.repositories." + groupName, true);
                if (featuresList != null && featuresList.length > 0) {
                    for (Repository repository : featuresList) {
                        if (this.isAllowed(group, "feature", repository.getName(), EventType.OUTBOUND).booleanValue()) {
                            ClusterFeaturesEvent event;
                            boolean installed = this.featuresService.isInstalled((Feature)repository);
                            String key = repository.getName() + "/" + repository.getVersion();
                            FeatureState clusterFeature = (FeatureState)clusterFeatures.get(key);
                            if (clusterFeature == null) {
                                LOGGER.debug("CELLAR FEATURE: adding feature {} to cluster group {}", (Object)key, (Object)groupName);
                                clusterFeature = new FeatureState();
                                clusterFeature.setName(repository.getName());
                                clusterFeature.setVersion(repository.getVersion());
                                clusterFeature.setInstalled(installed);
                                clusterFeatures.put(key, clusterFeature);
                                event = installed ? new ClusterFeaturesEvent(repository.getName(), repository.getVersion(), FeatureEvent.EventType.FeatureInstalled) : new ClusterFeaturesEvent(repository.getName(), repository.getVersion(), FeatureEvent.EventType.FeatureUninstalled);
                                event.setSourceGroup(group);
                                event.setSourceNode(this.clusterManager.getNode());
                                event.setLocal(this.clusterManager.getNode());
                                this.eventProducer.produce((Event)event);
                                continue;
                            }
                            if (clusterFeature.getInstalled() != installed) {
                                clusterFeature.setInstalled(installed);
                                clusterFeatures.put(key, clusterFeature);
                                event = installed ? new ClusterFeaturesEvent(repository.getName(), repository.getVersion(), FeatureEvent.EventType.FeatureInstalled) : new ClusterFeaturesEvent(repository.getName(), repository.getVersion(), FeatureEvent.EventType.FeatureUninstalled);
                                event.setSourceGroup(group);
                                event.setSourceNode(this.clusterManager.getNode());
                                this.eventProducer.produce((Event)event);
                                continue;
                            }
                            LOGGER.debug("CELLAR FEATURE: feature {} already sync on the cluster group {}", (Object)key, (Object)groupName);
                            continue;
                        }
                        LOGGER.debug("CELLAR FEATURE: feature {} is marked BLOCKED OUTBOUND for cluster group {}", (Object)repository.getName(), (Object)groupName);
                    }
                }
                synchronizers.put("org.apache.karaf.cellar.features." + groupName, true);
            }
            finally {
                Thread.currentThread().setContextClassLoader(originalClassLoader);
            }
        }
    }

    public String getSyncPolicy(Group group) {
        String groupName = group.getName();
        try {
            String propertyKey;
            Configuration configuration = this.configurationAdmin.getConfiguration("org.apache.karaf.cellar.groups", null);
            Dictionary properties = configuration.getProperties();
            if (properties != null && properties.get(propertyKey = groupName + "." + "feature" + "." + "sync") != null) {
                return properties.get(propertyKey).toString();
            }
        }
        catch (IOException e) {
            LOGGER.error("CELLAR FEATURE: error while retrieving the sync policy", (Throwable)e);
        }
        return null;
    }
}

