/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.ha;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.camel.ha.CamelClusterService;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClusterServiceSelectors {
    public static final CamelClusterService.Selector DEFAULT_SELECTOR = new SelectSingle();
    private static final Logger LOGGER = LoggerFactory.getLogger(ClusterServiceSelectors.class);

    private ClusterServiceSelectors() {
    }

    public static CamelClusterService.Selector defaultSelector() {
        return DEFAULT_SELECTOR;
    }

    public static CamelClusterService.Selector single() {
        return new SelectSingle();
    }

    public static CamelClusterService.Selector first() {
        return new SelectFirst();
    }

    public static CamelClusterService.Selector order() {
        return new SelectByOrder();
    }

    public static CamelClusterService.Selector type(Class<? extends CamelClusterService> type) {
        return new SelectByType(type);
    }

    public static CamelClusterService.Selector attribute(String key, Object value) {
        return new SelectByAttribute(key, value);
    }

    public static final class SelectByAttribute
    implements CamelClusterService.Selector {
        private final String key;
        private final Object value;

        public SelectByAttribute(String key, Object value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public Optional<CamelClusterService> select(Collection<CamelClusterService> services) {
            for (CamelClusterService service : services) {
                Map<String, Object> attributes = service.getAttributes();
                if (!ObjectHelper.equal(attributes.get(this.key), this.value)) continue;
                return Optional.of(service);
            }
            return Optional.empty();
        }
    }

    public static final class SelectByType
    implements CamelClusterService.Selector {
        private final Class<? extends CamelClusterService> type;

        public SelectByType(Class<? extends CamelClusterService> type) {
            this.type = type;
        }

        @Override
        public Optional<CamelClusterService> select(Collection<CamelClusterService> services) {
            for (CamelClusterService service : services) {
                if (!this.type.isInstance(service)) continue;
                return Optional.of(service);
            }
            return Optional.empty();
        }
    }

    public static final class SelectByOrder
    implements CamelClusterService.Selector {
        @Override
        public Optional<CamelClusterService> select(Collection<CamelClusterService> services) {
            Optional<Map.Entry> highPriorityServices = services.stream().collect(Collectors.groupingBy(CamelClusterService::getOrder)).entrySet().stream().min(Comparator.comparingInt(Map.Entry::getKey));
            if (highPriorityServices.isPresent()) {
                if (((List)highPriorityServices.get().getValue()).size() == 1) {
                    return Optional.of(((List)highPriorityServices.get().getValue()).iterator().next());
                }
                LOGGER.warn("Multiple CamelClusterService instances available for highest priority (order={}, items={})", highPriorityServices.get().getKey(), highPriorityServices.get().getValue());
            }
            return Optional.empty();
        }
    }

    public static final class SelectFirst
    implements CamelClusterService.Selector {
        @Override
        public Optional<CamelClusterService> select(Collection<CamelClusterService> services) {
            return ObjectHelper.isNotEmpty(services) ? Optional.of(services.iterator().next()) : Optional.empty();
        }
    }

    public static final class SelectSingle
    implements CamelClusterService.Selector {
        @Override
        public Optional<CamelClusterService> select(Collection<CamelClusterService> services) {
            if (services != null && services.size() == 1) {
                return Optional.of(services.iterator().next());
            }
            LOGGER.warn("Multiple CamelClusterService instances available (items={})", services);
            return Optional.empty();
        }
    }
}

