/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.patterns;

import com.strobel.core.CollectionUtilities;
import com.strobel.core.VerifyArgument;
import com.strobel.decompiler.languages.java.ast.AstNode;
import com.strobel.decompiler.languages.java.ast.AstNodeCollection;
import com.strobel.decompiler.languages.java.ast.Roles;
import com.strobel.decompiler.languages.java.ast.VariableDeclarationStatement;
import com.strobel.decompiler.languages.java.ast.VariableInitializer;
import com.strobel.decompiler.patterns.INode;
import com.strobel.decompiler.patterns.Match;
import com.strobel.decompiler.patterns.Pattern;

public final class DeclaredVariableBackReference
extends Pattern {
    private final String _referencedGroupName;

    public DeclaredVariableBackReference(String referencedGroupName) {
        this._referencedGroupName = (String)VerifyArgument.notNull((Object)referencedGroupName, (String)"referencedGroupName");
    }

    public final String getReferencedGroupName() {
        return this._referencedGroupName;
    }

    @Override
    public final boolean matches(INode other, Match match) {
        INode lastInGroup;
        if (other instanceof AstNode && (lastInGroup = (INode)CollectionUtilities.lastOrDefault(match.get(this._referencedGroupName))) instanceof VariableDeclarationStatement) {
            VariableDeclarationStatement referenced = (VariableDeclarationStatement)lastInGroup;
            AstNodeCollection<VariableInitializer> variables = referenced.getVariables();
            return variables.hasSingleElement() && DeclaredVariableBackReference.matchString(variables.firstOrNullObject().getName(), ((AstNode)other).getChildByRole(Roles.IDENTIFIER).getName());
        }
        return false;
    }
}

