/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast;

import com.strobel.decompiler.languages.java.ast.AstType;
import com.strobel.decompiler.languages.java.ast.Expression;
import com.strobel.decompiler.languages.java.ast.IAstVisitor;
import com.strobel.decompiler.languages.java.ast.JavaTokenNode;
import com.strobel.decompiler.languages.java.ast.Roles;
import com.strobel.decompiler.languages.java.ast.TokenRole;
import com.strobel.decompiler.patterns.INode;
import com.strobel.decompiler.patterns.Match;

public class InstanceOfExpression
extends Expression {
    public static final TokenRole INSTANCE_OF_KEYWORD_ROLE = new TokenRole("instanceof", 3);

    public InstanceOfExpression(int offset, Expression expression, AstType type) {
        super(offset);
        this.setExpression(expression);
        this.setType(type);
    }

    public final AstType getType() {
        return this.getChildByRole(Roles.TYPE);
    }

    public final void setType(AstType type) {
        this.setChildByRole(Roles.TYPE, type);
    }

    public final JavaTokenNode getInstanceOfToken() {
        return this.getChildByRole(INSTANCE_OF_KEYWORD_ROLE);
    }

    public final Expression getExpression() {
        return this.getChildByRole(Roles.EXPRESSION);
    }

    public final void setExpression(Expression value) {
        this.setChildByRole(Roles.EXPRESSION, value);
    }

    @Override
    public <T, R> R acceptVisitor(IAstVisitor<? super T, ? extends R> visitor, T data) {
        return visitor.visitInstanceOfExpression(this, data);
    }

    @Override
    public boolean matches(INode other, Match match) {
        if (other instanceof InstanceOfExpression) {
            InstanceOfExpression otherExpression = (InstanceOfExpression)other;
            return !otherExpression.isNull() && this.getExpression().matches(otherExpression.getExpression(), match) && this.getType().matches(otherExpression.getType(), match);
        }
        return false;
    }
}

