/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.jcas.cas;

import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.PrimitiveIterator;
import java.util.Spliterator;
import java.util.function.LongConsumer;
import java.util.stream.LongStream;
import org.apache.uima.cas.CommonArrayFS;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.LongArrayFSImpl;
import org.apache.uima.cas.impl.TypeImpl;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.JCasRegistry;
import org.apache.uima.jcas.cas.CommonPrimitiveArray;
import org.apache.uima.jcas.cas.TOP;

public final class LongArray
extends TOP
implements CommonPrimitiveArray<Long>,
LongArrayFSImpl,
Iterable<Long> {
    public static final String _TypeName = "uima.cas.LongArray";
    public static final int typeIndexID;
    public static final int type;
    private final long[] theArray;

    @Override
    public int getTypeIndexID() {
        return typeIndexID;
    }

    private LongArray() {
        this.theArray = null;
    }

    public LongArray(JCas jcas, int length) {
        super(jcas);
        this.theArray = new long[length];
        if (CASImpl.traceFSs) {
            this._casView.traceFSCreate(this);
        }
        if (this._casView.isId2Fs()) {
            this._casView.adjustLastFsV2size_nonHeapStoredArrays();
        }
    }

    public LongArray(TypeImpl t, CASImpl c, int length) {
        super(t, c);
        this.theArray = new long[length];
        if (CASImpl.traceFSs) {
            this._casView.traceFSCreate(this);
        }
        if (this._casView.isId2Fs()) {
            this._casView.adjustLastFsV2size_nonHeapStoredArrays();
        }
    }

    @Override
    public long get(int i) {
        return this.theArray[i];
    }

    @Override
    public void set(int i, long v) {
        this.theArray[i] = v;
        this._casView.maybeLogArrayUpdate(this, null, i);
    }

    @Override
    public void copyFromArray(long[] src, int srcPos, int destPos, int length) {
        System.arraycopy(src, srcPos, this.theArray, destPos, length);
        this._casView.maybeLogArrayUpdates(this, destPos, length);
    }

    @Override
    public void copyToArray(int srcPos, long[] dest, int destPos, int length) {
        System.arraycopy(this.theArray, srcPos, dest, destPos, length);
    }

    @Override
    public long[] toArray() {
        return Arrays.copyOf(this.theArray, this.theArray.length);
    }

    @Override
    public int size() {
        return this.theArray.length;
    }

    @Override
    public void copyToArray(int srcPos, String[] dest, int destPos, int length) {
        this._casView.checkArrayBounds(this.theArray.length, srcPos, length);
        for (int i = 0; i < length; ++i) {
            dest[i + destPos] = Long.toString(this.theArray[i + srcPos]);
        }
    }

    @Override
    public void copyFromArray(String[] src, int srcPos, int destPos, int length) {
        this._casView.checkArrayBounds(this.theArray.length, destPos, length);
        for (int i = 0; i < length; ++i) {
            this.theArray[i + destPos] = Long.parseLong(src[i + srcPos]);
        }
        this._casView.maybeLogArrayUpdates(this, destPos, length);
    }

    public long[] _getTheArray() {
        return this.theArray;
    }

    @Override
    public void copyValuesFrom(CommonArrayFS v) {
        LongArray bv = (LongArray)v;
        System.arraycopy(bv.theArray, 0, this.theArray, 0, this.theArray.length);
        this._casView.maybeLogArrayUpdates(this, 0, this.size());
    }

    @Override
    public void setArrayValueFromString(int i, String v) {
        this.set(i, Long.parseLong(v));
    }

    public Spliterator.OfLong spliterator() {
        return Arrays.spliterator(this.theArray);
    }

    public PrimitiveIterator.OfLong iterator() {
        return new PrimitiveIterator.OfLong(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < LongArray.this.size();
            }

            @Override
            public long nextLong() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return LongArray.this.get(this.i++);
            }
        };
    }

    public LongStream stream() {
        return Arrays.stream(this.theArray);
    }

    public static LongArray create(JCas jcas, long[] a) {
        LongArray longArray = new LongArray(jcas, a.length);
        longArray.copyFromArray(a, 0, 0, a.length);
        return longArray;
    }

    public void forEach(LongConsumer action) {
        for (long l : this.theArray) {
            action.accept(l);
        }
    }

    public boolean contains(long item) {
        for (long b : this.theArray) {
            if (b != item) continue;
            return true;
        }
        return false;
    }

    static {
        type = typeIndexID = JCasRegistry.register(LongArray.class);
    }
}

