/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.searchStrategy;

import org.apache.uima.caseditor.ide.TypeSystemLocationPropertyPage;
import org.apache.uima.caseditor.ide.searchstrategy.ITypeSystemSearchStrategy;
import org.apache.uima.ruta.addons.RutaAddonsPlugin;
import org.apache.uima.ruta.ide.core.RutaNature;
import org.apache.uima.ruta.ide.core.builder.RutaProjectUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.dltk.internal.launching.LaunchConfigurationUtils;

public class LastLaunchSearchStrategy
implements ITypeSystemSearchStrategy {
    public IFile findTypeSystem(IFile casFile) {
        IFile scriptFile;
        IProject project = casFile.getProject();
        IFile typeSystemLocation = TypeSystemLocationPropertyPage.getTypeSystemLocation((IProject)project);
        if (typeSystemLocation != null && !typeSystemLocation.getName().equals("TypeSystem.xml")) {
            return null;
        }
        try {
            IProjectNature nature = project.getNature("org.apache.uima.ruta.ide.nature");
            if (!(nature instanceof RutaNature)) {
                return null;
            }
        }
        catch (CoreException e) {
            return null;
        }
        ILaunchConfiguration lastRun = DebugUITools.getLastLaunch((String)"org.eclipse.debug.ui.launchGroup.run");
        String scriptName = LaunchConfigurationUtils.getString((ILaunchConfiguration)lastRun, (String)"mainScript", (String)"");
        if (scriptName != null && scriptName.length() != 0 && new Path(scriptName).segmentCount() > 0 && Path.ROOT.isValidPath(scriptName) && (scriptFile = project.getFile(scriptName)).exists()) {
            IPath path = null;
            try {
                ClassLoader classLoader = RutaProjectUtils.getClassLoader((IProject)project);
                path = RutaProjectUtils.getTypeSystemDescriptorPath((IPath)scriptFile.getLocation(), (IProject)project, (ClassLoader)classLoader);
            }
            catch (CoreException e) {
                RutaAddonsPlugin.error(e);
            }
            if (path != null) {
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                IPath location = Path.fromOSString((String)path.toFile().getAbsolutePath());
                IFile ts = workspace.getRoot().getFileForLocation(location);
                if (ts != null && ts.exists()) {
                    return ts;
                }
            }
        }
        return null;
    }
}

