/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.betwixt.expression;

import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.betwixt.expression.Context;
import org.apache.commons.betwixt.expression.TypedUpdater;

public class DynaBeanUpdater
extends TypedUpdater {
    private final String propertyName;

    public DynaBeanUpdater(DynaProperty dynaProperty) {
        this(dynaProperty.getName(), dynaProperty.getType());
    }

    public DynaBeanUpdater(String propertyName, Class type) {
        this.propertyName = propertyName;
        this.setValueType(type);
    }

    protected void executeUpdate(Context context, Object bean, Object value) throws Exception {
        if (bean instanceof DynaBean) {
            DynaBean dynaBean = (DynaBean)bean;
            dynaBean.set(this.propertyName, value);
        } else {
            this.handleException(context, new IllegalArgumentException("DynaBean required."));
        }
    }

    public String toString() {
        return "DynaBeanUpdater [property=" + this.propertyName + "]";
    }
}

