/*
 * Decompiled with CFR 0.152.
 */
package test.ojb.odmg;

import ojb.broker.Identity;
import ojb.odmg.TransactionAware;
import org.odmg.TransactionAbortedException;
import test.ojb.odmg.ProductGroup;

public class Article
implements TransactionAware {
    private int articleId;
    private String articleName;
    private int isSelloutArticle;
    private int minimumStock;
    private int orderedUnits;
    private double price;
    private ProductGroup productGroup;
    private int productGroupId;
    private int stock;
    private int supplierId;
    private String unit;

    public String toString() {
        String group = "" + this.productGroupId;
        if (this.productGroup != null) {
            group = this.productGroup.getName();
        }
        return "----\nArticle No:   " + this.articleId + "\n" + "Description:  " + this.articleName + "\n" + "ProductGroup: " + group + "\n" + "stock:        " + this.stock + "\n" + "price:        " + this.price + "\n" + "stock-value   " + this.getStockValue() + "\n";
    }

    public void addToStock(int diff) {
        this.stock += diff;
    }

    public int getArticleId() {
        return this.articleId;
    }

    public String getArticleName() {
        return this.articleName;
    }

    public ProductGroup getProductGroup() {
        return this.productGroup;
    }

    public int getStock() {
        return this.stock;
    }

    public double getStockValue() {
        return this.price * (double)this.stock;
    }

    public void setArticleId(int newArticleId) {
        this.articleId = newArticleId;
    }

    public void setArticleName(String newArticleName) {
        this.articleName = newArticleName;
    }

    public void setStock(int newStock) {
        this.stock = newStock;
    }

    public void afterAbort() {
        System.out.println("afterAbort: " + new Identity(this));
    }

    public void afterCommit() {
        System.out.println("afterCommit: " + new Identity(this));
    }

    public void beforeAbort() {
        System.out.println("beforeAbort: " + new Identity(this));
    }

    public void beforeCommit() throws TransactionAbortedException {
        System.out.println("beforeCommit: " + new Identity(this));
    }

    public boolean equals(Object obj) {
        if (obj instanceof Article) {
            return this.articleId == ((Article)obj).articleId;
        }
        return false;
    }
}

