/*
 * Decompiled with CFR 0.152.
 */
package test.ojb.broker;

import java.io.Serializable;
import test.ojb.broker.Article;
import test.ojb.broker.InterfaceProductGroup;

public class BookArticle
extends Article
implements Serializable {
    private int articleId;
    private String articleName;
    private int isSelloutArticle;
    private int minimumStock;
    private int orderedUnits;
    private double price;
    private InterfaceProductGroup productGroup;
    private int productGroupId;
    private int stock;
    private int supplierId;
    private String unit;
    private String author;
    private String isbn;

    public String toString() {
        String group = "" + this.productGroupId;
        if (this.productGroup != null) {
            group = this.productGroup.getName();
        }
        return "----\nArticle No:   " + this.articleId + "\n" + "Description:  " + this.articleName + "\n" + "ProductGroup: " + group + "\n" + "stock:        " + this.stock + "\n" + "price:        " + this.price + "\n" + "stock-value   " + this.getStockValue() + "\n";
    }

    public void addToStock(int diff) {
        this.stock += diff;
    }

    public int getArticleId() {
        return this.articleId;
    }

    public String getArticleName() {
        return this.articleName;
    }

    public double getStockValue() {
        return this.price * (double)this.stock;
    }

    public void setArticleId(int newArticleId) {
        this.articleId = newArticleId;
    }

    public void setArticleName(String newArticleName) {
        this.articleName = newArticleName;
    }

    public BookArticle() {
    }

    public BookArticle(int artId, String artName, int suppId, int pgId, String uni, double pric, int sto, int ordUnits, int minStock, int isSellout) {
        this.articleId = artId;
        this.articleName = artName;
        this.supplierId = suppId;
        this.productGroupId = pgId;
        this.unit = uni;
        this.price = pric;
        this.stock = sto;
        this.orderedUnits = ordUnits;
        this.minimumStock = minStock;
        this.isSelloutArticle = isSellout;
    }

    public int getMinimumStock() {
        return this.minimumStock;
    }

    public int getOrderedUnits() {
        return this.orderedUnits;
    }

    public double getPrice() {
        return this.price;
    }

    public InterfaceProductGroup getProductGroup() {
        return this.productGroup;
    }

    public int getProductGroupId() {
        return this.productGroupId;
    }

    public int getStock() {
        return this.stock;
    }

    public int getSupplierId() {
        return this.supplierId;
    }

    public String getUnit() {
        return this.unit;
    }

    public void setIsSelloutArticle(int newIsSelloutArticle) {
        this.isSelloutArticle = newIsSelloutArticle;
    }

    public void setMinimumStock(int newMinimumStock) {
        this.minimumStock = newMinimumStock;
    }

    public void setOrderedUnits(int newOrderedUnits) {
        this.orderedUnits = newOrderedUnits;
    }

    public void setPrice(double newPrice) {
        this.price = newPrice;
    }

    public void setProductGroup(InterfaceProductGroup newProductGroup) {
        this.productGroup = newProductGroup;
    }

    public void setProductGroupId(int newProductGroupId) {
        this.productGroupId = newProductGroupId;
    }

    public void setStock(int newStock) {
        this.stock = newStock;
    }

    public void setSupplierId(int newSupplierId) {
        this.supplierId = newSupplierId;
    }

    public void setUnit(String newUnit) {
        this.unit = newUnit;
    }
}

