/*
 * Decompiled with CFR 0.152.
 */
package ojb.odmg;

import ojb.broker.Identity;
import ojb.broker.PersistenceBroker;
import ojb.broker.PersistenceBrokerException;
import ojb.broker.query.QueryByExample;
import ojb.odmg.DatabaseImpl;
import ojb.odmg.NamedRootsEntry;
import ojb.odmg.OJB;
import ojb.odmg.TransactionImpl;
import org.odmg.ObjectNameNotFoundException;
import org.odmg.ObjectNameNotUniqueException;

public class NamedRootsMap {
    private static NamedRootsMap _instance;

    private NamedRootsMap() {
    }

    public Identity get(String key) {
        NamedRootsEntry example = new NamedRootsEntry(key, null);
        QueryByExample query = new QueryByExample(example);
        try {
            PersistenceBroker broker = ((DatabaseImpl)OJB.getInstance().getDatabase(null)).getBroker();
            NamedRootsEntry entry = (NamedRootsEntry)broker.getObjectByQuery(query);
            return Identity.fromByteArray(entry.getOid());
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static NamedRootsMap getInstance() {
        if (_instance == null) {
            _instance = new NamedRootsMap();
        }
        return _instance;
    }

    public void put(String key, Identity oid) throws ObjectNameNotUniqueException {
        NamedRootsEntry entry = new NamedRootsEntry(key, oid.serialize());
        try {
            PersistenceBroker broker = ((DatabaseImpl)OJB.getInstance().getDatabase(null)).getBroker();
            TransactionImpl tx = (TransactionImpl)OJB.getInstance().currentTransaction();
            NamedRootsEntry stored = (NamedRootsEntry)broker.getObjectByQuery(new QueryByExample(entry));
            if (stored != null) {
                throw new ObjectNameNotUniqueException("the key " + key + " is not unique");
            }
            tx.lock(entry, 4);
        }
        catch (PersistenceBrokerException ex) {
            // empty catch block
        }
    }

    public void unbind(String key) throws ObjectNameNotFoundException {
        NamedRootsEntry example = new NamedRootsEntry(key, null);
        try {
            PersistenceBroker broker = ((DatabaseImpl)OJB.getInstance().getDatabase(null)).getBroker();
            TransactionImpl tx = (TransactionImpl)OJB.getInstance().currentTransaction();
            NamedRootsEntry stored = (NamedRootsEntry)broker.getObjectByQuery(new QueryByExample(example));
            if (stored == null) {
                throw new ObjectNameNotFoundException("don't know " + key);
            }
            tx.markDelete(stored);
        }
        catch (PersistenceBrokerException persistenceBrokerException) {
            // empty catch block
        }
    }
}

