/*
 * Decompiled with CFR 0.152.
 */
package ojb.broker.query;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import ojb.broker.query.Criteria;
import ojb.broker.query.CriteriaException;
import ojb.broker.query.DBException;
import ojb.broker.query.SearchFilter;

public class OJBSearchFilter
extends SearchFilter {
    Criteria criteria = new Criteria();

    public void matchList(String elementName, Vector values, int oper) {
        this.criteria = new Criteria();
        if (oper != 4) {
            try {
                int i = 0;
                while (i < values.size()) {
                    Criteria tempCrit = new Criteria();
                    tempCrit.addEqualTo(elementName, values.elementAt(i));
                    this.criteria.addOrCriteria(tempCrit);
                    ++i;
                }
            }
            catch (CriteriaException e) {
                System.err.println("Can't add 'OR' criteria. Skiping element! Exception: " + e);
            }
        } else {
            int i = 0;
            while (i < values.size()) {
                this.criteria.addNotEqualTo(elementName, values.elementAt(i));
                ++i;
            }
        }
    }

    public void matchList(String elementName, String[] values, int oper) {
        this.criteria = new Criteria();
        if (oper != 4) {
            try {
                int i = 0;
                while (i < values.length) {
                    Criteria tempCrit = new Criteria();
                    tempCrit.addEqualTo(elementName, values[i]);
                    this.criteria.addOrCriteria(tempCrit);
                    ++i;
                }
            }
            catch (CriteriaException e) {
                System.err.println("Can't add 'OR' criteria. Skiping element! Exception: " + e);
            }
        } else {
            int i = 0;
            while (i < values.length) {
                this.criteria.addNotEqualTo(elementName, values[i]);
                ++i;
            }
        }
    }

    public void matchList(String elementName, int[] values, int oper) {
        this.criteria = new Criteria();
        if (oper != 4) {
            try {
                int i = 0;
                while (i < values.length) {
                    Criteria tempCrit = new Criteria();
                    tempCrit.addEqualTo(elementName, new Integer(values[i]));
                    this.criteria.addOrCriteria(tempCrit);
                    ++i;
                }
            }
            catch (CriteriaException e) {
                System.err.println("Can't add 'OR' criteria. Skiping element! Exception: " + e);
            }
        } else {
            int i = 0;
            while (i < values.length) {
                this.criteria.addNotEqualTo(elementName, new Integer(values[i]));
                ++i;
            }
        }
    }

    public void matchValue(String elementName, String value, int oper) {
        this.criteria = new Criteria();
        if (oper != 4) {
            this.criteria.addEqualTo(elementName, value);
        } else {
            this.criteria.addNotEqualTo(elementName, value);
        }
    }

    public void matchValue(String elementName, int value, int oper) {
        this.criteria = new Criteria();
        if (oper != 4) {
            this.criteria.addEqualTo(elementName, new Integer(value));
        } else {
            this.criteria.addNotEqualTo(elementName, new Integer(value));
        }
    }

    public void compareFilter(String elementName, String value, int oper) throws DBException {
        this.criteria = new Criteria();
        if ((oper & 0x100) == 0) {
            throw new DBException();
        }
        switch (oper) {
            case 265: {
                this.criteria.addLike(elementName, value);
                break;
            }
            case 266: {
                this.criteria.addEqualTo(elementName, value);
                break;
            }
            case 267: {
                this.criteria.addNotEqualTo(elementName, value);
                break;
            }
            case 268: {
                this.criteria.addLessThan(elementName, value);
                break;
            }
            case 269: {
                this.criteria.addGreaterThan(elementName, value);
                break;
            }
            case 270: {
                this.criteria.addGreaterOrEqualThan(elementName, value);
                break;
            }
            case 271: {
                this.criteria.addLessOrEqualThan(elementName, value);
                break;
            }
            default: {
                System.out.println("Unsupported binary operation in OJBSearchFilter!");
                throw new DBException();
            }
        }
    }

    public void matchSet(Hashtable elements, int combine_op, int compare_op) throws DBException {
        this.criteria = new Criteria();
        if ((compare_op & 0x100) == 0) {
            throw new DBException();
        }
        if (combine_op == 512) {
            Enumeration e = elements.keys();
            while (e.hasMoreElements()) {
                String elementName = (String)e.nextElement();
                String elementValue = (String)elements.get(elementName);
                switch (compare_op) {
                    case 265: {
                        this.criteria.addLike(elementName, elementValue);
                        break;
                    }
                    case 266: {
                        this.criteria.addEqualTo(elementName, elementValue);
                        break;
                    }
                    case 267: {
                        this.criteria.addNotEqualTo(elementName, elementValue);
                        break;
                    }
                    case 268: {
                        this.criteria.addLessThan(elementName, elementValue);
                        break;
                    }
                    case 269: {
                        this.criteria.addGreaterThan(elementName, elementValue);
                        break;
                    }
                    case 270: {
                        this.criteria.addGreaterOrEqualThan(elementName, elementValue);
                        break;
                    }
                    case 271: {
                        this.criteria.addLessOrEqualThan(elementName, elementValue);
                        break;
                    }
                    default: {
                        System.out.println("Unsupported binary operation in OJBSearchFilter!");
                        throw new DBException();
                    }
                }
            }
        } else if (combine_op == 513) {
            try {
                Enumeration e = elements.keys();
                while (e.hasMoreElements()) {
                    String elementName = (String)e.nextElement();
                    String elementValue = (String)elements.get(elementName);
                    switch (compare_op) {
                        case 265: {
                            Criteria tempCrit = new Criteria();
                            tempCrit.addLike(elementName, elementValue);
                            this.criteria.addOrCriteria(tempCrit);
                            break;
                        }
                        case 266: {
                            Criteria tempCrit = new Criteria();
                            tempCrit.addEqualTo(elementName, elementValue);
                            this.criteria.addOrCriteria(tempCrit);
                            break;
                        }
                        case 267: {
                            Criteria tempCrit = new Criteria();
                            tempCrit.addNotEqualTo(elementName, elementValue);
                            this.criteria.addOrCriteria(tempCrit);
                            break;
                        }
                        case 268: {
                            Criteria tempCrit = new Criteria();
                            tempCrit.addLessThan(elementName, elementValue);
                            this.criteria.addOrCriteria(tempCrit);
                            break;
                        }
                        case 269: {
                            Criteria tempCrit = new Criteria();
                            tempCrit.addGreaterThan(elementName, elementValue);
                            this.criteria.addOrCriteria(tempCrit);
                            break;
                        }
                        case 270: {
                            Criteria tempCrit = new Criteria();
                            tempCrit.addGreaterOrEqualThan(elementName, elementValue);
                            this.criteria.addOrCriteria(tempCrit);
                            break;
                        }
                        case 271: {
                            Criteria tempCrit = new Criteria();
                            tempCrit.addLessOrEqualThan(elementName, elementValue);
                            this.criteria.addOrCriteria(tempCrit);
                            break;
                        }
                        default: {
                            System.out.println("Unsupported binary operation in OJBSearchFilter!");
                            throw new DBException();
                        }
                    }
                }
            }
            catch (CriteriaException e) {
                System.out.println("Can't combine search criteria in OJBSearchFilter.matchSet(...) " + e);
                throw new DBException();
            }
        } else {
            throw new DBException();
        }
    }

    public void matchSet(String[] elementNames, String[] elementValues, int op) throws DBException {
        this.criteria = new Criteria();
        if (op == 513) {
            try {
                int i = 0;
                while (i < elementNames.length) {
                    Criteria tempCrit = new Criteria();
                    tempCrit.addEqualTo(elementNames[i], elementValues[i]);
                    this.criteria.addOrCriteria(tempCrit);
                    ++i;
                }
            }
            catch (CriteriaException e) {
                System.err.println("Can't add 'OR' criteria. Skiping element! Exception: " + e);
            }
        } else if (op == 512) {
            int i = 0;
            while (i < elementNames.length) {
                this.criteria.addEqualTo(elementNames[i], elementValues[i]);
                ++i;
            }
        } else {
            throw new DBException();
        }
    }

    public void combine(Vector new_filters, int op) throws DBException {
        Enumeration elems = new_filters.elements();
        while (elems.hasMoreElements()) {
            SearchFilter filter = (SearchFilter)elems.nextElement();
            this.combine(filter, op);
        }
    }

    public void combine(SearchFilter new_filter, int op) throws DBException {
        OJBSearchFilter ojbFilter = (OJBSearchFilter)new_filter;
        switch (op) {
            case 513: {
                try {
                    this.criteria.addOrCriteria(ojbFilter.getCriteria());
                    break;
                }
                catch (CriteriaException e) {
                    throw new DBException();
                }
            }
            case 512: {
                this.criteria.addAndCriteria(ojbFilter.getCriteria());
                break;
            }
            default: {
                throw new DBException();
            }
        }
    }

    public String toString() {
        return this.criteria.toString();
    }

    protected Criteria getCriteria() {
        return this.criteria;
    }
}

