/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.eval.app.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.eval.app.db.AbstractDBBuffer;
import org.apache.tika.eval.app.db.Cols;
import org.apache.tika.eval.app.db.TableInfo;
import org.apache.tika.mime.MediaType;
import org.apache.tika.mime.MimeType;
import org.apache.tika.mime.MimeTypeException;
import org.apache.tika.mime.MimeTypes;

public class MimeBuffer
extends AbstractDBBuffer {
    private final PreparedStatement st;
    private final TikaConfig config;
    private final Connection connection;

    public MimeBuffer(Connection connection, TableInfo mimeTable, TikaConfig config) throws SQLException {
        this.st = connection.prepareStatement("insert into " + mimeTable.getName() + "( " + Cols.MIME_ID.name() + ", " + Cols.MIME_STRING.name() + ", " + Cols.FILE_EXTENSION.name() + ") values (?,?,?)");
        this.config = config;
        this.connection = connection;
    }

    @Override
    public void write(int id, String value) throws RuntimeException {
        try {
            this.st.clearParameters();
            this.st.setInt(1, id);
            this.st.setString(2, value);
            try {
                String ext = MimeUtil.getExtension(value, this.config);
                if (ext == null || ext.isEmpty()) {
                    this.st.setNull(3, 12);
                } else {
                    this.st.setString(3, ext);
                }
            }
            catch (MimeTypeException e) {
                this.st.setNull(3, 12);
            }
            this.st.execute();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() throws SQLException {
        this.st.close();
        this.connection.commit();
    }

    private static class MimeUtil {
        private static final String APPLICATION = "application";
        private static final String TEXT = "text";
        private static final String HTML = "html";
        private static final String XML = "xml";
        private static final String XHTML_XML = "xhtml+xml";
        private static final String CSS = "css";
        private static final String CSV = "csv";
        private static final String PLAIN = "plain";
        private static final String EMPTY_STRING = "";

        private MimeUtil() {
        }

        public static String getExtension(String contentType, TikaConfig config) throws MimeTypeException {
            MimeTypes types = config.getMimeRepository();
            MimeType mime = types.forName(contentType);
            return MimeUtil.getExtension(mime);
        }

        public static String getExtension(MimeType mime) {
            String ext = mime.getExtension();
            if (ext.startsWith(".")) {
                ext = ext.substring(1);
            }
            if (ext.isEmpty()) {
                ext = MimeUtil.tryTextyTypes(mime.getType());
            }
            return ext;
        }

        private static String tryTextyTypes(MediaType mediaType) {
            String type = mediaType.getType();
            String subtype = mediaType.getSubtype();
            if (type.equals(TEXT)) {
                switch (subtype) {
                    case "html": {
                        return HTML;
                    }
                    case "plain": {
                        return "txt";
                    }
                    case "css": {
                        return CSS;
                    }
                    case "csv": {
                        return CSV;
                    }
                }
            } else if (type.equals(APPLICATION)) {
                if (subtype.equals(XML)) {
                    return XML;
                }
                if (subtype.equals(XHTML_XML)) {
                    return HTML;
                }
            }
            return EMPTY_STRING;
        }
    }
}

