/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.transform;

import org.apache.tapestry5.commons.ObjectLocator;
import org.apache.tapestry5.internal.services.ComponentClassCache;
import org.apache.tapestry5.ioc.annotations.InjectService;
import org.apache.tapestry5.model.MutableComponentModel;
import org.apache.tapestry5.plastic.PlasticClass;
import org.apache.tapestry5.plastic.PlasticField;
import org.apache.tapestry5.services.transform.ComponentClassTransformWorker2;
import org.apache.tapestry5.services.transform.TransformationSupport;

public class InjectServiceWorker
implements ComponentClassTransformWorker2 {
    private final ObjectLocator locator;
    private final ComponentClassCache cache;

    public InjectServiceWorker(ObjectLocator locator, ComponentClassCache cache) {
        this.locator = locator;
        this.cache = cache;
    }

    @Override
    public void transform(PlasticClass plasticClass, TransformationSupport support, MutableComponentModel model) {
        for (PlasticField field : plasticClass.getFieldsWithAnnotation(InjectService.class)) {
            InjectService annotation = (InjectService)field.getAnnotation(InjectService.class);
            field.claim((Object)annotation);
            Class fieldType = this.cache.forName(field.getTypeName());
            Object service = this.locator.getService(annotation.value(), fieldType);
            field.inject(service);
        }
    }
}

